/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.daemon.trace;

import com.ibm.team.filesystem.client.daemon.JSONHandlerRequestEvent;
import com.ibm.team.filesystem.client.daemon.JSONHandlerResponseEvent;
import com.ibm.team.filesystem.client.daemon.events.IConnectedHttpServerEvent;
import com.ibm.team.filesystem.client.daemon.events.IConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.RequestEvent;
import com.ibm.team.filesystem.client.daemon.events.ResponseEvent;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.daemon.RegisteredSandboxPseudoEvent;
import com.ibm.team.filesystem.client.internal.daemon.trace.DaemonInfoPseudoParms;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.marshalling.ParameterWrapperHandlerWithFallback;
import com.ibm.team.filesystem.client.rest.TracerObscure;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationDiscardedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationDroppedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationQueuedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationSentEvent;
import com.ibm.team.repository.common.json.IJSONSerializable;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Pattern;

public class DaemonTracer
implements ILightweightEventListener<ILightweightEvent> {
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MMM/dd HH:mm:ss.SSS");
    private static final byte[] NEWLINE = System.getProperty("line.separator").getBytes();
    private final File outputFile;

    public DaemonTracer(File outputFile) {
        this(outputFile, null);
    }

    public DaemonTracer(File outputFile, String extraComment) {
        this.outputFile = outputFile;
        this.write(outputFile, "# Time - Type - Port - Description", null);
        if (extraComment != null) {
            this.write(outputFile, "# " + extraComment, null);
        }
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    private String clunkyPrettyPrint(IParameterWrapper arg) throws UnsupportedEncodingException {
        int n;
        ParameterWrapperHandlerWithFallback serializer = new ParameterWrapperHandlerWithFallback(this.getClass().getClassLoader());
        String s = serializer.createQueryString(arg, true);
        if (s.length() == 0) {
            return "(no payload)";
        }
        String[] strings = s.split(Pattern.quote("&"));
        HashSet<String> escapedFields = null;
        if (arg.getClass().isAnnotationPresent(TracerObscure.class)) {
            escapedFields = new HashSet<String>();
            String[] stringArray = arg.getClass().getAnnotation(TracerObscure.class).value();
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                escapedFields.add(fieldName);
                ++n2;
            }
        }
        StringBuffer buf = new StringBuffer(s.length());
        String[] stringArray = strings;
        int n3 = strings.length;
        n = 0;
        while (n < n3) {
            String kvp = stringArray[n];
            String[] pair = kvp.split("=", 2);
            if (pair.length > 0) {
                buf.append(pair[0]);
                buf.append(" = ");
            }
            if (pair.length > 1) {
                if (escapedFields != null && escapedFields.contains(pair[0])) {
                    buf.append("{redacted}");
                } else {
                    Object any;
                    String jsonified = URLDecoder.decode(pair[1], "UTF-8");
                    try {
                        any = JSONObject.parseAny((Reader)new StringReader(jsonified));
                    }
                    catch (IOException iOException) {
                        any = jsonified;
                    }
                    if (any instanceof IJSONSerializable) {
                        buf.append(((IJSONSerializable)any).toString(true));
                    } else {
                        buf.append(any);
                    }
                }
            }
            buf.append("\n");
            ++n;
        }
        return buf.toString();
    }

    @Override
    public void handleEvent(ILightweightEvent event) {
        try {
            this._handleEvent(event);
        }
        catch (Exception e) {
            CharArrayWriter baos = new CharArrayWriter();
            PrintWriter ps = new PrintWriter(baos);
            e.printStackTrace(ps);
            ps.flush();
            ps.close();
            this.write(this.outputFile, "Exception while logging", new BufferedReader(new StringReader(baos.toString())));
        }
    }

    public void _handleEvent(ILightweightEvent event) throws IOException {
        if (event instanceof RequestEvent) {
            this.write((RequestEvent)event);
        } else if (event instanceof ResponseEvent) {
            this.write((ResponseEvent)event);
        } else if (event instanceof NotificationEvent) {
            this.write((NotificationEvent)event);
        } else if (event instanceof JSONHandlerRequestEvent) {
            JSONHandlerRequestEvent reqEvent = (JSONHandlerRequestEvent)event;
            this.write(reqEvent);
        } else if (event instanceof JSONHandlerResponseEvent) {
            JSONHandlerResponseEvent respEvent = (JSONHandlerResponseEvent)event;
            this.write(respEvent);
        } else if (event instanceof IConnectionEvent) {
            this.write((IConnectionEvent)event);
        } else if (event instanceof FSDaemon.IInitializedEvent) {
            this.write((FSDaemon.IInitializedEvent)event);
        } else if (event instanceof RegisteredSandboxPseudoEvent) {
            this.write((RegisteredSandboxPseudoEvent)event);
        }
    }

    private void write(RegisteredSandboxPseudoEvent event) {
        this.write(this.outputFile, LineTypes.AUTOJOINED_SANDBOX, -1, event.getSandboxPath(), null);
    }

    private void write(FSDaemon.IInitializedEvent event) {
        BufferedReader reader;
        DaemonInfoPseudoParms parms = new DaemonInfoPseudoParms();
        File f = event.getDaemon().getDaemonEntryDir();
        if (f != null) {
            parms.daemonEntryDir = f.getAbsolutePath();
        }
        parms.listeningPort = event.getDaemon().getPort();
        parms.daemonUuid = event.getDaemon().getProcessUuid();
        try {
            parms.buildId = System.getProperty("scm.daemon.buildId", "(unset)");
        }
        catch (AccessControlException accessControlException) {
            parms.buildId = "Unavailable due to Security Manager.";
        }
        try {
            reader = new BufferedReader(new StringReader(this.clunkyPrettyPrint(parms)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            reader = null;
        }
        this.write(this.outputFile, LineTypes.START_LISTENING, event.getDaemon().getPort(), "Listening on port " + event.getDaemon().getPort(), reader);
    }

    private void write(NotificationEvent event) throws UnsupportedEncodingException {
        Notification<?> notification = event.getNotification();
        LineTypes eventType = null;
        int port = -1;
        if (event instanceof NotificationQueuedEvent) {
            eventType = LineTypes.NOTIFICATION_QUEUED;
        } else if (event instanceof NotificationSentEvent) {
            eventType = LineTypes.NOTIFICATION_SENT;
            port = ((NotificationSentEvent)event).getPeerPort();
        } else if (event instanceof NotificationDiscardedEvent) {
            eventType = LineTypes.NOTIFICATION_DISCARDED;
        } else if (event instanceof NotificationDroppedEvent) {
            eventType = LineTypes.NOTIFICATION_DROPPED;
            port = ((NotificationDroppedEvent)event).getPeerPort();
        }
        BufferedReader reader = new BufferedReader(new StringReader(this.clunkyPrettyPrint((IParameterWrapper)notification.notification)));
        this.write(this.outputFile, eventType, port, "Type: " + event.getNotification().type + ", Progress-Key: " + event.getNotification().key, reader);
    }

    private void write(ResponseEvent event) {
        HttpResponse resp = event.getResponse();
        this.write(this.outputFile, event, LineTypes.RESPONSE, Integer.toString(resp.getLastCode()));
    }

    private void write(RequestEvent event) {
        HttpRequest req = event.getRequest();
        this.write(this.outputFile, event, LineTypes.REQUEST, String.valueOf(req.getMethod().toString()) + " " + req.getRequestURI());
    }

    private void write(IConnectionEvent event) {
        if (event.getType() == IConnectionEvent.Type.OPENED) {
            this.write(this.outputFile, event, LineTypes.CONNECT, "Client connected");
        } else if (event.getType() == IConnectionEvent.Type.CLOSED) {
            this.write(this.outputFile, event, LineTypes.DISCONNECT, "Client disconnected");
        }
    }

    private void write(JSONHandlerRequestEvent reqEvent) throws UnsupportedEncodingException {
        IParameterWrapper params = reqEvent.getParams();
        BufferedReader reader = params == null ? null : new BufferedReader(new StringReader(this.clunkyPrettyPrint(params)));
        this.write(this.outputFile, LineTypes.JSON_REQUEST, reqEvent.getPeerPort(), "Request, Progress-Key: " + reqEvent.getProgressKey(), reader);
    }

    private void write(JSONHandlerResponseEvent respEvent) {
        String payload = respEvent.getFormattedPayload();
        this.write(this.outputFile, LineTypes.JSON_RESPONSE, respEvent.getPeerPort(), "Response (" + respEvent.getResponse().getLastCode() + ")", new BufferedReader(new StringReader(payload)));
    }

    private void write(File file, IConnectedHttpServerEvent event, LineTypes eventType, String eventDescription) {
        this.write(file, eventType, event.getPeerPort(), eventDescription, null);
    }

    private void write(File file, LineTypes eventType, int port, String eventDescription, BufferedReader multilineContent) {
        StringBuffer buf = new StringBuffer();
        this.writeTimeIntoBuffer(buf);
        buf.append(" - ");
        buf.append(eventType.toString());
        buf.append(" - ");
        buf.append(port);
        buf.append(" - ");
        buf.append(eventDescription);
        this.write(file, buf, multilineContent);
    }

    private synchronized void write(File file, CharSequence seq, BufferedReader multilineContent) {
        block16: {
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(file, true);
                    out.write(seq.toString().getBytes());
                    out.write(NEWLINE);
                    if (multilineContent == null) break block16;
                    try {
                        String line;
                        while ((line = multilineContent.readLine()) != null) {
                            out.write(9);
                            out.write(line.getBytes());
                            out.write(NEWLINE);
                        }
                    }
                    finally {
                        multilineContent.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (out == null) break block16;
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private void writeTimeIntoBuffer(StringBuffer buf) {
        DATE_FORMAT.format(new Date(), buf, new FieldPosition(0));
    }

    public static enum LineTypes {
        CONNECT,
        DISCONNECT(CONNECT),
        REQUEST,
        RESPONSE(REQUEST),
        NOTIFICATION_QUEUED("NOTIFICATION QUEUED"),
        NOTIFICATION_SENT("NOTIFICATION SENT"),
        NOTIFICATION_DISCARDED("NOTIFICATION DISCARDED"),
        NOTIFICATION_DROPPED("NOTIFICATION_DROPPED"),
        JSON_REQUEST,
        JSON_RESPONSE(JSON_REQUEST),
        START_LISTENING,
        AUTOJOINED_SANDBOX;

        private final String inFileName;
        private final LineTypes starter;
        private boolean starts = false;

        private LineTypes() {
            this.inFileName = this.name();
            this.starter = null;
        }

        private LineTypes(String inFileName) {
            this.inFileName = inFileName;
            this.starter = null;
        }

        private LineTypes(LineTypes starter) {
            this.inFileName = this.name();
            this.starter = starter;
            starter.starts = true;
        }

        public String toString() {
            return this.inFileName;
        }

        public LineTypes getStartType() {
            return this.starter;
        }

        public boolean expectStop() {
            return this.starts;
        }

        public boolean isNotification() {
            return this == NOTIFICATION_QUEUED || this == NOTIFICATION_SENT || this == NOTIFICATION_DISCARDED || this == NOTIFICATION_DROPPED;
        }

        public boolean isHttp() {
            return this == REQUEST || this == RESPONSE || this == JSON_REQUEST || this == JSON_RESPONSE;
        }

        public boolean isStop() {
            if (this.starts) {
                return false;
            }
            return !this.isNotification();
        }

        public static LineTypes parse(String s) {
            LineTypes[] lineTypesArray = LineTypes.values();
            int n = lineTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineTypes t = lineTypesArray[n2];
                if (t.inFileName.equals(s)) {
                    return t;
                }
                ++n2;
            }
            throw new IllegalArgumentException(s);
        }
    }
}

