/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.exceptions;

import com.ibm.team.filesystem.client.restproxy.exceptions.RestTransportException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;

public class RestHttpException
extends RestTransportException {
    protected HttpMethod request;

    private static String responseToString(HttpMethod request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        if (request.hasBeenUsed()) {
            StatusLine status = request.getStatusLine();
            return String.valueOf(status.getStatusCode()) + ": " + status.getReasonPhrase();
        }
        return "<Missing or incomplete HTTP response>";
    }

    public RestHttpException(HttpMethod request, Exception e) {
        super(RestHttpException.responseToString(request), e);
        this.setRequest(request);
    }

    public RestHttpException(String string, HttpMethod request, Exception e) {
        super(string, e);
        this.setRequest(request);
    }

    public void setRequest(HttpMethod request) {
        this.request = request;
    }

    public int getHttpCode() {
        if (this.request != null) {
            return this.request.getStatusCode();
        }
        return -1;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (this.request != null) {
            sb.append("\nRequest detail:");
            sb.append("\n\tMethod: " + this.request.getName());
            URI uri = null;
            try {
                uri = this.request.getURI();
            }
            catch (URIException uRIException) {}
            if (uri != null) {
                sb.append("\n\tURI: " + uri.toString());
            }
        }
        if (this.request != null && this.request.getStatusLine() != null) {
            StatusLine line = this.request.getStatusLine();
            sb.append("\nResponse detail:");
            sb.append("\n\tCode: " + line.getStatusCode());
            sb.append("\n\tReason: " + line.getReasonPhrase());
        }
        return sb.toString();
    }
}

