/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.advice.runtime;

import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdviceListener;
import com.ibm.team.process.common.advice.runtime.IParticipantInfoCollector;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.ParticipantReport;
import com.ibm.team.process.internal.common.advice.ReportInfo;
import com.ibm.team.process.internal.common.advice.runtime.IOperationAdviceNotifier;
import com.ibm.team.process.internal.common.advice.runtime.Messages;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;

public class ParticipantInfoCollector
implements IParticipantInfoCollector {
    private final OperationAdviceManager fOperationAdviceManager;
    private final ParticipantReport fReport;

    public ParticipantInfoCollector(OperationAdviceManager operationAdviceManager, ParticipantReport report) {
        this.fOperationAdviceManager = operationAdviceManager;
        this.fReport = report;
    }

    @Override
    public void addInfo(IReportInfo info) {
        this.addInfos(new IReportInfo[]{info});
    }

    @Override
    public void addInfos(final IReportInfo[] infos) {
        this.fReport.addInfos(infos);
        this.fOperationAdviceManager.runAdviceNotifier(new IOperationAdviceNotifier(){

            @Override
            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleInfosAdded(infos);
            }
        });
    }

    @Override
    public IReportInfo createExceptionInfo(String summary, Throwable exception) {
        String description = NLS.bind(Messages.getCommonString("ParticipantInfoCollector.0"), exception.getMessage());
        ReportInfo info = (ReportInfo)this.createInfo(summary, description);
        info.setIdentifier("com.ibm.team.process.exceptionProblem");
        info.setSeverity(4);
        return info;
    }

    @Override
    public IReportInfo createInfo(String summary, String description) {
        ReportInfo problem = AdvicePackage.eINSTANCE.getAdviceFactory().createReportInfo();
        problem.setDescription(description);
        problem.setIdentifier("com.ibm.team.process.participantInfo");
        problem.setSeverity(0);
        problem.setSummary(summary);
        return problem;
    }
}

