/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import com.ibm.team.repository.common.utils.IInputStreamProvider;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class InputStreamUtil {
    private InputStreamUtil() {
    }

    public static int countLines(IInputStreamProvider provider, String charset, IProgressMonitor monitor) throws IOException {
        int count = 0;
        InputStream stream = provider.getInputStream(monitor);
        try {
            String next;
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(stream, charset));
            while ((next = streamReader.readLine()) != null) {
                ++count;
            }
        }
        finally {
            stream.close();
        }
        return count;
    }

    public static boolean isEmpty(IInputStreamProvider provider, IProgressMonitor monitor) throws IOException {
        InputStream fileContents = provider.getInputStream(monitor);
        boolean isEmpty = false;
        try {
            isEmpty = fileContents.read() == -1;
        }
        finally {
            fileContents.close();
        }
        return isEmpty;
    }

    public static int write(OutputStream tos, InputStream inputStream, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int totalBytesRead = 0;
        byte[] nextRead = new byte[65536];
        int bytesRead = 0;
        while (bytesRead >= 0) {
            InputStreamUtil.checkCanceled((IProgressMonitor)progress);
            bytesRead = inputStream.read(nextRead);
            progress.setWorkRemaining(100);
            progress.worked(50);
            if (bytesRead <= 0) continue;
            tos.write(nextRead, 0, bytesRead);
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    public static int write(OutputStream tos, IInputStreamProvider provider, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        InputStream inputStream = provider.getInputStream((IProgressMonitor)progress.newChild(100));
        try {
            int n = InputStreamUtil.write(tos, inputStream, (IProgressMonitor)progress);
            return n;
        }
        finally {
            inputStream.close();
        }
    }

    public static void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException("Operation cancelled by user");
        }
    }

    /*
     * Loose catch block
     */
    public static boolean compareStreams(InputStream inputStream1, InputStream inputStream2, IProgressMonitor monitor) throws IOException {
        BufferedInputStream bufferedInputStream1 = new BufferedInputStream(inputStream1, 4096);
        try {
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(inputStream2, 4096);
            while (true) {
                int read1;
                block9: {
                    read1 = bufferedInputStream1.read();
                    int read2 = bufferedInputStream2.read();
                    if (read1 == read2) break block9;
                    bufferedInputStream2.close();
                    return false;
                }
                if (read1 != -1) continue;
                break;
            }
            bufferedInputStream2.close();
            return true;
            catch (Throwable throwable) {
                bufferedInputStream2.close();
                throw throwable;
            }
        }
        finally {
            bufferedInputStream1.close();
        }
    }

    public static boolean compareStreams(IInputStreamProvider streamProvider1, IInputStreamProvider streamProvider2, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        InputStream inputStream1 = streamProvider1.getInputStream((IProgressMonitor)progress.newChild(10));
        try {
            boolean bl;
            InputStream inputStream2 = streamProvider2.getInputStream((IProgressMonitor)progress.newChild(10));
            try {
                bl = InputStreamUtil.compareStreams(inputStream1, inputStream2, (IProgressMonitor)progress.newChild(80));
            }
            catch (Throwable throwable) {
                inputStream2.close();
                throw throwable;
            }
            inputStream2.close();
            return bl;
        }
        finally {
            inputStream1.close();
        }
    }

    public static void copyStream(OutputStream outputStream, InputStream inputStream, IProgressMonitor monitor) throws IOException {
        int next;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        byte[] buffer = new byte[8192];
        while ((next = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, next);
            progress.setWorkRemaining(10000);
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }
}

