/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate;

import com.urbancode.persistence.hibernate.audit.event.EmptyAuditEventProcessor;
import com.urbancode.persistence.hibernate.audit.event.IAuditEventProcessor;
import com.urbancode.persistence.hibernate.interceptor.ChainedInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.context.ThreadLocalSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUtil2 {
    private static final Logger log = LoggerFactory.getLogger(HibernateUtil2.class);
    private static final String HIBERNATE_PROPERTIES_RESOURCE = "com/urbancode/persistence/hibernate/hibernate.cfg.properties";
    private static final String ROOT_HIBERNATE_PROPERTIES_RESOURCE = "hibernate.cfg.properties";
    private static final String HIBERNATE_CLASS_RESOURCE = "com/urbancode/persistence/hibernate/hibernate.cfg.classes";
    private static final String HIBERNATE_LISTENERS_RESOURCE = "com/urbancode/persistence/hibernate/hibernate.cfg.listeners";
    private static final String HIBERNATE_INTERCEPTORS_RESOURCE = "com/urbancode/persistence/hibernate/hibernate.cfg.interceptors";
    private SessionFactory sessionFactory = null;
    private IAuditEventProcessor auditEventProcessor = new EmptyAuditEventProcessor();

    public void init() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.init((Properties)null);
    }

    public synchronized void init(Properties inputProps) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        this.loadProperties(cfg, inputProps);
        this.loadAnnotatedClasses(cfg);
        this.loadListeners(cfg);
        this.loadInterceptors(cfg);
        this.sessionFactory = cfg.configure().buildSessionFactory();
    }

    public synchronized void init(SessionFactory factory) {
        if (this.sessionFactory != null) {
            throw new IllegalStateException("HibernateUtils has already been configured. Call reset() if required.");
        }
        this.sessionFactory = factory;
    }

    public synchronized void reset() {
        this.sessionFactory = null;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            throw new HibernateException("Initialize HibernateUtil before getting the session factory");
        }
        return this.sessionFactory;
    }

    public synchronized void unbindThreadLocalSessionContext() {
        if (this.sessionFactory != null) {
            ThreadLocalSessionContext.unbind((SessionFactory)this.sessionFactory);
        }
    }

    private void loadProperties(AnnotationConfiguration cfg, Properties inputProperties) throws IOException {
        if (cfg == null) {
            throw new IllegalArgumentException("The parameter cfg must be non-null.");
        }
        Properties props = this.getSessionFactoryProperties();
        cfg.addProperties(props);
        if (inputProperties != null) {
            cfg.addProperties(inputProperties);
        }
    }

    private void loadAnnotatedClasses(AnnotationConfiguration cfg) throws IOException, ClassNotFoundException {
        if (cfg == null) {
            throw new IllegalArgumentException("The parameter cfg must be non-null.");
        }
        HashSet<Class<?>> entitites = this.loadClassesFromResource(HIBERNATE_CLASS_RESOURCE);
        for (Class<?> entityClass : entitites) {
            if (log.isDebugEnabled()) {
                log.debug("Adding annotated Class '" + entityClass + "'.");
            }
            cfg.addAnnotatedClass(entityClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadListeners(AnnotationConfiguration cfg) throws IOException, ClassNotFoundException {
        HashMap<String, HashSet<String>> listeners = new HashMap<String, HashSet<String>>();
        Enumeration<URL> listnUrls = HibernateUtil2.class.getClassLoader().getResources(HIBERNATE_LISTENERS_RESOURCE);
        while (listnUrls.hasMoreElements()) {
            URL listnUrl = listnUrls.nextElement();
            InputStream listnStream = listnUrl.openStream();
            try {
                Properties props = new Properties();
                props.load(listnStream);
                String classPrefix = (String)props.remove("class-prefix");
                classPrefix = classPrefix == null ? "" : classPrefix.trim();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String clazz = (classPrefix + (String)entry.getKey()).trim();
                    String types = (String)entry.getValue();
                    if (log.isDebugEnabled()) {
                        log.debug("Found listener " + clazz + " for events " + types);
                    }
                    for (String type : types.split(",")) {
                        if ((type = type.trim()).length() == 0) continue;
                        HashSet<String> classSet = (HashSet<String>)listeners.get(type);
                        if (classSet == null) {
                            classSet = new HashSet<String>();
                            listeners.put(type, classSet);
                        }
                        classSet.add(clazz);
                    }
                }
            }
            finally {
                listnStream.close();
            }
        }
        for (Map.Entry entry : listeners.entrySet()) {
            cfg.setListeners((String)entry.getKey(), ((HashSet)entry.getValue()).toArray(new String[0]));
        }
    }

    private void loadInterceptors(AnnotationConfiguration cfg) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ChainedInterceptor chainedInterceptor = new ChainedInterceptor();
        log.debug("LOADING INTERCEPTORS");
        HashSet<Class<?>> interceptors = this.loadClassesFromResource(HIBERNATE_INTERCEPTORS_RESOURCE);
        for (Class<?> interceptor : interceptors) {
            if (log.isDebugEnabled()) {
                log.debug("Loading interceptor '" + interceptor.getName() + "'.");
            }
            chainedInterceptor.add((Interceptor)interceptor.newInstance());
        }
        cfg.setInterceptor((Interceptor)chainedInterceptor);
        log.debug("LOADED INTERCEPTORS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<Class<?>> loadClassesFromResource(String resourceName) throws ClassNotFoundException, IOException {
        HashSet result = new HashSet();
        Enumeration<URL> urls = HibernateUtil2.class.getClassLoader().getResources(resourceName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(url.openStream(), "UTF-8"));
            try {
                String className = null;
                while ((className = lineReader.readLine()) != null) {
                    if ((className = className.trim()).length() <= 0 || className.startsWith("#")) continue;
                    result.add(Class.forName(className));
                }
            }
            finally {
                lineReader.close();
            }
        }
        return result;
    }

    public Properties getSessionFactoryProperties() throws IOException {
        Properties props = new Properties();
        this.getSessionFactoryProperties(props, HIBERNATE_PROPERTIES_RESOURCE);
        this.getSessionFactoryProperties(props, ROOT_HIBERNATE_PROPERTIES_RESOURCE);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getSessionFactoryProperties(Properties props, String resourceName) throws IOException {
        if (props == null) {
            throw new IllegalArgumentException("The parameter props must be non-null.");
        }
        Enumeration<URL> propUrls = HibernateUtil2.class.getClassLoader().getResources(resourceName);
        while (propUrls.hasMoreElements()) {
            URL propUrl = propUrls.nextElement();
            InputStream propStream = propUrl.openStream();
            try {
                props.load(propStream);
            }
            finally {
                propStream.close();
            }
        }
        return props;
    }

    public synchronized void closeSessionFactory() {
        if (log.isDebugEnabled()) {
            log.debug("Closing hibernate session factory.");
        }
        if (this.sessionFactory != null) {
            if (!this.sessionFactory.isClosed()) {
                this.sessionFactory.close();
            } else if (log.isWarnEnabled()) {
                log.warn("The hibernate session factory appears to have already been closed!");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Successfully closed hibernate session factory.");
        }
    }

    public Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void setAuditEventProcessor(IAuditEventProcessor auditEventProcessor) {
        this.auditEventProcessor = auditEventProcessor;
    }

    public IAuditEventProcessor getAuditEventProcessor() {
        return this.auditEventProcessor;
    }
}

