/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.sql;

import com.urbancode.sql.XADataSourceAdapter;
import javax.transaction.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingSynchronization
implements Synchronization {
    private static final Logger log = LoggerFactory.getLogger(XADataSourceAdapter.class);
    private final Synchronization delegate;

    LoggingSynchronization(Synchronization delegate) {
        this.delegate = delegate;
    }

    public void afterCompletion(int status) {
        if (log.isTraceEnabled()) {
            log.trace("afterCompletion()");
        }
        this.delegate.afterCompletion(status);
        if (log.isDebugEnabled()) {
            log.debug("After JTA Transaction completion");
        }
    }

    public void beforeCompletion() {
        if (log.isTraceEnabled()) {
            log.trace("beforeCompletion()");
        }
        if (log.isDebugEnabled()) {
            log.debug("Before JTA Transaction completion");
        }
        this.delegate.beforeCompletion();
    }
}

