/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.core.runtime.OperationCanceledException;

class CachingRetryableRequestEntity
implements RequestEntity {
    private final int contentSize;
    private final String contentType;
    private final byte[] buffer;

    public CachingRetryableRequestEntity(InputStream stream, int size, String contentType, HttpMethod method) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Stream may not be null");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size must be greater than zero");
        }
        this.contentSize = size;
        this.contentType = contentType;
        this.buffer = CachingRetryableRequestEntity.initBuffer(stream, size, method);
    }

    private static byte[] initBuffer(InputStream stream, int size, HttpMethod method) throws IOException {
        byte[] buffer = new byte[size];
        int pos = 0;
        try {
            int count;
            while ((count = stream.read(buffer, pos, buffer.length - pos)) > 0) {
                if ((pos += count) <= buffer.length) continue;
                throw new IllegalStateException(NLS.bind((String)"The content size specified for the input stream was {0} but more bytes than that were in the input stream", (Object)size, (Object[])new Object[0]));
            }
        }
        catch (OperationCanceledException e) {
            method.abort();
            throw e;
        }
        return buffer;
    }

    public long getContentLength() {
        return this.contentSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream output) throws IOException {
        output.write(this.buffer);
    }
}

