/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.internal.client.Messages;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.service.IAccessGroupService;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class AccessGroupClientService
implements IAccessGroupClientService {
    private final IClientLibraryContext fContext;
    private IAccessGroupService fAccessGroupService;
    private static final int MAX_GROUPS_TO_FETCH = 250;

    public AccessGroupClientService(IClientLibraryContext context) {
        this.fContext = context;
    }

    @Override
    public IAccessGroup[] getAccessGroups(final String filter, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IAccessGroup[])this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IAccessGroup[] groups = AccessGroupClientService.this.getService().getAvailableAccessGroups(null, filter, 250);
                List shared = AccessGroupClientService.this.shareList(Arrays.asList(groups));
                return shared.toArray(new IAccessGroup[shared.size()]);
            }
        }, monitor);
    }

    @Override
    public IAccessGroup getAccessGroupForGroupContextId(final UUID groupContextId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IAccessGroup)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return AccessGroupClientService.this.shareSingle((IItem)AccessGroupClientService.this.getService().getAccessGroupForGroupContextId(groupContextId));
            }
        }, monitor);
    }

    @Override
    public IAccessGroup save(IAccessGroup accessGroup, IProgressMonitor monitor) throws TeamRepositoryException {
        AccessGroupSaveRunnable runnable = new AccessGroupSaveRunnable(accessGroup);
        IProcessClientService processClient = (IProcessClientService)this.fContext.teamRepository().getClientLibrary(IProcessClientService.class);
        processClient.execute(runnable, Messages.getString("AccessGroupClientService.2"), monitor);
        return (IAccessGroup)this.shareSingle((IItem)runnable.getAccessGroup());
    }

    private IAccessGroupService getService() {
        if (this.fAccessGroupService == null) {
            this.fAccessGroupService = (IAccessGroupService)this.fContext.getServiceInterface(IAccessGroupService.class);
        }
        return this.fAccessGroupService;
    }

    private List shareList(List items) throws TeamRepositoryException {
        List sharedItems = this.fContext.teamRepository().itemManager().applyItemUpdates(items);
        int i = 0;
        while (i < sharedItems.size()) {
            Object shared = sharedItems.get(i);
            if (shared == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("AccessGroupClientService.0"), (Object)items.get(i).toString()));
            }
            ++i;
        }
        return sharedItems;
    }

    protected IItem shareSingle(IItem item) throws TeamRepositoryException {
        if (item != null) {
            List items = this.fContext.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(item));
            Object shared = items.get(0);
            if (shared == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("AccessGroupClientService.1"), (Object)item));
            }
            return (IItem)shared;
        }
        return null;
    }

    private class AccessGroupSaveRunnable
    extends ProcessRunnable {
        private IAccessGroup fAccessGroup;

        public AccessGroupSaveRunnable(IAccessGroup accessGroup) {
            this.fAccessGroup = accessGroup;
        }

        public IAccessGroup getAccessGroup() {
            return this.fAccessGroup;
        }

        public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
            return (IOperationReport)AccessGroupClientService.this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    IItemsResponse response = AccessGroupClientService.this.getService().saveAccessGroup(AccessGroupSaveRunnable.this.fAccessGroup);
                    AccessGroupSaveRunnable.this.fAccessGroup = (IAccessGroup)response.getFirstClientItem();
                    return response.getOperationReport();
                }
            }, monitor);
        }
    }
}

