/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.internal.client.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class HttpClientUtil {
    public static ITeamRawRestServiceClient.IRawRestClientConnection.Response get(final URI uri, ITeamRepository repo, IClientLibraryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        final ITeamRawRestServiceClient restServiceClient = repo.getRawRestServiceClient();
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response>(){

            public ITeamRawRestServiceClient.IRawRestClientConnection.Response run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    ITeamRawRestServiceClient.IRawRestClientConnection connection = restServiceClient.getConnection(uri);
                    try {
                        return connection.doGet();
                    }
                    catch (TeamServiceException e) {
                        ITeamRawRestServiceClient.IRawRestClientConnection.Response realResponse = connection.getResponse();
                        if (realResponse != null) {
                            HttpClientUtil.throwHttpClientError(realResponse, e);
                        }
                        throw e;
                    }
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        }, monitor);
        return response;
    }

    private static TeamRepositoryException throwHttpClientError(ITeamRawRestServiceClient.IRawRestClientConnection.Response response, TeamServiceException cause) throws TeamRepositoryException {
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            throw cause;
        }
        String errorMessage = HttpClientUtil.getResponseMessage(response);
        switch (statusCode) {
            case 400: {
                if (errorMessage != null && !errorMessage.isEmpty()) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ThinClientProcess.2"), (Object)response.getStatusText(), (Object)errorMessage), (Throwable)cause);
                }
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ThinClientProcess.3"), (Object)response.getStatusText()), (Throwable)cause);
            }
            case 404: {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ThinClientProcess.4"), (Object)response.getStatusText()), (Throwable)cause);
            }
        }
        if (errorMessage != null && !errorMessage.isEmpty()) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ThinClientProcess.2"), (Object)response.getStatusText(), (Object)errorMessage), (Throwable)cause);
        }
        throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ThinClientProcess.3"), (Object)response.getStatusText()), (Throwable)cause);
    }

    private static String getResponseMessage(ITeamRawRestServiceClient.IRawRestClientConnection.Response response) {
        StringBuffer buffer = new StringBuffer();
        try {
            InputStream responseStream = response.getResponseStream();
            if (responseStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream, "UTF-8"));
                char[] chars = new char[1024];
                int read = reader.read(chars);
                while (read > 0) {
                    buffer.append(chars, 0, read);
                    read = reader.read(chars);
                }
            }
        }
        catch (IOException iOException) {}
        return buffer.toString();
    }
}

