/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IProcessItemWorkingCopy;
import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.IWorkingCopyManager;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.ProcessDefinitionWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ProjectAreaWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.TeamAreaWorkingCopy;
import java.util.HashMap;
import java.util.Map;

public class WorkingCopyManager
implements IWorkingCopyManager {
    private Map fCache = new HashMap();
    private IUpdateContext fUpdateContext;

    @Override
    public synchronized void connect(IProcessItem item) {
        if (item == null) {
            throw new IllegalArgumentException(Messages.getString("WorkingCopyManager.0"));
        }
        WorkingCopyInfo info = this.getWorkingCopyInfo(item);
        if (info == null) {
            info = this.createWorkingCopyInfo(item);
            this.fCache.put(item.getItemId(), info);
        } else {
            ++info.fRefCount;
        }
    }

    @Override
    public synchronized void disconnect(IProcessItem item) {
        WorkingCopyInfo info = this.getWorkingCopyInfo(item);
        if (info != null) {
            --info.fRefCount;
            if (info.fRefCount == 0L) {
                this.disposeWorkingCopyInfo((WorkingCopyInfo)this.fCache.remove(item.getItemId()));
            }
        }
    }

    @Override
    public synchronized IProcessItemWorkingCopy getWorkingCopy(IProcessItem item) {
        WorkingCopyInfo info = this.getWorkingCopyInfo(item);
        if (info != null) {
            return info.fWorkingCopy;
        }
        return null;
    }

    private WorkingCopyInfo createWorkingCopyInfo(IProcessItem item) {
        IProcessItemWorkingCopy wc = this.createWorkingCopy(item, false);
        if (wc == null) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("WorkingCopyManager.1")) + item.getClass().getName());
        }
        WorkingCopyInfo info = new WorkingCopyInfo();
        info.fWorkingCopy = wc;
        info.fRefCount = 1L;
        return info;
    }

    private void disposeWorkingCopyInfo(WorkingCopyInfo info) {
        if (info.fWorkingCopy != null) {
            info.fWorkingCopy.dispose();
            info.fWorkingCopy = null;
        }
    }

    private WorkingCopyInfo getWorkingCopyInfo(IProcessItem item) {
        if (item != null) {
            return (WorkingCopyInfo)this.fCache.get(item.getItemId());
        }
        return null;
    }

    private IProcessItemWorkingCopy createWorkingCopy(IProcessItem item, boolean privateWorkingCopy) {
        if (item instanceof IProjectArea) {
            IProjectArea area = (IProjectArea)item;
            return new ProjectAreaWorkingCopy(area);
        }
        if (item instanceof ITeamArea) {
            ITeamArea area = (ITeamArea)item;
            return new TeamAreaWorkingCopy(area, !privateWorkingCopy);
        }
        if (item instanceof IProcessDefinition) {
            IProcessDefinition definition = (IProcessDefinition)item;
            return new ProcessDefinitionWorkingCopy(definition);
        }
        return null;
    }

    @Override
    public void setUpdateContext(IUpdateContext context) {
        this.fUpdateContext = context;
    }

    @Override
    public IUpdateContext getUpdateContext() {
        return this.fUpdateContext;
    }

    @Override
    public IProcessItemWorkingCopy createPrivateWorkingCopy(IProcessItem item) throws IllegalArgumentException {
        IProcessItemWorkingCopy wc = this.createWorkingCopy(item, true);
        if (wc != null) {
            return wc;
        }
        throw new IllegalArgumentException(Messages.getString("WorkingCopyManager.2"));
    }

    private static class WorkingCopyInfo {
        public IProcessItemWorkingCopy fWorkingCopy;
        public long fRefCount;

        private WorkingCopyInfo() {
        }
    }
}

