/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.dbhm;

import com.ibm.team.internal.repository.rcp.dbhm.BTreeHeap;
import com.ibm.team.internal.repository.rcp.dbhm.CachedDiskBackedHashMap;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.DiskBackedHashMap;
import com.ibm.team.internal.repository.rcp.dbhm.HeapADT;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayInputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayOutputStream;
import com.ibm.team.repository.common.util.NLS;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ContainedDiskBackedHashMap<K, V>
extends CachedDiskBackedHashMap<K, V>
implements HeapADT,
Serializable {
    private static final long serialVersionUID = 7283194992693856344L;
    protected static final Map<ContainedDBHMRecord, WeakReference<ContainedDiskBackedHashMap<?, ?>>> containedMap = Collections.synchronizedMap(new WeakHashMap());
    protected static final int METADATA_SIZE = 41;
    protected long metadataOffset;
    protected ContainedDBHMRecord record;
    protected long refCount;
    protected boolean metadataChanged;
    protected int nestingLevel;

    public ContainedDiskBackedHashMap(DiskBackedHashMap<?, ?> parent) throws IOException {
        super(17L, 0.75, 0);
        this.init(parent);
    }

    public ContainedDiskBackedHashMap(DiskBackedHashMap<?, ?> parent, long initialCapacity, double loadFactor) throws IOException {
        super(initialCapacity, loadFactor, 0);
        this.init(parent);
    }

    public ContainedDiskBackedHashMap(DiskBackedHashMap<?, ?> parent, long initialCapacity) throws IOException {
        super(initialCapacity, 0.75, 0);
        this.init(parent);
    }

    public ContainedDiskBackedHashMap(DiskBackedHashMap<?, ?> parent, Map<? extends K, ? extends V> toCopy) throws IOException {
        super(Math.max(toCopy.size() * 2 + 1, 17), 0.75, 0);
        this.init(parent);
        this.putAll(toCopy);
    }

    protected void init(DiskBackedHashMap<?, ?> parent) throws IOException {
        if (parent.heap == null) {
            throw new IllegalStateException("The parent's heap has not been initialized");
        }
        this.heap = parent.heap;
        super.initTablePtr();
        this.metadataOffset = this.heap.allocate(41L);
        this.record = new ContainedDBHMRecord(this.metadataOffset, this.heap);
        containedMap.put(this.record, new WeakReference<ContainedDiskBackedHashMap>(this));
        this.writeMetadata();
    }

    protected void writeMetadata() throws IOException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(41);
        DataOutputStream dOut = new DataOutputStream(out);
        dOut.writeByte(1);
        dOut.writeLong(this.tablePtr);
        dOut.writeLong(this.size);
        dOut.writeLong(this.capacity);
        dOut.writeDouble(this.loadFactor);
        dOut.writeLong(this.refCount);
        dOut.flush();
        OutputStream hOut = this.heap.getOutputStream(this.metadataOffset);
        try {
            out.writeTo(hOut);
        }
        finally {
            hOut.close();
        }
        this.metadataChanged = false;
    }

    @Override
    protected void initHeap() throws IOException {
    }

    @Override
    protected void initTablePtr() throws IOException {
    }

    @Override
    public Object init(BTreeHeap heap) throws IOException {
        ContainedDBHMRecord r = new ContainedDBHMRecord(this.metadataOffset, heap);
        WeakReference<ContainedDiskBackedHashMap<?, ?>> ref = containedMap.get(r);
        if (ref != null) {
            ContainedDiskBackedHashMap map = (ContainedDiskBackedHashMap)ref.get();
            if (map != null) {
                return map;
            }
            containedMap.remove(r);
        }
        this.heap = heap;
        InputStream in = heap.getInputStream(this.metadataOffset);
        try {
            byte[] buf = new byte[41];
            int read = 0;
            while (read != 41) {
                int bytesRead = in.read(buf, read, 41 - read);
                if (bytesRead < 0) {
                    throw new EOFException();
                }
                read += bytesRead;
            }
            DataInputStream dIn = new DataInputStream(new UnsynchronizedByteArrayInputStream(buf));
            byte formatVersion = dIn.readByte();
            if (formatVersion != 1) {
                String msg = NLS.bind((String)"Old format version {0} does not match version {1}.", (Object)formatVersion, (Object[])new Object[]{1});
                throw new IOException(msg);
            }
            this.tablePtr = dIn.readLong();
            this.size = dIn.readLong();
            this.capacity = dIn.readLong();
            this.loadFactor = dIn.readDouble();
            this.refCount = dIn.readLong();
            this.record = r;
            containedMap.put(this.record, new WeakReference<ContainedDiskBackedHashMap>(this));
            super.init();
        }
        finally {
            in.close();
        }
        return this;
    }

    @Override
    protected DiskBackedHashMap.Entry putNew(K key, V value, DiskBackedHashMap.Entry predecessor) throws IOException {
        this.metadataChanged = true;
        return super.putNew(key, value, predecessor);
    }

    @Override
    protected void initTable(long offset, long capacity) throws IOException {
        super.initTable(offset, capacity);
        this.metadataChanged = true;
    }

    @Override
    protected void removeEntry(DiskBackedHashMap.Entry entry) throws IOException {
        super.removeEntry(entry);
        this.metadataChanged = true;
    }

    @Override
    public void delete() throws IOException {
        assert (this.refCount > 0L);
        --this.refCount;
        this.metadataChanged = true;
        if (this.nestingLevel == 0) {
            this.writeMetadata();
        }
    }

    @Override
    public void add() throws IOException {
        ++this.refCount;
        this.metadataChanged = true;
        if (this.nestingLevel == 0) {
            this.writeMetadata();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.metadataOffset = in.readLong();
        this.maxCacheSize = 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.metadataOffset);
    }

    protected void startOp() {
        ++this.nestingLevel;
    }

    protected void endOp(boolean normalFinish) {
        --this.nestingLevel;
        assert (this.nestingLevel >= 0);
        if (this.nestingLevel == 0 && this.metadataChanged) {
            if (normalFinish) {
                try {
                    this.writeMetadata();
                }
                catch (IOException e) {
                    throw new DBHMException(e);
                }
            }
            try {
                this.writeMetadata();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public V put(K key, V value) {
        this.startOp();
        boolean success = false;
        try {
            V result = super.put(key, value);
            success = true;
            V v = result;
            return v;
        }
        finally {
            this.endOp(success);
        }
    }

    @Override
    public V remove(Object key) {
        this.startOp();
        boolean success = false;
        try {
            Object result = super.remove(key);
            success = true;
            Object v = result;
            return v;
        }
        finally {
            this.endOp(success);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.startOp();
        boolean success = false;
        try {
            super.putAll(t);
            success = true;
        }
        finally {
            this.endOp(success);
        }
    }

    @Override
    public void clear() {
        this.startOp();
        boolean success = false;
        try {
            if (this.size != 0L) {
                Iterator it = this.entrySet().iterator();
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
            }
            success = true;
        }
        finally {
            this.endOp(success);
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ContainedKeySet();
        }
        return this.keySet;
    }

    public DiskBackedHashMap.EntrySet entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ContainedEntrySet();
        }
        return this.entrySet;
    }

    public DiskBackedHashMap.Values values() {
        if (this.values == null) {
            this.values = new ContainedValues();
        }
        return this.values;
    }

    public void deallocate() throws IOException {
        if (this.refCount != 0L) {
            throw new IllegalStateException();
        }
        ++this.nestingLevel;
        try {
            this.clear();
            this.heap.free(this.tablePtr);
            this.heap = null;
        }
        finally {
            --this.nestingLevel;
        }
    }

    protected static class ContainedDBHMRecord {
        protected long offset;
        protected BTreeHeap heap;

        public ContainedDBHMRecord(long offset, BTreeHeap heap) {
            this.offset = offset;
            this.heap = heap;
        }

        public int hashCode() {
            return (int)(this.offset ^ this.offset >>> 32) ^ System.identityHashCode(this.heap);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContainedDBHMRecord)) {
                return false;
            }
            ContainedDBHMRecord other = (ContainedDBHMRecord)o;
            return other.offset == this.offset && other.heap == this.heap;
        }
    }

    protected class ContainedEntrySet
    extends DiskBackedHashMap.EntrySet {
        protected ContainedEntrySet() {
            super(ContainedDiskBackedHashMap.this);
        }

        @Override
        public boolean remove(Object o) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.remove(o);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.retainAll(c);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.removeAll(c);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public void clear() {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                super.clear();
                success = true;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }
    }

    protected class ContainedKeySet
    extends DiskBackedHashMap.KeySet {
        protected ContainedKeySet() {
            super(ContainedDiskBackedHashMap.this);
        }

        @Override
        public boolean remove(Object o) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.remove(o);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.retainAll(c);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.removeAll(c);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public void clear() {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                super.clear();
                success = true;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }
    }

    protected class ContainedValues
    extends DiskBackedHashMap.Values {
        protected ContainedValues() {
            super(ContainedDiskBackedHashMap.this);
        }

        @Override
        public boolean remove(Object o) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.remove(o);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.retainAll(c);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                boolean result = super.removeAll(c);
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }

        @Override
        public void clear() {
            ContainedDiskBackedHashMap.this.startOp();
            boolean success = false;
            try {
                super.clear();
                success = true;
            }
            finally {
                ContainedDiskBackedHashMap.this.endOp(success);
            }
        }
    }
}

