/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends InputStream {
    protected final InputStream in;
    protected final OutputStream[] out;
    protected long writtenSinceMark;
    protected long readSinceReset;

    public TeeInputStream(InputStream in, OutputStream[] out) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        if (out == null) {
            throw new IllegalArgumentException();
        }
        if (out.length == 0) {
            throw new IllegalArgumentException();
        }
        int i = out.length;
        while (i != 0) {
            if (out[--i] != null) continue;
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.out = out;
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.in.read();
        if (byteRead != -1) {
            if (this.writtenSinceMark == this.readSinceReset) {
                int i = this.out.length;
                while (i != 0) {
                    this.out[--i].write(byteRead);
                }
                ++this.readSinceReset;
                ++this.writtenSinceMark;
            } else {
                ++this.readSinceReset;
            }
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = this.in.read(b);
        if (bytesRead != -1) {
            if (this.writtenSinceMark < this.readSinceReset + (long)bytesRead) {
                int start = (int)(this.writtenSinceMark - this.readSinceReset);
                int len = bytesRead - start;
                int i = this.out.length;
                while (i != 0) {
                    this.out[--i].write(b, start, len);
                }
                this.readSinceReset += (long)bytesRead;
                this.writtenSinceMark += (long)len;
            } else {
                this.readSinceReset += (long)bytesRead;
            }
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead != -1) {
            if (this.writtenSinceMark < this.readSinceReset + (long)bytesRead) {
                int skip = (int)(this.writtenSinceMark - this.readSinceReset);
                int start = skip + off;
                int toWriteLen = bytesRead - skip;
                int i = this.out.length;
                while (i != 0) {
                    this.out[--i].write(b, start, toWriteLen);
                }
                this.readSinceReset += (long)bytesRead;
                this.writtenSinceMark += (long)toWriteLen;
            } else {
                this.readSinceReset += (long)bytesRead;
            }
        }
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.readSinceReset = 0L;
        this.writtenSinceMark = 0L;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.readSinceReset = 0L;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

