/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.client.IAdvisorProblemResolution;
import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.client.ProcessClient;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.internal.client.InternalProcessClient;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class AdvisorProblemResolution
implements IAdvisorProblemResolution {
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_CLASS = "class";
    private IConfigurationElement fConfigurationElement;
    private IAdvisorProblemResolutionDelegate fDelegate;
    private boolean fDelegateLoaded = false;

    public AdvisorProblemResolution(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    @Override
    public String getLabel() {
        return this.fConfigurationElement.getAttribute(ATTR_LABEL);
    }

    @Override
    public String getDescription() {
        return this.fConfigurationElement.getAttribute(ATTR_DESCRIPTION);
    }

    @Override
    public void run(final IAdvisorInfo problem, final IProgressMonitor monitor) {
        if (this.fDelegate == null) {
            try {
                this.fDelegate = (IAdvisorProblemResolutionDelegate)this.fConfigurationElement.createExecutableExtension(ATTR_CLASS);
            }
            catch (CoreException exception) {
                InternalProcessClient.log(exception.getStatus());
            }
        }
        if (this.fDelegate != null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    boolean applied = AdvisorProblemResolution.this.fDelegate.run(problem, monitor);
                    if (applied) {
                        ((OperationAdviceManager)ProcessClient.getOperationAdviceManager()).setResolutionApplied((IReportInfo)problem, applied);
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
        monitor.done();
    }

    @Override
    public boolean mayBeApplicable(IAdvisorInfo problem) {
        IAdvisorProblemResolutionDelegate delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.mayBeApplicable(problem);
        }
        return false;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    private synchronized IAdvisorProblemResolutionDelegate getDelegate() {
        if (this.fDelegate == null && !this.fDelegateLoaded) {
            try {
                this.fDelegateLoaded = true;
                this.fDelegate = (IAdvisorProblemResolutionDelegate)this.fConfigurationElement.createExecutableExtension(ATTR_CLASS);
            }
            catch (CoreException exception) {
                InternalProcessClient.log(exception.getStatus());
            }
        }
        return this.fDelegate;
    }
}

