/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.internal.client.InternalProcessClient;
import com.ibm.team.process.internal.client.workingcopies.IServerRequest;
import com.ibm.team.process.internal.client.workingcopies.IUpdateRequest;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ExecUtil {
    public static void asyncExec(final IUpdateRequest request, final IUpdateContext context, IProgressMonitor monitor) {
        if (!ThreadCheck.longOpsProhibited()) {
            monitor = ExecUtil.getProgressMonitor(monitor);
            try {
                request.execute(context, monitor);
                return;
            }
            finally {
                monitor.done();
            }
        }
        Job job = new Job(request.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                return request.execute(context, monitor);
            }
        };
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncExec(final IServerRequest request, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!ThreadCheck.longOpsProhibited()) {
            monitor = ExecUtil.getProgressMonitor(monitor);
            try {
                request.execute(monitor);
                return;
            }
            finally {
                monitor.done();
            }
        }
        final IStatus[] syncPoint = new IStatus[1];
        Job job = new Job(request.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                IStatus[] iStatusArray = syncPoint;
                synchronized (syncPoint) {
                    syncPoint.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    try {
                        try {
                            request.execute(monitor);
                        }
                        catch (Exception x) {
                            syncPoint[0] = new Status(0, "com.ibm.team.process.client", 0, this.getName(), (Throwable)x);
                            Status status = syncPoint[0];
                            IStatus[] iStatusArray2 = syncPoint;
                            synchronized (syncPoint) {
                                syncPoint.notifyAll();
                                // ** MonitorExit[var5_6] (shouldn't be in output)
                                return status;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        IStatus[] iStatusArray3 = syncPoint;
                        synchronized (syncPoint) {
                            syncPoint.notifyAll();
                            // ** MonitorExit[var5_8] (shouldn't be in output)
                            throw throwable;
                        }
                    }
                    IStatus iStatus = syncPoint[0] = Status.OK_STATUS;
                    IStatus[] iStatusArray4 = syncPoint;
                    synchronized (syncPoint) {
                        syncPoint.notifyAll();
                        // ** MonitorExit[var5_7] (shouldn't be in output)
                        return iStatus;
                    }
                }
            }
        };
        job.schedule();
        try {
            IStatus[] iStatusArray = syncPoint;
            synchronized (syncPoint) {
                if (syncPoint[0] == null) {
                    try {
                        syncPoint.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                job.join();
                IStatus result = job.getResult();
                if (result == null) {
                    InternalProcessClient.log(Messages.getString("ExecUtil.0"));
                } else {
                    if (result.getException() instanceof TeamRepositoryException) {
                        throw (TeamRepositoryException)result.getException();
                    }
                    if (result.getException() instanceof RuntimeException) {
                        throw (RuntimeException)result.getException();
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }
}

