/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.client.IProcessInternalClientService;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.IPropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.ProjectAreaWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.PropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.process.internal.common.IProcessProviderCacheItemHandle;
import com.ibm.team.process.internal.common.ProcessProviderCacheItem;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.internal.common.enterprise.IProcessProvider;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProcessProviderWorkingCopy
extends PropertyWorkingCopy
implements IPropertyWorkingCopy {
    public static String PROCESS_PROVIDER_SETTING_EVENT_PROPERTY = "ProcessProviderChange";
    public static final String USES_PROCESS_EVENT_PROPERTY = "ProcessProviderUsesChange";
    private static final String IS_PROCESS_EVENT_PROPERTY = "ProcessProviderIsChange";
    public static final String PROCESS_PROVIDER_EVENT_PROPERTY = "ProcessProviderProjectAreaChange";
    private static final String EMPTY_STRING = "";
    private Boolean fIsProcessProvider;
    private Boolean fUsesProcessProvider;
    private IProcessProvider fProcessProvider;
    private ProjectAreaWorkingCopy fProjectAreaWorkingCopy;
    protected ITeamRepository fCachedTeamRepository;
    private boolean fIsRemote;
    private String fRemoteServerTitle;

    public ProcessProviderWorkingCopy(ProjectAreaWorkingCopy projectAreaWorkingCopy) {
        this.fProjectAreaWorkingCopy = projectAreaWorkingCopy;
        ProjectArea projectArea = (ProjectArea)this.fProjectAreaWorkingCopy.getUnderlyingProcessArea();
        this.fCachedTeamRepository = (ITeamRepository)projectArea.getOrigin();
        this.updateFields(projectArea);
    }

    private void updateFields(ProjectArea projectArea) {
        this.fIsProcessProvider = projectArea.isProcessProvider();
        this.fUsesProcessProvider = projectArea.getProcessProvider() != null || projectArea.getRemoteProcessProvider() != null;
    }

    public Boolean getIsProcessProvider() {
        return this.fIsProcessProvider;
    }

    public Boolean getUsesProcessProvider() {
        return this.fUsesProcessProvider;
    }

    public IProcessProvider getProcessProvider() {
        return this.fProcessProvider;
    }

    public void asyncUpdate(final IProjectArea projectArea, final int flags, IUpdateContext context, IProgressMonitor monitor) {
        if (this.isDisposed()) {
            return;
        }
        UpdateRequest updateRequest = new UpdateRequest(Messages.getString("ProcessProviderWorkingCopy.JOB_NAME")){

            @Override
            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                if (ProcessProviderWorkingCopy.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                monitor.beginTask(ProcessProviderWorkingCopy.EMPTY_STRING, 1000);
                try {
                    try {
                        ProjectArea area = (ProjectArea)projectArea;
                        ProcessProviderWorkingCopy.this.updateProcessProviderFromProjectArea(area, flags, monitor);
                        ProcessProviderWorkingCopy.this.updateFields(area);
                        ProcessProviderWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(ProcessProviderWorkingCopy.this, PROCESS_PROVIDER_SETTING_EVENT_PROPERTY, null, null));
                    }
                    catch (TeamRepositoryException exception) {
                        if (ProcessProviderWorkingCopy.this.isDisposed()) {
                            IStatus iStatus = Status.OK_STATUS;
                            monitor.done();
                            return iStatus;
                        }
                        Status status = new Status(4, "com.ibm.team.process.client", 0, this.getName(), (Throwable)exception);
                        monitor.done();
                        return status;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        ExecUtil.asyncExec(updateRequest, context, monitor);
    }

    @Override
    public boolean isDisposed() {
        return this.fIsProcessProvider == null && this.fUsesProcessProvider == null;
    }

    @Override
    public void dispose() {
        this.fIsProcessProvider = null;
        this.fUsesProcessProvider = null;
        this.fProcessProvider = null;
        super.dispose();
    }

    public void syncSave(IProjectArea mutableProjectArea, List processItemsToSaveCollector, SubProgressMonitor subProgressMonitor) throws TeamRepositoryException {
        ProjectArea projectArea = (ProjectArea)mutableProjectArea;
        if (this.fUsesProcessProvider.booleanValue()) {
            if (this.fProcessProvider == null) {
                throw new TeamRepositoryException(Messages.getString("ProcessProviderWorkingCopy.NO_PROCESS_PROVIDER_EXCEPTION_MESSAGE"));
            }
            if (this.isProcessProviderRemote()) {
                projectArea.setRemoteProcessProviderUrl(((ProcessProviderCacheItem)this.fProcessProvider).getProcessProviderUrl());
                projectArea.setProcessProvider(null);
            } else {
                projectArea.setProcessProvider((IProjectAreaHandle)((ProjectArea)this.fProcessProvider));
                projectArea.setRemoteProcessProviderUrl(EMPTY_STRING);
            }
        } else {
            projectArea.setProcessProvider(null);
            projectArea.setRemoteProcessProviderUrl(EMPTY_STRING);
        }
        projectArea.setIsProcessProvider(this.fIsProcessProvider.booleanValue());
    }

    public void setIsProcessProvider(Boolean isProcessProvider) {
        if (isProcessProvider != this.fIsProcessProvider) {
            Boolean oldValue = this.fIsProcessProvider;
            this.fIsProcessProvider = isProcessProvider;
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, IS_PROCESS_EVENT_PROPERTY, oldValue, this.fIsProcessProvider));
        }
    }

    public void setUsesProcessProvider(Boolean usesProcessProvider) {
        if (usesProcessProvider != this.fUsesProcessProvider) {
            Boolean oldValue = this.fUsesProcessProvider;
            this.fUsesProcessProvider = usesProcessProvider;
            if (!usesProcessProvider.booleanValue()) {
                this.fProcessProvider = null;
            }
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, USES_PROCESS_EVENT_PROPERTY, oldValue, this.fUsesProcessProvider));
        }
    }

    public void setProcessProvider(IProjectArea processProvider) {
        IProcessProvider oldProvider = this.fProcessProvider;
        this.fProcessProvider = (ProjectArea)processProvider;
        this.fUsesProcessProvider = this.fProcessProvider != null;
        if (processProvider != null) {
            this.fIsRemote = false;
            this.fRemoteServerTitle = EMPTY_STRING;
        }
        this.setDirty(true, true);
        this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, PROCESS_PROVIDER_EVENT_PROPERTY, oldProvider, this.fProcessProvider));
    }

    public ITeamRepository getOrigin() {
        return this.fCachedTeamRepository;
    }

    public boolean isProcessProviderRemote() {
        return this.fIsRemote;
    }

    private void updateProcessProviderFromProjectArea(ProjectArea area, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fProcessProvider = null;
        this.fIsRemote = false;
        IProjectAreaHandle providerHandle = area.getProcessProvider();
        this.fRemoteServerTitle = EMPTY_STRING;
        if (providerHandle != null) {
            IItemManager manager = this.fCachedTeamRepository.itemManager();
            this.fProcessProvider = (ProjectArea)manager.fetchCompleteItem((IItemHandle)providerHandle, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        } else {
            IProcessProviderCacheItemHandle cacheHandle = area.getRemoteProcessProvider();
            if (cacheHandle != null) {
                IItemManager manager = this.fCachedTeamRepository.itemManager();
                this.fProcessProvider = (ProcessProviderCacheItem)manager.fetchCompleteItem((IItemHandle)cacheHandle, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                this.fIsRemote = true;
                IProcessInternalClientService service = (IProcessInternalClientService)this.getOrigin().getClientLibrary(IProcessInternalClientService.class);
                this.fRemoteServerTitle = service.getTitleForRemoteSever(((ProcessProviderCacheItem)this.fProcessProvider).getProcessProviderUrl(), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
        }
    }

    public String getRemoteServerTitle() {
        return this.fRemoteServerTitle;
    }
}

