/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.internal.Messages;
import com.ibm.team.filesystem.client.workitems.internal.WorkItemUtils;
import com.ibm.team.filesystem.client.workitems.operations.ISubmitForReviewOperation;
import com.ibm.team.filesystem.client.workitems.operations.SubmitForReviewDilemmaHandler;
import com.ibm.team.filesystem.client.workitems.operations.SubmitForReviewParameter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class SubmitForReviewOperation
extends ChangeHistoryChangeSetsOperation
implements ISubmitForReviewOperation {
    private SubmitForReviewParameter submitForReviewParameter;
    private final Map<IWorkspaceConnection, List<IChangeSet>> sourceToChangeSets;
    private SubmitForReviewDilemmaHandler baseProblemHandler;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    public SubmitForReviewOperation(SubmitForReviewDilemmaHandler handler) {
        super((ChangeHistoryChangeSetsDilemmaHandler)(handler == null ? SubmitForReviewDilemmaHandler.getDefault().getSuspendDilemmaHandler() : handler.getSuspendDilemmaHandler()));
        this.baseProblemHandler = handler == null ? SubmitForReviewDilemmaHandler.getDefault() : handler;
        this.sourceToChangeSets = new HashMap<IWorkspaceConnection, List<IChangeSet>>();
    }

    public void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.submitForReviewParameter.getRepo();
        HashMap<IChangeSetHandle, IWorkspaceConnection> changeSetToSource = new HashMap<IChangeSetHandle, IWorkspaceConnection>();
        for (SubmitForReviewParameter.ChangeSetReview changeSetToReview : this.submitForReviewParameter.getChangeSetReviews()) {
            if (!changeSetToReview.getSource().teamRepository().equals(repo)) {
                throw new TeamRepositoryException("Repository for work item is not the same as for the change sets.");
            }
            changeSetToSource.put(changeSetToReview.getChangeSet(), changeSetToReview.getSource());
        }
        ArrayList itemHandles = new ArrayList(changeSetToSource.keySet());
        List fullChangeSets = repo.itemManager().fetchCompleteItems(itemHandles, 0, (IProgressMonitor)progress.newChild(1));
        final HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        ArrayList determinants = new ArrayList();
        int i = 0;
        for (IChangeSet changeSet : fullChangeSets) {
            IWorkspaceConnection connection = (IWorkspaceConnection)changeSetToSource.get(itemHandles.get(i));
            affectedConfigurations.add(new ConfigurationFacade((IConnection)connection, changeSet.getComponent()));
            List<IChangeSet> changeSets = this.sourceToChangeSets.get(connection);
            if (changeSets == null) {
                changeSets = new ArrayList<IChangeSet>();
                this.sourceToChangeSets.put(connection, changeSets);
            }
            changeSets.add(changeSet);
            ++i;
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SubmitForReviewOperation.this.submitForReview(affectedConfigurations, monitor);
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.SubmitForReviewOperation_1, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private void submitForReview(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (this.verifyInSyncEnabled() && !this.baseProblemHandler.getSuspendDilemmaHandler().getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            SubMonitor iterMonitor = monitor.newChild(1);
            iterMonitor.setWorkRemaining(affectedConfigurations.size());
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.baseProblemHandler.getSuspendDilemmaHandler().getOutOfSyncDilemmaHandler());
            for (ConfigurationFacade descriptor : affectedConfigurations) {
                verifyOp.addToVerify(descriptor.getConnection((IProgressMonitor)iterMonitor.newChild(1)), descriptor.getComponentHandle());
            }
            verifyOp.run((IProgressMonitor)monitor.newChild(1));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)monitor.newChild(1));
        try {
            if (!this.submitForReviewParameter.isSuspend()) {
                this.checkinPendingChanges(affectedConfigurations, (ChangeHistoryChangeSetsDilemmaHandler)this.baseProblemHandler.getSuspendDilemmaHandler(), true, (IProgressMonitor)monitor.newChild(15));
            }
            ArrayList<IWorkItemHandle> workItems = new ArrayList<IWorkItemHandle>(this.submitForReviewParameter.getWorkItems());
            Iterator i = workItems.iterator();
            while (i.hasNext()) {
                if (i.next() != null) continue;
                i.remove();
            }
            ITeamRepository repo = this.submitForReviewParameter.getRepo();
            List fullWorkItems = repo.itemManager().fetchCompleteItems(workItems, 1, (IProgressMonitor)monitor.newChild(1));
            ArrayList<IWorkItemHandle> inaccessibleWorkItems = new ArrayList<IWorkItemHandle>();
            HashSet<IWorkItem> uniqueWorkItems = new HashSet<IWorkItem>();
            int j = 0;
            while (j < workItems.size()) {
                IWorkItem iWorkItem = (IWorkItem)fullWorkItems.get(j);
                if (iWorkItem == null) {
                    inaccessibleWorkItems.add((IWorkItemHandle)workItems.get(j));
                } else {
                    uniqueWorkItems.add(iWorkItem);
                }
                ++j;
            }
            this.processInaccessibleWorkItems(inaccessibleWorkItems, fullWorkItems, (IProgressMonitor)monitor);
            SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(15), (int)(uniqueWorkItems.size() * this.submitForReviewParameter.getChangeSetReviews().size()));
            for (IWorkItemHandle iWorkItemHandle : uniqueWorkItems) {
                for (SubmitForReviewParameter.ChangeSetReview changeSetReview : this.submitForReviewParameter.getChangeSetReviews()) {
                    if (WorkItemUtils.isWorkItemAssociated(iWorkItemHandle, repo, changeSetReview.getChangeSet())) continue;
                    IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
                    workItemManager.createLink((IWorkspaceHandle)changeSetReview.getSource().getResolvedWorkspace(), changeSetReview.getChangeSet(), new IWorkItemHandle[]{iWorkItemHandle}, (IProgressMonitor)loopProgress.newChild(1));
                }
            }
            ISuspendOperation iSuspendOperation = IOperationFactory.instance.getSuspendOperation(this.baseProblemHandler.getSuspendDilemmaHandler());
            if (this.submitForReviewParameter.isSuspend()) {
                iSuspendOperation.setRefreshBeforeRun(this.getRefreshBeforeRun());
                if (this.nonAtomicCommitIsAnOption) {
                    iSuspendOperation.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    iSuspendOperation.disableNonAtomicCommit();
                }
                this.disableVerifyInSync((IFileSystemOperation)iSuspendOperation);
            }
            if (this.submitForReviewParameter.isSuspend()) {
                for (Map.Entry<IWorkspaceConnection, List<IChangeSet>> entry : this.sourceToChangeSets.entrySet()) {
                    iSuspendOperation.suspend(entry.getKey(), (Collection)entry.getValue());
                }
            }
            this.submitChangesForReview(new ArrayList<IWorkItem>(uniqueWorkItems), this.submitForReviewParameter.getReviewers(), this.submitForReviewParameter.getComment(), this.submitForReviewParameter.getSubject(), this.submitForReviewParameter.getDueDate(), (IProgressMonitor)monitor.newChild(15));
            if (this.submitForReviewParameter.isSuspend()) {
                iSuspendOperation.run((IProgressMonitor)monitor.newChild(15));
            }
            loopProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(15));
            loopProgress.setWorkRemaining(this.sourceToChangeSets.size());
            for (Map.Entry<IWorkspaceConnection, List<IChangeSet>> entry : this.sourceToChangeSets.entrySet()) {
                entry.getKey().ensureClosed((Collection)entry.getValue(), (IProgressMonitor)loopProgress.newChild(1));
            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)monitor.newChild(1));
        }
    }

    private void processInaccessibleWorkItems(List<IWorkItemHandle> inaccessibleWorkItems, List<IWorkItem> fullWorkItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (inaccessibleWorkItems.size() == 0) {
            return;
        }
        int action = this.baseProblemHandler.workItemsUnreachable(inaccessibleWorkItems.size(), fullWorkItems.size());
        if (action == 0) {
            Iterator<IWorkItem> i = fullWorkItems.iterator();
            while (i.hasNext()) {
                IWorkItem wi = i.next();
                if (wi != null) continue;
                i.remove();
            }
        } else {
            if (action == 2) {
                throw new TeamRepositoryException(Messages.SubmitForReviewOperation_2);
            }
            throw new OperationCanceledException();
        }
    }

    private void submitChangesForReview(List<IWorkItem> workItems, IContributorHandle[] reviewers, String comment, String subject, Timestamp dueDate, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.SubmitForReviewOperation_0, 3);
            for (IWorkItem workItem : workItems) {
                if (workItem == null) continue;
                WorkItemUtils.createReviewTask((ITeamRepository)workItem.getOrigin(), workItem, WorkItemApprovals.REVIEW_TYPE.getIdentifier(), subject, Arrays.asList(reviewers), true, comment, true, dueDate, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void submitForReview(SubmitForReviewParameter reviewParameter) {
        this.submitForReviewParameter = reviewParameter;
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
        super.disableNonAtomicCommit();
    }

    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
        super.enableNonAtomicCommit(numberUploads);
    }

    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        for (Map.Entry<IWorkspaceConnection, List<IChangeSet>> entry : this.sourceToChangeSets.entrySet()) {
            ChangeSetRefreshUtils.refreshLocalForRemoval((IFilesystemRefresher)refresher, affectedAreas, (IWorkspaceConnection)entry.getKey(), entry.getValue(), (IProgressMonitor)progress);
        }
    }
}

