/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.Messages;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.model.IWorkItem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class SortCriteria {
    public static final boolean ASCENDING = true;
    public static final boolean DESCENDING = false;
    private boolean fAscending;
    private IQueryableAttribute fAttribute;
    private String fAttributeIdentifier;
    private IItemType fItemType;

    public SortCriteria(IQueryableAttribute attribute, boolean ascending) {
        this(attribute.getIdentifier(), ascending);
        this.fAttribute = attribute;
    }

    public SortCriteria(String attributeIdentifier, boolean ascending) {
        Assert.isNotNull((Object)attributeIdentifier);
        this.fAscending = ascending;
        this.fAttributeIdentifier = attributeIdentifier;
        this.fItemType = IWorkItem.ITEM_TYPE;
    }

    public SortCriteria() {
    }

    public String getAttributeIdentifier() {
        return this.fAttributeIdentifier;
    }

    public IQueryableAttribute getAttribute(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fAttribute == null) {
            IQueryableAttributeFactory factory = QueryableAttributes.getFactory(this.fItemType);
            this.fAttribute = factory.findAttribute(context.getProjectArea(), this.fAttributeIdentifier, context.getAuditableCommon(), monitor);
            if (this.fAttribute == null) {
                String error = NLS.bind((String)Messages.getString("SortCriteria.UNKNOWN_ATTRIBUTE"), (Object)this.fAttributeIdentifier, (Object[])new Object[0]);
                throw new ItemNotFoundException(error);
            }
        }
        return this.fAttribute;
    }

    public boolean isAscending() {
        return this.fAscending;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SortCriteria)) {
            return false;
        }
        SortCriteria sc = (SortCriteria)obj;
        return this.getAttributeIdentifier().equals(sc.getAttributeIdentifier()) && this.isAscending() == sc.isAscending();
    }

    public void init(IPersistableElement persistableElement, ISerializationContext context) throws SerializationException {
        this.fItemType = context.getItemType();
        String attributeIdentifier = persistableElement.getAttribute("attribute");
        this.fAttributeIdentifier = context.getAttribute(attributeIdentifier, ISerializationContext.AttributeContext.SORTING);
        this.fAscending = true;
        if (persistableElement.hasAttribute("direction")) {
            this.fAscending = persistableElement.getAttribute("direction").equals("asc");
        }
    }

    public void saveState(IPersistableElement query) {
        IPersistableElement orderBy = query.createChild("orderBy");
        orderBy.setAttribute("attribute", this.fAttributeIdentifier);
        orderBy.setAttribute("direction", this.fAscending ? "asc" : "desc");
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(ProgressExpressionVisitor visitor, IProgressMonitor monitor) throws TeamRepositoryException {
        visitor.visit(this, monitor);
    }

    public SortCriteria copy() {
        SortCriteria copy = new SortCriteria(this.fAttribute, this.fAscending);
        copy.fAttributeIdentifier = this.fAttributeIdentifier;
        copy.fItemType = this.fItemType;
        return copy;
    }
}

