/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.AbstractAttributesByTypeAndStateAdvisor;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.internal.workflow.InternalWorkflowKeys;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImpliedAttributesAdvisor
implements IOperationAdvisor {
    public static final String ID = "com.ibm.team.workitem.advisor.impliedAttributes";
    public static final String UNASSIGN_ON_AREA_CHANGE_FEATURE = "unassignOnAreaChange";
    public static final String ASSIGN_ON_START_WORKING_FEATURE = "assignOnStartWorking";
    public static final String ASSIGN_ON_RESOLVE_FEATURE = "assignOnResolve";
    public static final String FEATURES_ELEMENT = "features";
    public static final String FEATURE_ELEMENT = "feature";
    public static final String ID_ATTRIBUTE = "id";
    public static final String SKIP_IF_SAME_OWNER_ATTRIBUTE = "skipIfSameOwner";
    public static final Set<String> SUPPORTED_ASSIGN_ATTRIBUTES = new HashSet<String>(Arrays.asList(IWorkItem.TARGET_PROPERTY, IWorkItem.OWNER_PROPERTY));

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object data = operation.getOperationData();
        if (!(data instanceof ISaveParameter)) {
            return;
        }
        ISaveParameter saveParameter = (ISaveParameter)data;
        Set<IProcessConfigurationElement> features = null;
        IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
        if (saveParameter.getNewState() instanceof IWorkItem) {
            IProcessArea area = saveParameter.getNewProcessArea();
            if (features == null) {
                features = this.readConfiguration(auditableCommon, area, ID, monitor);
            }
            for (IProcessConfigurationElement processConfigurationElement : features) {
                if (processConfigurationElement.getAttribute(ID_ATTRIBUTE).contains(UNASSIGN_ON_AREA_CHANGE_FEATURE)) {
                    this.unassignOnAreaChange(processConfigurationElement, auditableCommon, saveParameter, collector, monitor);
                    continue;
                }
                if (processConfigurationElement.getAttribute(ID_ATTRIBUTE).contains(ASSIGN_ON_START_WORKING_FEATURE)) {
                    this.assignOnStartWorking(processConfigurationElement, auditableCommon, saveParameter, collector, monitor);
                    continue;
                }
                if (!processConfigurationElement.getAttribute(ID_ATTRIBUTE).contains(ASSIGN_ON_RESOLVE_FEATURE)) continue;
                this.assignOnResolve(processConfigurationElement, auditableCommon, saveParameter, collector, monitor);
            }
        }
    }

    private void unassignOnAreaChange(IProcessConfigurationElement processConfigurationElement, IAuditableCommon auditableCommon, ISaveParameter saveParameter, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute owner;
        if (saveParameter.isCreation()) {
            return;
        }
        IWorkItem newState = (IWorkItem)saveParameter.getNewState();
        IWorkItem oldState = (IWorkItem)saveParameter.getOldState();
        if (this.equal((IItemHandle)saveParameter.getNewProcessArea(), (IItemHandle)saveParameter.getOldProcessArea())) {
            return;
        }
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        IWorkItemType workItemType = workItemCommon.findWorkItemType(newState.getProjectArea(), newState.getWorkItemType(), monitor);
        if (workItemType == null) {
            return;
        }
        Set<String> properties = AbstractAttributesByTypeAndStateAdvisor.getConfiguredAttributes(workItemCommon, newState, null, processConfigurationElement, monitor);
        String attr = processConfigurationElement.getAttribute(SKIP_IF_SAME_OWNER_ATTRIBUTE);
        if (attr != null && ("true".equals(attr) || "1".equals(attr)) && (owner = workItemCommon.findAttribute(newState.getProjectArea(), IWorkItem.OWNER_PROPERTY, monitor)) != null && oldState.getOwner() != null && !oldState.getOwner().getItemId().equals((Object)DefaultModel.NULL_CONTRIBUTOR_ITEM_ID) && this.contains(owner.getValueSet(auditableCommon, newState, monitor), oldState.getOwner())) {
            return;
        }
        Map<String, IAttribute> newAttributes = this.resolveAttributes(workItemCommon, newState.getProjectArea(), properties, monitor);
        Map<String, IAttribute> oldAttributes = this.resolveAttributes(workItemCommon, oldState.getProjectArea(), properties, monitor);
        ArrayList<String> unassignedAttributeNames = new ArrayList<String>();
        for (String property : properties) {
            Object defaultValue;
            IAttribute newAttribute = newAttributes.get(property);
            IAttribute oldAttribute = oldAttributes.get(property);
            Object newValue = newState.getValue(newAttribute);
            if (!this.equal(newValue, oldState.getValue(oldAttribute)) || this.equal(newValue, defaultValue = newAttribute.getDefaultValue(auditableCommon, newState, monitor))) continue;
            newState.setValue(newAttribute, defaultValue);
            unassignedAttributeNames.add(newAttribute.getDisplayName());
        }
        if (!unassignedAttributeNames.isEmpty()) {
            String summary = NLS.bind((String)Messages.getString("ImpliedAttributesAdvisor.UNASSIGNED_PROPERTIES"), (Object)this.createEnumeration(unassignedAttributeNames), (Object[])new Object[0]);
            IAdvisorInfo info = collector.createProblemInfo(summary, Messages.getString("ImpliedAttributesAdvisor.SOME_PROPERTIES_UNASSIGNED"), ID);
            info.setSeverity(0);
            collector.addInfo((IReportInfo)info);
        }
    }

    private Map<String, IAttribute> resolveAttributes(IWorkItemCommon workItemCommon, IProjectAreaHandle projectArea, Collection<String> properties, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, IAttribute> map = new HashMap<String, IAttribute>();
        for (String property : properties) {
            map.put(property, workItemCommon.findAttribute(projectArea, property, monitor));
        }
        return map;
    }

    private void assignOnStartWorking(IProcessConfigurationElement processConfigurationElement, IAuditableCommon auditableCommon, ISaveParameter saveParameter, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean isStarted = this.isTransitioning(auditableCommon, saveParameter, 1, 4);
        if (!isStarted) {
            return;
        }
        String message = Messages.getString("ImpliedAttributesAdvisor.SOME_PROPERTIES_ASSIGNED_BECAUSE_STARTED");
        IWorkItem newState = (IWorkItem)saveParameter.getNewState();
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        Set<String> properties = AbstractAttributesByTypeAndStateAdvisor.getConfiguredAttributes(workItemCommon, newState, null, processConfigurationElement, monitor);
        this.assign(properties, auditableCommon, saveParameter, collector, message, monitor);
    }

    private void assignOnResolve(IProcessConfigurationElement processConfigurationElement, IAuditableCommon auditableCommon, ISaveParameter saveParameter, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean isResolved = this.isTransitioning(auditableCommon, saveParameter, 5, 2);
        if (!isResolved) {
            return;
        }
        String message = Messages.getString("ImpliedAttributesAdvisor.SOME_PROPERTIES_ASSIGNED_BECAUSE_RESOLVED");
        IWorkItem newState = (IWorkItem)saveParameter.getNewState();
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        IWorkItemType workItemType = workItemCommon.findWorkItemType(newState.getProjectArea(), newState.getWorkItemType(), monitor);
        if (workItemType == null) {
            return;
        }
        Set<String> properties = AbstractAttributesByTypeAndStateAdvisor.getConfiguredAttributes(workItemCommon, newState, null, processConfigurationElement, monitor);
        this.assign(properties, auditableCommon, saveParameter, collector, message, monitor);
    }

    private void assign(Collection<String> properties, IAuditableCommon auditableCommon, ISaveParameter saveParameter, IAdvisorInfoCollector collector, String message, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        ArrayList<String> assignedAttributeNames = new ArrayList<String>();
        IWorkItem oldState = (IWorkItem)saveParameter.getOldState();
        IWorkItem newState = (IWorkItem)saveParameter.getNewState();
        if (properties.contains(IWorkItem.TARGET_PROPERTY) && newState.getTarget() == null && (oldState == null || this.equal((IItemHandle)newState.getTarget(), (IItemHandle)oldState.getTarget()))) {
            IIterationHandle interval;
            IProcessArea processArea = saveParameter.getNewProcessArea();
            IDevelopmentLine developmentLine = saveParameter.getNewDevelopmentLine();
            if (processArea != null && developmentLine != null && (interval = IterationsHelper.findCurrentMilestone(auditableCommon, (IDevelopmentLineHandle)developmentLine, monitor)) != null) {
                newState.setTarget(interval);
                IAttribute target = workItemCommon.findAttribute(newState.getProjectArea(), IWorkItem.TARGET_PROPERTY, monitor);
                assignedAttributeNames.add(target.getDisplayName());
            }
        }
        if (properties.contains(IWorkItem.OWNER_PROPERTY) && DefaultModel.NULL_CONTRIBUTOR_ITEM_ID.equals((Object)newState.getOwner().getItemId()) && (oldState == null || newState.getOwner().sameItemId((IItemHandle)oldState.getOwner()))) {
            newState.setOwner(auditableCommon.getUser());
            IAttribute owner = workItemCommon.findAttribute(newState.getProjectArea(), IWorkItem.OWNER_PROPERTY, monitor);
            assignedAttributeNames.add(owner.getDisplayName());
        }
        if (!assignedAttributeNames.isEmpty()) {
            String summary = NLS.bind((String)Messages.getString("ImpliedAttributesAdvisor.ASSIGNED_PROPERTIES"), (Object)this.createEnumeration(assignedAttributeNames), (Object[])new Object[0]);
            IAdvisorInfo info = collector.createProblemInfo(summary, message, ID);
            info.setSeverity(0);
            collector.addInfo((IReportInfo)info);
        }
    }

    private String createEnumeration(List<String> attributeNames) {
        Collections.sort(attributeNames);
        String list = "";
        for (String name : attributeNames) {
            String element = NLS.bind((String)Messages.getString("ImpliedAttributesAdvisor.PROPERTY_NAME"), (Object)name, (Object[])new Object[0]);
            list = list.length() == 0 ? element : NLS.bind((String)Messages.getString("ImpliedAttributesAdvisor.PROPERTY_LIST"), (Object)list, (Object[])new Object[]{element});
        }
        return list;
    }

    private boolean isTransitioning(IAuditableCommon auditableCommon, ISaveParameter saveParameter, int fromStateGroups, int toStateGroups) throws TeamRepositoryException {
        IWorkItem workItem = (IWorkItem)saveParameter.getNewState();
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        WorkflowManager wm = (WorkflowManager)workItemCommon.getWorkflowManager();
        String workflow = wm.getWorkflowId(workItem, null);
        if (workflow == null) {
            return false;
        }
        IWorkflowInfo workflowInfo = workItemCommon.findCachedWorkflowInfo(workItem);
        if (workflowInfo == null) {
            return false;
        }
        if (!workflowInfo.stateGroupContains(toStateGroups, workItem.getState2())) {
            return false;
        }
        if ("bugzillaWorkflow".equals(workflow) && toStateGroups == 2 && !InternalWorkflowKeys.LEGACY_ECLIPSEWAY_RESOLUTION_FIXED.equals(workItem.getResolution2())) {
            return false;
        }
        if (workItem.isNewItem()) {
            return true;
        }
        IWorkItem oldState = (IWorkItem)saveParameter.getOldState();
        String oldWorkflow = wm.getWorkflowId(oldState, null);
        if (oldWorkflow == null || !workflow.equals(oldWorkflow)) {
            return true;
        }
        return workflowInfo.stateGroupContains(fromStateGroups, oldState.getState2());
    }

    private Set<IProcessConfigurationElement> readConfiguration(IAuditableCommon auditableCommon, IProcessArea processArea, String participantId, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<IProcessConfigurationElement> features = new HashSet<IProcessConfigurationElement>();
        if (processArea == null) {
            return features;
        }
        IAuditableCommonProcess process = auditableCommon.getProcess((IProcessAreaHandle)processArea, monitor);
        List<IAdvisorDeclaration> advisorDeclarations = process.findAdvisorDeclarations((IProcessAreaHandle)processArea, "com.ibm.team.workitem.operation.workItemSave", participantId, monitor);
        for (IAdvisorDeclaration advisorDeclaration : advisorDeclarations) {
            IProcessConfigurationElement[] primaryElements;
            IProcessConfigurationElement[] iProcessConfigurationElementArray = primaryElements = advisorDeclaration.getConfigurationElement().getChildren();
            int n = primaryElements.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement primaryElement = iProcessConfigurationElementArray[n2];
                if (FEATURES_ELEMENT.equals(primaryElement.getName())) {
                    IProcessConfigurationElement[] secondaryElements;
                    IProcessConfigurationElement[] iProcessConfigurationElementArray2 = secondaryElements = primaryElement.getChildren();
                    int n3 = secondaryElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id;
                        IProcessConfigurationElement secondaryElement = iProcessConfigurationElementArray2[n4];
                        if (FEATURE_ELEMENT.equals(secondaryElement.getName()) && (id = secondaryElement.getAttribute(ID_ATTRIBUTE)) != null) {
                            features.add(secondaryElement);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return features;
    }

    private boolean contains(Object[] values, Object value) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object current = objectArray[n2];
            if (this.equal(current, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean equal(Object left, Object right) {
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return this.equal((IItemHandle)left, (IItemHandle)right);
        }
        return left == right || left != null && left.equals(right);
    }

    private boolean equal(IItemHandle left, IItemHandle right) {
        return left == right || left != null && left.sameItemId(right);
    }
}

