/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.AttributeValueProviderRegistry;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ICondition;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IProviderConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValidator;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FallbackProvider
implements IValueSetProvider<Object>,
IValueProvider<Object>,
IDefaultValueProvider<Object>,
ICondition,
IValidator {
    @Override
    public Object getValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        return workItem.getValue(attribute);
    }

    @Override
    public Object getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        return AttributeTypes.getAttributeType(attribute.getAttributeType()).getDefaultValue(workItemCommon.getAuditableCommon(), workItem, attribute, monitor);
    }

    @Override
    public List<Object> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getValueSet(attribute, workItem, workItemCommon, configuration, false, monitor);
    }

    public List<Object> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        Object[] valueSet = AttributeTypes.getAttributeType(attribute.getAttributeType()).getValueSet(workItemCommon.getAuditableCommon(), workItem, attribute, includeArchived, monitor);
        return valueSet != null ? Arrays.asList(valueSet) : Collections.emptyList();
    }

    public boolean hasValueSet(IAttribute attribute) {
        return AttributeTypes.getAttributeType(attribute.getAttributeType()).hasValueSet();
    }

    @Override
    public boolean matches(IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        return false;
    }

    @Override
    public IStatus validate(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        if (AttributeTypes.isEnumerationAttributeType(attribute.getAttributeType())) {
            boolean containedInEnumSet;
            Identifier currentValue = (Identifier)workItem.getValue(attribute);
            IEnumeration<? extends ILiteral> enumeration = workItemCommon.resolveEnumeration(attribute, monitor);
            boolean containedInValueSet = Arrays.asList(attribute.getValueSet(workItemCommon.getAuditableCommon(), workItem, monitor)).contains(currentValue);
            boolean bl = containedInEnumSet = enumeration.findEnumerationLiteral(currentValue, true) != null;
            if (containedInValueSet && containedInEnumSet) {
                return Status.OK_STATUS;
            }
            if (containedInValueSet && !containedInEnumSet) {
                return new Status(4, "com.ibm.team.workitem.common", Messages.getString("FallbackProvider.INCONSISTENT_VALUE_SET"));
            }
            if (!containedInValueSet && containedInEnumSet) {
                return new Status(4, "com.ibm.team.workitem.common", Messages.getString("FallbackProvider.VALUE_FILTERED"));
            }
            if (this.isProviderSet(attribute, workItemCommon, monitor)) {
                return new Status(4, "com.ibm.team.workitem.common", Messages.getString("FallbackProvider.NEW_VALUE_DISALLOWED"));
            }
            return new Status(2, "com.ibm.team.workitem.common", Messages.getString("FallbackProvider.NEW_VALUE_ADDED"));
        }
        return Status.OK_STATUS;
    }

    private boolean isProviderSet(IAttribute attribute, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IProviderConfiguration providerConfiguration = workItemCommon.getProviderConfiguration(attribute, monitor);
        IConfiguration valueSetConfiguration = providerConfiguration != null ? providerConfiguration.getValueSetProvider() : null;
        IValueSetProvider<?> provider = AttributeValueProviderRegistry.getInstance().getValueSetProvider(valueSetConfiguration, attribute);
        return !(provider instanceof FallbackProvider);
    }
}

