/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.internal.expression.ASTExpression;
import com.ibm.team.workitem.common.internal.query.QueryCommon;
import com.ibm.team.workitem.common.internal.query.rcp.dto.ResultPage;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResult;
import com.ibm.team.workitem.common.query.ResultSize;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class QueryResultIterator
implements IQueryResult<IResult> {
    private final QueryCommon fQueryCommon;
    private IQueryDescriptor fQueryDescriptor;
    private UUID fToken;
    private Iterator<IResult> fIterator;
    private ResultPage fPage;
    private int fStartIndex;
    private int fPageSize;
    private int fPageSizeIncrement;
    private int fLimit;
    private ResultSize fResultSize = ResultSize.EMPTY;

    private QueryResultIterator(QueryCommon queryCommon) {
        this.fQueryCommon = queryCommon;
        this.fStartIndex = 0;
        this.fPageSize = 100;
        this.fPageSizeIncrement = 0;
        this.fLimit = -1;
    }

    QueryResultIterator(QueryCommon queryCommon, IQueryDescriptor query) {
        this(queryCommon);
        this.fQueryDescriptor = query;
    }

    QueryResultIterator(QueryCommon queryCommon, UUID token) {
        this(queryCommon);
        this.fToken = token;
    }

    @Override
    public void setStartIndex(int startIndex) {
        Assert.isLegal((startIndex >= 0 ? 1 : 0) != 0);
        this.fStartIndex = startIndex;
    }

    @Override
    public int getStartIndex() {
        return this.fStartIndex;
    }

    @Override
    public void setPageSize(int size) {
        Assert.isLegal((size > 0 ? 1 : 0) != 0);
        this.fPageSize = size;
    }

    @Override
    public void setPageSizeIncrement(int increment) {
        Assert.isLegal((increment >= 0 ? 1 : 0) != 0);
        this.fPageSizeIncrement = increment;
    }

    @Override
    public void setLimit(int limit) {
        this.fLimit = limit;
    }

    @Override
    public int getLimit() {
        return this.fLimit;
    }

    @Override
    public boolean hasNext(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.hasNext();
    }

    @Override
    public IResult next(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.next();
    }

    @Override
    public List<IResult> nextPage(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        ArrayList<IResult> list = new ArrayList<IResult>();
        while (this.fIterator.hasNext()) {
            list.add(this.fIterator.next());
        }
        return list;
    }

    @Override
    public ResultSize getResultSize(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fResultSize;
    }

    @Override
    public int getTotalSize(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getResultSize(monitor).getTotal();
    }

    @Override
    public UUID getToken(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fPage.getToken();
    }

    private void update(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fPage == null) {
            this.fPage = this.fetchFirstPage(monitor);
            this.fIterator = this.createIterator(this.fPage, monitor);
            this.fResultSize = new ResultSize(this.fPage.getTotal(), this.fPage.getEstimatedTotal(), this.fPage.getTotalAvailable());
        }
        while (!this.fIterator.hasNext() && this.fPage.getNextStartIndex() != -1) {
            this.fPageSize += this.fPageSizeIncrement;
            this.fPage = this.fQueryCommon.fetchMore(this.fPage.getToken(), this.fPage.getNextStartIndex(), this.fPageSize, monitor);
            this.fIterator = this.createIterator(this.fPage, monitor);
        }
    }

    private ResultPage fetchFirstPage(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fToken != null) {
            return this.fQueryCommon.fetchMore(this.fToken, this.fStartIndex, this.fPageSize, monitor);
        }
        ASTExpression astExpression = QueryUtils.getASTExpression(this.fQueryDescriptor.getResolvedExpression());
        if (astExpression != null) {
            return this.fQueryCommon.fetchQueryResults(astExpression, this.fStartIndex, this.fPageSize, this.fLimit, monitor);
        }
        return this.fQueryCommon.fetchQueryResults(this.fQueryDescriptor, this.fStartIndex, this.fPageSize, this.fLimit, monitor);
    }

    private Iterator<IResult> createIterator(ResultPage page, IProgressMonitor monitor) {
        return page.getResults().iterator();
    }
}

