/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.ContentType;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XMLHelper;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class RMPreVersion1ResourceUpdater
extends ResourceUpdater {
    private static final String ELEMENT_LABEL = "label";
    private static final String ELEMENT_LINK_COLLECTION = "LinkCollection";
    private static final Property RDF_DESCRIPTION = RDFIdentifiers.DESCRIPTION;
    private static final Property RDF_ABOUT = RDFIdentifiers.ABOUT;
    private static final Property RDF_RESOURCE = RDFIdentifiers.RESOURCE;
    private static final Property RDFS_LABEL = new Property("http://www.w3.org/2000/01/rdf-schema#", "label");
    private static final Property OSLC_RM_LINK_COLLECTION = new Property("http://open-services.net/xmlns/rm/1.0/", "LinkCollection");
    private Map<OSLCResourceDescription.ResourcePropertyDescription, OSLCResource> fLinkCollectionResources;
    private boolean fIsLinkFormatChangedPreV1;

    @Override
    protected ResourceUpdater.ResourceContent loadExistingContent(OSLCResource resource, Set<OSLCResourceDescription.ResourcePropertyDescription> propertyDescriptions) throws TeamRepositoryException, UnsupportedVersionException {
        ResourceUpdater.ResourceContent result = new ResourceUpdater.ResourceContent(resource);
        this.fLinkCollectionResources = new HashMap<OSLCResourceDescription.ResourcePropertyDescription, OSLCResource>();
        this.fIsLinkFormatChangedPreV1 = true;
        CALMDocument document = new CALMDocument(resource.getContent());
        for (OSLCResourceDescription.ResourcePropertyDescription propertyDescription : propertyDescriptions) {
            String linkCollectionURL = this.fetchLinkCollectionURL(propertyDescription, document);
            OSLCResource collectionResource = OSLCResource.loadResource(this.getHttpAccess(), linkCollectionURL, null, this.getResourceVersion());
            CALMDocument collectionResourceDocument = new CALMDocument(resource.getContent());
            NodeList nodes = collectionResourceDocument.getNodes(this.getLinkPath(propertyDescription));
            List<ResourceUpdater.LinkProperty> links = this.parseLinks(propertyDescription, nodes, collectionResourceDocument);
            result.putLinkProperties(propertyDescription, links);
            this.fLinkCollectionResources.put(propertyDescription, collectionResource);
        }
        return result;
    }

    private String fetchLinkCollectionURL(OSLCResourceDescription.ResourcePropertyDescription propertyDescription, CALMDocument resourceRepresentation) throws TeamRepositoryException, UnsupportedVersionException {
        String result = resourceRepresentation.getText(this.getLinkCollectionPath(propertyDescription));
        try {
            new URI(result);
        }
        catch (URISyntaxException uRISyntaxException) {
            String resultUrl = this.getResourceURL();
            String message = MessageFormat.format(Messages.getString("RMPreVersion1ResourceUpdater_ERROR_NO_LINKS"), resultUrl);
            throw new TeamRepositoryException(message);
        }
        return result;
    }

    private List<ResourceUpdater.LinkProperty> parseLinks(OSLCResourceDescription.ResourcePropertyDescription propertyDescription, NodeList nodes, CALMDocument document) throws CALMDocument.DocumentParseException {
        ArrayList<ResourceUpdater.LinkProperty> result = new ArrayList<ResourceUpdater.LinkProperty>(nodes.getLength());
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node curNode = nodes.item(idx);
            String curTarget = this.parseLinkURI(curNode, document);
            String curLabel = this.parseLinkLabel(curNode, document);
            if (curTarget != null && curTarget.length() > 0 && curLabel != null) {
                result.add(new ResourceUpdater.LinkProperty(propertyDescription.getId(), curTarget, curLabel));
            }
            ++idx;
        }
        return result;
    }

    private String parseLinkLabel(Node node, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery path = new XPathQuery("./").addRef(RDF_DESCRIPTION).add('/').addRef(RDFS_LABEL);
        return document.getText(path, (Object)node);
    }

    private String parseLinkURI(Node node, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery pathV1 = new XPathQuery("@").addRef(RDF_RESOURCE);
        XPathQuery pathPreV1 = new XPathQuery("./").addRef(RDF_DESCRIPTION).add("/@").addRef(RDF_ABOUT);
        String result = document.getText(pathV1, (Object)node);
        if (result != null && result.length() > 0) {
            this.fIsLinkFormatChangedPreV1 = true;
            return result;
        }
        this.fIsLinkFormatChangedPreV1 = false;
        return document.getText(pathPreV1, (Object)node);
    }

    private Property getLinkCollectionElement(OSLCResourceDescription.ResourcePropertyDescription propertyDescription) {
        Property linkProperty = propertyDescription.getProperty();
        return new Property(linkProperty.getNamespaceURI(), String.valueOf(linkProperty.getName()) + "Collection");
    }

    private XPathQuery getLinkCollectionPath(OSLCResourceDescription.ResourcePropertyDescription propertyDescription) {
        return new XPathQuery().add('/').addRef(RDFIdentifiers.RDF).add('/').addRef(this.getResourceVersion().getElementName()).add('/').addRef(this.getLinkCollectionElement(propertyDescription)).add("/@").addRef(RDFIdentifiers.RESOURCE);
    }

    private XPathQuery getLinkPath(OSLCResourceDescription.ResourcePropertyDescription propertyDescription) {
        return new XPathQuery().add('/').addRef(RDFIdentifiers.RDF).add('/').addRef(OSLC_RM_LINK_COLLECTION).add('/').addRef(propertyDescription.getProperty());
    }

    @Override
    protected String storeContent(ResourceUpdater.ResourceContent updatedLinks) throws TeamRepositoryException {
        for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<ResourceUpdater.LinkProperty>> entry : updatedLinks.getLinkPropertySet()) {
            OSLCResourceDescription.ResourcePropertyDescription desc = entry.getKey();
            List<ResourceUpdater.LinkProperty> newLinks = entry.getValue();
            OSLCResource resource = this.fLinkCollectionResources.get(desc);
            if (resource == null) {
                throw new IllegalArgumentException("Can not write links before read.");
            }
            try {
                String newContent = this.createLinkCollectionDocument(resource, desc, newLinks);
                resource.write(this.getHttpAccess(), newContent, null);
            }
            catch (XMLHelper.XMLSerializeException e) {
                throw new TeamRepositoryException("Problem modifying links", (Throwable)e);
            }
        }
        return null;
    }

    private String createLinkCollectionDocument(OSLCResource resource, OSLCResourceDescription.ResourcePropertyDescription desc, List<ResourceUpdater.LinkProperty> newLinks) throws XMLHelper.XMLSerializeException {
        XMLHelper xmlHelper = new XMLHelper(new ContentType(resource.getContentType()), HttpUtil.CharsetEncoding.UTF8.toCharset());
        xmlHelper.startDocument();
        xmlHelper.startElement(RDFIdentifiers.RDF);
        AttributesImpl attrib = xmlHelper.createAttribute(RDFIdentifiers.ABOUT, resource.getURL());
        xmlHelper.startElement(OSLC_RM_LINK_COLLECTION, (Attributes)attrib);
        for (ResourceUpdater.LinkProperty cur : newLinks) {
            this.addLinkElementToLinkCollection(desc, cur, xmlHelper);
        }
        xmlHelper.endElement(OSLC_RM_LINK_COLLECTION);
        xmlHelper.endElement(RDFIdentifiers.RDF);
        xmlHelper.endDocument();
        return xmlHelper.getString();
    }

    private void addLinkElementToLinkCollection(OSLCResourceDescription.ResourcePropertyDescription desc, ResourceUpdater.LinkProperty newLink, XMLHelper xmlHelper) {
        Property linkName = desc.getProperty();
        if (this.fIsLinkFormatChangedPreV1) {
            AttributesImpl attributes = xmlHelper.createAttribute(RDFIdentifiers.RESOURCE, newLink.getLinkUri());
            xmlHelper.startElement(linkName, (Attributes)attributes);
        } else {
            xmlHelper.startElement(linkName);
            AttributesImpl attributes = xmlHelper.createAttribute(RDFIdentifiers.ABOUT, newLink.getLinkUri());
            xmlHelper.startElement(RDFIdentifiers.DESCRIPTION, (Attributes)attributes);
            xmlHelper.startElement(RDFS_LABEL);
            xmlHelper.characters(newLink.getLinkComment());
            xmlHelper.endElement(RDFS_LABEL);
            xmlHelper.endElement(RDFIdentifiers.DESCRIPTION);
        }
        xmlHelper.endElement(linkName);
    }
}

