/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.workitems.internal.process;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.internal.process.UnifiedProcessDescriptionUtil;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class WorkItemAdvisorDetailConstants {
    public static final String EL_WORKITEM_LINK = "workitem-link";
    public static final String EL_WORKITEM_QUERY_LINK = "workitem-query-link";

    public static Element makeWorkItemLink(Document doc, String linkText, UUID repoUuid, UUID ... wiIds) {
        Element link = doc.createElement(EL_WORKITEM_LINK);
        link.setAttribute("repository", repoUuid.getUuidValue());
        link.setAttribute("uuids", UnifiedProcessDescriptionUtil.joinUuids((UUID[])wiIds));
        link.setTextContent(linkText);
        return link;
    }

    public static Element makeWorkItemLink(Document doc, String linkText, UUID repoUuid, List<IWorkItemHandle> wiHandles) {
        UUID[] wiIds = new UUID[wiHandles.size()];
        int i = 0;
        for (IWorkItemHandle wiHandle : wiHandles) {
            wiIds[i++] = wiHandle.getItemId();
        }
        return WorkItemAdvisorDetailConstants.makeWorkItemLink(doc, linkText, repoUuid, wiIds);
    }

    public static void addWorkItemsLinks(Document doc, Element parent, UUID repoUuid, Collection<IWorkItem> wis) {
        boolean needsComma = false;
        for (IWorkItem wi : wis) {
            if (needsComma) {
                parent.appendChild(doc.createTextNode(", "));
            }
            Element link = WorkItemAdvisorDetailConstants.makeWorkItemLink(doc, Integer.toString(wi.getId()), repoUuid, wi.getItemId());
            parent.appendChild(link);
            needsComma = true;
        }
    }

    public static Element makeWorkItemQueryLink(Document doc, IQueryDescriptor query, UUID repoUuid) {
        Element link = doc.createElement(EL_WORKITEM_QUERY_LINK);
        link.setAttribute("repository", repoUuid.getUuidValue());
        link.setAttribute("uuid", query.getItemId().getUuidValue());
        link.setTextContent(query.getName());
        return link;
    }

    public static Element makeWorkItemQueryLink(Document doc, IQueryDescriptor query, String linkText, UUID repoUuid) {
        Element link = doc.createElement(EL_WORKITEM_QUERY_LINK);
        link.setAttribute("repository", repoUuid.getUuidValue());
        link.setAttribute("uuid", query.getItemId().getUuidValue());
        link.setAttribute("name", query.getName());
        link.setTextContent(linkText);
        return link;
    }
}

