/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.workitems.internal.process.config;

import com.ibm.team.filesystem.common.internal.process.ComponentMatchBlock;
import com.ibm.team.scm.common.internal.process.PCD_mayBeNull;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PreventLinkToApprovedWorkItemConfig {
    @PCD_mayBeNull
    public ComponentMatchBlock compMatcher = new ComponentMatchBlock();
    public List<AllowedApprovalState> allowedLink;

    public boolean matchesAllowedLink(String type, String state) {
        if (this.allowedLink == null) {
            return false;
        }
        for (AllowedApprovalState allowed : this.allowedLink) {
            if (!allowed.matches(type, state)) continue;
            return true;
        }
        return false;
    }

    public boolean allowsLinkToType(IApprovalType type) {
        if (this.allowedLink == null) {
            return false;
        }
        String id = type.getIdentifier();
        for (AllowedApprovalState allowed : this.allowedLink) {
            if (!id.equals(allowed.approvalType)) continue;
            return true;
        }
        return false;
    }

    public List<IApprovalState> getApprovalsFor(IApprovalType type) {
        if (this.allowedLink == null) {
            return Collections.emptyList();
        }
        String id = type.getIdentifier();
        ArrayList<IApprovalState> toReturn = new ArrayList<IApprovalState>();
        for (AllowedApprovalState allowed : this.allowedLink) {
            if (!id.equals(allowed.approvalType)) continue;
            toReturn.add(WorkItemApprovals.getState((String)allowed.stateType));
        }
        return toReturn;
    }

    public static class AllowedApprovalState {
        public String approvalType;
        public String stateType;

        public AllowedApprovalState(String type, String state) {
            this.approvalType = type;
            this.stateType = state;
        }

        public AllowedApprovalState() {
        }

        public boolean matches(String type, String state) {
            return this.approvalType.equals(type) && this.stateType.equals(state);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "(" + this.approvalType + "/" + this.stateType + ")";
        }
    }
}

