/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class FetchProfile {
    private static FetchProfile FULL_PROFILE = null;
    private static FetchProfile EMPTY_PROFILE = null;
    private Set properties;

    private FetchProfile() {
        this.properties = null;
    }

    private FetchProfile(Set properties) {
        this.properties = properties;
    }

    public static FetchProfile createProfile(Collection properties) {
        HashSet props = new HashSet();
        props.addAll(properties);
        return new FetchProfile(props);
    }

    public static FetchProfile createEmptyProfile() {
        if (EMPTY_PROFILE == null) {
            EMPTY_PROFILE = new FetchProfile(new HashSet());
        }
        return EMPTY_PROFILE;
    }

    public static FetchProfile createFullProfile() {
        if (FULL_PROFILE == null) {
            FULL_PROFILE = new FetchProfile();
        }
        return FULL_PROFILE;
    }

    public Collection<String> getProperties() {
        return this.properties;
    }

    public boolean contains(FetchProfile toCheck) {
        if (this.properties == null) {
            return true;
        }
        if (toCheck == this) {
            return true;
        }
        if (toCheck.properties == null) {
            return false;
        }
        for (Object next : toCheck.properties) {
            if (this.properties.contains(next)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        FetchProfile toCheck = (FetchProfile)obj;
        return FetchProfile.equals(this.properties, toCheck.properties);
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        if (this.properties == null) {
            return 0;
        }
        return this.properties.hashCode();
    }

    public boolean isEmpty() {
        return this.properties != null && this.properties.isEmpty();
    }

    public boolean isFull() {
        return this.properties == null;
    }

    public FetchProfile merge(FetchProfile toMerge) {
        if (toMerge.contains(this)) {
            return toMerge;
        }
        return this.merge(toMerge.getProperties());
    }

    public FetchProfile merge(Collection additionalProperties) {
        if (this.contains(additionalProperties)) {
            return this;
        }
        HashSet newProperties = new HashSet();
        newProperties.addAll(this.properties);
        newProperties.addAll(additionalProperties);
        return new FetchProfile(newProperties);
    }

    private boolean contains(Collection additionalProperties) {
        if (this.properties == null) {
            return true;
        }
        for (Object next : additionalProperties) {
            if (this.properties.contains(next)) continue;
            return false;
        }
        return true;
    }
}

