/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.index;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.FulltextException;
import com.ibm.team.fulltext.common.IIndexManager;
import com.ibm.team.fulltext.common.IndexConfig;
import com.ibm.team.fulltext.common.NoPermissionException;
import com.ibm.team.fulltext.common.internal.FulltextCommonPlugin;
import com.ibm.team.fulltext.common.internal.analysis.DelegatingAnalyzer;
import com.ibm.team.fulltext.common.internal.index.IIndexAccess;
import com.ibm.team.fulltext.common.internal.index.IIndexingLanguage;
import com.ibm.team.fulltext.common.internal.index.Messages;
import com.ibm.team.fulltext.common.internal.util.AnalyzerDebugUtils;
import com.ibm.team.fulltext.common.internal.util.QueryUtils;
import com.ibm.team.fulltext.common.model.IInformationArtifact;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.service.IContextManagerService;
import com.ibm.team.repository.common.util.NLS;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class IndexManagerImpl
implements IIndexManager {
    private static IndexManagerImpl fgSingleton = new IndexManagerImpl();
    private static final int FLUSH_TIME_STORES_THRESHOLD = 100;
    public static final String SINGLE_INDEX_TYPE = "com.ibm.team.fulltext.service.internal.index.SingleIndexType";
    private final Map<String, Long> fMapTypeToLastIndexTime = new ConcurrentHashMap<String, Long>(2);
    private final Map<String, Long> fMapTypeToLastDeleteTime = new ConcurrentHashMap<String, Long>(2);
    private final AtomicInteger fTimeStoreAccessCounter = new AtomicInteger();
    private static final String LAST_INDEX_TIME_STORE = "lastindextimes";
    private static final String LAST_DELETE_TIME_STORE = "lastdeletetimes";
    private final DelegatingAnalyzer fDelegatingAnalyzer = new DelegatingAnalyzer();
    private final Map<String, Directory> fCachedDirectories = new ConcurrentHashMap<String, Directory>();
    private final Map<String, IndexWriter> fCachedIndexWriters = new ConcurrentHashMap<String, IndexWriter>();
    private final Map<String, IndexSearcher> fCachedIndexSearchers = new ConcurrentHashMap<String, IndexSearcher>();
    private final Map<String, Boolean> fIsFlushRequired = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, SnapshotDeletionPolicy> fCachedSnapshots = new ConcurrentHashMap<String, SnapshotDeletionPolicy>();
    private Set<String> fCachedIndexNames;

    public static IndexManagerImpl getInstance() {
        return fgSingleton;
    }

    @Override
    public void index(Collection<IInformationArtifact> artifacts, boolean withDate, IContextManagerService contextManagerService, IProgressMonitor monitor) throws FulltextException {
        String type;
        ArrayList<Document> documents;
        HashMap<String, ArrayList<Document>> mapTypeToDocuments = new HashMap<String, ArrayList<Document>>();
        for (IInformationArtifact artifact : artifacts) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            URIReference reference = artifact.getId();
            Assert.isNotNull((Object)reference, (String)Messages.getString("IndexManagerImpl.ERROR_ID_NULL"));
            Assert.isNotNull((Object)reference.getType(), (String)Messages.getString("IndexManagerImpl.ERROR_REFERENCE_TYPE_NULL"));
            if (artifact.getContainerId() != null) {
                Assert.isNotNull((Object)artifact.getContainerId().getType(), (String)Messages.getString("IndexManagerImpl.ERROR_REFERENCE_TYPE_NULL"));
                Assert.isTrue((!artifact.getContainerId().getType().equals(reference.getType()) ? 1 : 0) != 0, (String)Messages.getString("IndexManagerImpl.ERROR_WRONG_CONTAINER_TYPE"));
            }
            if ((documents = (List)mapTypeToDocuments.get(type = reference.getType())) == null) {
                documents = new ArrayList<Document>();
                mapTypeToDocuments.put(type, documents);
            }
            documents.add(this.createDocument(artifact, withDate));
        }
        Set entries = mapTypeToDocuments.entrySet();
        for (Map.Entry entry : entries) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            type = (String)entry.getKey();
            documents = (ArrayList<Document>)entry.getValue();
            try {
                this.write(type, (Collection<Document>)documents, contextManagerService, monitor);
            }
            catch (IOException e) {
                throw new FulltextException(NLS.bind((String)Messages.getString("IndexManagerImpl.ERROR_INDEXING_ITEMS"), (Object)this.getLogDetails(documents), (Object[])new Object[0]), e);
            }
        }
    }

    private Document createDocument(IInformationArtifact artifact, boolean withDate) {
        UUID context;
        Document document = new Document();
        document.add((Fieldable)new Field("_id", artifact.getId().getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field("_artifactType", artifact.getId().getType(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field("_artifactName", artifact.getId().getName(), Field.Store.YES, Field.Index.NO));
        boolean refDetailsMatchesName = artifact.getId().getDetails().equals(artifact.getName());
        if (!refDetailsMatchesName) {
            document.add((Fieldable)new Field("_artifactDetails", artifact.getId().getDetails(), Field.Store.YES, Field.Index.NO));
        }
        if (artifact.getContainerId() != null) {
            URIReference container = artifact.getContainerId();
            document.add((Fieldable)new Field("_containerId", container.getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((Fieldable)new Field("_containerType", container.getType(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((Fieldable)new Field("_containerName", container.getName(), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field("_containerDetails", container.getDetails(), Field.Store.YES, Field.Index.NO));
            UUID containerContext = artifact.getContainerContext();
            if (containerContext == null) {
                containerContext = IContext.PUBLIC;
            }
            document.add((Fieldable)new Field("_containerContext", containerContext.getUuidValue(), Field.Store.YES, Field.Index.NO));
        }
        if ((context = artifact.getContext()) == null) {
            context = IContext.PUBLIC;
        }
        document.add((Fieldable)new Field("_context", context.getUuidValue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        UUID owner = artifact.getOwner();
        if (owner != null) {
            document.add((Fieldable)new Field("_owner", owner.getUuidValue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (artifact.getName() != null) {
            AnalyzerDebugUtils.printTokens(this.fDelegatingAnalyzer, new StringReader(artifact.getName()), "_name");
            document.add((Fieldable)new Field("_name", artifact.getName(), refDetailsMatchesName ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES));
        }
        if (artifact.getContent() != null) {
            document.add((Fieldable)new Field("_content", artifact.getContent(), Field.TermVector.YES));
        }
        if (artifact.getTags() != null) {
            AnalyzerDebugUtils.printTokens(this.fDelegatingAnalyzer, new StringReader(artifact.getTags()), "_tags");
            document.add((Fieldable)new Field("_tags", artifact.getTags(), Field.Store.NO, Field.Index.ANALYZED));
        }
        if (artifact.getMeta() != null) {
            AnalyzerDebugUtils.printTokens(this.fDelegatingAnalyzer, new StringReader(artifact.getMeta()), "_meta");
            document.add((Fieldable)new Field("_meta", artifact.getMeta(), Field.Store.NO, Field.Index.ANALYZED));
        }
        if (withDate) {
            document.add((Fieldable)new Field("_indexDate", DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (artifact.getLanguage() != null) {
            document.add((Fieldable)new Field("_artifactLanguage", artifact.getLanguage(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        return document;
    }

    private synchronized void write(String type, Collection<Document> documents, IContextManagerService contextManagerService, IProgressMonitor monitor) throws IOException, FulltextException {
        IndexWriter writer = this.getIndexWriter(type);
        if (this.fIsFlushRequired.containsKey(type) && this.fIsFlushRequired.get(type).booleanValue()) {
            writer.commit();
            this.fIsFlushRequired.put(type, false);
        }
        IndexSearcher searcher = new IndexSearcher(this.fCachedDirectories.get(type), true);
        try {
            for (Document document : documents) {
                block14: {
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    String itemId = document.get("_id");
                    this.handleUpdate(document, itemId, (Searcher)searcher, contextManagerService);
                    try {
                        String language = document.get("_artifactLanguage");
                        this.fDelegatingAnalyzer.setOverridenLanguage(language);
                        writer.updateDocument(new Term("_id", itemId), document);
                    }
                    catch (CharConversionException e) {
                        String message = NLS.bind((String)Messages.getString("IndexManagerImpl.SKIP_INDEX_ENCODING_PROBLEM"), (Object)itemId, (Object[])new Object[]{type});
                        this.logException(message, e);
                        this.fDelegatingAnalyzer.setOverridenLanguage(null);
                        break block14;
                    }
                    catch (IOException e) {
                        try {
                            this.logException(itemId, e);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.fDelegatingAnalyzer.setOverridenLanguage(null);
                        }
                    }
                    this.fDelegatingAnalyzer.setOverridenLanguage(null);
                }
                this.fIsFlushRequired.put(type, true);
            }
        }
        finally {
            searcher.close();
        }
    }

    private void handleUpdate(Document document, String documentId, Searcher searcher, IContextManagerService contextManagerService) throws IOException, FulltextException {
        TermQuery artifactQuery = new TermQuery(new Term("_id", documentId));
        TopDocs topDocs = searcher.search((Query)artifactQuery, 1);
        if (topDocs.totalHits == 1) {
            Document existingDocument = searcher.doc(topDocs.scoreDocs[0].doc);
            String newContainerId = document.get("_containerId");
            this.assertWritePermission(existingDocument, contextManagerService);
            String[] containerIds = existingDocument.getValues("_containerId");
            if (containerIds != null) {
                String[] containerContexts = existingDocument.getValues("_containerContext");
                String[] containerTypes = existingDocument.getValues("_containerType");
                String[] containerDetails = existingDocument.getValues("_containerDetails");
                String[] containerNames = existingDocument.getValues("_containerName");
                int j = 0;
                while (j < containerIds.length) {
                    if (!containerIds[j].equals(newContainerId)) {
                        String containerId = containerIds[j];
                        String containerContext = containerContexts != null && containerContexts.length > j ? containerContexts[j] : null;
                        String containerType = containerTypes[j];
                        String containerDetail = containerDetails[j];
                        String containerName = containerNames[j];
                        document.add((Fieldable)new Field("_containerId", containerId, Field.Store.YES, Field.Index.NOT_ANALYZED));
                        if (containerContext != null) {
                            document.add((Fieldable)new Field("_containerContext", containerContext, Field.Store.YES, Field.Index.NO));
                        }
                        document.add((Fieldable)new Field("_containerType", containerType, Field.Store.YES, Field.Index.NOT_ANALYZED));
                        document.add((Fieldable)new Field("_containerName", containerName, Field.Store.YES, Field.Index.NO));
                        document.add((Fieldable)new Field("_containerDetails", containerDetail, Field.Store.YES, Field.Index.NO));
                    }
                    ++j;
                }
            }
        }
    }

    @Override
    public synchronized void closeAllWriters() {
        Collection<IndexWriter> writers = this.fCachedIndexWriters.values();
        for (IndexWriter writer : writers) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LogFactory.getLog((String)"com.ibm.team.fulltext.common").error((Object)Messages.getString("IndexManagerImpl.ERROR_CLOSING_WRITER"), (Throwable)e);
            }
        }
    }

    @Override
    public void delete(URIReference reference, URIReference container, IContextManagerService contextManagerService, IProgressMonitor monitor) throws FulltextException {
        try {
            String id = reference.getURI().toString();
            String type = reference.getType();
            TermQuery artifactQuery = new TermQuery(new Term("_id", id));
            IIndexAccess indexAccess = this.getIndexAccess();
            List<QueryUtils.Pair<Document, Float>> search = indexAccess.search(new String[]{type}, (Query)artifactQuery, null, 0.0f);
            if (search.size() == 1) {
                Document artifactToDelete = search.get(0).getFirst();
                this.assertWritePermission(artifactToDelete, contextManagerService);
                String[] containerIds = artifactToDelete.getValues("_containerId");
                if (container != null && containerIds != null && containerIds.length > 1) {
                    return;
                }
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            this.internalDelete(id, type);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("IndexManagerImpl.ERROR_DELETING_ARTIFACT"), (Object)this.getLogDetails(reference), (Object[])new Object[0]), e);
        }
    }

    private void assertWritePermission(Document document, IContextManagerService contextManagerService) throws FulltextException {
        if (!contextManagerService.isReadPermissionEnabled()) {
            return;
        }
        String artifactContext = document.get("_context");
        String artifactOwner = document.get("_owner");
        String containerContext = document.get("_containerContext");
        if (artifactContext == null && containerContext == null && artifactOwner == null) {
            return;
        }
        try {
            UUID artifactContextUUID = UUID.valueOf((String)artifactContext);
            if (!contextManagerService.isUserInContext(artifactContextUUID)) {
                throw new NoPermissionException(Messages.getString("IndexManagerImpl.PERMISSION_DENIED"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(e.getMessage(), e);
        }
        try {
            UUID containerContextUUID = UUID.valueOf((String)containerContext);
            if (!contextManagerService.isUserInContext(containerContextUUID)) {
                throw new NoPermissionException(Messages.getString("IndexManagerImpl.PERMISSION_DENIED"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(e.getMessage(), e);
        }
        try {
            UUID artifactOwnerUUID = UUID.valueOf((String)artifactOwner);
            if (!contextManagerService.isUserInContext(artifactOwnerUUID)) {
                throw new NoPermissionException(Messages.getString("IndexManagerImpl.PERMISSION_DENIED"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(e.getMessage(), e);
        }
    }

    private synchronized void internalDelete(String id, String type) throws IOException {
        this.getIndexWriter(type).deleteDocuments(new Term("_id", id));
        this.fIsFlushRequired.put(type, true);
    }

    @Override
    public void enableIndexOptimization() {
    }

    @Override
    public void disableIndexOptimization() {
    }

    @Override
    public synchronized void optimizeIndex() throws FulltextException {
    }

    private IndexWriter getIndexWriter(String type) throws IOException {
        IndexWriter writer = this.fCachedIndexWriters.get(type);
        if (writer == null) {
            this.createIndexDirectoryAndWriterIfRequired(type);
            writer = this.fCachedIndexWriters.get(type);
        }
        return writer;
    }

    public IIndexAccess getIndexAccess() {
        return new IIndexAccess(){

            @Override
            public int docFreq(String[] searchScope, Term term) throws IOException {
                Searcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(searchScope);
                return searcher.docFreq(term);
            }

            @Override
            public TermFreqVector getTermFreqVector(int docNumber, String type, String field) throws IOException {
                IndexSearcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(type);
                return searcher.getIndexReader().getTermFreqVector(docNumber, field);
            }

            @Override
            public int numDocs(String[] types) throws IOException {
                int numDocs = 0;
                Searcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(types);
                if (searcher instanceof IndexSearcher) {
                    numDocs = ((IndexSearcher)searcher).getIndexReader().numDocs();
                } else if (searcher instanceof MultiSearcher) {
                    Searchable[] searchables;
                    Searchable[] searchableArray = searchables = ((MultiSearcher)searcher).getSearchables();
                    int n = searchables.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Searchable searchable = searchableArray[n2];
                        numDocs += ((IndexSearcher)searchable).getIndexReader().numDocs();
                        ++n2;
                    }
                }
                return numDocs;
            }

            @Override
            public List<QueryUtils.Pair<Document, Float>> search(String[] searchScope, Query query, Filter filter, float minScoreFactor) throws IOException {
                ArrayList<QueryUtils.Pair<Document, Float>> results = new ArrayList<QueryUtils.Pair<Document, Float>>();
                Searcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(searchScope);
                if (searcher instanceof MultiSearcher && ((MultiSearcher)searcher).getSearchables().length == 0) {
                    return results;
                }
                class DocCollector
                extends Collector {
                    Scorer scorer;
                    float maxScore = 0.0f;
                    int size = 0;
                    int[] docs = new int[5];
                    float[] scores = new float[5];
                    int docBase = 0;

                    DocCollector() {
                    }

                    public void collect(int doc) throws IOException {
                        float score = this.scorer.score();
                        if (score > this.maxScore) {
                            this.maxScore = score;
                        }
                        if (this.size == this.docs.length) {
                            this.docs = new int[this.size * 2];
                            System.arraycopy(this.docs, 0, this.docs, 0, this.size);
                            this.scores = new float[this.size * 2];
                            System.arraycopy(this.scores, 0, this.scores, 0, this.size);
                        }
                        this.docs[this.size] = this.docBase + doc;
                        this.scores[this.size++] = score;
                    }

                    public boolean acceptsDocsOutOfOrder() {
                        return false;
                    }

                    public void setNextReader(IndexReader reader, int docBase) throws IOException {
                        this.docBase = docBase;
                    }

                    public void setScorer(Scorer scorer) throws IOException {
                        this.scorer = scorer;
                    }
                }
                DocCollector collector = new DocCollector();
                searcher.search(query, filter, (Collector)collector);
                float cutOffScore = minScoreFactor > 0.0f ? collector.maxScore * minScoreFactor : 0.0f;
                float scoreNorm = collector.maxScore <= 1.0f ? 1.0f : 1.0f / collector.maxScore;
                int i = 0;
                while (i < collector.size) {
                    float score = collector.scores[i];
                    if (!(score < cutOffScore)) {
                        Document document = searcher.doc(collector.docs[i]);
                        results.add(QueryUtils.Pair.create(document, Float.valueOf(score * scoreNorm)));
                    }
                    ++i;
                }
                return results;
            }

            @Override
            public TermDocs termDocs(String type, Term term) throws IOException {
                IndexSearcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(type);
                return searcher.getIndexReader().termDocs(term);
            }
        };
    }

    private Searcher internalGetIndexSearcher(String[] types) throws IOException {
        IndexSearcher searcher = null;
        if (types == null || types.length == 0) {
            Set<String> indexNames = this.getIndexNames();
            ArrayList<IndexSearcher> searchables = new ArrayList<IndexSearcher>(indexNames.size());
            for (String indexName : indexNames) {
                searchables.add(this.internalGetIndexSearcher(indexName));
            }
            searcher = new MultiSearcher(searchables.toArray(new Searchable[searchables.size()]));
        } else if (types.length > 1) {
            ArrayList<IndexSearcher> searchables = new ArrayList<IndexSearcher>(types.length);
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                searchables.add(this.internalGetIndexSearcher(type));
                ++n2;
            }
            searcher = new MultiSearcher(searchables.toArray(new Searchable[searchables.size()]));
        } else if (types.length == 1) {
            searcher = this.internalGetIndexSearcher(types[0]);
        }
        return searcher;
    }

    private synchronized IndexSearcher internalGetIndexSearcher(String type) throws IOException {
        Assert.isNotNull((Object)type, (String)Messages.getString("IndexManagerImpl.ERROR_TYPE_NULL"));
        IndexSearcher searcher = null;
        boolean flushed = false;
        if (this.fIsFlushRequired.containsKey(type) && this.fIsFlushRequired.get(type).booleanValue()) {
            this.fCachedIndexWriters.get(type).commit();
            this.fIsFlushRequired.put(type, false);
            flushed = true;
        }
        if (!this.fCachedIndexSearchers.containsKey(type)) {
            this.createIndexDirectoryAndWriterIfRequired(type);
            searcher = new IndexSearcher(this.fCachedDirectories.get(type), true);
            this.fCachedIndexSearchers.put(type, searcher);
        } else if (flushed) {
            this.fCachedIndexSearchers.get(type).close();
            searcher = new IndexSearcher(this.fCachedDirectories.get(type), true);
            this.fCachedIndexSearchers.put(type, searcher);
        } else {
            searcher = this.fCachedIndexSearchers.get(type);
        }
        return searcher;
    }

    public Analyzer getAnalyzer() {
        return this.fDelegatingAnalyzer;
    }

    private void createIndexDirectoryAndWriterIfRequired(String type) throws IOException {
        if (!this.fCachedDirectories.containsKey(type)) {
            String location = IndexConfig.getIndexLocation(type);
            LogFactory.getLog((String)"com.ibm.team.fulltext.common").info((Object)("Fulltext:: Server location: " + location));
            NativeFSLockFactory lockFactory = new NativeFSLockFactory(location);
            FSDirectory directory = FSDirectory.open((File)new File(location), (LockFactory)lockFactory);
            IndexWriter writer = null;
            SnapshotDeletionPolicy snapshotDeletionPolicy = null;
            try {
                snapshotDeletionPolicy = new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
                writer = new IndexWriter((Directory)directory, (Analyzer)this.fDelegatingAnalyzer, !IndexReader.indexExists((Directory)directory), (IndexDeletionPolicy)snapshotDeletionPolicy, IndexWriter.MaxFieldLength.LIMITED);
                writer.setMaxFieldLength(100000);
                writer.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                writer.setMergePolicy((MergePolicy)new LogDocMergePolicy());
                writer.setMaxBufferedDocs(10);
                writer.commit();
            }
            catch (IOException e) {
                if (writer != null) {
                    writer.close(true);
                }
                directory.close();
                throw e;
            }
            this.fCachedDirectories.put(type, (Directory)directory);
            this.fCachedIndexWriters.put(type, writer);
            this.fCachedSnapshots.put(type, snapshotDeletionPolicy);
            if (!this.getIndexNames().contains(type)) {
                this.fCachedIndexNames.add(type);
            }
        }
    }

    private synchronized Set<String> getIndexNames() {
        if (this.fCachedIndexNames != null) {
            return this.fCachedIndexNames;
        }
        this.fCachedIndexNames = Collections.synchronizedSet(new HashSet());
        File indexLocation = new File(IndexConfig.getIndexLocation(null));
        File[] files = indexLocation.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.fCachedIndexNames.add(file.getName());
                }
                ++n2;
            }
        }
        return this.fCachedIndexNames;
    }

    private String getLogDetails(Object cause) {
        if (cause instanceof URIReference) {
            URIReference ref = (URIReference)cause;
            return "URI: " + ref.getURI() + ", Type: " + ref.getType() + ", Name: " + ref.getName();
        }
        if (cause instanceof Document) {
            Document doc = (Document)cause;
            return "URI: " + doc.get("_id") + ", Type: " + doc.get("_artifactType") + ", Name: " + doc.get("_artifactName");
        }
        if (cause instanceof List) {
            List causes = (List)cause;
            StringBuilder str = new StringBuilder();
            for (Object obj : causes) {
                if (!(obj instanceof Document)) continue;
                str.append("[").append(this.getLogDetails(obj)).append("] ");
            }
            return str.toString();
        }
        return "Unknown Cause";
    }

    public synchronized void clear() throws FulltextException {
        try {
            Set<String> types = this.getIndexNames();
            for (String type : types) {
                this.getIndexWriter(type).deleteDocuments((Query)new MatchAllDocsQuery());
                this.fIsFlushRequired.put(type, true);
            }
            this.optimizeIndex();
        }
        catch (IOException e) {
            throw new FulltextException(Messages.getString("IndexManagerImpl.ERROR_CLEARING_INDEX"), e);
        }
    }

    @Override
    public void startup() throws FulltextException {
        this.clearCaches();
        this.readTimes(this.fMapTypeToLastIndexTime, LAST_INDEX_TIME_STORE);
        this.readTimes(this.fMapTypeToLastDeleteTime, LAST_DELETE_TIME_STORE);
    }

    private void readTimes(Map<String, Long> map, String fileName) throws FulltextException {
        File timestampFile;
        String location = IndexConfig.getIndexLocation(null);
        File indexRoot = new File(location);
        if (indexRoot.exists() && (timestampFile = new File(indexRoot, fileName)).exists()) {
            ObjectInputStream inS = null;
            try {
                try {
                    inS = new ObjectInputStream(new FileInputStream(timestampFile));
                    Object obj = inS.readObject();
                    if (obj instanceof Map) {
                        map.putAll((Map)obj);
                    }
                }
                catch (FileNotFoundException e) {
                    throw new FulltextException(e);
                }
                catch (IOException e) {
                    throw new FulltextException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new FulltextException(e);
                }
            }
            catch (Throwable throwable) {
                if (inS != null) {
                    try {
                        inS.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inS != null) {
                try {
                    inS.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void shutdown() throws FulltextException {
        this.writeTimes();
        this.clearCaches();
    }

    private void writeTimes() throws FulltextException {
        this.writeTimes(this.fMapTypeToLastIndexTime, LAST_INDEX_TIME_STORE);
        this.writeTimes(this.fMapTypeToLastDeleteTime, LAST_DELETE_TIME_STORE);
    }

    private void writeTimes(Map<String, Long> map, String fileName) throws FulltextException {
        String location = IndexConfig.getIndexLocation(null);
        File indexRoot = new File(location);
        if (indexRoot.exists()) {
            File timestampFile = new File(indexRoot, fileName);
            if (timestampFile.exists() && !timestampFile.delete()) {
                throw new FulltextException(NLS.bind((String)Messages.getString("IndexManagerImpl.UNABLE_DELETE"), (Object)timestampFile, (Object[])new Object[0]));
            }
            if (map.isEmpty()) {
                return;
            }
            ObjectOutputStream outS = null;
            try {
                try {
                    outS = new ObjectOutputStream(new FileOutputStream(timestampFile));
                    outS.writeObject(map);
                }
                catch (FileNotFoundException e) {
                    throw new FulltextException(e);
                }
                catch (IOException e) {
                    throw new FulltextException(e);
                }
            }
            catch (Throwable throwable) {
                if (outS != null) {
                    try {
                        outS.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (outS != null) {
                try {
                    outS.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void storeLastIndexedTime(String type, long timestamp) {
        this.storeTime(this.fMapTypeToLastIndexTime, type, timestamp);
    }

    @Override
    public void storeLastDeletedTime(String type, long timestamp) {
        this.storeTime(this.fMapTypeToLastDeleteTime, type, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTime(Map<String, Long> map, String type, long timestamp) {
        Map<String, Long> map2 = map;
        synchronized (map2) {
            Long existing = map.get(type);
            if ((existing == null || existing < timestamp) && timestamp > 0L) {
                map.put(type, timestamp);
                if (this.fTimeStoreAccessCounter.incrementAndGet() > 100) {
                    try {
                        this.writeTimes();
                    }
                    catch (FulltextException e) {
                        FulltextCommonPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.fulltext.common", e.getMessage(), (Throwable)e));
                    }
                    this.fTimeStoreAccessCounter.set(0);
                }
            }
        }
    }

    @Override
    public long getLastIndexedTimestamp(String type) {
        Long lastIndexTime = this.fMapTypeToLastIndexTime.get(type);
        if (lastIndexTime != null) {
            return lastIndexTime;
        }
        return -1L;
    }

    @Override
    public long getLastDeletedTimestamp(String type) {
        Long lastDeleteTime = this.fMapTypeToLastDeleteTime.get(type);
        if (lastDeleteTime != null) {
            return lastDeleteTime;
        }
        return -1L;
    }

    private void logException(String messagePrefix, Exception ex) {
        FulltextCommonPlugin.getDefault().getLog().log((IStatus)new Status(2, "com.ibm.team.fulltext.common", String.valueOf(messagePrefix) + ex.getMessage(), (Throwable)ex));
    }

    private void clearCaches() {
        for (IndexWriter writer : this.fCachedIndexWriters.values()) {
            try {
                writer.close();
            }
            catch (CorruptIndexException ex) {
                this.logException("Problem while closing index writer: ", (Exception)((Object)ex));
            }
            catch (IOException ex) {
                this.logException("Problem while closing index writer: ", ex);
            }
        }
        for (IndexSearcher searcher : this.fCachedIndexSearchers.values()) {
            try {
                searcher.close();
            }
            catch (IOException ex) {
                this.logException("Problem while closing index searcher: ", ex);
            }
        }
        for (Directory directory : this.fCachedDirectories.values()) {
            try {
                directory.close();
            }
            catch (IOException ex) {
                this.logException("Problem while closing index directory: ", ex);
            }
        }
        this.fCachedDirectories.clear();
        this.fCachedSnapshots.clear();
        this.fCachedIndexWriters.clear();
        this.fCachedIndexSearchers.clear();
        this.fIsFlushRequired.clear();
        this.fMapTypeToLastIndexTime.clear();
        this.fMapTypeToLastDeleteTime.clear();
        if (this.fCachedIndexNames != null) {
            this.fCachedIndexNames.clear();
        }
    }

    public String getIndexingLanguage() {
        return this.fDelegatingAnalyzer.getIndexingLanguage().getLanguage();
    }

    public void setIndexingLanguage(IIndexingLanguage language) {
        this.fDelegatingAnalyzer.setIndexingLanguage(language);
    }

    private void backupIndexingTime(ZipOutputStream zipOut, String fileName, Map<String, Long> storedTime) throws IOException {
        String rootLocation = IndexConfig.getIndexLocation(null);
        File timestampFile = new File(rootLocation, fileName);
        if (timestampFile.exists()) {
            ZipEntry timeEntry = new ZipEntry(Path.fromOSString((String)fileName).toPortableString());
            timeEntry.setComment("fulltext_index");
            zipOut.putNextEntry(timeEntry);
            ObjectOutputStream outS = null;
            try {
                outS = new ObjectOutputStream(new FileOutputStream(timestampFile));
                outS.writeObject(storedTime);
            }
            finally {
                if (outS != null) {
                    outS.close();
                }
            }
        }
    }

    public void backup(ZipOutputStream zipOut) throws IOException {
        FileInputStream inFile = null;
        String id = UUID.generate().getUuidValue();
        try {
            this.backupIndexingTime(zipOut, LAST_INDEX_TIME_STORE, this.fMapTypeToLastIndexTime);
            this.backupIndexingTime(zipOut, LAST_DELETE_TIME_STORE, this.fMapTypeToLastDeleteTime);
            String rootLocation = IndexConfig.getIndexLocation(null);
            File rootDir = new File(rootLocation);
            if (rootDir.exists()) {
                List<File> allFiles = Arrays.asList(rootDir.listFiles());
                for (File oneFile : allFiles) {
                    if (!oneFile.isDirectory()) continue;
                    String type = oneFile.getName();
                    this.createIndexDirectoryAndWriterIfRequired(oneFile.getName());
                    try {
                        IndexCommit commit = this.fCachedSnapshots.get(type).snapshot(id);
                        Collection files = commit.getFileNames();
                        for (String fileName : files) {
                            File oneIndexFile = new File(fileName);
                            String entyName = String.valueOf(type) + File.separator + oneIndexFile.getName();
                            ZipEntry entry = new ZipEntry(Path.fromOSString((String)entyName).toPortableString());
                            entry.setComment("fulltext_index");
                            zipOut.putNextEntry(entry);
                            inFile = new FileInputStream(String.valueOf(IndexConfig.getIndexLocation(type)) + File.separator + oneIndexFile.getName());
                            byte[] b = new byte[256];
                            int len = 0;
                            while ((len = inFile.read(b)) > 0) {
                                zipOut.write(b, 0, len);
                            }
                            inFile.close();
                        }
                    }
                    finally {
                        this.fCachedSnapshots.get(type).release(id);
                    }
                }
            }
        }
        finally {
            if (inFile != null) {
                inFile.close();
            }
        }
    }
}

