/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class ProcessExporter {
    public abstract IProcessExportContext getContext();

    public static File createZip(File directory, File archive) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(archive));
        ZipOutputStream zipStream = new ZipOutputStream(stream);
        try {
            ProcessExporter.writeFileToZip(directory, zipStream, (IPath)new Path(directory.toString()));
        }
        finally {
            zipStream.close();
        }
        return archive;
    }

    private static void writeFileToZip(File file, ZipOutputStream zipStream, IPath rootPath) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                ProcessExporter.writeFileToZip(child, zipStream, rootPath);
                ++i;
            }
        } else {
            Path filePath = new Path(file.toString());
            int matching = filePath.matchingFirstSegments(rootPath);
            if (matching > 0 && filePath.segmentCount() > matching) {
                String relativePath = filePath.removeFirstSegments(matching).setDevice(null).toString();
                ZipEntry entry = new ZipEntry(relativePath);
                zipStream.putNextEntry(entry);
                FileInputStream inputStream = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                int read = inputStream.read(buffer);
                while (read > 0) {
                    zipStream.write(buffer, 0, read);
                    read = inputStream.read(buffer);
                }
                zipStream.flush();
                zipStream.closeEntry();
            }
        }
    }

    protected void writeStringToFile(File directory, String fileName, String string) throws IOException {
        File file = this.createFile(directory, fileName);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.write(string);
        }
        finally {
            writer.close();
        }
    }

    public void writeFile(File directory, String fileName, IContent content, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        byte[] bytes = this.getContext().readContent(content, monitor);
        this.writeFile(directory, fileName, bytes);
    }

    protected void writeFile(File directory, String fileName, byte[] content) throws IOException {
        File file = this.createFile(directory, fileName);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            outputStream.write(content);
        }
        finally {
            outputStream.close();
        }
    }

    protected File createFile(File directory, String fileName) throws IOException {
        return this.getContext().createFile(directory, fileName, false);
    }

    protected File createDirectory(File parentDirectory, String directoryName) throws IOException {
        return this.getContext().createFile(parentDirectory, directoryName, true);
    }

    public static interface IProcessExportContext {
        public List fetchCompleteItems(List var1, IProgressMonitor var2) throws TeamRepositoryException;

        public File createFile(File var1, String var2, boolean var3) throws IOException;

        public byte[] readContent(IContent var1, IProgressMonitor var2) throws TeamRepositoryException;
    }
}

