/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.repository.transport.client.OAuthHandler;
import java.io.ByteArrayInputStream;
import java.net.URI;
import org.eclipse.core.runtime.Status;

public class TrustingOauthHandler
extends OAuthHandler {
    private ITeamRawRestServiceClient restClient = null;

    public TrustingOauthHandler(ITeamRawRestServiceClient restClient) {
        this.restClient = restClient;
    }

    @Override
    public IOAuthHandler.IResponse authorize(String authorizeURL) {
        ITeamRawRestServiceClient.IRawRestClientConnection.Response returnResponse = null;
        ITeamRawRestServiceClient.IRawRestClientConnection connection = null;
        try {
            connection = this.restClient.getConnection(new URI(authorizeURL));
            connection.addRequestHeader("Accept", "text/json");
            byte[] body = String.format("authorize=%s", Boolean.TRUE.toString()).getBytes("UTF-8");
            returnResponse = connection.doPost(new ByteArrayInputStream(body), body.length, "application/x-www-form-urlencoded");
        }
        catch (Exception e) {
            ITeamRawRestServiceClient.IRawRestClientConnection.Response response;
            if (connection != null && (response = connection.getResponse()) != null && response.getStatusCode() == 302) {
                try {
                    connection = this.restClient.getConnection(new URI(response.getResponseHeader("Location")));
                    response = connection.doGet();
                    if (response.getStatusCode() == 200) {
                        return new OAuthHandler.Response(authorizeURL, Status.OK_STATUS);
                    }
                    return new OAuthHandler.Response(authorizeURL, Status.CANCEL_STATUS);
                }
                catch (Exception exception) {
                    e.printStackTrace();
                    return new OAuthHandler.Response(authorizeURL, Status.CANCEL_STATUS);
                }
            }
            e.printStackTrace();
            return null;
        }
        if (returnResponse.getStatusCode() != 200) {
            return new OAuthHandler.Response(authorizeURL, Status.CANCEL_STATUS);
        }
        return new OAuthHandler.Response(authorizeURL, Status.OK_STATUS);
    }
}

