/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.MilestoneTemplate;

public class Milestone
extends ClientDescribed<Milestone> {
    public Long originalPlanDate;
    public Long updatedPlanDate;
    public Long actualDate;
    public Status status;
    public Release release;
    public User user;
    public String userId;
    public Role executorRole;
    public String roleId;
    public MilestoneTemplate template;
    public String templateId;
    public Integer daysToTargetDate;

    public Milestone() {
        this.path = "/milestone/";
        this.userId = "";
    }

    public Milestone originalPlanDate(Long originalPlanDate) {
        this.originalPlanDate = originalPlanDate;
        return this;
    }

    public Milestone updatedPlanDate(Long updatedPlanDate) {
        this.updatedPlanDate = updatedPlanDate;
        return this;
    }

    public Milestone actualDate(Long actualDate) {
        this.actualDate = actualDate;
        return this;
    }

    public Milestone status(Status status) {
        this.handleNull((Object)status, "status");
        this.status = status;
        return this;
    }

    public Milestone release(Release release) {
        this.handleNull(release, "release");
        this.release = release;
        return this;
    }

    public Milestone user(User user) {
        if (this.handleNull(user, "user", "userId")) {
            this.user = user;
            this.userId = user.id;
        } else {
            this.user = null;
            this.userId = null;
        }
        return this;
    }

    public Milestone executorRole(Role executorRole) {
        if (this.handleNull(executorRole, "executorRole", "roleId")) {
            this.executorRole = executorRole;
            this.roleId = executorRole.id;
        } else {
            this.executorRole = null;
            this.roleId = null;
        }
        return this;
    }

    public Milestone template(MilestoneTemplate template) {
        if (this.handleNull(template, "template", "templateId")) {
            this.template = template;
            this.templateId = template.id;
        } else {
            this.template = null;
            this.templateId = null;
        }
        return this;
    }

    public Milestone daysToTargetDate(Integer daysToTargetDate) {
        this.daysToTargetDate = daysToTargetDate;
        return this;
    }

    public static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        COMPLETED;

        public transient String value = this.name().replace('_', ' ');

        public String toString() {
            return this.value;
        }
    }
}

