/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.GeneralizedAttributeDescriptor;
import com.ibm.team.repository.common.internal.util.NewAttributeDescriptor;
import com.ibm.team.repository.common.internal.util.NewTypeDescriptor;
import com.ibm.team.repository.common.internal.util.NullableAttributeDescriptor;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class EvolutionDescriptor
extends AbstractElementDescriptor {
    private static final String DTO_EVOLUTION_ELEMENT_NAME = "dtoEvolution";
    private static final String NEW_ATTRIBUTE_ELEMENT = "addedAttribute";
    private static final String NEW_TYPE_ELEMENT = "addedType";
    private static final String GENERALIZED_ATTRIBUTE_ELEMENT = "generalizedAttribute";
    private static final String NULLABLE_ATTRIBUTE_ELEMENT = "madeAttributeNullable";
    private static final String COMPONENT_VERSION_ATTRIBUTE = "componentVersion";
    private static final String MODEL_VERSION_ATTRIBUTE = "modelVersion";
    private static final String NON_CLIENT_COMPATIBILITY_BREAKING_CHANGE_ATTRIBUTE = "nonClientCompatibilityBreakingChange";
    private Map<String, Map<String, NewAttributeDescriptor>> newAttributes;
    private Map<String, NewTypeDescriptor> newTypes;
    private Map<String, Map<String, GeneralizedAttributeDescriptor>> generalizedAttributeDescriptors;
    private Map<String, Map<String, NullableAttributeDescriptor>> nullableAttributes;

    EvolutionDescriptor(IConfigurationElement element) {
        super(element, element.getName());
    }

    public NewAttributeDescriptor getNewAttribute(String className, String attribName) {
        if (this.getNewAttributes().get(className) == null) {
            return null;
        }
        return this.getNewAttributes().get(className).get(attribName);
    }

    public NullableAttributeDescriptor getNullableAttribute(String className, String attribName) {
        if (this.getNullableAttributes().get(className) == null) {
            return null;
        }
        return this.getNullableAttributes().get(className).get(attribName);
    }

    public NewTypeDescriptor getNewType(String className) {
        return this.getNewTypes().get(className);
    }

    public String getComponentVersion() {
        return this.getAttribute(COMPONENT_VERSION_ATTRIBUTE);
    }

    public String getModelVersion() {
        return this.getAttribute(MODEL_VERSION_ATTRIBUTE);
    }

    private String getNonClientCompatibilityBreakingChange() {
        return this.getAttribute(NON_CLIENT_COMPATIBILITY_BREAKING_CHANGE_ATTRIBUTE, "false");
    }

    public GeneralizedAttributeDescriptor getGeneralizedAttribute(String className, String attribName) {
        Map<String, GeneralizedAttributeDescriptor> classList = this.getGeneralizedAttributeDescriptors().get(className);
        if (classList == null) {
            return null;
        }
        return classList.get(attribName);
    }

    public boolean isNonClientCompatibilityBreakingChange() {
        return this.getNonClientCompatibilityBreakingChange().equalsIgnoreCase(Boolean.TRUE.toString());
    }

    @Override
    protected void processChild(IConfigurationElement child) {
        String name = child.getName();
        if (NEW_ATTRIBUTE_ELEMENT.equalsIgnoreCase(name)) {
            this.processNewAttributeElement(child);
        } else if (NEW_TYPE_ELEMENT.equalsIgnoreCase(name)) {
            this.processNewTypeElement(child);
        } else if (GENERALIZED_ATTRIBUTE_ELEMENT.equalsIgnoreCase(name)) {
            this.processGeneralizedAttributeElement(child);
        } else if (NULLABLE_ATTRIBUTE_ELEMENT.equalsIgnoreCase(name)) {
            this.processNullableAttributeElement(child);
        } else {
            super.processChild(child);
        }
    }

    @Override
    protected void checkElement() {
        super.checkElement();
        this.checkComponentVersionAttribute();
        this.checkModelVersionAttribute();
        this.checkNonClientCompatibilityBreakingChangeAttribute();
    }

    private void processNewAttributeElement(IConfigurationElement child) {
        Map<Object, Object> attribMap;
        NewAttributeDescriptor newAttrib = new NewAttributeDescriptor(child);
        if (this.getNewAttributes().containsKey(newAttrib.getClassName())) {
            attribMap = this.getNewAttributes().get(newAttrib.getClassName());
        } else {
            attribMap = new HashMap(5);
            this.getNewAttributes().put(newAttrib.getClassName(), attribMap);
        }
        attribMap.put(newAttrib.getName(), newAttrib);
    }

    private void processNewTypeElement(IConfigurationElement child) {
        NewTypeDescriptor newType = new NewTypeDescriptor(child);
        this.getNewTypes().put(newType.getName(), newType);
    }

    private void processGeneralizedAttributeElement(IConfigurationElement child) {
        GeneralizedAttributeDescriptor generalizedAttribute = new GeneralizedAttributeDescriptor(child);
        String typeName = generalizedAttribute.getTypeName();
        Map<String, GeneralizedAttributeDescriptor> classMap = this.getGeneralizedAttributeDescriptors().get(typeName);
        if (classMap == null) {
            classMap = new HashMap<String, GeneralizedAttributeDescriptor>(5);
            this.getGeneralizedAttributeDescriptors().put(typeName, classMap);
        }
        String attribName = generalizedAttribute.getAttributeName();
        classMap.put(attribName, generalizedAttribute);
    }

    private void processNullableAttributeElement(IConfigurationElement child) {
        Map<Object, Object> attribMap;
        NullableAttributeDescriptor nullableAttrib = new NullableAttributeDescriptor(child);
        if (this.getNewAttributes().containsKey(nullableAttrib.getClassName())) {
            attribMap = this.getNullableAttributes().get(nullableAttrib.getClassName());
        } else {
            attribMap = new HashMap(5);
            this.getNullableAttributes().put(nullableAttrib.getClassName(), attribMap);
        }
        attribMap.put(nullableAttrib.getName(), nullableAttrib);
    }

    private Map<String, Map<String, NullableAttributeDescriptor>> getNullableAttributes() {
        if (this.nullableAttributes == null) {
            this.nullableAttributes = new HashMap<String, Map<String, NullableAttributeDescriptor>>(5);
        }
        return this.nullableAttributes;
    }

    private Map<String, Map<String, NewAttributeDescriptor>> getNewAttributes() {
        if (this.newAttributes == null) {
            this.newAttributes = new HashMap<String, Map<String, NewAttributeDescriptor>>(5);
        }
        return this.newAttributes;
    }

    private Map<String, NewTypeDescriptor> getNewTypes() {
        if (this.newTypes == null) {
            this.newTypes = new HashMap<String, NewTypeDescriptor>(5);
        }
        return this.newTypes;
    }

    public Map<String, Map<String, GeneralizedAttributeDescriptor>> getGeneralizedAttributeDescriptors() {
        if (this.generalizedAttributeDescriptors == null) {
            this.generalizedAttributeDescriptors = new HashMap<String, Map<String, GeneralizedAttributeDescriptor>>(5);
        }
        return this.generalizedAttributeDescriptors;
    }

    private void checkComponentVersionAttribute() {
        String componentVersion = this.getComponentVersion();
        this.checkAttributeIsSet(componentVersion, COMPONENT_VERSION_ATTRIBUTE);
    }

    private void checkModelVersionAttribute() {
        if (this.isDtoEvolution()) {
            return;
        }
        String modelVersion = this.getModelVersion();
        this.checkAttributeIsSet(modelVersion, MODEL_VERSION_ATTRIBUTE);
    }

    private void checkNonClientCompatibilityBreakingChangeAttribute() {
        String attrib = this.getNonClientCompatibilityBreakingChange();
        this.checkAttributeIsLegal(attrib, NON_CLIENT_COMPATIBILITY_BREAKING_CHANGE_ATTRIBUTE, false, Boolean.TRUE.toString(), Boolean.FALSE.toString());
    }

    protected boolean isDtoEvolution() {
        return DTO_EVOLUTION_ELEMENT_NAME.equals(this.getElement().getName());
    }

    @Override
    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printOn(buffer, MODEL_VERSION_ATTRIBUTE, this.getModelVersion());
        this.printOn(buffer, COMPONENT_VERSION_ATTRIBUTE, this.getComponentVersion());
    }
}

