/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.service.graph;

import com.ibm.team.repository.common.service.graph.IServiceImplementation;
import com.ibm.team.repository.common.service.graph.IServiceInterface;
import com.ibm.team.repository.common.service.graph.ServiceInterface;
import java.util.ArrayList;
import java.util.List;

public class ServiceImplementation
implements IServiceImplementation {
    private String className;
    private List<String> providedServices;
    private List<String> requiredServices;
    private List<String> optionalServices;

    public ServiceImplementation(String className, List<String> providedServices, List<String> requiredServices, List<String> optionalServices) {
        this.className = className;
        this.providedServices = providedServices;
        this.requiredServices = requiredServices;
        this.optionalServices = optionalServices;
    }

    @Override
    public String getImplementationClassName() {
        return this.className;
    }

    @Override
    public List<IServiceInterface> getOptionalServiceInterfaces() {
        return this.getServiceInterfaces(this.optionalServices);
    }

    @Override
    public List<IServiceInterface> getProvidedServiceInterfaces() {
        return this.getServiceInterfaces(this.providedServices);
    }

    @Override
    public List<IServiceInterface> getRequiredServiceInterfaces() {
        return this.getServiceInterfaces(this.requiredServices);
    }

    private List<IServiceInterface> getServiceInterfaces(List<String> serviceNames) {
        if (serviceNames == null) {
            return null;
        }
        ArrayList<IServiceInterface> services = new ArrayList<IServiceInterface>(serviceNames.size());
        for (String name : serviceNames) {
            ServiceInterface service = new ServiceInterface(name, this);
            services.add(service);
        }
        return services;
    }
}

