/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core.model;

import java.net.URI;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/core#")
@OslcResourceShape(title="OSLC Creation Factory Resource Shape", describes={"http://open-services.net/ns/core#CreationFactory"})
public final class CreationFactory
extends AbstractResource {
    private final SortedSet<URI> resourceShapes = new TreeSet<URI>();
    private final SortedSet<URI> resourceTypes = new TreeSet<URI>();
    private final SortedSet<URI> usages = new TreeSet<URI>();
    private URI creation;
    private String label;
    private String title;

    public CreationFactory() {
    }

    public CreationFactory(String title, URI creation) {
        this();
        this.title = title;
        this.creation = creation;
    }

    public void addResourceShape(URI resourceShape) {
        this.resourceShapes.add(resourceShape);
    }

    public void addResourceType(URI resourceType) {
        this.resourceTypes.add(resourceType);
    }

    public void addUsage(URI usage) {
        this.usages.add(usage);
    }

    @OslcDescription(value="To create a new resource via the factory, post it to this URI")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#creation")
    @OslcReadOnly
    @OslcTitle(value="Creation")
    public URI getCreation() {
        return this.creation;
    }

    @OslcDescription(value="Very short label for use in menu items")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#label")
    @OslcReadOnly
    @OslcTitle(value="Label")
    public String getLabel() {
        return this.label;
    }

    @OslcDescription(value="A creation factory may provide resource shapes that describe shapes of resources that may be created")
    @OslcName(value="resourceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#resourceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcReadOnly
    @OslcTitle(value="Resource Shapes")
    @OslcValueShape(value="resourceShapes/resourceShape")
    public URI[] getResourceShapes() {
        return this.resourceShapes.toArray(new URI[this.resourceShapes.size()]);
    }

    @OslcDescription(value="The expected resource type URI of the resource that will be created using this creation factory. These would be the URIs found in the result resource's rdf:type property")
    @OslcName(value="resourceType")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#resourceType")
    @OslcReadOnly
    @OslcTitle(value="Resource Types")
    public URI[] getResourceTypes() {
        return this.resourceTypes.toArray(new URI[this.resourceTypes.size()]);
    }

    @OslcDescription(value="Title string that could be used for display")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcReadOnly
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    @OslcDescription(value="An identifier URI for the domain specified usage of this creation factory. If a service provides multiple creation factories, it may designate the primary or default one that should be used with a property value of http://open-services.net/ns/core#default")
    @OslcName(value="usage")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#usage")
    @OslcReadOnly
    @OslcTitle(value="Usages")
    public URI[] getUsages() {
        return this.usages.toArray(new URI[this.usages.size()]);
    }

    public void setCreation(URI creation) {
        this.creation = creation;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setResourceShapes(URI[] resourceShapes) {
        this.resourceShapes.clear();
        if (resourceShapes != null) {
            this.resourceShapes.addAll(Arrays.asList(resourceShapes));
        }
    }

    public void setResourceTypes(URI[] resourceTypes) {
        this.resourceTypes.clear();
        if (resourceTypes != null) {
            this.resourceTypes.addAll(Arrays.asList(resourceTypes));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUsages(URI[] usages) {
        this.usages.clear();
        if (usages != null) {
            this.usages.addAll(Arrays.asList(usages));
        }
    }
}

