/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.internal.util.ComponentConfigurationRegistry;
import com.ibm.team.repository.common.serialize.IDeserializer2;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import com.ibm.team.repository.common.transport.HostUtil;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.InsecureProtocolException;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.transport.UriUtil;
import com.ibm.team.repository.common.transport.VersionMismatchException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.auth.Tracer;
import com.ibm.team.repository.transport.auth.TransportAuthException;
import com.ibm.team.repository.transport.auth.TransportAuthUtil;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.NoResponseException;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.client.RemoteTeamService;
import com.ibm.team.repository.transport.internal.client.MethodProvider;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class ClientHttpUtil
extends HttpUtil {
    private static final String NLS_HTTP_ERROR = "ClientHttpUtil.HttpError";
    private static final String NLS_HTTP_ERROR_AUTHENTICATION = "ClientHttpUtil.HttpError.Authentication";
    private static final String NLS_HTTP_ERROR_SERVICE = "ClientHttpUtil.HttpError.Service";
    private static final String NLS_HTTP_ERROR_TIMEOUT = "ClientHttpUtil.HttpError.Timeout";
    private static final String NLS_HTTP_ERROR_NO_RESPONSE = "ClientHttpUtil.HttpError.NoResponse";
    private static final String NLS_HTTP_ERROR_SOCKET = "ClientHttpUtil.HttpError.Socket";
    private static final String NLS_HTTP_ERROR_INVALID = "ClientHttpUtil.HttpError.Invalid";
    private static final String NLS_HTTP_ERROR_UNKNOWN_HOST = "ClientHttpUtil.HttpError.UnknownHost";
    private static final String NLS_MISSING_PASSWORD = "ClientHttpUtil.MissingPassword";
    private static final String NLS_MISSING_USERNAME = "ClientHttpUtil.MissingUsername";
    private static final String NLS_MISSING_USERNAME_PASSWORD = "ClientHttpUtil.MissingUsernamePassword";
    private static final String NLS_GENERAL_ERROR = "ClientHttpUtil.GeneralError";
    private static final String NLS_GENERAL_ERROR_UNKNOWN_SERVICE = "ClientHttpUtil.GeneralErrorUnknownService";
    private static final String NLS_UNAVAILABLE_ERROR = "ClientHttpUtil.UnavailableError";
    private static final String NLS_NOT_IMPLEMENTED_ERROR = "ClientHttpUtil.NotImplementedError";
    private static final String NLS_FORBIDDEN_ERROR = "ClientHttpUtil.ForbiddenError";
    private static final String NLS_UNAUTHORIZED_ERROR = "ClientHttpUtil.UnauthorizedError";
    private static final String NLS_UNEXPECTED_AUTH_ERROR = "ClientHttpUtil.UnexpectedAuthError";
    private static final String JAUTH_TOKEN_DOMAIN_COOKIE = "8bd8c910-6d91-11df-be2b-0800200c9a66";
    private static final String ISSUE_TOKEN_URI = "jauth-issue-token";
    private static final String AUTHENTICATED_IDENTITY_URI = "/authenticated/identity";
    private static final String PROP_SYSTEM_TEST = "com.ibm.team.repository.transport.client.ClientHttpUtil.test";
    private static final String PROP_TEST_TOKEN_EXPIRATION = "com.ibm.team.repository.transport.client.ClientHttpUtil.test.tokenExpiration";
    private static final String PROP_TEST_EXECUTE_WAIT_TIME = "com.ibm.team.repository.transport.client.ClientHttpUtil.test.authorizedRequestWait";
    private static final String PROP_TEST_ALLOW_JAUTH_FAILURE_RETRIES = "com.ibm.team.repository.transport.client.ClientHttpUtil.test.jauthFailureRetries";
    private static final String VIA_PROXY_HEADER = "X-Via-Jazz-Proxy";
    private static final String FROM_WEBUI_PROXY_HEADER = "X-net-jazz-ajax-proxy";
    private final RemoteTeamServer server;
    private final RemoteTeamService service;
    private final boolean handle404;
    private final boolean wrapIOException;
    private final boolean decodeExceptions;
    private final HttpClient httpClient;
    private static Pattern JAUTH_PATTERN = Pattern.compile("^[Jj][Aa][Uu][Tt][Hh]\\s+.*");
    private static Pattern BASIC_PATTERN = Pattern.compile("^[Bb][Aa][Ss][Ii][Cc]\\s+.*");
    private static Tracer _tracer = new Tracer(ClientHttpUtil.class);
    private static MethodProvider methodProvider = null;
    private boolean serverHandlesJAuth;
    public static final String PROXY_URI_PARM = "uri";
    public static final String PROXY_CONTEXT_SEGMENT = "proxy";
    private static final Log logger = LogFactory.getLog(ClientHttpUtil.class);

    ClientHttpUtil(RemoteTeamServer server, RemoteTeamService service, boolean handle404, boolean wrapIOException, boolean decodeExceptions) {
        this(server, service, handle404, wrapIOException, true, decodeExceptions);
    }

    ClientHttpUtil(RemoteTeamServer server, RemoteTeamService service, boolean handle404, boolean wrapIOException, boolean serverHandlesJAuth, boolean decodeExceptions) {
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        this.server = server;
        this.service = service;
        this.handle404 = handle404;
        this.wrapIOException = wrapIOException;
        this.decodeExceptions = decodeExceptions;
        this.httpClient = server.getHttpClient();
        this.serverHandlesJAuth = true;
    }

    public static int executeHttpMethod(RemoteTeamServer server, RemoteTeamService service, HttpMethod method, boolean handle404, boolean wrapIOException, boolean decodeExceptions) throws IOException, TeamServiceException {
        if (method == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        _tracer.enter("executeHttpMethod(server, service, method, handle404, wrapIOException, decodeExceptions)", new Object[0]);
        try {
            int status;
            ClientHttpUtil clientUtil = new ClientHttpUtil(server, service, handle404, wrapIOException, decodeExceptions);
            int n = status = clientUtil.executeHttpMethod(method, true);
            return n;
        }
        finally {
            _tracer.leave("executeHttpMethod(server, service, method, handle404, wrapIOException, decodeExceptions)", new Object[0]);
        }
    }

    public static int executeHttpMethod(RemoteTeamServer server, RemoteTeamService service, HttpMethod method, boolean handle404, boolean wrapIOException) throws IOException, TeamServiceException {
        return ClientHttpUtil.executeHttpMethod(server, service, method, handle404, wrapIOException, true);
    }

    private static String extractJAuthToken(HostConfiguration hostConfig, String path, HttpState state) {
        _tracer.enter("extractJAuthToken", new Object[0]);
        try {
            Cookie[] cookies = state.getCookies();
            CookieSpecBase spec = new CookieSpecBase();
            boolean isSecure = hostConfig.getProtocol().isSecure();
            String cookieHost = JAUTH_TOKEN_DOMAIN_COOKIE + hostConfig.getHost();
            int port = hostConfig.getPort();
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (spec.match(cookieHost, port, path, isSecure, cookie) && cookie.getName().equals("user_token")) {
                    String val = cookie.getValue();
                    _tracer.debug("Found JAuthToken cookie value: %s", new Object[]{val});
                    String string = val;
                    return string;
                }
                ++n2;
            }
            _tracer.trace("extractJAuthToken - no cookie found", new Object[0]);
            return null;
        }
        finally {
            _tracer.leave("extractJAuthToken", new Object[0]);
        }
    }

    private void storeJAuthToken(HostConfiguration hostConfig, String path, HttpState state, String tokenValue, int maxAge) {
        _tracer.enter("storeJAuthToken", new Object[0]);
        try {
            if (hostConfig == null) {
                _tracer.debug("Request HostConfiguration not available - using httpClient HostConfiguration", new Object[0]);
                hostConfig = this.httpClient.getHostConfiguration();
            }
            String cookieHost = JAUTH_TOKEN_DOMAIN_COOKIE + hostConfig.getHost();
            Cookie cookie = new Cookie(cookieHost, "user_token", tokenValue, path, maxAge, false);
            _tracer.debug("Adding JAuthToken cookie to HttpState: %s", new Object[]{cookie.toExternalForm()});
            state.addCookie(cookie);
        }
        finally {
            _tracer.leave("storeJAuthToken", new Object[0]);
        }
    }

    private void addJAuthAuthorizationHeader(HttpRequest request) {
        _tracer.enter("addJAuthAuthorizationHeader", new Object[0]);
        try {
            String token;
            HostConfiguration hostConfig = request.hostConfig;
            if (hostConfig == null) {
                _tracer.debug("Request HostConfiguration not available - using httpClient HostConfiguration", new Object[0]);
                hostConfig = this.httpClient.getHostConfiguration();
            }
            if ((token = ClientHttpUtil.extractJAuthToken(hostConfig, request.method.getPath(), request.state)) == null) {
                token = UUID.generate().getUuidValue();
                _tracer.debug("No stored JAuth token value - using auto-generated token \"%s\"", new Object[]{token});
            }
            request.method.removeRequestHeader("Authorization");
            request.method.addRequestHeader("Authorization", String.format("jauth user_token=%s", token));
            request.method.setDoAuthentication(false);
        }
        finally {
            _tracer.leave("addJAuthAuthorizationHeader", new Object[0]);
        }
    }

    private static void removeJAuthAuthorization(HttpRequest request) {
        if (ClientHttpUtil.hasJAuthAuthorization(request)) {
            request.method.removeRequestHeader("Authorization");
        }
    }

    private static boolean hasJAuthAuthorization(HttpRequest request) {
        request.method.getRequestHeaders("Authorization");
        Header[] headerArray = request.method.getRequestHeaders("Authorization");
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String value = header.getValue().trim();
            if (JAUTH_PATTERN.matcher(value).find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int executeHttpMethod(HttpMethod method, boolean retry) throws TeamServiceException, IOException {
        _tracer.enter("executeHttpMethod(method, retry)", new Object[0]);
        try {
            int status;
            HttpState state = this.httpClient.getState();
            HttpRequest request = new HttpRequest(null, method, state);
            int n = status = this.executeHttpMethod(request, this.serverHandlesJAuth, retry);
            return n;
        }
        finally {
            _tracer.leave("executeHttpMethod(method, retry)", new Object[0]);
        }
    }

    private int executeHttpMethod(HttpRequest request, boolean useJAuth, boolean retry) throws TeamServiceException, IOException {
        _tracer.enter("executeHttpMethod(request, useJAuth, retry)", new Object[0]);
        try {
            boolean authenticationHandled;
            int soTimeout = this.server.getConfiguration().getSocketTimeout();
            Header soTimeoutHeader = request.method.getRequestHeader("http.socket.timeout");
            if (soTimeoutHeader != null && soTimeoutHeader.getValue() != null) {
                try {
                    soTimeout = Integer.parseInt(soTimeoutHeader.getValue());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.httpClient.getParams().setSoTimeout(soTimeout);
            HostConfiguration methodConfiguration = request.method.getHostConfiguration();
            if (methodConfiguration != null && methodConfiguration.isHostSet()) {
                Protocol protocol = methodConfiguration.getProtocol();
                String host = methodConfiguration.getHost();
                int port = methodConfiguration.getPort();
                logger.warn((Object)NLS.bind((String)"HttpMethod should not have a defined host\n\tProtocol: {0}\n\tHost: {1}\n\tPort: {2}", (Object)protocol.toString(), (Object[])new Object[]{host, port}));
            }
            java.net.URI requestUri = this.getURI(request);
            HttpState state = request.state;
            HttpState privateState = this.createTemporaryHttpState(state, requestUri);
            request = request.changeState(privateState);
            if (useJAuth) {
                _tracer.debug("Adding JAuth Authorization header", new Object[0]);
                this.addJAuthAuthorizationHeader(request);
            }
            request.method.setFollowRedirects(false);
            request.method.setDoAuthentication(false);
            int statusCode = this.executePrimitiveRequest(request);
            _tracer.debug("Executed httpRequest on URL \"%s\": statusCode: %d", new Object[]{requestUri.toString(), statusCode});
            try {
                authenticationHandled = this.handleAuthenticationChallenge(request);
            }
            catch (ServiceNotAvailableDuringAuthException e) {
                int n = e.getStatusCode();
                _tracer.leave("executeHttpMethod(request, useJAuth, retry)", new Object[0]);
                return n;
            }
            if (authenticationHandled) {
                _tracer.debug("Authentication challenge handled", new Object[0]);
                if (useJAuth) {
                    if (this.serverHandlesJAuth) {
                        _tracer.debug("Adding JAuth Authorization header", new Object[0]);
                        this.addJAuthAuthorizationHeader(request);
                    } else {
                        ClientHttpUtil.removeJAuthAuthorization(request);
                    }
                }
                request.method.setFollowRedirects(false);
                request.method.setDoAuthentication(false);
                if (retry && useJAuth && this.serverHandlesJAuth && ClientHttpUtil.clientUnderTest()) {
                    int seconds = ClientHttpUtil.getExecuteWaitTimeForTest();
                    if (seconds != -1) {
                        try {
                            Thread.sleep(seconds * 1000);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    ClientHttpUtil.unsetExecuteWaitTimeForTest();
                    ClientHttpUtil.unsetTokenExpirationForTest();
                }
                statusCode = this.executePrimitiveRequest(request);
                _tracer.debug("Executed httpRequest on URL \"%s\": statusCode: %d", new Object[]{requestUri.toString(), statusCode});
                AuthChallengeHandler challengeHandler = this.detectAuthenticationChallenge(request, true);
                if (challengeHandler != null) {
                    statusCode = challengeHandler.getRequest().method.getStatusCode();
                    if (retry && challengeHandler instanceof JAuthChallengeHandler && ClientHttpUtil.allowJAuthFailureRetries()) {
                        _tracer.debug("Retrying request because of failed jauth authentication", new Object[0]);
                        statusCode = this.executeHttpMethod(request.method, false);
                        challengeHandler = this.detectAuthenticationChallenge(request, true);
                        if (challengeHandler != null) {
                            _tracer.trace("executeHttpMethod: Unexpected authChallenge - throwing AuthenticationException", new Object[0]);
                            this.throwAuthenticationException(request, this.getAppropriateRequestURL(request));
                        }
                    } else {
                        _tracer.trace("executeHttpMethod: Unexpected authChallenge - throwing AuthenticationException", new Object[0]);
                        this.throwAuthenticationException(request, this.getAppropriateRequestURL(request));
                    }
                }
            }
            state.addCookies(privateState.getCookies());
            if (ClientHttpUtil.isResponseFromProxyTarget(request)) {
                _tracer.debug("Response from JFAM proxy - exiting", new Object[0]);
                int n = statusCode;
                return n;
            }
            switch (statusCode) {
                case 401: {
                    String message = NLS.bind((String)Messages.getServerString(NLS_UNAUTHORIZED_ERROR), (Object)request.method.getURI(), (Object[])new Object[0]);
                    AuthenticationException exp = new AuthenticationException(message, statusCode);
                    exp.setRequestUri(this.getAppropriateRequestURL(request));
                    exp.addHeaders(request.method.getResponseHeaders());
                    _tracer.trace("executeHttpMethod: Throwing AuthenticationException", new Object[0]);
                    throw exp;
                }
                case 403: {
                    String message = NLS.bind((String)Messages.getServerString(NLS_FORBIDDEN_ERROR), (Object)request.method.getURI(), (Object[])new Object[0]);
                    PermissionDeniedException wrappedCause = new PermissionDeniedException(message);
                    AuthenticationException exp = new AuthenticationException(message, (Throwable)wrappedCause, statusCode);
                    exp.setRequestUri(this.getAppropriateRequestURL(request));
                    exp.addHeaders(request.method.getResponseHeaders());
                    _tracer.trace("executeHttpMethod: Throwing AuthenticationException", new Object[0]);
                    throw exp;
                }
                case 501: {
                    String message = NLS.bind((String)Messages.getServerString(NLS_NOT_IMPLEMENTED_ERROR), (Object)request.method.getURI(), (Object[])new Object[0]);
                    ServiceNotAvailableException exp = new ServiceNotAvailableException(message, statusCode);
                    exp.setRequestUri(this.getAppropriateRequestURL(request));
                    exp.addHeaders(request.method.getResponseHeaders());
                    _tracer.trace("executeHttpMethod: Throwing ServiceNotAvailableException", new Object[0]);
                    throw exp;
                }
                case 503: {
                    String message = NLS.bind((String)Messages.getServerString(NLS_UNAVAILABLE_ERROR), (Object)request.method.getURI(), (Object[])new Object[0]);
                    ServiceNotAvailableException exp = new ServiceNotAvailableException(message, statusCode);
                    exp.setRequestUri(this.getAppropriateRequestURL(request));
                    exp.addHeaders(request.method.getResponseHeaders());
                    _tracer.trace("executeHttpMethod: Throwing ServiceNotAvailableException", new Object[0]);
                    throw exp;
                }
                case 302: {
                    String protocol = this.httpClient.getHostConfiguration().getProtocol().getScheme();
                    if (protocol.compareToIgnoreCase("http") == 0) {
                        String message = NLS.bind((String)Messages.getServerString("ClientHttpUtil.ErrorInsecureHttpConnection"), (Object)request.method.getURI(), (Object[])new Object[]{"http", "https"});
                        _tracer.trace("executeHttpMethod: Throwing InsecureProtocolException", new Object[0]);
                        throw new InsecureProtocolException(message, statusCode);
                    }
                    _tracer.trace("executeHttpMethod: Throwing httpClientError", new Object[0]);
                    this.throwHttpClientError(request, statusCode);
                }
            }
            if (!this.handle404 && 404 == statusCode) {
                _tracer.trace("executeHttpMethod: not handling 404", new Object[0]);
                int n = statusCode;
                return n;
            }
            if (statusCode >= 300) {
                _tracer.trace("executeHttpMethod: Throwing httpClientError for statusCode %d", new Object[]{statusCode});
                this.throwHttpClientError(request, statusCode);
            }
            _tracer.trace("executeHttpMethod: statusCode == %d", new Object[]{statusCode});
            int n = statusCode;
            return n;
        }
        finally {
            _tracer.leave("executeHttpMethod(request, useJAuth, retry)", new Object[0]);
        }
    }

    private void throwAuthenticationException(HttpRequest request, String requestUri) throws AuthenticationException {
        String message = NLS.bind((String)Messages.getServerString(NLS_UNEXPECTED_AUTH_ERROR), (Object)requestUri, (Object[])new Object[0]);
        message = this.dumpResponseState(request, message);
        AuthenticationException exp = new AuthenticationException(message, 401);
        exp.setRequestUri(requestUri);
        exp.addHeaders(request.method.getResponseHeaders());
        throw exp;
    }

    private String dumpResponseState(HttpRequest request, String message) {
        Header header;
        StringBuffer buf = new StringBuffer(message != null ? message : "");
        buf.append("\nHTTP Client");
        buf.append("\nHost Config: ");
        buf.append(this.httpClient.getHostConfiguration());
        buf.append("\n\nMETHOD");
        buf.append("\nAuth State: ");
        buf.append(request.method.getHostAuthState());
        buf.append("\nMethod HostConfig: ");
        buf.append(request.method.getHostConfiguration());
        buf.append("\nRequest struct HostConfig: ");
        buf.append(request.hostConfig);
        buf.append("\n\nREQUEST");
        buf.append("\nName: ");
        buf.append(request.method.getName());
        buf.append("\nPath: ");
        buf.append(request.method.getPath() != null ? request.method.getPath() : "");
        buf.append("\nURI: ");
        try {
            buf.append(request.method.getURI());
        }
        catch (Exception e) {
            buf.append("Error getting URI: " + e.getMessage());
        }
        buf.append("\nRequest Headers:\n");
        Header[] headerArray = request.method.getRequestHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            header = headerArray[n2];
            buf.append('\t');
            buf.append(header.toExternalForm());
            ++n2;
        }
        buf.append("\n\nRESPONSE");
        buf.append("\nStatus Line: ");
        buf.append(request.method.getStatusLine() != null ? request.method.getStatusLine().toString() : "");
        buf.append("\nResponse Headers:\n");
        headerArray = request.method.getResponseHeaders();
        n = headerArray.length;
        n2 = 0;
        while (n2 < n) {
            header = headerArray[n2];
            buf.append('\t');
            buf.append(header.toExternalForm());
            ++n2;
        }
        return buf.toString();
    }

    public static void setMethodProvider(MethodProvider mp) {
        methodProvider = mp;
    }

    private PostMethod createPostMethod(String uri) {
        if (methodProvider != null) {
            return methodProvider.createPostMethod(uri);
        }
        return new PostMethod(uri);
    }

    private AuthChallengeHandler detectAuthenticationChallenge(HttpRequest request, boolean authOnly) throws TeamServiceException, IOException {
        _tracer.enter("detectAuthenticationChallenge", new Object[0]);
        try {
            boolean requestingJAuth = ClientHttpUtil.hasJAuthAuthorization(request);
            HttpRequest finalRequest = this.followRedirects(request, authOnly);
            int statusCode = finalRequest.method.getStatusCode();
            Object handler = null;
            if (statusCode == 401) {
                _tracer.debug("Handling unauthorized status code", new Object[0]);
                Header authenticateHeader = finalRequest.method.getResponseHeader("WWW-Authenticate");
                if (authenticateHeader != null) {
                    String value = authenticateHeader.getValue();
                    _tracer.debug("Handling authenticateHeader \"%s\"", new Object[]{value});
                    if (JAUTH_PATTERN.matcher(value).matches()) {
                        HttpRequest requestToExecute = request;
                        if (finalRequest != request) {
                            requestToExecute = finalRequest;
                        }
                        finalRequest.method.releaseConnection();
                        handler = new JAuthChallengeHandler(requestToExecute);
                    } else if (BASIC_PATTERN.matcher(value).matches()) {
                        HttpRequest requestToExecute = request;
                        if (finalRequest != request) {
                            requestToExecute = finalRequest;
                        }
                        finalRequest.method.releaseConnection();
                        handler = new BasicAuthChallengeHandler(requestToExecute);
                    }
                } else {
                    AuthScheme authScheme = finalRequest.method.getHostAuthState().getAuthScheme();
                    if (authScheme != null && finalRequest.method.getHostAuthState().isAuthRequested() && authScheme.getSchemeName().equalsIgnoreCase("BASIC")) {
                        HttpRequest requestToExecute = request;
                        if (finalRequest != request) {
                            _tracer.debug("finalRequest != request", new Object[0]);
                            requestToExecute = finalRequest;
                        }
                        finalRequest.method.releaseConnection();
                        handler = new BasicAuthChallengeHandler(requestToExecute);
                    }
                }
            } else if (TransportAuthUtil.hasAuthRequiredHeader((HttpMethod)finalRequest.method)) {
                finalRequest.method.releaseConnection();
                handler = new FormAuthChallengeHandler(finalRequest);
            }
            if (requestingJAuth && handler != null && !(handler instanceof JAuthChallengeHandler)) {
                this.serverHandlesJAuth = false;
            }
            String handlerName = "no handler";
            if (handler != null) {
                handlerName = handler.getClass().getSimpleName();
            }
            _tracer.trace("Returning handler: \"%s\"", new Object[]{handlerName});
            Object object = handler;
            return object;
        }
        finally {
            _tracer.leave("detectAuthenticationChallenge", new Object[0]);
        }
    }

    private static String migrateCredentials(HttpState state, java.net.URI orignalUri, String targetURLString) {
        _tracer.enter("migrateCredentials", new Object[0]);
        try {
            java.net.URI targetUri;
            if (!orignalUri.isAbsolute()) {
                _tracer.trace("migrateCredentials - throwing IAE as URI not absolute", new Object[0]);
                throw new IllegalArgumentException(NLS.bind((String)"Credentials cannot be migrated from the original URI, \"{0}\", because it is relative.", (Object)orignalUri.toString(), (Object[])new Object[0]));
            }
            AuthScope originalAuthScope = new AuthScope(orignalUri.getHost(), orignalUri.getPort());
            Credentials originalCredentials = state.getCredentials(originalAuthScope);
            try {
                targetUri = new java.net.URI(targetURLString);
            }
            catch (URISyntaxException e) {
                _tracer.trace("migrateCredentials - throwing URISyntaxException", new Object[0]);
                throw new IllegalArgumentException(NLS.bind((String)"The target URI, \"{0}\", was not a valid URI.", (Object)targetURLString, (Object[])new Object[0]), e);
            }
            if (targetUri.isAbsolute() && originalCredentials != null) {
                _tracer.debug("Creating new AuthScope and updating credentials", new Object[0]);
                AuthScope targetAuthScope = new AuthScope(targetUri.getHost(), targetUri.getPort(), AuthScope.ANY_REALM, targetUri.getScheme());
                state.setCredentials(targetAuthScope, originalCredentials);
            }
            if (originalCredentials instanceof UsernamePasswordCredentials) {
                String userName = ((UsernamePasswordCredentials)originalCredentials).getUserName();
                _tracer.trace("migrateCredentials - userName %s", new Object[]{userName});
                String string = userName;
                return string;
            }
            _tracer.trace("migrateCredentials - returning null", new Object[0]);
            return null;
        }
        finally {
            _tracer.leave("migrateCredentials", new Object[0]);
        }
    }

    private HttpRequest followRedirects(HttpRequest request, boolean authOnly) throws IOException, TeamServiceException {
        _tracer.enter("followRedirects - authOnly == %s, statusCode == %d", new Object[]{authOnly, request.method.getStatusCode()});
        try {
            boolean handledAuthenticatedIdentity = false;
            while (request.method.getStatusCode() == 302) {
                _tracer.debug("Handling 302", new Object[0]);
                if (!authOnly || TransportAuthUtil.hasAuthRequiredHeader((HttpMethod)request.method)) {
                    authOnly = false;
                    Header location = request.method.getResponseHeader("Location");
                    if (location != null) {
                        request.method.releaseConnection();
                        String locationURL = location.getValue();
                        if (ClientHttpUtil.isIssueTokenURL(locationURL)) {
                            _tracer.trace("followRedirects - issueToken URL: %s", new Object[]{locationURL});
                            HttpRequest httpRequest = request;
                            return httpRequest;
                        }
                        if (handledAuthenticatedIdentity && !TransportAuthUtil.formAuthRequested((HttpMethod)request.method)) {
                            _tracer.trace("followRedirects - received a 302 after having seen identity servlet - URL: %s", new Object[]{locationURL});
                            HttpRequest httpRequest = request;
                            return httpRequest;
                        }
                        if (ClientHttpUtil.isAuthenticatedIdentity(locationURL)) {
                            handledAuthenticatedIdentity = true;
                        }
                        ClientHttpUtil.migrateCredentials(request.state, this.getURI(request), locationURL);
                        HttpRequest redirectRequest = this.createGetRequestForRedirect(locationURL, request);
                        redirectRequest.method.setFollowRedirects(false);
                        redirectRequest.method.setDoAuthentication(false);
                        this.executePrimitiveRequest(redirectRequest);
                        request = redirectRequest;
                        continue;
                    }
                    java.net.URI requestedURI = this.getURI(request);
                    _tracer.trace("followRedirects - throwing TeamServiceException", new Object[0]);
                    throw new TeamServiceException(NLS.bind((String)"A redirect request was received from the server in the response from \"{0}\", but no location was received.", (Object)requestedURI.toString(), (Object[])new Object[0]));
                }
                _tracer.trace("followRedirects - only following auth redirects", new Object[0]);
                break;
            }
            HttpRequest httpRequest = request;
            return httpRequest;
        }
        finally {
            _tracer.leave("followRedirects", new Object[0]);
        }
    }

    private static boolean isIssueTokenURL(String url) {
        _tracer.enter("isIssueTokenURL", new Object[0]);
        try {
            java.net.URI uri;
            if (url == null) {
                _tracer.trace("isIssueTokenURL - url == null", new Object[0]);
                return false;
            }
            try {
                uri = new java.net.URI(url);
            }
            catch (URISyntaxException e) {
                ClientHttpUtil.error("Exception parsing url \"%s\": %s", url, e.getMessage());
                _tracer.trace("isIssueTokenURL - false", new Object[0]);
                _tracer.leave("isIssueTokenURL", new Object[0]);
                return false;
            }
            String segment = UriUtil.trimTrailingSlash((String)uri.getPath());
            boolean isTokenUrl = segment.endsWith(ISSUE_TOKEN_URI);
            _tracer.trace("isTokenUrl - value == %s", new Object[]{isTokenUrl});
            boolean bl = isTokenUrl;
            return bl;
        }
        finally {
            _tracer.leave("isIssueTokenURL", new Object[0]);
        }
    }

    private static boolean isAuthenticatedIdentity(String url) {
        _tracer.enter("isAuthenticatedIdentity", new Object[0]);
        try {
            java.net.URI uri;
            if (url == null) {
                _tracer.trace("isAuthenticatedIdentity - url == null", new Object[0]);
                return false;
            }
            try {
                uri = new java.net.URI(url);
            }
            catch (URISyntaxException e) {
                ClientHttpUtil.error("Exception parsing url \"%s\": %s", url, e.getMessage());
                _tracer.trace("isAuthenticatedIdentity - false", new Object[0]);
                _tracer.leave("isAuthenticatedIdentity", new Object[0]);
                return false;
            }
            String segment = UriUtil.trimTrailingSlash((String)uri.getPath());
            boolean isAuthenticatedIdentityUrl = segment.endsWith(AUTHENTICATED_IDENTITY_URI);
            _tracer.trace("isAuthenticatedIdentity - value == %s", new Object[]{isAuthenticatedIdentityUrl});
            boolean bl = isAuthenticatedIdentityUrl;
            return bl;
        }
        finally {
            _tracer.leave("isAuthenticatedIdentity", new Object[0]);
        }
    }

    private HttpRequest createGetRequestForRedirect(String location, HttpRequest request) throws TeamServiceException, IOException {
        _tracer.enter("createGetRequestForRedirect", new Object[0]);
        try {
            PathAndHostConfig pathAndHostConfig = this.buildPathAndHostConfig(location, request);
            request = request.changeHostConfig(pathAndHostConfig.config);
            GetMethod method = new GetMethod(pathAndHostConfig.path);
            HttpRequest httpRequest = request.changeMethod((HttpMethod)method);
            return httpRequest;
        }
        finally {
            _tracer.leave("createGetRequestForRedirect", new Object[0]);
        }
    }

    private static boolean isResponseFromProxyTarget(HttpRequest request) {
        _tracer.enter("isResponseFromProxyTarget", new Object[0]);
        try {
            Header proxyHeader = request.getMethod().getResponseHeader(VIA_PROXY_HEADER);
            boolean retVal = proxyHeader != null && Boolean.parseBoolean(proxyHeader.getValue());
            _tracer.trace("isResponseFromProxyTarget - return = %s", new Object[]{retVal});
            boolean bl = retVal;
            return bl;
        }
        finally {
            _tracer.leave("isResponseFromProxyTarget", new Object[0]);
        }
    }

    private PathAndHostConfig buildPathAndHostConfig(String newLocation, HttpRequest request) throws TeamServiceException, IOException {
        _tracer.enter("buildPathAndHostConfig - location = %s", new Object[]{newLocation});
        try {
            String fragment;
            java.net.URI locationURI;
            java.net.URI requestURI = this.getURI(request);
            try {
                locationURI = new java.net.URI(newLocation);
                if (!locationURI.isAbsolute()) {
                    _tracer.trace("buildPathAndHostConfig - unexpected relative URI", new Object[0]);
                    throw new IllegalStateException(String.format("The URI \"%s\" is expected to be absolute", newLocation));
                }
            }
            catch (URISyntaxException e) {
                _tracer.trace("buildPathAndHostConfig - throwing URISyntaxException: %s", new Object[]{e.getMessage()});
                throw new TeamServiceException(NLS.bind((String)"The location, \"{0}\", relative to \"{1}\" could not be resolved.", (Object)newLocation, (Object[])new Object[]{requestURI.toString()}), (Throwable)e);
            }
            HostConfiguration hostConfig = request.hostConfig;
            if (!HostUtil.authorityEquivalent((java.net.URI)requestURI, (java.net.URI)locationURI) || hostConfig == null) {
                hostConfig = this.server.buildHostConfiguration(locationURI.getScheme(), locationURI.getHost(), locationURI.getPort());
            }
            String path = locationURI.getRawPath();
            String query = locationURI.getRawQuery();
            if (query != null) {
                path = String.valueOf(path) + '?' + query;
            }
            if ((fragment = locationURI.getRawFragment()) != null) {
                path = String.valueOf(path) + '#' + fragment;
            }
            PathAndHostConfig pathAndHostConfig = new PathAndHostConfig(path, hostConfig);
            return pathAndHostConfig;
        }
        finally {
            _tracer.leave("buildPathAndHostConfig", new Object[0]);
        }
    }

    private boolean handleAuthenticationChallenge(HttpRequest request) throws TeamServiceException, IOException {
        _tracer.enter("handleAuthenticationChallenge", new Object[0]);
        try {
            AuthChallengeHandler handler = this.detectAuthenticationChallenge(request, false);
            if (handler != null) {
                boolean noPasswordAuthFailures = handler.handleChallenge();
                _tracer.trace("handleAuthenticationChallenge - return = %b", new Object[]{noPasswordAuthFailures});
                boolean bl = noPasswordAuthFailures;
                return bl;
            }
            _tracer.trace("handleAuthenticationChallenge - return = %s", new Object[]{"false"});
            return false;
        }
        finally {
            _tracer.leave("handleAuthenticationChallenge", new Object[0]);
        }
    }

    private int executePrimitiveRequest(HttpRequest request) throws TeamServiceException, IOException {
        _tracer.enter("executePrimitiveRequest", new Object[0]);
        try {
            int statusCode = -1;
            java.net.URI requestUri = this.getURI(request);
            try {
                this.server.updateHostConfigProxy(request.hostConfig);
                this.server.updateProxyCredentials(request.state);
                ClientHttpUtil.addComponentConfigurationHeaders(request.method);
                statusCode = this.httpClient.executeMethod(request.hostConfig, request.method, request.state);
            }
            catch (org.apache.commons.httpclient.auth.AuthenticationException e) {
                AuthenticationException ex = new AuthenticationException(this.httpErrorMessage(NLS_HTTP_ERROR_AUTHENTICATION, request, (Exception)((Object)e)), e, 401);
                ex.setRequestUri(requestUri.toString());
                ex.addHeaders(request.method.getResponseHeaders());
                _tracer.trace("executePrimitiveRequest - Throwing AuthenticationException", new Object[0]);
                throw ex;
            }
            catch (HttpException e) {
                TeamServiceException ex = new TeamServiceException(this.httpErrorMessage(NLS_HTTP_ERROR_SERVICE, request, (Exception)((Object)e)), (Throwable)e);
                ex.setRequestUri(requestUri.toString());
                ex.addHeaders(request.method.getResponseHeaders());
                _tracer.trace("executePrimitiveRequest - Throwing HttpException", new Object[0]);
                throw ex;
            }
            catch (ConnectTimeoutException e) {
                ConnectionException ex = new ConnectionException(this.httpErrorMessage(NLS_HTTP_ERROR_TIMEOUT, request, (Exception)((Object)e)), (Throwable)e);
                ex.setRequestUri(requestUri.toString());
                _tracer.trace("executePrimitiveRequest - Throwing ConnectTimeoutException", new Object[0]);
                throw ex;
            }
            catch (NoHttpResponseException e) {
                NoResponseException ex = new NoResponseException(this.httpErrorMessage(NLS_HTTP_ERROR_NO_RESPONSE, request, (Exception)((Object)e)), e);
                ex.setRequestUri(requestUri.toString());
                _tracer.trace("executePrimitiveRequest - Throwing NoHttpResponseException", new Object[0]);
                throw ex;
            }
            catch (SocketException e) {
                ConnectionException c = new ConnectionException(this.httpErrorMessage(NLS_HTTP_ERROR_SOCKET, request, e), (Throwable)e);
                c.setRequestUri(requestUri.toString());
                _tracer.trace("executePrimitiveRequest - Throwing SocketException", new Object[0]);
                throw c;
            }
            catch (UnresolvedAddressException e) {
                HostUnknownException ex = new HostUnknownException(this.httpErrorMessage(NLS_HTTP_ERROR_INVALID, request, e), (Throwable)e);
                ex.setRequestUri(requestUri.toString());
                _tracer.trace("executePrimitiveRequest - Throwing UnresolvedAddressException", new Object[0]);
                throw ex;
            }
            catch (UnknownHostException e) {
                HostUnknownException ex = new HostUnknownException(this.httpErrorMessage(NLS_HTTP_ERROR_UNKNOWN_HOST, request, e), (Throwable)e);
                ex.setRequestUri(requestUri.toString());
                _tracer.trace("executePrimitiveRequest - Throwing UnknownHostException", new Object[0]);
                throw ex;
            }
            catch (IOException e) {
                if (this.wrapIOException) {
                    TeamServiceException ex = new TeamServiceException(this.httpErrorMessage(request, e), (Throwable)e);
                    ex.setRequestUri(requestUri.toString());
                    _tracer.trace("executePrimitiveRequest - Throwing TeamServiceException", new Object[0]);
                    throw ex;
                }
                _tracer.trace("executePrimitiveRequest - Throwing catch-all IOException", new Object[0]);
                throw e;
            }
            _tracer.trace("executePrimitiveRequest - statusCode = %d", new Object[]{statusCode});
            int n = statusCode;
            return n;
        }
        finally {
            _tracer.leave("executePrimitiveRequest", new Object[0]);
        }
    }

    private HttpState createTemporaryHttpState(HttpState state, java.net.URI requestURI) throws MalformedURLException {
        _tracer.enter("createTemporaryHttpState", new Object[0]);
        try {
            AuthScope as;
            Credentials cred;
            HttpState privateState = new HttpState();
            privateState.addCookies(state.getCookies());
            int port = requestURI.getPort();
            if (port == -1) {
                port = requestURI.toURL().getDefaultPort();
            }
            if ((cred = state.getCredentials(as = new AuthScope(requestURI.getHost(), port))) != null) {
                _tracer.debug("Setting credentials on returned state", new Object[0]);
                privateState.setCredentials(as, cred);
            }
            if ((as = this.server.getProxyAuthScope()) != null) {
                _tracer.debug("Proxy AuthScope != null", new Object[0]);
                cred = state.getProxyCredentials(as);
                if (cred != null) {
                    _tracer.debug("Setting proxy credentials on returned state", new Object[0]);
                    privateState.setProxyCredentials(as, cred);
                }
            }
            HttpState httpState = privateState;
            return httpState;
        }
        finally {
            _tracer.leave("createTemporaryHttpState", new Object[0]);
        }
    }

    public static void setAcceptLanguageHeader(HttpMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        _tracer.enter("setAcceptLanguageHeader", new Object[0]);
        try {
            String variant;
            Locale locale = Locale.getDefault();
            StringBuffer buffer = new StringBuffer(locale.getLanguage());
            String country = locale.getCountry();
            if (country.length() > 0) {
                buffer.append('-').append(country);
            }
            if ((variant = locale.getVariant()).length() > 0) {
                buffer.append('-').append(variant);
            }
            String headerVal = buffer.toString();
            _tracer.trace("setAcceptLanguageHeader - value == %s", new Object[]{headerVal});
            method.setRequestHeader("Accept-Language", headerVal);
        }
        finally {
            _tracer.leave("setAcceptLanguageHeader", new Object[0]);
        }
    }

    private void throwHttpClientError(HttpRequest request, int statusCode) throws TeamServiceException {
        _tracer.enter("throwHttpClientError", new Object[0]);
        try {
            Throwable cause;
            String template;
            String decodedStatusText = URLDecoder.decode(request.method.getStatusText());
            String message = null;
            if (this.service == null) {
                template = Messages.getServerString(NLS_GENERAL_ERROR_UNKNOWN_SERVICE);
                message = NLS.bind((String)template, (Object)statusCode, (Object[])new Object[]{decodedStatusText});
            } else {
                template = Messages.getServerString(NLS_GENERAL_ERROR);
                message = NLS.bind((String)template, (Object)this.service.toString(), (Object[])new Object[]{statusCode, decodedStatusText});
            }
            TeamServiceException exp = new TeamServiceException(message, statusCode);
            try {
                exp.setRequestUri(this.getAppropriateRequestURL(request));
            }
            catch (IOException e) {
                try {
                    ClientHttpUtil.error("Error determining request URI \"%s\": %s", request.method.getURI(), e.getMessage());
                }
                catch (URIException uRIException) {
                    ClientHttpUtil.error("Error determining request URI: %s", e.getMessage());
                }
            }
            exp.addHeaders(request.method.getResponseHeaders());
            if (this.decodeExceptions) {
                if (this.service == null) {
                    ClientHttpUtil.appendReadException(exp, request.method);
                } else {
                    this.appendNestedException(exp, request.method);
                }
            }
            if ((cause = exp.getCause()) instanceof VersionMismatchException) {
                exp = new VersionMismatchException(cause.getMessage(), (Throwable)exp, statusCode);
            }
            throw exp;
        }
        catch (Throwable throwable) {
            _tracer.leave("throwHttpClientError", new Object[0]);
            throw throwable;
        }
    }

    private static void appendReadException(TeamServiceException exp, HttpMethod method) {
        Throwable cause;
        Header responseHeader = method.getResponseHeader("Content-Type");
        String encoding = HttpUtil.CharsetEncoding.ISO8859.toString();
        if (responseHeader != null) {
            HeaderElement[] elements = responseHeader.getElements();
            if (elements.length != 1) {
                return;
            }
            String type = elements[0].getName();
            if (!HttpUtil.MediaType.JSON.toString().equals(type)) {
                return;
            }
            NameValuePair nvp = elements[0].getParameterByName("charset");
            if (nvp != null) {
                encoding = nvp.getValue();
            }
        }
        try {
            byte[] body = method.getResponseBody();
            if (body == null) {
                return;
            }
            Charset charset = Charset.forName(encoding);
            ByteArrayInputStream stream = new ByteArrayInputStream(body);
            InputStreamReader r = new InputStreamReader((InputStream)stream, charset);
            IDeserializer2 deserializer = IDeserializer2.FACTORY.newInstance(HttpUtil.MediaType.JSON, null);
            cause = deserializer.deserializeException((Reader)r, ClientHttpUtil.class.getClassLoader(), null);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (SerializeException serializeException) {
            return;
        }
        Throwable walker = exp;
        while (walker.getCause() != null) {
            walker = walker.getCause();
        }
        walker.initCause(cause);
    }

    private static void throwEmptyCredsException(UsernamePasswordCredentials storedCredentials) throws AuthenticationException {
        _tracer.enter("throwEmptyCredsException", new Object[0]);
        try {
            String username = null;
            String password = null;
            if (storedCredentials != null) {
                username = storedCredentials.getUserName();
                password = storedCredentials.getPassword();
                if (username.length() == 0) {
                    username = null;
                }
                if (password.length() == 0) {
                    password = null;
                }
            }
            if (username == null && password == null) {
                _tracer.trace("throwEmptyCredsException - missing username and password", new Object[0]);
                throw new AuthenticationException(Messages.getServerString(NLS_MISSING_USERNAME_PASSWORD), 401);
            }
            if (username == null) {
                _tracer.trace("throwEmptyCredsException - missing username", new Object[0]);
                throw new AuthenticationException(Messages.getServerString(NLS_MISSING_USERNAME), 401);
            }
            _tracer.trace("throwEmptyCredsException - missing password", new Object[0]);
            throw new AuthenticationException(Messages.getServerString(NLS_MISSING_PASSWORD), 401);
        }
        catch (Throwable throwable) {
            _tracer.leave("throwEmptyCredsException", new Object[0]);
            throw throwable;
        }
    }

    private String httpErrorMessage(HttpRequest request, Exception e) throws URIException, IOException {
        return this.httpErrorMessage(NLS_HTTP_ERROR, request, e);
    }

    private String httpErrorMessage(String messageKey, HttpRequest request, Exception e) throws URIException, IOException {
        String msg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
        java.net.URI u = this.getURI(request);
        String s = NLS.bind((String)Messages.getServerString(messageKey), (Object)msg, (Object[])new Object[]{u.toString()});
        return s;
    }

    private java.net.URI getURI(HttpRequest request) throws IOException {
        _tracer.enter("getURI", new Object[0]);
        try {
            java.net.URI u;
            HostConfiguration hostConfiguration = request.hostConfig;
            if (hostConfiguration == null) {
                hostConfiguration = request.method.getHostConfiguration();
            }
            if (!hostConfiguration.isHostSet()) {
                hostConfiguration = this.httpClient.getHostConfiguration();
            }
            String protocol = hostConfiguration.getProtocol().getScheme();
            String host = hostConfiguration.getHost();
            int port = hostConfiguration.getPort();
            URI reqURI = request.method.getURI();
            try {
                u = new java.net.URI(protocol, null, host, port, reqURI.getPath(), reqURI.getQuery(), reqURI.getFragment());
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            _tracer.trace("getURI = %s", new Object[]{u.toString()});
            java.net.URI uRI = u;
            return uRI;
        }
        finally {
            _tracer.leave("getURI", new Object[0]);
        }
    }

    private String getAppropriateRequestURL(HttpRequest request) throws IOException {
        _tracer.enter("getProxyURL", new Object[0]);
        try {
            Header[] responseHeaders;
            java.net.URI u = this.getURI(request);
            if (!this.isProxyUri(u)) {
                String s = u.toString();
                _tracer.trace("getProxyURL = %s", new Object[]{s});
                String string = s;
                return string;
            }
            if (request.method.getStatusCode() == 401 && ((responseHeaders = request.method.getResponseHeaders(FROM_WEBUI_PROXY_HEADER)) == null || responseHeaders.length == 0)) {
                String s = u.toString();
                _tracer.trace("getProxyURL = %s", new Object[]{s});
                String string = s;
                return string;
            }
            Map parms = UriUtil.parseQueryParameters((String)u.getQuery());
            String[] uriParm = (String[])parms.get(PROXY_URI_PARM);
            if (uriParm == null || uriParm.length == 0) {
                String s = u.toString();
                ClientHttpUtil.error("Unexpected missing %s parameter from proxy URI \"%s\"", PROXY_URI_PARM, s);
                String string = s;
                return string;
            }
            String s = uriParm[0];
            _tracer.trace("getProxyURL = %s", new Object[]{s});
            String string = s;
            return string;
        }
        finally {
            _tracer.leave("getProxyURL", new Object[0]);
        }
    }

    private String buildProxyUri() {
        _tracer.enter("buildProxyUri", new Object[0]);
        try {
            String repoUri = this.server.getRepositoryURL();
            String proxyUri = String.valueOf(repoUri) + PROXY_CONTEXT_SEGMENT;
            _tracer.trace("buildProxyUri - %s", new Object[]{proxyUri});
            String string = proxyUri;
            return string;
        }
        finally {
            _tracer.leave("buildProxyUri", new Object[0]);
        }
    }

    private boolean isProxyUri(java.net.URI requestUri) {
        _tracer.enter("isProxyUri", new Object[0]);
        try {
            java.net.URI proxyUri = null;
            try {
                proxyUri = new java.net.URI(this.buildProxyUri());
            }
            catch (URISyntaxException e) {
                ClientHttpUtil.error("Error resolving proxy URI: %s", e.getMessage());
                _tracer.leave("isProxyUri", new Object[0]);
                return false;
            }
            if (!HostUtil.authorityEquiv((java.net.URI)requestUri, (java.net.URI)proxyUri)) {
                _tracer.trace("isProxyUri - false", new Object[0]);
                return false;
            }
            if (UriUtil.startsWithPath((java.net.URI)proxyUri, (java.net.URI)requestUri)) {
                _tracer.trace("isProxyUri - true", new Object[0]);
                return true;
            }
            _tracer.trace("isProxyUri - false", new Object[0]);
            return false;
        }
        finally {
            _tracer.leave("isProxyUri", new Object[0]);
        }
    }

    private void appendNestedException(TeamServiceException exception, HttpMethod method) {
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        try {
            Throwable throwable;
            Fault fault;
            Envelope envelope = ClientHttpUtil.demarshallEnvelope(webServicesMarshaller, method);
            Body body = envelope.getBody();
            if (body != null && (fault = body.getFault()) != null && (throwable = this.constructExceptionFromFault(fault)) != null) {
                exception.initCause(throwable);
                exception.setFromServer(true);
            }
        }
        catch (Throwable throwable) {}
    }

    private Throwable constructExceptionFromFault(Fault fault) {
        Throwable result = MarshallerUtil.decodeFault((Fault)fault, (ClassLoader)this.service.getServiceClassLoader());
        return result;
    }

    private static Envelope demarshallEnvelope(WebServicesMarshaller webServicesMarshaller, HttpMethod postMethod) throws IOException, MarshallingException {
        Header[] headers = postMethod.getResponseHeaders("Content-Encoding");
        if (headers == null) {
            headers = new Header[]{};
        }
        boolean gzipped = false;
        int i = 0;
        while (i < headers.length) {
            if (headers[i].getValue().equalsIgnoreCase("gzip")) {
                gzipped = true;
            }
            ++i;
        }
        InputStream responseStream = postMethod.getResponseBodyAsStream();
        if (gzipped) {
            responseStream = new GZIPInputStream(responseStream, 8192);
        }
        return (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
    }

    protected static void error(String message, Object ... args) {
        if (message == null) {
            return;
        }
        if (logger.isErrorEnabled()) {
            logger.error((Object)String.format(message, args));
        }
    }

    public static void addUseridHeader(String userId, HttpMethod method) {
        if (userId == null) {
            return;
        }
        try {
            userId = URLEncoder.encode(userId, HttpUtil.CharsetEncoding.UTF8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        method.addRequestHeader("X-com-ibm-team-userid", userId);
    }

    private static boolean clientUnderTest() {
        String property = System.getProperty(PROP_SYSTEM_TEST, "false");
        return Boolean.parseBoolean(property);
    }

    private static int tokenExpirationForTest() {
        if (ClientHttpUtil.clientUnderTest()) {
            String property = System.getProperty(PROP_TEST_TOKEN_EXPIRATION, "-1");
            return Integer.parseInt(property);
        }
        return -1;
    }

    private static void unsetTokenExpirationForTest() {
        System.clearProperty(PROP_TEST_TOKEN_EXPIRATION);
    }

    private static int getExecuteWaitTimeForTest() {
        if (ClientHttpUtil.clientUnderTest()) {
            String property = System.getProperty(PROP_TEST_EXECUTE_WAIT_TIME, "-1");
            return Integer.parseInt(property);
        }
        return -1;
    }

    private static void unsetExecuteWaitTimeForTest() {
        System.clearProperty(PROP_TEST_EXECUTE_WAIT_TIME);
    }

    private static boolean allowJAuthFailureRetries() {
        if (ClientHttpUtil.clientUnderTest()) {
            String property = System.getProperty(PROP_TEST_ALLOW_JAUTH_FAILURE_RETRIES, "true");
            return Boolean.parseBoolean(property);
        }
        return true;
    }

    private static void addComponentConfigurationHeaders(HttpMethod method) {
        _tracer.enter("addComponentConfigurations", new Object[0]);
        try {
            if (method == null) {
                _tracer.trace("addComponentConfigurations - null method argument", new Object[0]);
                return;
            }
            Header requestHeader = method.getRequestHeader("X-com-ibm-team-configuration-versions");
            if (requestHeader != null) {
                _tracer.trace("addComponentConfigurations - component configuration header present", new Object[0]);
                return;
            }
            List componentConfigurations = ComponentConfigurationRegistry.INSTANCE.getComponentConfigurations();
            if (componentConfigurations == null) {
                _tracer.trace("addComponentConfigurations - null component configuration", new Object[0]);
                return;
            }
            String headerValue = ComponentConfigurationRegistry.formatConfigurationsForHttpHeader((List)componentConfigurations);
            method.setRequestHeader("X-com-ibm-team-configuration-versions", headerValue);
            _tracer.trace("addComponentConfigurations - component configuration header added", new Object[0]);
        }
        finally {
            _tracer.leave("addComponentConfigurations", new Object[0]);
        }
    }

    static /* synthetic */ PathAndHostConfig access$7(ClientHttpUtil clientHttpUtil, String string, HttpRequest httpRequest) throws TeamServiceException, IOException {
        return clientHttpUtil.buildPathAndHostConfig(string, httpRequest);
    }

    static /* synthetic */ PostMethod access$8(ClientHttpUtil clientHttpUtil, String string) {
        return clientHttpUtil.createPostMethod(string);
    }

    static /* synthetic */ String access$10(HttpState httpState, java.net.URI uRI, String string) {
        return ClientHttpUtil.migrateCredentials(httpState, uRI, string);
    }

    static /* synthetic */ int access$11(ClientHttpUtil clientHttpUtil, HttpRequest httpRequest, boolean bl, boolean bl2) throws TeamServiceException, IOException {
        return clientHttpUtil.executeHttpMethod(httpRequest, bl, bl2);
    }

    static /* synthetic */ void access$12(ClientHttpUtil clientHttpUtil, HostConfiguration hostConfiguration, String string, HttpState httpState, String string2, int n) {
        clientHttpUtil.storeJAuthToken(hostConfiguration, string, httpState, string2, n);
    }

    static /* synthetic */ void access$13(ClientHttpUtil clientHttpUtil, boolean bl) {
        clientHttpUtil.serverHandlesJAuth = bl;
    }

    static interface AuthChallengeHandler {
        public boolean handleChallenge() throws TeamServiceException, IOException;

        public HttpRequest getRequest();
    }

    class BasicAuthChallengeHandler
    implements AuthChallengeHandler {
        private final HttpRequest request;

        public BasicAuthChallengeHandler(HttpRequest request) {
            this.request = request;
        }

        @Override
        public HttpRequest getRequest() {
            return this.request;
        }

        @Override
        public boolean handleChallenge() throws TeamServiceException, IOException {
            try {
                Header location;
                Header authHeader;
                AuthScope challengeScope;
                UsernamePasswordCredentials storedCredentials;
                _tracer.enter("BasicAuthChallengeHandler#handleChallenge", new Object[0]);
                if (this.request == null) {
                    _tracer.trace("BasicAuthChallengeHandler - request == null", new Object[0]);
                    return true;
                }
                HostConfiguration hostConfig = this.request.hostConfig;
                if (hostConfig == null) {
                    _tracer.debug("Request HostConfiguration not available - using httpClient HostConfiguration", new Object[0]);
                    hostConfig = ClientHttpUtil.this.httpClient.getHostConfiguration();
                }
                if (!TransportAuthUtil.credDefined((UsernamePasswordCredentials)(storedCredentials = (UsernamePasswordCredentials)this.request.state.getCredentials(challengeScope = new AuthScope(hostConfig.getHost(), hostConfig.getPort()))))) {
                    _tracer.trace("BasicAuthChallengeHandler#handleChallenge - throwing emptyCredsException", new Object[0]);
                    ClientHttpUtil.throwEmptyCredsException(storedCredentials);
                }
                if ((authHeader = this.request.method.getRequestHeader("Authorization")) != null) {
                    this.request.method.removeRequestHeader("Authorization");
                }
                boolean authPreempt = ClientHttpUtil.this.httpClient.getParams().getBooleanParameter("http.authentication.preemptive", false);
                ClientHttpUtil.this.httpClient.getParams().setAuthenticationPreemptive(true);
                ClientHttpUtil.this.httpClient.getParams().setCredentialCharset(this.getCredentialCharset());
                boolean autoAuth = this.request.method.getDoAuthentication();
                this.request.method.setDoAuthentication(true);
                this.request.method.setFollowRedirects(false);
                int statusCode = ClientHttpUtil.this.executePrimitiveRequest(this.request);
                boolean noPasswordAuthFailures = true;
                if (statusCode == 503) {
                    ServiceNotAvailableDuringAuthException ex = new ServiceNotAvailableDuringAuthException("Encountered SERVICE_UNAVAILABLE error during basic auth", statusCode);
                    _tracer.trace("BasicAuthChallengeHandler#handleChallenge - throwing AuthenticationException on 503", new Object[0]);
                    throw ex;
                }
                if (statusCode >= 400 && statusCode <= 599) {
                    _tracer.trace("BasicAuthChallengeHandler#handleChallenge - unexpected status code %d", new Object[]{statusCode});
                    return false;
                }
                if (statusCode == 302 && (location = this.request.method.getResponseHeader("Location")) != null && location.getValue().contains(ClientHttpUtil.AUTHENTICATED_IDENTITY_URI)) {
                    try {
                        _tracer.debug("Visiting authenticationURL", new Object[0]);
                        int authStatusCode = TransportAuthUtil.visitAuthenticatedURLWithStatus((String)ClientHttpUtil.this.server.getRepositoryPath(), (HttpClient)ClientHttpUtil.this.httpClient, (HttpState)this.request.state);
                        if (authStatusCode == 401) {
                            noPasswordAuthFailures = false;
                        }
                    }
                    catch (TransportAuthException e) {
                        _tracer.trace("BasicAuthChallengeHandler#handleChallenge - throwing TeamServiceException: %s", new Object[]{e.getMessage()});
                        throw new TeamServiceException(e.getMessage());
                    }
                }
                this.request.method.setDoAuthentication(autoAuth);
                ClientHttpUtil.this.httpClient.getParams().setAuthenticationPreemptive(authPreempt);
                boolean bl = noPasswordAuthFailures;
                return bl;
            }
            finally {
                _tracer.leave("BasicAuthChallengeHandler#handleChallenge", new Object[0]);
            }
        }

        private String getCredentialCharset() {
            return System.getProperty("com.ibm.team.repository.transport.client.basic.auth.credential.charset", "ISO-8859-1");
        }
    }

    class FormAuthChallengeHandler
    implements AuthChallengeHandler {
        private final HttpRequest request;

        public FormAuthChallengeHandler(HttpRequest request) {
            this.request = request;
        }

        @Override
        public HttpRequest getRequest() {
            return this.request;
        }

        @Override
        public boolean handleChallenge() throws TeamServiceException, IOException {
            _tracer.enter("FormAuthChallengeHandler#handleChallenge", new Object[0]);
            try {
                AuthScope challengeScope = new AuthScope(this.request.hostConfig.getHost(), this.request.hostConfig.getPort());
                UsernamePasswordCredentials storedCredentials = (UsernamePasswordCredentials)this.request.state.getCredentials(challengeScope);
                if (!TransportAuthUtil.credDefined((UsernamePasswordCredentials)storedCredentials)) {
                    ClientHttpUtil.throwEmptyCredsException(storedCredentials);
                }
                this.request.method.getHostAuthState().setAuthScheme(null);
                ClientHttpUtil.this.httpClient.getParams().setAuthenticationPreemptive(false);
                try {
                    String lastURL = this.request.method.getPath();
                    HttpMethod authenticateMethod = TransportAuthUtil.formBasedAuthenticate((String)lastURL, (HostConfiguration)this.request.hostConfig, (HttpClient)ClientHttpUtil.this.httpClient, (UsernamePasswordCredentials)storedCredentials, (HttpState)this.request.state);
                    HttpRequest lastRequest = ClientHttpUtil.this.followRedirects(new HttpRequest(this.request.hostConfig, authenticateMethod, this.request.state), false);
                    lastRequest.method.releaseConnection();
                    return true;
                }
                catch (TransportAuthException e) {
                    java.net.URI requestUri = ClientHttpUtil.this.getURI(this.request);
                    AuthenticationException ex = new AuthenticationException(e.getMessage(), e.getCause());
                    ex.setRequestUri(requestUri.toString());
                    ex.addHeaders(this.request.method.getResponseHeaders());
                    _tracer.trace("FormAuthChallengeHandler#handleChallenge#Throwing TransportAuthException", new Object[0]);
                    throw ex;
                }
            }
            finally {
                _tracer.leave("FormAuthChallengeHandler#handleChallenge", new Object[0]);
            }
        }
    }

    class HttpRequest {
        final HostConfiguration hostConfig;
        final HttpMethod method;
        final HttpState state;

        HttpRequest(HostConfiguration hostConfig, HttpMethod method, HttpState state) {
            this.hostConfig = hostConfig;
            this.method = method;
            this.state = state;
        }

        HttpMethod getMethod() {
            return this.method;
        }

        HttpRequest changeMethod(HttpMethod newMethod) {
            return new HttpRequest(this.hostConfig, newMethod, this.state);
        }

        HttpRequest changeHostConfig(HostConfiguration hostConfig) {
            return new HttpRequest(hostConfig, this.method, this.state);
        }

        HttpRequest changeState(HttpState state) {
            return new HttpRequest(this.hostConfig, this.method, state);
        }
    }

    class JAuthChallengeHandler
    implements AuthChallengeHandler {
        private final HttpRequest request;

        public JAuthChallengeHandler(HttpRequest request) {
            this.request = request;
        }

        @Override
        public HttpRequest getRequest() {
            return this.request;
        }

        private String getTokenURL() throws TeamServiceException {
            int expiration;
            Header authenticateHeader = this.request.method.getResponseHeader("WWW-Authenticate");
            String authenticateHeaderValue = authenticateHeader.getValue();
            Pattern p = Pattern.compile("token_uri\\s*=\\s*\"([^\"]+)\"");
            Matcher matcher = p.matcher(authenticateHeaderValue);
            if (!matcher.find()) {
                throw new TeamServiceException(NLS.bind((String)"A JAuth authorization header was found but it didn't include a token_uri.  The full header value was \"{0}\".", (Object)authenticateHeaderValue, (Object[])new Object[0]));
            }
            String tokenURIString = matcher.group(1);
            if (ClientHttpUtil.clientUnderTest() && (expiration = ClientHttpUtil.tokenExpirationForTest()) != -1) {
                tokenURIString = String.format("%s?expiration=%d", tokenURIString, expiration);
            }
            return tokenURIString;
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean handleChallenge() throws TeamServiceException, IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class PathAndHostConfig {
        private final String path;
        private final HostConfiguration config;

        PathAndHostConfig(String path, HostConfiguration config) {
            this.path = path;
            this.config = config;
        }
    }

    private static class ServiceNotAvailableDuringAuthException
    extends ServiceNotAvailableException {
        public ServiceNotAvailableDuringAuthException(String message, int statusCode) {
            super(message, statusCode);
        }
    }
}

