/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileStorageInputStreamProvider
implements IInputStreamProvider {
    private IFileStorage fileStorage;
    private IFileOptions options;

    private FileStorageInputStreamProvider(IFileOptions options, IFileStorage fileStorage) {
        this.options = options;
        this.fileStorage = fileStorage;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fileStorage == null ? 0 : this.fileStorage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileStorageInputStreamProvider other = (FileStorageInputStreamProvider)obj;
        return !(this.fileStorage == null ? other.fileStorage != null : !this.fileStorage.equals(other.fileStorage));
    }

    public static FileStorageInputStreamProvider create(IFileOptions options, IFileStorage fileStorage) {
        return new FileStorageInputStreamProvider(options, fileStorage);
    }

    public static FileStorageInputStreamProvider createLink(IFileStorage fileStorage) {
        return new FileStorageInputStreamProvider(null, fileStorage);
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            if (this.fileStorage.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.SYMBOLIC_LINK) {
                String targetString = this.fileStorage.getLinkInfo((IProgressMonitor)progress.newChild(1)).getTarget();
                return new ByteArrayInputStream(targetString.getBytes(Charset.defaultCharset().name()));
            }
            return this.fileStorage.getContents(this.options);
        }
        catch (FileSystemException e) {
            IOException e2 = new IOException();
            e2.initCause((Throwable)((Object)e));
            throw e2;
        }
    }
}

