/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.ChangedInfosValue;
import com.ibm.team.filesystem.client.internal.copyfileareas.ForwardInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.InverseInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.ItemComponentConnection;
import com.ibm.team.filesystem.client.internal.copyfileareas.LoadedComponent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ValidationItemHandle;
import com.ibm.team.filesystem.client.internal.copyfileareas.WCChangedInfoKey;
import com.ibm.team.filesystem.client.internal.core.SharingMetadata2;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GlobalMetadataValidator {
    protected boolean isCaseSensitive;
    protected File lcf;
    protected PersistentDiskBackedHashMap<LoadedComponent, Object> loadedComponents;
    protected File sif;
    protected PersistentDiskBackedHashMap<String, SharingInfoWrapper> sharingInfo;
    protected File isif;
    protected PersistentDiskBackedHashMap<ItemComponentConnection, String> inverseSharingInfo;
    protected File cif;
    protected PersistentDiskBackedHashMap<WCChangedInfoKey, ChangedInfosValue> changedItems;
    protected File fif;
    protected PersistentDiskBackedHashMap<String, ForwardInfoWrapper> forwardInfo;
    protected File ifif;
    protected PersistentDiskBackedHashMap<ItemComponentConnection, String> inverseForwardInfo;
    protected File iif;
    protected PersistentDiskBackedHashMap<ItemComponentConnection, InverseInfo> inverseInfo;
    protected File vif;
    protected PersistentDiskBackedHashMap<ItemComponentConnection, String> visitedItems;
    protected boolean descriptorsComplete;
    protected String descriptorsFN;
    protected boolean inverseDescriptorsComplete;
    protected String inverseDescriptorsFN;
    protected boolean inverseItemInfosComplete;
    protected String inverseItemInfosFN;
    protected boolean loadedComponentsComplete;
    protected String loadedComponentsFN;
    protected boolean metadataComplete;
    protected boolean metametaComplete;
    protected String metadataFN;
    protected String metametaFN;
    protected boolean persistentMetadataComplete;
    protected String persistentMetadataFN;
    protected boolean metadataCorrupt;
    protected String metadataCorruptFN;
    private Date lastSandboxListenerEvent;

    public void beginValidation(boolean isCaseSensitive) throws IOException {
        this.isCaseSensitive = isCaseSensitive;
        this.descriptorsComplete = false;
        this.inverseDescriptorsComplete = false;
        this.inverseItemInfosComplete = false;
        this.loadedComponentsComplete = false;
        this.metadataComplete = false;
        this.metametaComplete = false;
        this.persistentMetadataComplete = false;
        this.metadataCorrupt = false;
        if (isCaseSensitive) {
            this.descriptorsFN = ".descriptors.isComplete";
            this.inverseDescriptorsFN = ".inverseDescriptors.isComplete";
            this.inverseItemInfosFN = ".inverseItemInfos.isComplete";
            this.loadedComponentsFN = ".loadedComponents.isComplete";
            this.metadataFN = ".metadata.isComplete";
            this.metametaFN = ".metameta.isComplete";
            this.persistentMetadataFN = ".persistentMetadata.isComplete";
            this.metadataCorruptFN = ".isCorrupt";
        } else {
            this.descriptorsFN = ".descriptors.iscomplete";
            this.inverseDescriptorsFN = ".inversedescriptors.iscomplete";
            this.inverseItemInfosFN = ".inverseiteminfos.iscomplete";
            this.loadedComponentsFN = ".loadedcomponents.iscomplete";
            this.metadataFN = ".metadata.iscomplete";
            this.metametaFN = ".metameta.iscomplete";
            this.persistentMetadataFN = ".persistentmetadata.iscomplete";
            this.metadataCorruptFN = ".iscorrupt";
        }
        this.lcf = File.createTempFile("loadedcomponents", null);
        this.loadedComponents = new PersistentDiskBackedHashMap<LoadedComponent, Object>(this.lcf){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.sif = File.createTempFile("sharinginfo", null);
        this.sharingInfo = new PersistentDiskBackedHashMap<String, SharingInfoWrapper>(this.sif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.isif = File.createTempFile("inversesharinginfo", null);
        this.inverseSharingInfo = new PersistentDiskBackedHashMap<ItemComponentConnection, String>(this.isif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.cif = File.createTempFile("changeditems", null);
        this.changedItems = new PersistentDiskBackedHashMap<WCChangedInfoKey, ChangedInfosValue>(this.cif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.fif = File.createTempFile("forwardinfo", null);
        this.forwardInfo = new PersistentDiskBackedHashMap<String, ForwardInfoWrapper>(this.fif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.iif = File.createTempFile("inverseinfo", null);
        this.inverseInfo = new PersistentDiskBackedHashMap<ItemComponentConnection, InverseInfo>(this.iif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
    }

    public boolean addFlag(String fn) {
        if (!this.isCaseSensitive) {
            fn = fn.toUpperCase().toLowerCase();
        }
        if (this.descriptorsFN.equals(fn)) {
            this.descriptorsComplete = true;
            return true;
        }
        if (this.inverseDescriptorsFN.equals(fn)) {
            this.inverseDescriptorsComplete = true;
            return true;
        }
        if (this.inverseItemInfosFN.equals(fn)) {
            this.inverseItemInfosComplete = true;
            return true;
        }
        if (this.loadedComponentsFN.equals(fn)) {
            this.loadedComponentsComplete = true;
            return true;
        }
        if (this.metadataFN.equals(fn)) {
            this.metadataComplete = true;
            return true;
        }
        if (this.metametaFN.equals(fn)) {
            this.metametaComplete = true;
            return true;
        }
        if (this.persistentMetadataFN.equals(fn)) {
            this.persistentMetadataComplete = true;
            return true;
        }
        if (this.metadataCorruptFN.equals(fn)) {
            this.metadataCorrupt = true;
            return true;
        }
        return false;
    }

    public void addLoadedComponent(LoadedComponent lc) throws IOException {
        this.loadedComponents.put((Object)lc, null);
    }

    public void addSharingDescriptor(IPath path, ISharingDescriptor desc, StringBuilder log) throws IOException {
        SharingInfoWrapper oldInfo;
        String storedPath;
        String sPath;
        String normal = sPath = path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator().toString();
        if (!this.isCaseSensitive) {
            normal = sPath.toUpperCase().toLowerCase();
        }
        if (!normal.equalsIgnoreCase(storedPath = path.toString())) {
            log.append("Path " + normal + " does not equal stored path " + storedPath + " for share " + this.getStringFor(desc) + "\n");
        }
        if ((oldInfo = (SharingInfoWrapper)this.sharingInfo.put((Object)normal, (Object)new SharingInfoWrapper(sPath, desc))) != null) {
            log.append("Conflicting shares from path " + normal + "(" + this.getStringFor(oldInfo.desc) + " and " + this.getStringFor(desc) + "\n");
        }
    }

    public void addInverseSharingDescriptor(IPath path, SharingMetadata2.ShareRoot share, StringBuilder log) {
        ItemComponentConnection icc;
        String oldPath;
        String storedPath;
        String sPath;
        String normal = sPath = path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator().toString();
        if (!this.isCaseSensitive) {
            normal = sPath.toUpperCase().toLowerCase();
        }
        if (!normal.equalsIgnoreCase(storedPath = path.toString())) {
            log.append("Path " + normal + " does not equal stored path " + storedPath + " for inverse share " + this.getStringFor(share) + "\n");
        }
        if ((oldPath = (String)this.inverseSharingInfo.put((Object)(icc = new ItemComponentConnection(share)), (Object)normal)) != null) {
            log.append("Conflicting shares found for share root " + this.getStringFor(share) + " at path " + oldPath + "\n");
        }
    }

    public void addModifiedInfo(WCChangedInfoKey key, ChangedInfosValue value) throws IOException {
        this.changedItems.put((Object)key, (Object)value);
    }

    public void addForwardInfo(IPath path, ForwardInfo info) throws IOException {
        String sPath;
        String normal = sPath = path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator().toString();
        if (!this.isCaseSensitive) {
            normal = sPath.toUpperCase().toLowerCase();
        }
        this.forwardInfo.put((Object)normal, (Object)new ForwardInfoWrapper(sPath, info));
    }

    public void addInverseInfo(ItemComponentConnection key, InverseInfo info) throws IOException {
        this.inverseInfo.put((Object)key, (Object)info);
    }

    public void addLastSandboxListenerEvent(Date d) {
        this.lastSandboxListenerEvent = d;
    }

    public Date getLastSandboxListenerEvent() {
        return this.lastSandboxListenerEvent;
    }

    public void endValidation(StringBuilder log) throws IOException {
        this.validateFlags(log);
        this.checkInverseSharingInfoMap(log);
        this.checkLoadedComponentSharingDescConsistency(log);
        this.checkSharingDescRootFolderConsistency(log);
        this.buildInverseForwardInfoMap(log);
        this.checkInverseForwardMapAgreement(log);
        this.checkParentChildAgreement(log);
        this.checkRemoteTreeConsistency(log);
        this.checkChangesInverseMapAgreement(log);
    }

    protected void validateFlags(StringBuilder log) {
        if (!this.descriptorsComplete) {
            log.append("The sharing descriptors map is not marked as complete\n");
        }
        if (!this.inverseDescriptorsComplete) {
            log.append("The inverse sharing descriptors map is not marked as complete\n");
        }
        if (!this.inverseItemInfosComplete) {
            log.append("The inverse item infos map is not marked as complete\n");
        }
        if (!this.loadedComponentsComplete) {
            log.append("The loaded descriptors map is not marked as complete\n");
        }
        if (!this.metadataComplete) {
            log.append("The forward item infos map is not marked as complete\n");
        }
        if (!this.metametaComplete) {
            log.append("The meta meta data is not marked as complete\n");
        }
        if (!this.persistentMetadataComplete) {
            log.append("The changed items map is not marked as complete\n");
        }
        if (this.metadataCorrupt) {
            log.append("The metadata is marked as corrupt\n");
        }
    }

    protected void checkInverseSharingInfoMap(StringBuilder log) throws IOException {
        for (Map.Entry e : this.sharingInfo.entrySet()) {
            String path = (String)e.getKey();
            SharingInfoWrapper wrap = (SharingInfoWrapper)e.getValue();
            ISharingDescriptor desc = wrap.desc;
            String inversePath = (String)this.inverseSharingInfo.get((Object)new ItemComponentConnection(desc));
            if (inversePath == null) {
                log.append("There is no inverse sharing descriptor at path " + path + " for " + this.getStringFor(desc) + "\n");
                continue;
            }
            if (inversePath.equals(path)) continue;
            log.append("The inverse path for " + this.getStringFor(desc) + " is " + inversePath + "instead of the forward path " + path + "\n");
        }
        HashSet<String> allPaths = new HashSet<String>();
        for (Map.Entry entry : this.inverseSharingInfo.entrySet()) {
            ItemComponentConnection info = (ItemComponentConnection)entry.getKey();
            String inversePath = (String)entry.getValue();
            allPaths.contains(inversePath);
            allPaths.add(inversePath);
            SharingInfoWrapper sharingInfoWrapper = (SharingInfoWrapper)this.sharingInfo.get((Object)inversePath);
            ISharingDescriptor desc = sharingInfoWrapper.desc;
            if (this.matches(desc, info)) continue;
            log.append("The descriptor for path " + inversePath + " does not match the inverse descriptor: " + "Forward: " + this.getStringFor(desc) + "Inverse: " + this.getStringFor(info) + "\n");
        }
    }

    private boolean matches(ISharingDescriptor desc, ItemComponentConnection info) {
        if (!desc.getRootVersionable().getItemId().getUuidValue().equals(info.getItemId())) {
            return false;
        }
        if (!desc.getComponent().getItemId().getUuidValue().equals(info.getComponentId())) {
            return false;
        }
        return desc.getConnectionHandle().getItemId().getUuidValue().equals(info.getConnectionId());
    }

    private String getStringFor(ISharingDescriptor desc) {
        return "item " + this.getStringFor(desc.getRootVersionable()) + " in " + desc.getConnectionName() + "(" + desc.getConnectionHandle().getItemId().getUuidValue() + ")" + "/" + desc.getComponentName() + "(" + desc.getComponent().getItemId().getUuidValue() + ")";
    }

    private String getStringFor(SharingMetadata2.ShareRoot info) {
        return "inverse info for item " + this.getStringFor(info.getRootVersionable()) + " in " + info.getConnectionComponent().getConnection().getItemId().getUuidValue() + "/" + info.getConnectionComponent().getComponent().getItemId().getUuidValue();
    }

    private String getStringFor(IVersionableHandle item) {
        return String.valueOf(item.getItemType().getName()) + ":" + item.getItemId().getUuidValue();
    }

    private String getStringFor(ItemComponentConnection info) {
        return "inverse info for item " + info.getItemId() + " in " + info.getConnectionId() + "/" + info.getComponentId();
    }

    protected void checkLoadedComponentSharingDescConsistency(StringBuilder log) throws IOException {
        for (SharingInfoWrapper w : this.sharingInfo.values()) {
            ISharingDescriptor desc = w.desc;
            LoadedComponent lc = new LoadedComponent();
            lc.setComponentId(desc.getComponent().getItemId().getUuidValue());
            lc.setConnectionId(desc.getConnectionHandle().getItemId().getUuidValue());
            lc.setConnectionType(desc.getConnectionHandle().getItemType().getName());
            lc.setConnectionTypeNS(desc.getConnectionHandle().getItemType().getNamespaceURI());
            if (this.loadedComponents.containsKey((Object)lc)) continue;
            log.append("The component " + lc.getComponentId() + " (" + desc.getComponentName() + ") of " + lc.getConnectionTypeNS() + "#" + lc.getConnectionType() + " " + lc.getConnectionId() + " (" + desc.getConnectionName() + ") is shared at \"" + w.path + "\" but is not marked as loaded\n");
        }
    }

    protected void checkSharingDescRootFolderConsistency(StringBuilder log) throws IOException {
        for (Map.Entry e : this.sharingInfo.entrySet()) {
            String path = (String)e.getKey();
            SharingInfoWrapper siw = (SharingInfoWrapper)e.getValue();
            ISharingDescriptor desc = siw.desc;
            ForwardInfoWrapper fiw = (ForwardInfoWrapper)this.forwardInfo.get((Object)path);
            if (fiw == null) continue;
            if (!desc.getRootVersionable().getItemId().getUuidValue().equals(fiw.info.getItemId())) {
                log.append("The folder " + desc.getRootVersionable().getItemId().getUuidValue() + " of component " + desc.getComponent().getItemId().getUuidValue() + " (" + desc.getComponentName() + ") of " + desc.getConnectionHandle().getItemType().getNamespaceURI() + "#" + desc.getConnectionHandle().getItemType().getName() + " " + desc.getConnectionHandle().getItemId().getUuidValue() + " (" + desc.getConnectionName() + ") is shared at \"" + siw.path + "\" but the forward map contains a " + fiw.info.getTypeString() + " " + fiw.info.getItemId() + " at that location\n");
                continue;
            }
            if (fiw.info.getStateId() != null) continue;
            log.append("The share root " + desc.getRootVersionable().getItemId().getUuidValue() + " of component " + desc.getComponent().getItemId().getUuidValue() + " (" + desc.getComponentName() + ") of " + desc.getConnectionHandle().getItemType().getNamespaceURI() + "#" + desc.getConnectionHandle().getItemType().getName() + " " + desc.getConnectionHandle().getItemId().getUuidValue() + " (" + desc.getConnectionName() + ") is shared at \"" + siw.path + "\" but the forward map does not have a state id for it\n");
        }
    }

    protected void buildInverseForwardInfoMap(StringBuilder log) throws IOException {
        this.ifif = File.createTempFile("inverseforwardinfo", null);
        this.inverseForwardInfo = new PersistentDiskBackedHashMap<ItemComponentConnection, String>((long)(this.forwardInfo.size() * 4 / 3), this.ifif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        for (Map.Entry e : this.forwardInfo.entrySet()) {
            String normalPath = (String)e.getKey();
            SharingInfoWrapper siw = this.getSharingInfo(normalPath);
            ForwardInfoWrapper fiw = (ForwardInfoWrapper)e.getValue();
            if (siw == null) {
                log.append("Failed to find sharing descriptor for " + fiw.info.getTypeString() + " " + fiw.info.getItemId() + " at \"" + fiw.path + "\"\n");
                continue;
            }
            ItemComponentConnection icc = new ItemComponentConnection();
            icc.setComponentId(siw.desc.getComponent().getItemId().getUuidValue());
            icc.setConnectionId(siw.desc.getConnectionHandle().getItemId().getUuidValue());
            icc.setConnectionType(siw.desc.getConnectionHandle().getItemType().getName());
            icc.setConnectionTypeNS(siw.desc.getConnectionHandle().getItemType().getNamespaceURI());
            icc.setItemId(fiw.info.getItemId());
            String oldPath = (String)this.inverseForwardInfo.put((Object)icc, (Object)normalPath);
            if (oldPath != null) {
                ForwardInfoWrapper oldFiw = (ForwardInfoWrapper)this.forwardInfo.get((Object)oldPath);
                log.append("The " + fiw.info.getTypeString() + " " + fiw.info.getItemId() + " of component " + siw.desc.getComponent().getItemId().getUuidValue() + " (" + siw.desc.getComponentName() + ") of " + siw.desc.getConnectionHandle().getItemType().getNamespaceURI() + "#" + siw.desc.getConnectionHandle().getItemType().getName() + " " + siw.desc.getConnectionHandle().getItemId().getUuidValue() + " (" + siw.desc.getConnectionName() + ") is shared at \"" + siw.path + "\" but conflicts with " + oldFiw.info.getTypeString() + " shared at \"" + oldFiw.path + "\"\n");
            }
            if (this.inverseInfo.containsKey((Object)icc)) continue;
            log.append("The " + fiw.info.getTypeString() + " " + fiw.info.getItemId() + " of component " + siw.desc.getComponent().getItemId().getUuidValue() + " (" + siw.desc.getComponentName() + ") of " + siw.desc.getConnectionHandle().getItemType().getNamespaceURI() + "#" + siw.desc.getConnectionHandle().getItemType().getName() + " " + siw.desc.getConnectionHandle().getItemId().getUuidValue() + " (" + siw.desc.getConnectionName() + ") is shared at \"" + siw.path + "\" but has no inverse info\n");
        }
    }

    protected void checkInverseForwardMapAgreement(StringBuilder log) throws IOException {
        for (Map.Entry e : this.inverseInfo.entrySet()) {
            ForwardInfoWrapper fiw;
            String path;
            boolean isShareRoot;
            ItemComponentConnection icc = (ItemComponentConnection)e.getKey();
            InverseInfo ii = (InverseInfo)e.getValue();
            try {
                isShareRoot = this.inverseSharingInfo.containsKey((Object)icc);
                path = (String)this.inverseForwardInfo.get((Object)icc);
                fiw = null;
                if (path != null) {
                    fiw = (ForwardInfoWrapper)this.forwardInfo.get((Object)path);
                }
            }
            catch (Exception ex) {
                log.append("Exception checking map agreement.\n");
                log.append(ex);
                return;
            }
            if (isShareRoot) {
                if (ii.getStateId() == null) {
                    log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" is a share root but does not have a state id\n");
                }
            } else if (ii.getStateId() != null && ii.getRemoteParentId() == null) {
                log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" is not a share root, has a state id but no remote parent\n");
            }
            if (isShareRoot || ii.getLocalParentId() != null) {
                if (fiw == null) continue;
                this.compareInfos(fiw, path, ii, icc, log);
                continue;
            }
            if (fiw != null) {
                log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" does not have a local parent, but appears in the forward map at \"" + fiw.path + "\"\n");
            }
            if (ii.getRemoteParentId() != null) continue;
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" does not have a remote or local parent and is not a share root\n");
        }
    }

    protected void compareInfos(ForwardInfoWrapper fiw, String normalizedPath, InverseInfo ii, ItemComponentConnection icc, StringBuilder log) throws IOException {
        Path path;
        boolean isShareRoot;
        if (fiw.info.getType() != ii.getType()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" is marked as " + fiw.info.getTypeString() + " in the forward map\n");
        }
        if (fiw.info.getStateId() == null && ii.getStateId() != null || fiw.info.getStateId() != null && !fiw.info.getStateId().equals(ii.getStateId())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has state id " + ii.getStateId() + " in the inverse map but state id " + fiw.info.getStateId() + " in the forward map\n");
        }
        if (fiw.info.getLastContentChangeCheckStamp() != ii.getLastContentChangeCheckStamp()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has check stamp " + ii.getLastContentChangeCheckStamp() + " in the inverse map but check stamp " + fiw.info.getLastContentChangeCheckStamp() + " in the forward map\n");
        }
        if (fiw.info.getRemoteParentId() == null && ii.getRemoteParentId() != null || fiw.info.getRemoteParentId() != null && !fiw.info.getRemoteParentId().equals(ii.getRemoteParentId())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote parent id " + ii.getRemoteParentId() + " in the inverse map but remote parent id " + fiw.info.getRemoteParentId() + " in the forward map\n");
        }
        if (fiw.info.getRemoteName() == null && ii.getRemoteName() != null || fiw.info.getRemoteName() != null && !fiw.info.getRemoteName().equals(ii.getRemoteName())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote name \"" + ii.getRemoteName() + "\" in the inverse map but remote name \"" + fiw.info.getRemoteName() + "\" in the forward map\n");
        }
        if (fiw.info.getLocalSize() != ii.getLocalSize()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local size " + ii.getLocalSize() + " in the inverse map but local size " + fiw.info.getLocalSize() + " in the forward map\n");
        }
        if (fiw.info.getHash() == null && ii.getHash() != null || fiw.info.getHash() != null && !fiw.info.getHash().equals((Object)ii.getHash())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local hash " + (ii.getHash() == null ? "null" : ii.getHash().toString()) + " in the inverse map but local hash " + (fiw.info.getHash() == null ? "null" : fiw.info.getHash().toString()) + " in the forward map\n");
        }
        if (fiw.info.getLocalLineDelimiter() != ii.getLocalLineDelimiter()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local line delimiter " + ii.getLocalLineDelimiter() + " in the inverse map but local line delimiter " + fiw.info.getLocalLineDelimiter() + " in the forward map\n");
        }
        if (fiw.info.getRemoteLineDelimiter() != ii.getRemoteLineDelimiter()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote line delimiter " + ii.getRemoteLineDelimiter() + " in the inverse map but remote line delimiter " + fiw.info.getRemoteLineDelimiter() + " in the forward map\n");
        }
        if (fiw.info.getLocalContentType() == null && ii.getLocalContentType() != null || fiw.info.getLocalContentType() != null && !fiw.info.getLocalContentType().equals(ii.getLocalContentType())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local content type \"" + ii.getLocalContentType() + "\" in the inverse map but local content type \"" + fiw.info.getLocalContentType() + "\" in the forward map\n");
        }
        if (fiw.info.getRemoteContentType() == null && ii.getRemoteContentType() != null || fiw.info.getRemoteContentType() != null && !fiw.info.getRemoteContentType().equals(ii.getRemoteContentType())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote content type \"" + ii.getRemoteContentType() + "\" in the inverse map but remote content type \"" + fiw.info.getRemoteContentType() + "\" in the forward map\n");
        }
        if (fiw.info.getPredecessorHintHash() == null && ii.getPredecessorHintHash() != null || fiw.info.getPredecessorHintHash() != null && !fiw.info.getPredecessorHintHash().equals((Object)ii.getPredecessorHintHash())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has predecessor " + ii.getPredecessorHintHash() + " in the inverse map but predecessor " + fiw.info.getPredecessorHintHash() + " in the forward map\n");
        }
        if (fiw.info.getRemoteSize() != ii.getRemoteSize()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote size " + ii.getRemoteSize() + " in the inverse map but remote size " + fiw.info.getRemoteSize() + " in the forward map\n");
        }
        if (fiw.info.getRemoteEncoding() == null && ii.getRemoteEncoding() != null || fiw.info.getRemoteEncoding() != null && !fiw.info.getRemoteEncoding().equals(ii.getRemoteEncoding())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote encoding \"" + ii.getRemoteEncoding() + "\" in the inverse map but remote encoding \"" + fiw.info.getRemoteEncoding() + "\" in the forward map\n");
        }
        if (fiw.info.getStoredHash() == null && ii.getStoredHash() != null || fiw.info.getStoredHash() != null && !fiw.info.getStoredHash().equals((Object)ii.getStoredHash())) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has stored " + ii.getStoredHash() + " in the inverse map but stored has " + fiw.info.getStoredHash() + " in the forward map\n");
        }
        if (fiw.info.getNumLineDelimiters() != ii.getNumLineDelimiters()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has " + ii.getNumLineDelimiters() + " line delimiters in the inverse map but " + fiw.info.getNumLineDelimiters() + " line delimiters in the forward map\n");
        }
        if (fiw.info.isRemoteExecutable() != ii.isRemoteExecutable()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" is marked as" + (ii.isRemoteExecutable() ? "" : " not") + " remotely executable in the inverse map but" + (fiw.info.isRemoteExecutable() ? "" : " not") + " remotely executable in the forward map\n");
        }
        if (fiw.info.isLocalExecutable() != ii.isLocalExecutable()) {
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" is marked as" + (ii.isLocalExecutable() ? "" : " not") + " locally executable in the inverse map but" + (fiw.info.isLocalExecutable() ? "" : " not") + " locally executable in the forward map\n");
        }
        if (!(isShareRoot = this.sharingInfo.containsKey((Object)normalizedPath)) && (path = new Path(null, normalizedPath)).segmentCount() >= 1) {
            String localName;
            String localParentId;
            ForwardInfoWrapper parent = (ForwardInfoWrapper)this.forwardInfo.get((Object)path.removeLastSegments(1).toString());
            if (parent != null) {
                localParentId = parent.info.getItemId();
                localName = new Path(null, fiw.path).lastSegment();
            } else {
                localParentId = null;
                localName = null;
            }
            if (localParentId == null && ii.getLocalParentId() != null || localParentId != null && !localParentId.equals(ii.getLocalParentId())) {
                log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local parent " + ii.getLocalParentId() + " in the inverse map but local parent " + localParentId + " in the forward map\n");
            }
            if (localName == null && ii.getLocalName() != null || localName != null && !localName.equals(ii.getLocalName())) {
                log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local name \"" + ii.getLocalName() + "\" in the inverse map but local name \"" + localName + "\" in the forward map\n");
            }
        }
    }

    protected void checkParentChildAgreement(StringBuilder log) throws IOException {
        ItemComponentConnection picc = new ItemComponentConnection();
        for (Map.Entry e : this.inverseInfo.entrySet()) {
            ItemComponentConnection icc = (ItemComponentConnection)e.getKey();
            InverseInfo ii = (InverseInfo)e.getValue();
            boolean isShareRoot = this.inverseSharingInfo.containsKey((Object)icc);
            if (!isShareRoot) {
                InverseInfo parent;
                if (ii.getRemoteParentId() != null) {
                    picc.setComponentId(icc.getComponentId());
                    picc.setConnectionId(icc.getConnectionId());
                    picc.setConnectionType(icc.getConnectionType());
                    picc.setConnectionTypeNS(icc.getConnectionTypeNS());
                    picc.setItemId(ii.getRemoteParentId());
                    parent = (InverseInfo)this.inverseInfo.get((Object)picc);
                    if (parent == null) {
                        log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the inverse map does not have such an item\n");
                    } else {
                        ValidationItemHandle child;
                        if (parent.getType() != 1) {
                            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the parent is marked as a file in the inverse map\n");
                        }
                        if ((child = parent.getRemoteChildren().get(ii.getRemoteName())) == null) {
                            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the parent doesn't contain such a remote child\n");
                        } else if (!child.getItemId().equals(ii.getItemId())) {
                            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the parent contains a " + child.getTypeString() + child.getItemId() + " at that path\n");
                        } else if (child.getType() != ii.getType()) {
                            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the parent says it's a " + child.getTypeString() + "\n");
                        }
                    }
                }
                if (ii.getLocalParentId() != null) {
                    picc.setComponentId(icc.getComponentId());
                    picc.setConnectionId(icc.getConnectionId());
                    picc.setConnectionType(icc.getConnectionType());
                    picc.setConnectionTypeNS(icc.getConnectionTypeNS());
                    picc.setItemId(ii.getLocalParentId());
                    parent = (InverseInfo)this.inverseInfo.get((Object)picc);
                    if (parent == null) {
                        log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has local parent " + ii.getLocalParentId() + " but the inverse map does not have such an item\n");
                    } else {
                        if (parent.getType() != 1) {
                            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has local parent " + ii.getLocalParentId() + " but the parent is marked as a file in the inverse map\n");
                        }
                        if (parent.getLocalParentId() == null && !this.inverseSharingInfo.containsKey((Object)picc)) {
                            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has local parent " + ii.getLocalParentId() + " but the parent doesn't have a local parent and is not a share root\n");
                        }
                    }
                }
            }
            for (Map.Entry<String, ValidationItemHandle> ch : ii.getRemoteChildren().entrySet()) {
                String sharePath;
                String name = ch.getKey();
                ValidationItemHandle child = ch.getValue();
                picc.setComponentId(icc.getComponentId());
                picc.setConnectionId(icc.getConnectionId());
                picc.setConnectionType(icc.getConnectionType());
                picc.setConnectionTypeNS(icc.getConnectionTypeNS());
                picc.setItemId(child.getItemId());
                if (!this.inverseInfo.containsKey((Object)picc)) {
                    log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote child " + child.getTypeString() + child.getItemId() + " (" + name + ") but the inverse map doesn't contain info for it\n");
                }
                if ((sharePath = (String)this.inverseSharingInfo.get((Object)picc)) == null) continue;
                sharePath = ((SharingInfoWrapper)this.sharingInfo.get((Object)sharePath)).path;
                log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote child " + child.getTypeString() + child.getItemId() + " (" + name + ") but it is the root for the share at \"" + sharePath + "\"\n");
            }
        }
    }

    protected void checkRemoteTreeConsistency(StringBuilder log) throws IOException {
        this.vif = File.createTempFile("visiteditems", null);
        this.visitedItems = new PersistentDiskBackedHashMap<ItemComponentConnection, String>((long)(this.inverseInfo.size() * 4 / 3), this.vif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        block0: for (Map.Entry e : this.inverseInfo.entrySet()) {
            ItemComponentConnection icc = (ItemComponentConnection)e.getKey();
            boolean hasChildren = false;
            InverseInfo ii = (InverseInfo)e.getValue();
            HashSet<String> visited = new HashSet<String>();
            while (this.visitedItems.put((Object)icc, (Object)"") == null) {
                if (!visited.add(icc.getItemId())) {
                    log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has a cycle in its remote tree structure\n");
                    continue block0;
                }
                boolean isShareRoot = this.inverseSharingInfo.containsKey((Object)icc);
                if (isShareRoot) continue block0;
                if (ii.getRemoteParentId() == null) {
                    if (!hasChildren) continue block0;
                    log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote children but no remote parent and it's not a share root\n");
                    continue block0;
                }
                hasChildren = true;
                ItemComponentConnection picc = new ItemComponentConnection();
                picc.setComponentId(icc.getComponentId());
                picc.setConnectionId(icc.getConnectionId());
                picc.setConnectionType(icc.getConnectionType());
                picc.setConnectionTypeNS(icc.getConnectionTypeNS());
                picc.setItemId(ii.getRemoteParentId());
                ii = (InverseInfo)this.inverseInfo.get((Object)picc);
                if (ii == null) continue block0;
                icc = picc;
            }
        }
    }

    protected void checkChangesInverseMapAgreement(StringBuilder log) throws IOException {
        for (Map.Entry e : this.inverseInfo.entrySet()) {
            ItemComponentConnection icc = (ItemComponentConnection)e.getKey();
            InverseInfo ii = (InverseInfo)e.getValue();
            WCChangedInfoKey key = new WCChangedInfoKey(icc.getComponentId(), icc.getConnectionId(), icc.getItemId(), ii.getType());
            ChangedInfosValue v = (ChangedInfosValue)this.changedItems.get((Object)key);
            boolean changed = ii.isChanged();
            if (changed) {
                if (v == null) {
                    log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has an inverse map change but it is not marked in the change map\n");
                }
            } else if (v != null) {
                log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" does not have an inverse map change but it is marked as changed in the change map\n");
            }
            if (ii.getType() != 0 || ii.getLastContentChangeCheckStamp() != -1L || ii.getStateId() == null || ii.getLocalParentId() == null || v != null) continue;
            log.append("The file " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has a null stamp but it is not marked in the change map\n");
        }
        for (Map.Entry e : this.changedItems.entrySet()) {
            WCChangedInfoKey key = (WCChangedInfoKey)e.getKey();
            ItemComponentConnection icc = new ItemComponentConnection();
            icc.setComponentId(key.getComponent());
            icc.setConnectionId(key.getConnection());
            icc.setItemId(key.getItemId());
            InverseInfo ii = (InverseInfo)this.inverseInfo.get((Object)icc);
            if (ii == null) {
                log.append("The " + key.getTypeString() + " " + key.getItemId() + " of component " + key.getComponent() + " of " + key.getConnection() + " does not have an inverse map entry but it is marked as changed in the change map\n");
                continue;
            }
            if (ii.getType() == key.getType()) continue;
            log.append("The " + ii.getTypeString() + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" is marked as a " + key.getTypeString() + "in the change map\n");
        }
    }

    protected SharingInfoWrapper getSharingInfo(String path) throws IOException {
        Path p = new Path(null, path);
        SharingInfoWrapper w;
        while ((w = (SharingInfoWrapper)this.sharingInfo.get((Object)p.toString())) == null) {
            if (p.segmentCount() == 0) {
                return null;
            }
            p = p.removeLastSegments(1);
        }
        return w;
    }

    public void cleanup() throws IOException {
        block788: {
            try {
                if (this.lcf == null) break block788;
                try {
                    if (this.loadedComponents != null) {
                        this.loadedComponents.close();
                    }
                }
                finally {
                    this.lcf.delete();
                }
            }
            finally {
                block789: {
                    try {
                        if (this.sif == null) break block789;
                        try {
                            if (this.sharingInfo != null) {
                                this.sharingInfo.close();
                            }
                        }
                        finally {
                            this.sif.delete();
                        }
                    }
                    finally {
                        block790: {
                            try {
                                if (this.isif == null) break block790;
                                try {
                                    if (this.inverseSharingInfo != null) {
                                        this.inverseSharingInfo.close();
                                    }
                                }
                                finally {
                                    this.isif.delete();
                                }
                            }
                            finally {
                                block791: {
                                    try {
                                        if (this.cif == null) break block791;
                                        try {
                                            if (this.changedItems != null) {
                                                this.changedItems.close();
                                            }
                                        }
                                        finally {
                                            this.cif.delete();
                                        }
                                    }
                                    finally {
                                        block792: {
                                            try {
                                                if (this.fif == null) break block792;
                                                try {
                                                    if (this.forwardInfo != null) {
                                                        this.forwardInfo.close();
                                                    }
                                                }
                                                finally {
                                                    this.fif.delete();
                                                }
                                            }
                                            finally {
                                                block793: {
                                                    try {
                                                        if (this.ifif == null) break block793;
                                                        try {
                                                            if (this.inverseForwardInfo != null) {
                                                                this.inverseForwardInfo.close();
                                                            }
                                                        }
                                                        finally {
                                                            this.ifif.delete();
                                                        }
                                                    }
                                                    finally {
                                                        block794: {
                                                            try {
                                                                if (this.iif == null) break block794;
                                                                try {
                                                                    if (this.inverseInfo != null) {
                                                                        this.inverseInfo.close();
                                                                    }
                                                                }
                                                                finally {
                                                                    this.iif.delete();
                                                                }
                                                            }
                                                            finally {
                                                                if (this.vif != null) {
                                                                    try {
                                                                        if (this.visitedItems != null) {
                                                                            this.visitedItems.close();
                                                                        }
                                                                    }
                                                                    finally {
                                                                        this.vif.delete();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected static class ForwardInfoWrapper
    implements Serializable {
        private static final long serialVersionUID = -5447035710263334711L;
        public String path;
        public ForwardInfo info;

        public ForwardInfoWrapper(String path, ForwardInfo info) {
            this.path = path;
            this.info = info;
        }
    }

    protected static class SharingInfoWrapper
    implements Serializable {
        private static final long serialVersionUID = -7255152426405908735L;
        public ISharingDescriptor desc;
        public String path;

        public SharingInfoWrapper(String path, ISharingDescriptor desc) {
            this.path = path;
            this.desc = desc;
        }
    }
}

