/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

public class CommitDilemmaHandler
extends UpdateDilemmaHandler {
    public static final int IGNORE = 100;
    private static CommitDilemmaHandler instance;

    public static CommitDilemmaHandler getDefault() {
        if (instance == null) {
            instance = new CommitDilemmaHandler();
        }
        return instance;
    }

    protected CommitDilemmaHandler() {
    }

    public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemException {
        int failuresSkipped = 0;
        for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
            if (iLineDelimiterUploadFailure.isAtomicCommit()) continue;
            iLineDelimiterUploadFailure.setSkipFailure(true);
            ++failuresSkipped;
        }
        if (failuresSkipped > 0) {
            return 0;
        }
        return 2;
    }

    public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
        int failuresHandled = 0;
        for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
            if (iEncodingUploadFailure.isUnknownEncoding() || iEncodingUploadFailure.isMalformedContent()) {
                if (iEncodingUploadFailure.getOriginalEncoding() == null) {
                    iEncodingUploadFailure.setIgnoreEncoding(true);
                    ++failuresHandled;
                    continue;
                }
                if (!iEncodingUploadFailure.getEncoding().equals(iEncodingUploadFailure.getOriginalEncoding()) && iEncodingUploadFailure.getOriginalEncoding() != null) {
                    try {
                        if (Charset.isSupported(iEncodingUploadFailure.getOriginalEncoding())) {
                            iEncodingUploadFailure.setAlternativeEncoding(iEncodingUploadFailure.getOriginalEncoding());
                            ++failuresHandled;
                            continue;
                        }
                    }
                    catch (IllegalCharsetNameException illegalCharsetNameException) {}
                }
            }
            if (iEncodingUploadFailure.isAtomicCommit()) continue;
            iEncodingUploadFailure.setSkipFailure(true);
            ++failuresHandled;
        }
        if (failuresHandled != 0) {
            return 0;
        }
        return 2;
    }

    public int predecessorContentDeletedErrors(Collection<IShareable> failedUploads) {
        return 2;
    }

    public void refreshed(IShareable shareable, IProgressMonitor progress) {
    }

    public void unsupportedOutOfSync(IShareable shareable, IProgressMonitor prog) {
    }

    public void commitComplete() throws TeamRepositoryException {
    }

    public void linkWarnings(boolean anyBrokenLinks, boolean anyNonInteroperableLinks, IShareable[] shareables, String[] targets, Boolean[] directoryLinks, Boolean[] broken, Boolean[] nonInteroperable) {
    }

    public int nonPatchShareables(Collection<IShareable> nonPatchShareables) {
        return 2;
    }

    public static /* bridge */ /* synthetic */ UpdateDilemmaHandler getDefault() {
        return CommitDilemmaHandler.getDefault();
    }
}

