/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import com.ibm.team.filesystem.client.restproxy.INotificationListener;
import com.ibm.team.filesystem.client.restproxy.RestInvocationHandler;
import com.ibm.team.filesystem.client.restproxy.RestInvocationParticipant;
import com.ibm.team.filesystem.client.restproxy.notification.ClientNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.KeyInUseException;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.filesystem.client.restproxy.notification.ProgressNotificationParm;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class ProgressRestParticipant
extends RestInvocationParticipant {
    private Map<RestInvocationParticipant.CallKey, List<NotificationListener>> monitors = new HashMap<RestInvocationParticipant.CallKey, List<NotificationListener>>();
    private Map<String, NotificationListener> listeners = new HashMap<String, NotificationListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInvoke(RestInvocationParticipant.CallKey callKey, Object proxy, Method method, Object[] args) {
        super.preInvoke(callKey, proxy, method, args);
        if (args == null) {
            return;
        }
        LinkedList<IProgressMonitor> currentMonitors = null;
        Object object = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = object[n2];
            if (arg instanceof IProgressMonitor) {
                if (currentMonitors == null) {
                    currentMonitors = new LinkedList<IProgressMonitor>();
                }
                currentMonitors.add((IProgressMonitor)arg);
            }
            ++n2;
        }
        if (currentMonitors == null) {
            return;
        }
        RestInvocationHandler handler = (RestInvocationHandler)Proxy.getInvocationHandler(proxy);
        ClientNotificationChannel channel = handler.getNotificationChannel();
        ArrayList<NotificationListener> list = new ArrayList<NotificationListener>(currentMonitors.size());
        object = this.monitors;
        synchronized (object) {
            this.monitors.put(callKey, list);
        }
        for (IProgressMonitor monitor : currentMonitors) {
            String key;
            NotificationListener l = new NotificationListener(channel, new RemoteProgressMonitor(monitor));
            try {
                key = channel.addListener(null, l, false);
            }
            catch (KeyInUseException keyInUseException) {
                throw new IllegalStateException("Key should be safe");
            }
            l.setKey(key);
            list.add(l);
            Map<String, NotificationListener> map = this.listeners;
            synchronized (map) {
                this.listeners.put(key, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preRequest(RestInvocationParticipant.CallKey key, HttpMethod request) {
        super.preRequest(key, request);
        Map<RestInvocationParticipant.CallKey, List<NotificationListener>> map = this.monitors;
        synchronized (map) {
            if (this.monitors.containsKey(key)) {
                StringBuffer buf = new StringBuffer();
                for (NotificationListener l : this.monitors.get(key)) {
                    if (buf.length() > 0) {
                        buf.append(" ");
                    }
                    buf.append(l.key);
                }
                request.addRequestHeader("X-Request-Progress", buf.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSynchronousCallback(RestInvocationParticipant.CallKey key, HttpMethod request, Object proxy, Method method, Object[] args, RestInvocationParticipant.ISynchronousCallback cb) {
        List<NotificationListener> listeners;
        Map<RestInvocationParticipant.CallKey, List<NotificationListener>> map = this.monitors;
        synchronized (map) {
            listeners = this.monitors.get(key);
        }
        if (listeners == null) {
            return false;
        }
        for (NotificationListener listener : listeners) {
            listener.setCallback(cb);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void duringInvoke(RestInvocationParticipant.CallKey key, HttpMethod request) {
        List<NotificationListener> listeners;
        Map<RestInvocationParticipant.CallKey, List<NotificationListener>> map = this.monitors;
        synchronized (map) {
            listeners = this.monitors.get(key);
        }
        for (NotificationListener listener : listeners) {
            if (!listener.monitor.isCanceled()) continue;
            request.abort();
            throw new OperationCanceledException("Locally thrown exception due to cancellation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postInvoke(RestInvocationParticipant.CallKey key, Object proxy, Method method, Object[] args, Object returnValue, Throwable exception) {
        List<NotificationListener> listeners;
        super.postInvoke(key, proxy, method, args, returnValue, exception);
        Map<RestInvocationParticipant.CallKey, List<NotificationListener>> map = this.monitors;
        synchronized (map) {
            listeners = this.monitors.remove(key);
        }
        if (listeners == null) {
            return;
        }
        RestInvocationHandler handler = (RestInvocationHandler)Proxy.getInvocationHandler(proxy);
        ClientNotificationChannel channel = handler.getNotificationChannel();
        for (NotificationListener l : listeners) {
            channel.removeListener(l.key, l);
            Map<String, NotificationListener> map2 = this.listeners;
            synchronized (map2) {
                NotificationListener listener = this.listeners.remove(l.key);
                if (listener != null) {
                    listener.monitor.done();
                }
            }
        }
    }

    private static class NotificationListener
    implements INotificationListener {
        final ClientNotificationChannel channel;
        final RemoteProgressMonitor monitor;
        String key;
        RestInvocationParticipant.ISynchronousCallback cb;

        public NotificationListener(ClientNotificationChannel channel, RemoteProgressMonitor monitor) {
            this.channel = channel;
            this.monitor = monitor;
        }

        public void notificationReceived(String key, Notification notification) {
            assert (ProgressNotificationParm.TYPE.equals(notification.type));
            final ProgressNotificationParm prog = (ProgressNotificationParm)notification.notification;
            this.cb.call(new Runnable(){

                @Override
                public void run() {
                    double toWork;
                    double progress;
                    if (prog.taskName != null) {
                        NotificationListener.this.monitor.setTaskName(prog.taskName);
                    }
                    if (prog.subTask != null) {
                        NotificationListener.this.monitor.subTask(prog.subTask);
                    }
                    if ((progress = prog.progress) > 100.0) {
                        progress = 100.0;
                    }
                    if ((toWork = progress - NotificationListener.this.monitor.getWorked()) > 0.0) {
                        NotificationListener.this.monitor.internalWorked(toWork);
                    }
                }
            });
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setCallback(RestInvocationParticipant.ISynchronousCallback cb) {
            this.cb = cb;
        }
    }

    protected static class RemoteProgressMonitor
    extends ProgressMonitorWrapper {
        public double worked;

        public RemoteProgressMonitor(IProgressMonitor toWrap) {
            super(toWrap);
            this.beginTask("", 100);
        }

        public void internalWorked(double work) {
            super.internalWorked(work);
            this.worked += work;
        }

        public void worked(int work) {
            super.worked(work);
            this.worked += (double)work;
        }

        public double getWorked() {
            return this.worked;
        }
    }
}

