/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.common.notification;

import com.ibm.team.build.internal.common.l10n.Messages;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class NotificationCriteria {
    private String criteriaName = "";
    private boolean enabled = true;
    private boolean personalCriteria = false;
    private NotifyCondition notifyCompletedCondition = NotifyCondition.NEVER;
    private NotifyCondition notifyAbandonedCondition = NotifyCondition.NEVER;
    private String[] emails = new String[0];
    private boolean notifySCM = false;
    private boolean notifyRequestor = false;
    private String[] users = new String[0];
    private String[] roles = new String[0];

    public String getCriteriaName() {
        return this.criteriaName;
    }

    public void setCriteriaName(String criteriaName) {
        this.criteriaName = criteriaName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isPersonalCriteria() {
        return this.personalCriteria;
    }

    public void setPersonalCriteria(boolean personalCriteria) {
        this.personalCriteria = personalCriteria;
    }

    public NotifyCondition getNotifyCompletedCondition() {
        return this.notifyCompletedCondition;
    }

    public void setNotifyCompletedCondition(NotifyCondition notifyCompleted) {
        this.notifyCompletedCondition = notifyCompleted;
    }

    public NotifyCondition getNotifyAbandonedCondition() {
        return this.notifyAbandonedCondition;
    }

    public void setNotifyAbandonedCondition(NotifyCondition notifyAbandonedCondition) {
        this.notifyAbandonedCondition = notifyAbandonedCondition;
    }

    public String[] getEmails() {
        return this.emails;
    }

    public void setEmails(String[] emails) {
        this.emails = emails;
    }

    public boolean isNotifySCM() {
        return this.notifySCM;
    }

    public void setNotifySCM(boolean notifySCM) {
        this.notifySCM = notifySCM;
    }

    public boolean isNotifyRequestor() {
        return this.notifyRequestor;
    }

    public void setNotifyRequestor(boolean notifyRequestor) {
        this.notifyRequestor = notifyRequestor;
    }

    public String[] getUsers() {
        return this.users;
    }

    public void setUsers(String[] users) {
        this.users = users;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public String getCriteriaSummary(Map<String, String> userNameMap, String delimiter) {
        int i;
        if (delimiter == null) {
            delimiter = "\n";
        }
        StringBuilder builder = new StringBuilder();
        if (this.isPersonalCriteria()) {
            builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_BUILD_PERSONAL"));
        } else {
            builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_BUILD_NON_PERSONAL"));
        }
        builder.append(delimiter);
        builder.append(delimiter);
        switch (this.getNotifyAbandonedCondition()) {
            case ALWAYS: {
                builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_ABANDONED_ALWAYS"));
                builder.append(delimiter);
                break;
            }
            case ON_ERROR: {
                builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_ABANDONED_ERRORS"));
                builder.append(delimiter);
            }
        }
        switch (this.getNotifyCompletedCondition()) {
            case ALWAYS: {
                builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_COMPLETED_ALWAYS"));
                builder.append(delimiter);
                break;
            }
            case ON_ERROR: {
                builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_COMPLETED_ERRORS"));
                builder.append(delimiter);
            }
        }
        if (this.getNotifyAbandonedCondition() != NotifyCondition.NEVER || this.getNotifyCompletedCondition() != NotifyCondition.NEVER) {
            builder.append(delimiter);
        }
        if (this.isNotifySCM()) {
            builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_USERS_SCM"));
            builder.append(delimiter);
        }
        if (this.isNotifyRequestor()) {
            builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_USERS_REQUEST"));
            builder.append(delimiter);
        }
        if (this.isNotifySCM() || this.isNotifyRequestor()) {
            builder.append(delimiter);
        }
        if (this.getEmails().length != 0) {
            builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_EMAILS_LABEL"));
            builder.append(' ');
            i = 0;
            while (i < this.getEmails().length) {
                if (i != 0) {
                    builder.append(Messages.getCommonString("NotificationCriteria_LIST_SEPARATOR")).append(this.getEmails()[i]);
                } else {
                    builder.append(this.getEmails()[i]);
                }
                ++i;
            }
            builder.append(delimiter);
            builder.append(delimiter);
        }
        if (this.getUsers().length != 0) {
            builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_USERS_LABEL"));
            builder.append(' ');
            if (userNameMap == null) {
                i = 0;
                while (i < this.getUsers().length) {
                    if (i != 0) {
                        builder.append(Messages.getCommonString("NotificationCriteria_LIST_SEPARATOR")).append(this.getUsers()[i]);
                    } else {
                        builder.append(this.getUsers()[i]);
                    }
                    ++i;
                }
            } else {
                this.appendUserDetailsToCriteriaSummary(builder, userNameMap);
            }
            builder.append(delimiter);
            builder.append(delimiter);
        }
        if (this.getRoles().length != 0) {
            builder.append(Messages.getCommonString("NotificationCriteria_SUMMARY_ROLES_LABEL"));
            builder.append(' ');
            i = 0;
            while (i < this.getRoles().length) {
                if (i != 0) {
                    builder.append(Messages.getCommonString("NotificationCriteria_LIST_SEPARATOR")).append(this.getRoles()[i]);
                } else {
                    builder.append(this.getRoles()[i]);
                }
                ++i;
            }
            builder.append(delimiter);
            builder.append(delimiter);
        }
        return builder.toString();
    }

    private void appendUserDetailsToCriteriaSummary(StringBuilder builder, Map<String, String> userNameMap) {
        String[] allUsers = this.getUsers();
        int i = 0;
        while (i < allUsers.length) {
            String userName = userNameMap.containsKey(allUsers[i]) ? NLS.bind((String)Messages.getCommonString("NotificationCriteria_USER_NAME_AND_ID"), (Object)userNameMap.get(allUsers[i]), (Object)allUsers[i]) : allUsers[i];
            if (i != 0) {
                builder.append(Messages.getCommonString("NotificationCriteria_LIST_SEPARATOR")).append(userName);
            } else {
                builder.append(userName);
            }
            ++i;
        }
    }

    public static enum NotifyCondition {
        NEVER,
        ON_ERROR,
        ALWAYS;

    }
}

