/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.LoginFailureException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.transport.UriUtil;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;

public class ConnectionUtil {
    public static boolean setConnectionError(Exception e, TeamRepository repository) {
        boolean connectionError = false;
        if (ConnectionUtil.isMinorConnectionError(e)) {
            connectionError = true;
        } else {
            int nextState = 0;
            if (e instanceof LoginFailureException || e instanceof AuthenticationException) {
                if (ConnectionUtil.authErrorOnRepository((AuthenticationException)e, repository)) {
                    nextState = 2;
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof PermissionDeniedException) {
                        nextState = 0;
                    } else {
                        repository.logout();
                    }
                }
            } else if (e.getCause() instanceof IOException) {
                nextState = 1;
                connectionError = true;
            } else if (e instanceof TeamServiceException) {
                TeamServiceException tse = (TeamServiceException)e;
                if (tse.getStatusCode() == 400) {
                    nextState = 0;
                } else {
                    nextState = 1;
                    connectionError = true;
                }
            }
            if (nextState != 0) {
                repository.setErrorState(nextState, e);
            }
        }
        return connectionError;
    }

    private static boolean authErrorOnRepository(AuthenticationException e, TeamRepository repo) {
        if (e == null) {
            throw new IllegalArgumentException("e must not be null");
        }
        if (repo == null) {
            throw new IllegalArgumentException("repo must not be null");
        }
        TeamRepository originConnection = e.getOrigin() instanceof TeamRepository ? (TeamRepository)e.getOrigin() : null;
        String requestUri = e.getRequestUri();
        if (requestUri == null || requestUri.trim().length() == 0) {
            if (originConnection != null) {
                return originConnection.equals(repo);
            }
            return true;
        }
        Collection repositoryURIs = repo.getAliasRepositoryURIs();
        for (Object obj : repositoryURIs) {
            String repoUri = null;
            try {
                repoUri = UriUtil.normalize((String)((String)obj), (boolean)false);
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            if (!requestUri.startsWith(repoUri)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMinorConnectionError(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            return false;
        }
        if (e instanceof ServiceNotAvailableException) {
            return true;
        }
        if (message.equals("Read timed out")) {
            return true;
        }
        return message.contains("Connection reset");
    }
}

