/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.reports.common.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.Iterator;

public class ResultIterator {
    private final IQueryService queryService;
    private IItemQueryPage page;
    private Iterator<IItemHandle> iterator;

    public ResultIterator(IQueryService queryService, IItemQuery itemQuery, Object[] parameters) throws TeamRepositoryException {
        this.queryService = queryService;
        itemQuery.distinct();
        this.page = queryService.queryItems(itemQuery, parameters, 512);
        this.iterator = this.page.getItemHandles().iterator();
    }

    public boolean hasNext() throws TeamRepositoryException {
        return this.iterator != null && this.iterator.hasNext() || this.fetchNextPage();
    }

    public IItemHandle next() throws TeamRepositoryException {
        return this.hasNext() ? this.iterator.next() : null;
    }

    private boolean fetchNextPage() throws TeamRepositoryException {
        if (this.page == null) {
            return false;
        }
        if (this.page.hasNext()) {
            this.page = (IItemQueryPage)this.queryService.fetchPage(this.page.getToken(), this.page.getNextStartPosition(), this.page.getSize());
            this.iterator = this.page.getItemHandles().iterator();
        } else {
            this.iterator = null;
            this.page = null;
        }
        return this.hasNext();
    }
}

