/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.internal.setup.builders;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessDefinitionHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.internal.setup.builders.AbstractProcessBuilder;
import com.ibm.team.process.common.internal.setup.builders.DevelopmentLineBuilder;
import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.process.common.internal.setup.builders.Processes;
import com.ibm.team.process.common.internal.setup.builders.TeamAreaBuilder;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.internal.common.service.IProcessService;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IPostSaveHook;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ProjectAreaBuilder
extends AbstractProcessBuilder<IProjectArea> {
    public static final String DEFAULT_PROCESS = "default.builder.process.ibm.com";
    public static final String DEFAULT_PROCESS_NAME = "Default Project Area Builder Process";
    public static final String DEFAULT_PROCESS_SUMMARY = "This is a sample default builder which is automatically created when using the Project Area Builder";
    public static final String DEFAULT_PROCESS_CONTENT_PATH = "http://localhost/testProcessContent";
    public static final String DEFAULT_ENCODING = "UTF8";
    private static final ValueKey<String> NAME_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".name");
    private static final ValueKey<Object> ORIGIN_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".origin");
    private static final ValueKey<String> SUMMARY_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".summary");
    private static final ValueKey<String> LOCALE_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".locale");
    private static final ValueKey<Processes> DEFINITION_ID_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".definition");
    private static final ValueKey<Map<IContributorHandle, IRole[]>> MEMBERS_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".member");
    private static final ValueKey<Map<IContributorHandle, IRole[]>> ADMINS_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".admin");
    private static final ValueKey<IDevelopmentLineHandle> DEVELOMPMENT_LINE_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".developmentLine");
    private List<IArtifactBuilder<IProjectArea>> fExtensionBuilders = new ArrayList<IArtifactBuilder<IProjectArea>>();

    public ProjectAreaBuilder(IProcessBuilderContext buildContext) {
        super(buildContext);
        this.setBuilderValue(MEMBERS_KEY, new HashMap());
        this.setBuilderValue(ADMINS_KEY, new HashMap());
    }

    public ProjectAreaBuilder name(String name) {
        this.setBuilderValue(NAME_KEY, name);
        return this;
    }

    public ProjectAreaBuilder summary(String summary) {
        this.setBuilderValue(SUMMARY_KEY, summary);
        return this;
    }

    public ProjectAreaBuilder origin(Object origin) {
        this.setBuilderValue(ORIGIN_KEY, origin);
        return this;
    }

    public ProjectAreaBuilder process(Processes process) {
        this.setBuilderValue(DEFINITION_ID_KEY, process);
        return this;
    }

    public ProjectAreaBuilder customProcessId(String id) {
        this.setBuilderValue(DEFINITION_ID_KEY, Processes.fromId(id));
        return this;
    }

    public ProjectAreaBuilder locale(String locale) {
        this.setBuilderValue(LOCALE_KEY, locale);
        return this;
    }

    public ProjectAreaBuilder member(IContributorHandle contributor, IRole ... roles) {
        this.getBuilderValue(MEMBERS_KEY).put(contributor, roles);
        return this;
    }

    public ProjectAreaBuilder admin(IContributorHandle contributor, IRole ... roles) {
        this.getBuilderValue(ADMINS_KEY).put(contributor, roles);
        return this;
    }

    public ProjectAreaBuilder developmentLine(DevelopmentLineBuilder line) {
        this.addChildBuilder(line);
        return this;
    }

    public ProjectAreaBuilder projectDevelopmentLine(DevelopmentLineBuilder line) {
        this.addChildBuilder(line);
        line.addPostSaveHook(new IPostSaveHook<IDevelopmentLine>(){

            @Override
            public void itemSaved(AbstractArtifactBuilder.ArtifactSavedEvent<IDevelopmentLine> saveEvent) {
                ProjectAreaBuilder.this.setBuilderValue(DEVELOMPMENT_LINE_KEY, (IDevelopmentLineHandle)saveEvent.fArtifact);
            }
        });
        return this;
    }

    public ProjectAreaBuilder teamArea(TeamAreaBuilder teamArea) {
        this.addChildBuilder(teamArea);
        return this;
    }

    public ProjectAreaBuilder extension(IArtifactBuilder<IProjectArea> builder) {
        this.fExtensionBuilders.add(builder);
        return this;
    }

    @Override
    protected BuildContext contributeToContext(IProjectArea artifact, BuildContext context) {
        BuildContext result = super.contributeToContext(artifact, context);
        result.setProperty(BuildContext.PROJECT_AREA, artifact);
        return result;
    }

    @Override
    protected IProjectArea doArtifactBuild(BuildContext context) {
        ProjectArea projectArea = (ProjectArea)this.artifact(IProjectArea.ITEM_TYPE);
        projectArea.setOrigin(this.getBuilderValue(ORIGIN_KEY, projectArea.getOrigin()));
        projectArea.setName(this.chooseValue(NAME_KEY, projectArea.getName(), UUID.generate().getUuidValue()));
        projectArea.setProcessSummary(this.chooseValue(SUMMARY_KEY, projectArea.getProcessSummary(), ""));
        projectArea.setLocale(this.chooseValue(LOCALE_KEY, projectArea.getLocale(), Locale.US.toString()));
        projectArea.setContextId(projectArea.getItemId());
        projectArea.setProcessContentPath(DEFAULT_PROCESS_CONTENT_PATH);
        projectArea.setProcessName(DEFAULT_PROCESS_NAME);
        projectArea.setProcessSummary(DEFAULT_PROCESS_SUMMARY);
        projectArea.setProcessDefinition((IProcessDefinitionHandle)IProcessDefinition.ITEM_TYPE.createItemHandle(UUID.generate(), null));
        for (Map.Entry<IContributorHandle, IRole[]> member : this.getBuilderValue(MEMBERS_KEY).entrySet()) {
            projectArea.addMember(member.getKey());
            projectArea.addRoleAssignments(member.getKey(), member.getValue());
        }
        for (Map.Entry<IContributorHandle, IRole[]> admin : this.getBuilderValue(ADMINS_KEY).entrySet()) {
            projectArea.addAdministrator(admin.getKey());
            projectArea.addRoleAssignments(admin.getKey(), admin.getValue());
        }
        return projectArea;
    }

    @Override
    protected void postSaveChildren(BuildContext saveContext, IProjectArea projectArea) throws TeamRepositoryException {
        projectArea = (IProjectArea)saveContext.getUpdatedItem(projectArea).getWorkingCopy();
        projectArea.setProjectDevelopmentLine(this.getBuilderValue(DEVELOMPMENT_LINE_KEY, projectArea.getProjectDevelopmentLine()));
        saveContext.updateItem((IItem)projectArea);
    }

    @Override
    protected IProjectArea postSave(IProjectArea artifact, BuildContext saveContext) throws TeamRepositoryException {
        for (IArtifactBuilder<IProjectArea> builder : this.fExtensionBuilders) {
            artifact = builder.save(new BuildContext(saveContext).setProperty(BuildContext.PROJECT_AREA, artifact));
        }
        return artifact;
    }

    @Override
    protected IProjectArea doArtifactSave(BuildContext context) throws TeamRepositoryException {
        IProjectArea projectArea = this.doArtifactBuild(context);
        IProcessService processService = this.getContext().getLibrary(IProcessService.class);
        if (!this.artifactExists()) {
            Processes process = this.getBuilderValue(DEFINITION_ID_KEY, Processes.fromId(DEFAULT_PROCESS));
            IProcessDefinition definition = processService.findProcessDefinition(process.getId(), null, null);
            if (definition == null) {
                if (process.getId().equals(DEFAULT_PROCESS)) {
                    this.deployDefaultProcessService(processService);
                } else if (process.isPredefined()) {
                    processService.deployPredefinedProcessDefinitions(null, null);
                } else {
                    process.save(this.getContext());
                }
                definition = processService.findProcessDefinition(process.getId(), null, null);
            }
            projectArea.setProcessDefinition((IProcessDefinitionHandle)definition);
            processService.saveProcessItem((IProcessItem)projectArea);
            projectArea = (IProjectArea)processService.initializeProjectArea(projectArea, null).getClientItems()[0];
            projectArea = (IProjectArea)projectArea.getWorkingCopy();
        }
        return projectArea;
    }

    protected void deployDefaultProcessService(IProcessService processService) throws TeamRepositoryException {
        if (!Platform.isRunning()) {
            throw new IllegalStateException("Default process template can only be used in OSGI environments. Use standard process instead, e.g., Processes.SCRUM.");
        }
        IProcessDefinition result = (IProcessDefinition)IProcessDefinition.ITEM_TYPE.createItem();
        result.setName(DEFAULT_PROCESS_NAME);
        result.getDescription().setSummary(DEFAULT_PROCESS_SUMMARY);
        result.setContextId(IContext.PUBLIC);
        result.setProcessId(DEFAULT_PROCESS);
        result.setProcessContentPath(DEFAULT_PROCESS_CONTENT_PATH);
        URL processSpecUrl = FileLocator.find((String)"com.ibm.team.rtc.common", (IPath)new Path("/resources/builderProcess/process_specification.xml"));
        URL processStateUrl = FileLocator.find((String)"com.ibm.team.rtc.common", (IPath)new Path("/resources/builderProcess/process_state.xml"));
        Map definitionData = result.getProcessData();
        IContent specification = this.createXMLContentFromFile(processSpecUrl);
        definitionData.put("com.ibm.team.internal.process.40.compiled.xml", specification);
        IContent state = this.createXMLContentFromFile(processStateUrl);
        definitionData.put("com.ibm.team.internal.process.state.xml", state);
        processService.saveProcessItem((IProcessItem)result);
    }

    private IContent createXMLContentFromFile(URL url) throws TeamRepositoryException {
        InputStream input = null;
        try {
            URLConnection connection = url.openConnection();
            input = connection.getInputStream();
            String contentEncoding = connection.getContentEncoding();
            if (contentEncoding == null) {
                contentEncoding = DEFAULT_ENCODING;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, contentEncoding));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, DEFAULT_ENCODING);
            int ch = reader.read();
            while (ch != -1) {
                writer.write(ch);
                ch = reader.read();
            }
            writer.flush();
            writer.close();
            IContent iContent = this.getContext().storeContent("text/xml", DEFAULT_ENCODING, output.toByteArray());
            return iContent;
        }
        catch (IOException x) {
            throw new TeamRepositoryException((Throwable)x);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException x) {
                throw new TeamRepositoryException((Throwable)x);
            }
        }
    }
}

