/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc.xml;

import com.urbancode.air.vc.VCHelper;
import com.urbancode.air.vc.xml.DocumentBuilderHelper;
import com.urbancode.commons.xml.marshall.BaseXMLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLVCHelper<T>
extends BaseXMLHelper<T>
implements VCHelper<T> {
    private static final Logger log;
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    static final ThreadLocal<TransformerFactory> transformerFactory;
    private static final String quot = "&quot;";
    private static final String lt = "&lt;";
    private static final String gt = "&gt;";
    private static final String amp = "&amp;";
    private static final String[] refs;
    private static final int[] hex;

    public static String replaceIllegalXmlChars(String input) {
        if (XMLVCHelper.isLegalXmlCharacters(input)) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        int length = input.length();
        int currentPos = 0;
        while (currentPos < length) {
            int repairBegins = input.indexOf(CDATA_BEGIN, currentPos);
            if (repairBegins == -1) {
                repairBegins = length;
            }
            String replaceThis = input.substring(currentPos, repairBegins);
            builder.append(XMLVCHelper.removeInvalidCharacterReferences(replaceThis));
            currentPos = repairBegins;
            int repairEnds = input.indexOf(CDATA_END, repairBegins);
            repairEnds = repairEnds == -1 ? length : (repairEnds += CDATA_END.length());
            builder.append(input.substring(repairBegins, repairEnds));
            currentPos = repairEnds;
        }
        String result = builder.toString();
        result = XMLVCHelper.removeIllegalCodePoints(result);
        return result;
    }

    private static String removeInvalidCharacterReferences(String input) {
        StringBuilder builder = new StringBuilder();
        int len = input.length();
        int beginRef = -1;
        int endRef = -1;
        int i = 0;
        while (i < len) {
            char c = input.charAt(i);
            if (beginRef == -1 && c == '&') {
                beginRef = i;
            } else if (beginRef > -1 && c == ';') {
                endRef = i;
            }
            if (beginRef > -1 && endRef > -1) {
                String charRef = input.substring(beginRef, endRef + 1);
                if (XMLVCHelper.isLegalCharacterReference(charRef)) {
                    builder.append(charRef);
                } else {
                    builder.append(amp);
                    i = beginRef;
                }
                beginRef = -1;
                endRef = -1;
            } else if (beginRef == -1) {
                builder.append(input.charAt(i));
            }
            if (i == len - 1 && beginRef != -1) {
                endRef = beginRef;
                continue;
            }
            ++i;
        }
        return builder.toString();
    }

    private static boolean isLegalCharacterReference(String str) {
        int codepoint;
        block7: {
            if (str.equals(quot) || str.equals(lt) || str.equals(gt) || str.equals(amp)) {
                return true;
            }
            if (str.length() <= 3) {
                return false;
            }
            int len = str.length();
            codepoint = -1;
            try {
                if (str.charAt(0) == '&' && str.charAt(1) == '#' && str.charAt(len - 1) == ';') {
                    if (str.charAt(2) == 'x') {
                        String hexValue = str.substring(3, len - 1);
                        codepoint = Integer.parseInt(hexValue, 16);
                    } else {
                        String decimalValue = str.substring(2, len - 1);
                        codepoint = Integer.parseInt(decimalValue, 10);
                    }
                }
            }
            catch (NumberFormatException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)String.format("Error parsing '%s'", str), (Throwable)e);
            }
        }
        return XMLVCHelper.isLegalCodePoint(codepoint);
    }

    private static String removeIllegalCodePoints(String input) {
        StringBuilder builder = new StringBuilder();
        for (int cp : XMLVCHelper.toCodePointArray(input)) {
            if (!XMLVCHelper.isLegalCodePoint(cp)) continue;
            builder.append(Character.toChars(cp));
        }
        return builder.toString();
    }

    private static boolean isLegalCodePoint(int cp) {
        return cp == 9 || cp == 10 || cp == 13 || cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF;
    }

    private static int[] toCodePointArray(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot convert null string to array");
        }
        int sLen = s.length();
        int cpCount = s.codePointCount(0, sLen);
        int[] result = new int[cpCount];
        int offset = 0;
        for (int i = 0; i < cpCount; ++i) {
            int cp;
            result[i] = cp = s.codePointAt(offset);
            offset += Character.charCount(cp);
        }
        return result;
    }

    static boolean isLegalXmlCharacters(String str) {
        int cdStart;
        int start = 0;
        int end = str.length() - 1;
        while ((cdStart = str.indexOf(CDATA_BEGIN, start)) != -1) {
            int cdEnd = str.indexOf(CDATA_END, cdStart + CDATA_BEGIN.length());
            if (cdEnd == -1) {
                return false;
            }
            if (!XMLVCHelper.isValidNonCData(str, start, cdStart - 1)) {
                return false;
            }
            if (!XMLVCHelper.isValidCData(str, cdStart + CDATA_BEGIN.length(), cdEnd - 1)) {
                return false;
            }
            start = cdEnd + CDATA_END.length();
        }
        return XMLVCHelper.isValidNonCData(str, start, end);
    }

    private static boolean isValidCData(String str, int first, int last) {
        int point;
        for (int i = first; i <= last; i += Character.charCount(point)) {
            point = str.codePointAt(i);
            if (XMLVCHelper.isLegalCodePoint(point)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidNonCData(String str, int first, int last) {
        int point;
        int refStart = -1;
        for (int i = first; i <= last; i += Character.charCount(point)) {
            point = str.codePointAt(i);
            if (!XMLVCHelper.isLegalCodePoint(point)) {
                return false;
            }
            if (point == 38) {
                if (refStart != -1) {
                    return false;
                }
                refStart = i;
                continue;
            }
            if (point != 59) continue;
            if (refStart == -1) {
                return false;
            }
            if (!XMLVCHelper.isLegalCharacterOrEntityReferenceRange(str, refStart, i)) {
                return false;
            }
            refStart = -1;
        }
        return refStart == -1;
    }

    private static boolean isLegalCharacterOrEntityReferenceRange(String str, int first, int last) {
        int len = last - first + 1;
        if (len <= 3) {
            return false;
        }
        for (String ref : refs) {
            if (!str.regionMatches(first, ref, 0, ref.length())) continue;
            return true;
        }
        if (str.charAt(first) != '&' || str.charAt(first + 1) != '#' || str.charAt(last) != ';') {
            return false;
        }
        int codepoint = -1;
        codepoint = str.charAt(first + 2) == 'x' ? XMLVCHelper.parseHexCodePoint(str, first + 3, last - 1) : XMLVCHelper.parseDecimalCodePoint(str, first + 2, last - 1);
        return XMLVCHelper.isLegalCodePoint(codepoint);
    }

    private static int parseDecimalCodePoint(String str, int first, int last) {
        int a = 0;
        for (int i = first; i <= last; ++i) {
            int d = XMLVCHelper.decodeDecimalDigit(str.charAt(i));
            if (d == -1) {
                return -1;
            }
            if ((a = 10 * a + d) <= 0x10FFFF) continue;
            return -1;
        }
        return a;
    }

    private static int parseHexCodePoint(String str, int first, int last) {
        int a = 0;
        for (int i = first; i <= last; ++i) {
            int d = XMLVCHelper.decodeHexDigit(str.charAt(i));
            if (d == -1) {
                return -1;
            }
            if ((a = 16 * a + d) <= 0x10FFFF) continue;
            return -1;
        }
        return a;
    }

    private static int decodeDecimalDigit(char c) {
        if (c < '0' || c > '9') {
            return -1;
        }
        return c - 48;
    }

    private static int decodeHexDigit(char c) {
        if (c > hex.length) {
            return -1;
        }
        return hex[c];
    }

    @Override
    public void write(T persistent, OutputStream output) {
        try {
            DocumentBuilder builder = DocumentBuilderHelper.getDocumentBuilder();
            Document document = builder.newDocument();
            document.appendChild(this.toXML(persistent, document));
            TransformerFactory factory = transformerFactory.get();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error writing XML for persistent " + persistent, e);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Error writing XML for persistent " + persistent, e);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Error writing XML for persistent " + persistent, e);
        }
    }

    @Override
    public final T restore(Document rootElement) {
        return (T)this.toObject(rootElement);
    }

    @Override
    public final T restore(InputStream input) {
        T result;
        try {
            DocumentBuilder builder = DocumentBuilderHelper.getDocumentBuilder();
            Document document = builder.parse(input);
            result = this.restore(document);
            if (result == null) {
                throw new RuntimeException(this.getClass().getName() + " returned a null object when converting from XML.");
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        return result;
    }

    protected String getNullableStringAttribute(Element element, String name) {
        String resultString = element.getAttribute(name);
        if (resultString != null && resultString.isEmpty()) {
            resultString = null;
        }
        return resultString;
    }

    protected UUID getUUIDAttribute(Element element, String name) {
        String resultString = element.getAttribute(name);
        UUID result = null;
        if (resultString != null && !resultString.isEmpty()) {
            result = UUID.fromString(resultString);
        }
        return result;
    }

    protected Boolean getBooleanAttribute(Element element, String name) {
        String resultString = element.getAttribute(name);
        Boolean result = null;
        if (resultString != null && !resultString.isEmpty()) {
            result = Boolean.valueOf(resultString);
        }
        return result;
    }

    protected Long getLongAttribute(Element element, String name) {
        String resultString = element.getAttribute(name);
        Long result = null;
        if (resultString != null && !resultString.isEmpty()) {
            result = Long.valueOf(resultString);
        }
        return result;
    }

    protected Integer getIntegerAttribute(Element element, String name) throws NumberFormatException {
        String resultString = element.getAttribute(name);
        Integer result = null;
        if (resultString != null && !resultString.isEmpty()) {
            result = Integer.valueOf(resultString);
        }
        return result;
    }

    static {
        int c;
        log = Logger.getLogger(XMLVCHelper.class);
        transformerFactory = new ThreadLocal<TransformerFactory>(){

            @Override
            protected TransformerFactory initialValue() {
                return TransformerFactory.newInstance();
            }
        };
        refs = new String[]{quot, lt, gt, amp};
        hex = new int[103];
        Arrays.fill(hex, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            XMLVCHelper.hex[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            XMLVCHelper.hex[c] = c - 65 + 10;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            XMLVCHelper.hex[c] = c - 97 + 10;
        }
    }
}

