/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;

public class SCMClientUtil {
    static final UUID CUSTOM_PRIVATE = UUID.valueOf((String)"_p57xQODvEd2JvqtXLuqiiw");

    static IProgressMonitor getMonitor(IProgressMonitor monitor) {
        return monitor == null ? new NullProgressMonitor() : monitor;
    }

    static IProgressMonitor getMonitor(IProgressMonitor monitor, int ticks) {
        IProgressMonitor result = SCMClientUtil.getMonitor(monitor);
        result.beginTask("", ticks);
        return result;
    }

    static IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    static void checkMonitor(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            throw new IllegalArgumentException();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    static int calculateSubMonitorTicks(int ticksToSpend, int numberOfEqualSubtasks) {
        if (numberOfEqualSubtasks == 0) {
            return 0;
        }
        return (int)Math.floor((double)ticksToSpend / (double)numberOfEqualSubtasks);
    }

    static void refreshItemsAsNecessary(List handles, IItemManager itemManager, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemManager == null) {
            throw new IllegalArgumentException();
        }
        if (handles == null) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor);
        ArrayList<IItem> needRefreshing = null;
        for (IItemHandle handle : handles) {
            IItem sharedItemIfKnown = itemManager.getSharedItemIfKnown(handle);
            if (sharedItemIfKnown == null) continue;
            if (needRefreshing == null) {
                needRefreshing = new ArrayList<IItem>(handles.size());
            }
            needRefreshing.add(sharedItemIfKnown);
        }
        if (needRefreshing != null) {
            itemManager.refreshSharedItems(needRefreshing, monitor);
        }
    }

    static List asList(Collection coll) {
        if (coll instanceof List) {
            return (List)coll;
        }
        return new ArrayList(coll);
    }

    static IItem ensureShared(ITeamRepository repo, IItem item) throws TeamRepositoryException {
        IItem sharedItem = repo.itemManager().getSharedItemIfKnown((IItemHandle)item);
        if (sharedItem == null) {
            repo.itemManager().fetchCompleteItem((IItemHandle)item, 0, null);
            List shares = repo.itemManager().applyItemUpdates(Collections.singletonList(item));
            sharedItem = (IItem)shares.iterator().next();
            Assert.isNotNull((Object)sharedItem);
        }
        return sharedItem;
    }

    static void makeImmutable(ITeamRepository repository, IVersionableHandle itemHandle) {
        SCMClientUtil.makeImmutable(repository, (EObject)itemHandle, new IdentityHashMap());
    }

    private static void makeImmutable(ITeamRepository repository, EObject eObject, Map visited) {
        if (visited.containsKey(eObject)) {
            return;
        }
        visited.put(eObject, null);
        if (eObject instanceof ItemHandle) {
            ItemHandle itemHandle = (ItemHandle)eObject;
            itemHandle.setOrigin((Object)repository);
            if (itemHandle instanceof Item) {
                Item item = (Item)itemHandle;
                if (!item.isWorkingCopy()) {
                    item.makeImmutable();
                }
                item.protect();
            } else {
                itemHandle.makeImmutable();
                itemHandle.protect();
            }
        }
        Iterator i = eObject.eContents().iterator();
        while (i.hasNext()) {
            SCMClientUtil.makeImmutable(repository, (EObject)i.next(), visited);
        }
        i = eObject.eCrossReferences().iterator();
        while (i.hasNext()) {
            SCMClientUtil.makeImmutable(repository, (EObject)i.next(), visited);
        }
    }
}

