/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.links.client.ILinkEvent;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.client.internal.LinkEvent;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.client.internal.AuditableClient;
import com.ibm.team.workitem.client.internal.DependencyHandler;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.client.internal.ModelPlugin;
import com.ibm.team.workitem.client.internal.UnmergableChangesException;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemSaveTransport;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.internal.WorkingCopyRunnable;
import com.ibm.team.workitem.client.internal.util.EventDispatcher;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.internal.AuditableCommon;
import com.ibm.team.workitem.common.internal.PropertyUtil;
import com.ibm.team.workitem.common.internal.SaveParameter;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.AttributeChangedNotifier;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.model.EnumerationAttributeType;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemReferences;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveParameterDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.RcpFactory;
import com.ibm.team.workitem.common.internal.rcp.dto.SaveParameterDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.SaveResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.StatusResultDTO;
import com.ibm.team.workitem.common.internal.util.DuplicateLinks;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.internal.util.EMFListener;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashMap;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.internal.util.ThreeWayDiffReport;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.ApprovalChangeDetails;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.CommentsChangeDetails;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ListChangeDetails;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class WorkItemWorkingCopyRegistry {
    private static final ItemProfile<IWorkItem> EMPTY_PROFILE = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[0]);
    private static final ItemProfile<IWorkItem> REFERENCES_PROFILE = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, Collections.emptyList(), (boolean)true);
    private final ItemHandleAwareHashMap<IWorkItemHandle, WorkItemWorkingCopyImpl> fWorkingCopies = new ItemHandleAwareHashMap();
    private final ItemHandleAwareHashMap<IWorkItemHandle, Set<ILink>> fLinksCache = new ItemHandleAwareHashMap();
    private final InternalListener fInternalListener = new InternalListener();
    private final InternalAttributeChangedNotfier fInternalNotfier = new InternalAttributeChangedNotfier();
    private final ListenerList fListenerList = new ListenerList();
    private final Map<String, ListenerList> fAttributeListenerMap = new HashMap<String, ListenerList>();
    private final Map<String, ListenerList> fAttributeDependencyListenerMap = new HashMap<String, ListenerList>();
    private final ListenerList fLiveCycleListenerLists = new ListenerList();
    private final Object fCompoundWorkItemChangeLock = new Object();
    private final Map<UUID, Integer> fCompoundWorkItemChangeCounters = new HashMap<UUID, Integer>();
    private final Map<UUID, WorkItemChangeEvent> fCompoundWorkItemChangeEvents = new HashMap<UUID, WorkItemChangeEvent>();
    private final Map<UUID, Integer> fWorkItemChangeModes = Collections.synchronizedMap(new HashMap());
    private final EventDispatcher fEventDispatcher = new EventDispatcher(true);
    private final IAuditableClient fAuditableClient;
    private final WorkItemClient fWorkItemClient;
    private final IWorkItemWorkingCopyManager fSystemWorkingCopyManager;
    private final ItemHandleAwareHashSet<IWorkItemHandle> fDeletedItems;

    public WorkItemWorkingCopyRegistry(WorkItemClient workItemClient) {
        this.fAuditableClient = (IAuditableClient)workItemClient.getTeamRepository().getClientLibrary(IAuditableClient.class);
        this.fWorkItemClient = workItemClient;
        this.fSystemWorkingCopyManager = workItemClient.createWorkingCopyManager(Messages.WorkItemWorkingCopyRegistry_SYSTEM_WORKING_COPY_MANAGER, false);
        this.fDeletedItems = new ItemHandleAwareHashSet();
        ITeamRepository teamRepository = workItemClient.getTeamRepository();
        teamRepository.itemManager().addItemChangeListener(IWorkItem.ITEM_TYPE, (ISharedItemChangeListener)this.fInternalListener);
        ILinkManager linkManager = (ILinkManager)teamRepository.getClientLibrary(ILinkManager.class);
        linkManager.addGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", (IListener)this.fInternalListener);
        linkManager.addGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", (IListener)this.fInternalListener);
        this.addWorkItemListener(new DependencyHandler(workItemClient));
    }

    public void connect(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.connect(manager, handle, profile, false, monitor);
    }

    public void connect(IWorkItemWorkingCopyManager manager, List<? extends IWorkItemHandle> handles, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.connect(manager, handles, profile, false, monitor);
    }

    public void connectCurrent(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.connect(manager, handle, (ItemProfile<IWorkItem>)profile, true, monitor);
    }

    public void connectCurrent(IWorkItemWorkingCopyManager manager, List<? extends IWorkItemHandle> handles, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.connect(manager, handles, profile, true, monitor);
    }

    public IWorkItemHandle connectNew(IWorkItemWorkingCopyManager manager, IWorkItemType workItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemWorkingCopy workingCopy = this.createNewUnconnected(workItemType, monitor);
        this.connectNew(manager, workingCopy, monitor);
        return (IWorkItemHandle)workingCopy.getWorkItem().getItemHandle();
    }

    public WorkItemWorkingCopy createNewUnconnected(IWorkItemType workItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItem workItem = this.fWorkItemClient.createWorkItem(workItemType, monitor);
        return this.createNewUnconnected(workItem);
    }

    public WorkItemWorkingCopy createNewUnconnected(IWorkItem workItem) {
        Assert.isTrue((boolean)workItem.isWorkingCopy());
        return this.createWorkingCopy(workItem, null, null, (IWorkItemReferences)new WorkItemReferences(workItem));
    }

    public void connectNew(IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fDeletedItems.contains((Object)workingCopy.getWorkItem())) {
            throw new TeamRepositoryException(Messages.WorkItemWorkingCopyRegistry_DELETION_ERROR);
        }
        Assert.isTrue((boolean)((WorkItemWorkingCopyManager)manager).isWriteable());
        Assert.isTrue((boolean)this.connectWorkingCopy(manager, (WorkItemWorkingCopyImpl)workingCopy));
    }

    public boolean connectLocal(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, ItemProfile<IWorkItem> profile) {
        return this.connectExisting(manager, handle, profile);
    }

    private IWorkItemReferences createWorkItemReferences(IWorkItem workItem, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((boolean)workItem.isWorkingCopy());
        return new WorkItemReferences(workItem, this.fetchLinks((IWorkItemHandle)workItem, refresh, monitor));
    }

    private List<IWorkItemReferences> createWorkItemReferences(Collection<IWorkItem> workItems, String[] linkTypeIds, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IWorkItem workItem : workItems) {
            Assert.isTrue((boolean)workItem.isWorkingCopy());
        }
        ItemHandleAwareHashMap<IWorkItemHandle, ? extends Collection<ILink>> links = this.fetchLinks(workItems, linkTypeIds, refresh, monitor);
        ArrayList<IWorkItemReferences> result = new ArrayList<IWorkItemReferences>(links.size());
        for (IWorkItem workItem : workItems) {
            List originalLinks = (List)links.get((Object)workItem);
            result.add((IWorkItemReferences)new WorkItemReferences(workItem, Arrays.asList(linkTypeIds), originalLinks != null ? originalLinks : Collections.emptyList()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemHandleAwareHashMap<IWorkItemHandle, ? extends Collection<ILink>> fetchLinks(Collection<? extends IWorkItemHandle> handles, final String[] linkTypeIds, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemHandleAwareHashMap result = new ItemHandleAwareHashMap();
        handles = new ArrayList<IWorkItemHandle>(handles);
        if (!refresh) {
            Iterator<? extends IWorkItemHandle> iter = handles.iterator();
            while (iter.hasNext()) {
                IWorkItemHandle next = iter.next();
                List<ILink> list = this.findCachedLinks(next);
                if (list == null) continue;
                HashSet<String> linkTypIdsAsCollection = new HashSet<String>(Arrays.asList(linkTypeIds));
                for (ILink link : list) {
                    linkTypIdsAsCollection.remove(link.getLinkTypeId());
                }
                if (!linkTypIdsAsCollection.isEmpty()) continue;
                iter.remove();
                result.put((Object)next, (Object)new ItemHandleAwareHashSet(list));
            }
        }
        if (handles.isEmpty()) {
            return result;
        }
        ILinkManager linkManager = (ILinkManager)this.fWorkItemClient.getTeamRepository().getClientLibrary(ILinkManager.class);
        final ArrayList<IItemReference> references = new ArrayList<IItemReference>(handles.size());
        for (IWorkItemHandle iWorkItemHandle : handles) {
            references.add(linkManager.referenceFactory().createReferenceToItem((IItemHandle)iWorkItemHandle));
        }
        ILinkCollection iLinkCollection = (ILinkCollection)((IClientLibraryContext)this.fWorkItemClient.getTeamRepository()).callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ILinkCollection>(){

            public ILinkCollection run(IProgressMonitor monitor) throws TeamRepositoryException {
                ILinkManager linkManager = (ILinkManager)WorkItemWorkingCopyRegistry.this.fWorkItemClient.getTeamRepository().getClientLibrary(ILinkManager.class);
                ILinkCollection links = linkManager.findLinks(linkTypeIds, (IReference[])references.toArray(new IItemReference[references.size()]), monitor).getAllLinksFromHereOn();
                return links;
            }
        }, monitor);
        ItemHandleAwareHashSet thisHandles = new ItemHandleAwareHashSet();
        thisHandles.addAll(handles);
        ArrayList<IItemReference> itemReferences = new ArrayList<IItemReference>();
        for (ILink link : iLinkCollection) {
            if (link.getSourceRef().isItemReference()) {
                itemReferences.add((IItemReference)link.getSourceRef());
            }
            if (!link.getTargetRef().isItemReference()) continue;
            itemReferences.add((IItemReference)link.getTargetRef());
        }
        for (IItemReference reference : itemReferences) {
            IItemHandle key = reference.getReferencedItem();
            if (!thisHandles.contains((Object)key)) continue;
            Set value = (Set)result.get((Object)key);
            if (value == null) {
                value = new ItemHandleAwareHashSet();
                result.put((Object)((IWorkItemHandle)key), (Object)value);
            }
            value.add(reference.getLink());
        }
        for (IWorkItemHandle handle : result.keySet()) {
            ItemHandleAwareHashMap<IWorkItemHandle, Set<ILink>> itemHandleAwareHashMap = this.fLinksCache;
            synchronized (itemHandleAwareHashMap) {
                this.fLinksCache.put((Object)this.handle(handle), (Object)new ItemHandleAwareHashSet((Collection)result.get((Object)handle)));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ILink> fetchLinks(final IWorkItemHandle handle, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        List<ILink> cache = null;
        if (!refresh) {
            cache = this.findCachedLinks(handle);
        }
        if (cache == null) {
            Set set = (Set)((IClientLibraryContext)this.fWorkItemClient.getTeamRepository()).callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Set<ILink>>(){

                public Set<ILink> run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ILinkManager linkManager = (ILinkManager)WorkItemWorkingCopyRegistry.this.fWorkItemClient.getTeamRepository().getClientLibrary(ILinkManager.class);
                    IItemReference reference = linkManager.referenceFactory().createReferenceToItem((IItemHandle)handle);
                    ILinkCollection links = linkManager.findLinks((IReference)reference, monitor).getAllLinksFromHereOn();
                    return new ItemHandleAwareHashSet((Collection)links);
                }
            }, monitor);
            cache = new ArrayList<ILink>(set);
            ItemHandleAwareHashMap<IWorkItemHandle, Set<ILink>> itemHandleAwareHashMap = this.fLinksCache;
            synchronized (itemHandleAwareHashMap) {
                this.fLinksCache.put((Object)this.handle(handle), (Object)set);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ILink> findCachedLinks(IWorkItemHandle handle) {
        ItemHandleAwareHashMap<IWorkItemHandle, Set<ILink>> itemHandleAwareHashMap = this.fLinksCache;
        synchronized (itemHandleAwareHashMap) {
            IAuditableCommon auditableCommon = this.fWorkItemClient.getAuditableCommon();
            for (IWorkItemHandle current : new ArrayList(this.fLinksCache.keySet())) {
                if (auditableCommon.findCachedAuditable((IAuditableHandle)handle, EMPTY_PROFILE) != null) continue;
                this.fLinksCache.remove((Object)current);
            }
            Set cache = (Set)this.fLinksCache.get((Object)handle);
            ArrayList<ILink> arrayList = cache != null ? new ArrayList<ILink>(cache) : null;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemWorkingCopy getWorkingCopy(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle) {
        ItemHandleAwareHashMap<IWorkItemHandle, WorkItemWorkingCopyImpl> itemHandleAwareHashMap = this.fWorkingCopies;
        synchronized (itemHandleAwareHashMap) {
            block4: {
                if (!this.fDeletedItems.contains((Object)handle)) break block4;
                return null;
            }
            WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.fWorkingCopies.get((Object)handle);
            Assert.isNotNull((Object)workingCopy);
            Assert.isTrue((boolean)workingCopy.isConnected(manager));
            return workingCopy;
        }
    }

    public void disconnect(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle) {
        this.disconnect(manager, handle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, boolean canRefresh) {
        WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy(manager, handle);
        if (workingCopy != null && canRefresh && workingCopy.isDirty() && !workingCopy.hasWriteConnectionAfter(manager)) {
            this.refresh(manager, handle);
        }
        ItemHandleAwareHashMap<IWorkItemHandle, WorkItemWorkingCopyImpl> itemHandleAwareHashMap = this.fWorkingCopies;
        synchronized (itemHandleAwareHashMap) {
            workingCopy = (WorkItemWorkingCopyImpl)this.fWorkingCopies.get((Object)handle);
            Assert.isNotNull((Object)workingCopy);
            workingCopy.disconnect(manager);
            if (!workingCopy.isDisconnected()) {
                return;
            }
            this.fDeletedItems.remove((Object)handle);
            this.fWorkingCopies.remove((Object)handle);
        }
        workingCopy.dispose();
        this.fInternalListener.uninstall(workingCopy);
    }

    public void revert(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle) {
        WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, handle);
        if (workingCopy == null || !this.canRefresh(manager, workingCopy)) {
            return;
        }
        try {
            ((WorkItemWorkingCopyImpl)workingCopy).aboutToUpdateBaseState();
            IWorkItem source = ((WorkItemWorkingCopyImpl)workingCopy).getBaseState();
            this.internalRefresh(manager, workingCopy, source, null, false, false);
        }
        finally {
            ((WorkItemWorkingCopyImpl)workingCopy).baseStateUpdated();
        }
    }

    public void refresh(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle) {
        WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, handle);
        if (workingCopy == null || !this.canRefresh(manager, workingCopy)) {
            return;
        }
        try {
            ((WorkItemWorkingCopyImpl)workingCopy).aboutToUpdateBaseState();
            IWorkItem source = ((WorkItemWorkingCopyImpl)workingCopy).getSharedItem();
            this.internalRefresh(manager, workingCopy, source, null, false, false);
        }
        finally {
            ((WorkItemWorkingCopyImpl)workingCopy).baseStateUpdated();
        }
    }

    public void refreshWithCurrent(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.refreshWithCurrent(manager, handle, false, false, false, monitor);
    }

    public void refreshWithCurrent(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, boolean checkNotDirty, IProgressMonitor monitor) throws TeamRepositoryException {
        this.refreshWithCurrent(manager, handle, checkNotDirty, false, false, monitor);
    }

    public void mergeWithCurrent(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, boolean dropUnmergableChanges, IProgressMonitor monitor) throws TeamRepositoryException {
        this.refreshWithCurrent(manager, handle, false, true, dropUnmergableChanges, monitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshWithCurrent(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, boolean checkNotDirty, boolean preserveChanges, boolean dropUnmergableChanges, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, handle);
        if (workingCopy == null || !this.canRefresh(manager, workingCopy, monitor)) {
            return;
        }
        AuditableClient auditableClient = (AuditableClient)this.fWorkItemClient.getAuditableCommon();
        ItemProfile profile = ItemProfile.computeProfile((IAuditable)workingCopy.getWorkItem());
        IWorkItem source = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)handle, profile);
        IWorkItem newer = (IWorkItem)auditableClient.internalFetchNewerAuditable((IAuditableHandle)handle, profile, monitor);
        if (newer != null) {
            source = newer;
        }
        Assert.isNotNull((Object)source);
        List<ILink> links = null;
        if (workingCopy.isReferencesSet()) {
            links = this.fetchLinks((IWorkItemHandle)workingCopy.getWorkItem().getItemHandle(), true, monitor);
        }
        if (!checkNotDirty || !workingCopy.isDirty()) {
            try {
                ((WorkItemWorkingCopyImpl)workingCopy).aboutToUpdateBaseState();
                this.internalRefresh(manager, workingCopy, source, links, preserveChanges, dropUnmergableChanges);
                if (newer == null) return;
                auditableClient.update(Collections.singletonList(newer), monitor).get(0);
                return;
            }
            finally {
                ((WorkItemWorkingCopyImpl)workingCopy).baseStateUpdated();
            }
        } else {
            if (newer == null) return;
            auditableClient.update(Collections.singletonList(newer), monitor).get(0);
        }
    }

    private void refreshWithCurrent(IWorkItemWorkingCopyManager manager, List<? extends IWorkItemHandle> handles, boolean checkNotDirty, boolean preserveChanges, boolean dropUnmergableChanges, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<WorkItemWorkingCopy> workingCopies = new ArrayList<WorkItemWorkingCopy>(handles.size());
        handles = new ArrayList<IWorkItemHandle>(handles);
        ListIterator<? extends IWorkItemHandle> iter = handles.listIterator();
        while (iter.hasNext()) {
            WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, iter.next());
            if (!this.canRefresh(manager, workingCopy, monitor)) {
                iter.remove();
                continue;
            }
            workingCopies.add(workingCopy);
        }
        Assert.isTrue((workingCopies.size() == handles.size() ? 1 : 0) != 0);
        if (workingCopies.isEmpty()) {
            return;
        }
        ItemProfile profile = null;
        for (WorkItemWorkingCopy workingCopy : workingCopies) {
            ItemProfile thisProfile = ItemProfile.computeProfile((IAuditable)workingCopy.getWorkItem());
            profile = profile == null ? thisProfile : profile.createExtension(thisProfile.getProperties(), thisProfile.getReferences());
        }
        Assert.isNotNull(profile);
        ItemHandleAwareHashMap<IWorkItemHandle, ? extends Collection<ILink>> allLinks = null;
        if (profile.containsReferences()) {
            allLinks = this.fetchLinks(handles, profile.getReferencesArray(), true, monitor);
        }
        AuditableClient auditableClient = (AuditableClient)this.fWorkItemClient.getAuditableCommon();
        List anyNewer = auditableClient.internalFetchNewerAuditable(handles, profile, monitor);
        iter = handles.listIterator();
        while (iter.hasNext()) {
            int index = iter.nextIndex();
            IWorkItemHandle handle = iter.next();
            IWorkItem source = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)handle, profile);
            IWorkItem newer = (IWorkItem)anyNewer.get(index);
            if (newer != null) {
                source = newer;
            }
            Assert.isNotNull((Object)source);
            WorkItemWorkingCopy workingCopy = (WorkItemWorkingCopy)workingCopies.get(index);
            if (!checkNotDirty || !workingCopy.isDirty()) {
                try {
                    ((WorkItemWorkingCopyImpl)workingCopy).aboutToUpdateBaseState();
                    ArrayList<ILink> links = null;
                    if (allLinks != null) {
                        links = new ArrayList<ILink>();
                        links.addAll((Collection)allLinks.get((Object)workingCopy.getWorkItem().getItemHandle()));
                    }
                    this.internalRefresh(manager, workingCopy, source, links, preserveChanges, dropUnmergableChanges);
                    if (newer == null) continue;
                    auditableClient.update(Collections.singletonList(newer), monitor).get(0);
                    continue;
                }
                finally {
                    ((WorkItemWorkingCopyImpl)workingCopy).baseStateUpdated();
                }
            }
            if (newer == null) continue;
            auditableClient.update(Collections.singletonList(newer), monitor).get(0);
        }
    }

    public void internalRefresh(IWorkItemWorkingCopyManager manager, IWorkItem source) {
        WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, (IWorkItemHandle)source);
        if (!this.canRefresh(manager, workingCopy)) {
            return;
        }
        try {
            ((WorkItemWorkingCopyImpl)workingCopy).aboutToUpdateBaseState();
            this.internalRefresh(manager, workingCopy, source, null, false, false);
        }
        finally {
            ((WorkItemWorkingCopyImpl)workingCopy).baseStateUpdated();
        }
    }

    private boolean canRefresh(IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy workingCopy) {
        if (workingCopy.getWorkItem().isNewItem()) {
            return false;
        }
        return ((WorkItemWorkingCopyManager)manager).isWriteable() || !((WorkItemWorkingCopyImpl)workingCopy).hasWriteConnection();
    }

    private boolean canRefresh(IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workingCopy.getWorkItem().isNewItem() && !WorkItemQueries.exists((IAuditableCommon)this.fWorkItemClient.getAuditableCommon(), (IAuditableHandle)((IWorkItemHandle)workingCopy.getWorkItem().getItemHandle())).hasNext(monitor)) {
            return false;
        }
        return ((WorkItemWorkingCopyManager)manager).isWriteable() || !((WorkItemWorkingCopyImpl)workingCopy).hasWriteConnection();
    }

    private boolean stillCanRefresh(IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy workingCopy) {
        return ((WorkItemWorkingCopyManager)manager).isWriteable() || !((WorkItemWorkingCopyImpl)workingCopy).hasWriteConnection();
    }

    private void internalRefresh(final IWorkItemWorkingCopyManager manager, final WorkItemWorkingCopy workingCopy, final IWorkItem source, final List<ILink> links, final boolean preserveChanges, final boolean dropUnmergableChanges) {
        ((WorkItemWorkingCopyImpl)workingCopy).write(new WorkingCopyRunnable<Void>(){
            boolean fCanceled = false;
            boolean fSuccess = false;

            @Override
            public Void run() {
                if (!WorkItemWorkingCopyRegistry.this.stillCanRefresh(manager, workingCopy)) {
                    this.fCanceled = true;
                    return null;
                }
                IWorkItem workItem = workingCopy.getWorkItem();
                WorkItemWorkingCopyRegistry.this.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                WorkItemWorkingCopyRegistry.this.beginRemoteWorkItemChange((IWorkItemHandle)workItem);
                List tmpLinks = links;
                if (workingCopy.isReferencesSet() && tmpLinks == null) {
                    tmpLinks = ((WorkItemReferences)workingCopy.getReferences()).getOriginalLinks();
                }
                WorkItemWorkingCopyRegistry.this.remoteUpdate(manager, workingCopy, source, tmpLinks, preserveChanges, dropUnmergableChanges);
                this.fSuccess = true;
                return null;
            }

            @Override
            public void runFinally() {
                if (this.fCanceled) {
                    return;
                }
                IWorkItem workItem = workingCopy.getWorkItem();
                WorkItemWorkingCopyRegistry.this.endRemoteWorkItemChange((IWorkItemHandle)workItem);
                WorkItemWorkingCopyRegistry.this.endCompoundWorkItemChange((IWorkItemHandle)workItem);
                if (!preserveChanges && this.fSuccess) {
                    ((WorkItemWorkingCopyImpl)workingCopy).reverted();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyLinksUpdate(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, List<ILink> links) {
        boolean connected = this.connectExisting(manager, handle, EMPTY_PROFILE);
        if (!connected) {
            return;
        }
        WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, handle);
        if (workingCopy == null) {
            return;
        }
        if (!workingCopy.isReferencesSet()) {
            ItemHandleAwareHashMap<IWorkItemHandle, Set<ILink>> itemHandleAwareHashMap = this.fLinksCache;
            synchronized (itemHandleAwareHashMap) {
                this.fLinksCache.put((Object)this.handle(handle), (Object)new ItemHandleAwareHashSet(links));
            }
            try {
                this.beginUpgradeWorkItemChange((IWorkItemHandle)workingCopy.getWorkItem());
                ((WorkItemWorkingCopyImpl)workingCopy).setReferences((IWorkItemReferences)new WorkItemReferences(workingCopy.getWorkItem(), links));
            }
            finally {
                this.endUpgradeWorkItemChange((IWorkItemHandle)workingCopy.getWorkItem());
                this.disconnect(manager, handle);
            }
        }
        try {
            this.beginRemoteWorkItemChange((IWorkItemHandle)workingCopy.getWorkItem());
            this.remoteUpdate(manager, workingCopy.getReferences(), links, true);
        }
        finally {
            this.endRemoteWorkItemChange((IWorkItemHandle)workingCopy.getWorkItem());
            this.disconnect(manager, handle);
        }
    }

    private void remoteUpdate(IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy workingCopy, IWorkItem source, List<ILink> links, boolean preserveChanges, boolean dropUnmergableChanges) {
        IWorkItem target = workingCopy.getWorkItem();
        IWorkItem oldBaseState = ((WorkItemWorkingCopyImpl)workingCopy).getBaseState();
        IWorkItem newBaseState = (IWorkItem)EcoreUtil.copy((EObject)((EObject)source));
        IWorkItem newBaseStateCopy = (IWorkItem)source.getWorkingCopy();
        Assert.isTrue((boolean)ItemProfile.computeProfile((IAuditable)target).isMatched((IAuditable)newBaseStateCopy), (String)"Source profile must match target profile");
        if (preserveChanges && workingCopy.isDirty() && !dropUnmergableChanges && oldBaseState == null) {
            throw new UnmergableChangesException();
        }
        if (!preserveChanges || !workingCopy.isDirty() || oldBaseState == null) {
            ArrayList<Object> exclusions = new ArrayList<Object>();
            EClass eClass = ((EObject)target).eClass();
            exclusions.add(RepositoryPackage.eINSTANCE.getItemHandle_Immutable());
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (((EObject)target).eIsSet(feature)) continue;
                exclusions.add(feature);
            }
            ((WorkItemWorkingCopyImpl)workingCopy).setBaseState(newBaseState);
            this.copyModifiedValues(newBaseStateCopy, source);
            EMFHelper.merge((EObject)((EObject)target), (EObject)((EObject)newBaseStateCopy), exclusions);
        } else if (!newBaseState.sameStateId((IItemHandle)oldBaseState)) {
            boolean resetWorkflowAction;
            ThreeWayDiffReport report = new ThreeWayDiffReport((IAuditable)((IWorkItem)oldBaseState.getWorkingCopy()), (IAuditable)target, (IAuditable)newBaseStateCopy);
            boolean bl = resetWorkflowAction = workingCopy.getWorkflowAction() != null && report.isIncomingOrConflicting((EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_InternalState());
            if (!(dropUnmergableChanges || !resetWorkflowAction && report.mergePreservesOutgoing())) {
                throw new UnmergableChangesException();
            }
            if (resetWorkflowAction) {
                workingCopy.setWorkflowAction(null);
            }
            ((WorkItemWorkingCopyImpl)workingCopy).setBaseState(newBaseState);
            report.merge();
        }
        if (workingCopy.isReferencesSet() && links != null) {
            this.remoteUpdate(manager, workingCopy.getReferences(), links, preserveChanges);
        }
    }

    private void remoteUpdate(IWorkItemWorkingCopyManager manager, IWorkItemReferences references, List<ILink> updatedLinks, boolean preserveChanges) {
        List originalLinks = ((WorkItemReferences)references).getOriginalLinks();
        ItemHandleAwareHashSet added = new ItemHandleAwareHashSet(updatedLinks);
        added.removeAll(originalLinks);
        ItemHandleAwareHashSet removed = new ItemHandleAwareHashSet((Collection)originalLinks);
        removed.removeAll(updatedLinks);
        ((WorkItemReferences)references).remoteUpdate(updatedLinks, preserveChanges);
        EventSource eventSource = null;
        ILinkManager linkManager = (ILinkManager)this.fWorkItemClient.getTeamRepository().getClientLibrary(ILinkManager.class);
        if (linkManager instanceof EventSource) {
            eventSource = (EventSource)linkManager;
        }
        try {
            if (eventSource != null) {
                eventSource.acquire();
            }
            for (ILink link : added) {
                this.handleAddedLink(manager, link);
                if (eventSource == null) continue;
                eventSource.queueEvent((Object)new LinkEvent((IEventSource)linkManager, "com.ibm.team.links.LinkSaveEvent", link));
            }
            for (ILink link : removed) {
                this.handleRemovedLink(manager, link);
                if (eventSource == null) continue;
                eventSource.queueEvent((Object)new LinkEvent((IEventSource)linkManager, "com.ibm.team.links.LinkDeletedEvent", link));
            }
        }
        finally {
            if (eventSource != null) {
                eventSource.release();
            }
        }
    }

    private void handleAddedLink(IWorkItemWorkingCopyManager manager, ILink link) {
        IWorkItemHandle targetHandle;
        IWorkItemHandle sourceHandle = this.findWorkItemHandle(link.getSourceRef());
        if (sourceHandle != null) {
            this.addReference(manager, sourceHandle, link.getTargetRef());
        }
        if ((targetHandle = this.findWorkItemHandle(link.getTargetRef())) != null && !targetHandle.sameItemId((IItemHandle)sourceHandle)) {
            this.addReference(manager, targetHandle, link.getSourceRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReference(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, IReference reference) {
        ItemHandleAwareHashMap<IWorkItemHandle, Set<ILink>> itemHandleAwareHashMap = this.fLinksCache;
        synchronized (itemHandleAwareHashMap) {
            Set cache = (Set)this.fLinksCache.get((Object)handle);
            if (cache != null) {
                cache.add(reference.getLink());
            }
        }
        boolean connected = this.connectExisting(manager, handle, REFERENCES_PROFILE);
        if (!connected) {
            return;
        }
        WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, handle);
        int mode = this.getWorkItemChangeMode(handle);
        try {
            if (mode != 2) {
                this.beginRemoteWorkItemChange(handle);
            }
            ((WorkItemReferences)workingCopy.getReferences()).remoteAdd(reference);
        }
        finally {
            if (mode != 2) {
                this.endRemoteWorkItemChange(handle);
            }
            this.disconnect(manager, handle);
        }
    }

    private void handleRemovedLink(IWorkItemWorkingCopyManager manager, ILink link) {
        IWorkItemHandle targetHandle;
        IWorkItemHandle sourceHandle = this.findWorkItemHandle(link.getSourceRef());
        if (sourceHandle != null) {
            this.removeReference(manager, sourceHandle, link.getTargetRef());
        }
        if ((targetHandle = this.findWorkItemHandle(link.getTargetRef())) != null) {
            this.removeReference(manager, targetHandle, link.getSourceRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReference(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, IReference reference) {
        ItemHandleAwareHashMap<IWorkItemHandle, Set<ILink>> itemHandleAwareHashMap = this.fLinksCache;
        synchronized (itemHandleAwareHashMap) {
            Set cache = (Set)this.fLinksCache.get((Object)handle);
            if (cache != null) {
                cache.remove(reference.getLink());
            }
        }
        boolean connected = this.connectExisting(manager, handle, REFERENCES_PROFILE);
        if (!connected) {
            return;
        }
        WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, handle);
        int mode = this.getWorkItemChangeMode(handle);
        try {
            if (mode != 2) {
                this.beginRemoteWorkItemChange(handle);
            }
            ((WorkItemReferences)workingCopy.getReferences()).remoteRemove(reference);
        }
        finally {
            if (mode != 2) {
                this.endRemoteWorkItemChange(handle);
            }
            this.disconnect(manager, handle);
        }
    }

    private IWorkItemHandle findWorkItemHandle(IReference reference) {
        if (reference.isItemReference() && ((IItemReference)reference).getReferencedItem() instanceof IWorkItemHandle) {
            return (IWorkItemHandle)((IItemReference)reference).getReferencedItem();
        }
        return null;
    }

    private void connect(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, ItemProfile<IWorkItem> profile, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemWorkingCopyImpl workingCopy;
        Assert.isTrue((boolean)handle.getItemType().equals(profile.getItemType()));
        if (this.fDeletedItems.contains((Object)handle)) {
            throw new TeamRepositoryException(Messages.WorkItemWorkingCopyRegistry_DELETION_ERROR);
        }
        boolean connected = this.connectExisting(manager, handle, EMPTY_PROFILE);
        if (connected) {
            workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy(manager, handle);
            if (this.matchesProfile(workingCopy, profile)) {
                if (refresh && !workingCopy.hasOtherWriteConnection(manager)) {
                    this.refreshWithCurrent(manager, handle, true, monitor);
                }
                return;
            }
        } else {
            boolean succeeded;
            IWorkItem workItem = refresh ? this.fWorkItemClient.fetchCurrentWorkItem(handle, profile, monitor) : this.fWorkItemClient.resolveWorkItem(handle, profile, monitor);
            IWorkItem copy = (IWorkItem)workItem.getWorkingCopy();
            IWorkItemReferences references = null;
            if (profile.containsReferences()) {
                references = this.createWorkItemReferences(copy, refresh, monitor);
            }
            if (succeeded = this.connectWorkingCopy(manager, workingCopy = this.createWorkingCopy(copy, workItem, (IWorkItem)EcoreUtil.copy((EObject)((EObject)workItem)), references))) {
                return;
            }
        }
        try {
            this.upgradeWorkingCopy(manager, handle, profile, monitor);
            Assert.isTrue((boolean)this.connectExisting(manager, handle, profile));
        }
        finally {
            this.disconnect(manager, handle);
        }
        if (refresh && !workingCopy.hasOtherWriteConnection(manager)) {
            this.refreshWithCurrent(manager, handle, true, monitor);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void connect(IWorkItemWorkingCopyManager manager, List<? extends IWorkItemHandle> handles, ItemProfile<IWorkItem> profile, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IWorkItemHandle cur : handles) {
            Assert.isTrue((boolean)cur.getItemType().equals(profile.getItemType()));
            if (!this.fDeletedItems.contains((Object)cur)) continue;
            throw new TeamRepositoryException(Messages.WorkItemWorkingCopyRegistry_DELETION_ERROR);
        }
        workingCopies = new ArrayList<WorkItemWorkingCopyImpl>(handles.size());
        handles = new ArrayList<IWorkItemHandle>(handles);
        iter = handles.iterator();
        while (iter.hasNext()) {
            handle = iter.next();
            connected = this.connectExisting(manager, handle, WorkItemWorkingCopyRegistry.EMPTY_PROFILE);
            if (!connected || this.matchesProfile(workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy(manager, handle), profile)) continue;
            iter.remove();
            workingCopies.add(workingCopy);
        }
        workItems = refresh != false ? this.fAuditableClient.fetchCurrentAuditables(handles, profile, monitor) : this.fAuditableClient.resolveAuditables(handles, profile, monitor);
        copies = new ArrayList<IWorkItem>(workItems.size());
        for (IWorkItem workItem : workItems) {
            copies.add((IWorkItem)workItem.getWorkingCopy());
        }
        workItemReferences = profile.containsReferences() != false ? this.createWorkItemReferences(copies, profile.getReferencesArray(), refresh, monitor) : null;
        Assert.isTrue((boolean)(workItemReferences == null || workItemReferences.size() == workItems.size()));
        listIter = workItems.listIterator();
        while (listIter.hasNext()) {
            index = listIter.nextIndex();
            workItem = (IWorkItem)listIter.next();
            copy = (IWorkItem)workItem.getWorkingCopy();
            references = null;
            if (workItemReferences != null) {
                references = workItemReferences.get(index);
            }
            if (succeeded = this.connectWorkingCopy(manager, workingCopy = this.createWorkingCopy(copy, workItem, (IWorkItem)EcoreUtil.copy((EObject)((EObject)workItem)), references))) continue;
            workingCopies.add(workingCopy);
        }
        upgradeHandles = new ArrayList<IWorkItem>();
        for (WorkItemWorkingCopyImpl workingCopy : workingCopies) {
            upgradeHandles.add(workingCopy.getWorkItem());
        }
        try {
            this.upgradeWorkingCopy(manager, upgradeHandles, profile, monitor);
            for (IWorkItemHandle handle : upgradeHandles) {
                Assert.isTrue((boolean)this.connectExisting(manager, handle, profile));
            }
        }
        finally {
            ** for (handle : upgradeHandles)
        }
lbl-1000:
        // 1 sources

        {
            this.disconnect(manager, handle);
            continue;
        }
lbl54:
        // 1 sources

        if (refresh) {
            toRefresh = new ArrayList<IWorkItem>();
            for (WorkItemWorkingCopyImpl workingCopy : workingCopies) {
                if (workingCopy.hasOtherWriteConnection(manager)) continue;
                toRefresh.add(workingCopy.getWorkItem());
            }
            this.refreshWithCurrent(manager, toRefresh, true, false, false, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectExisting(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, ItemProfile<IWorkItem> profile) {
        ItemHandleAwareHashMap<IWorkItemHandle, WorkItemWorkingCopyImpl> itemHandleAwareHashMap = this.fWorkingCopies;
        synchronized (itemHandleAwareHashMap) {
            WorkItemWorkingCopyImpl workingCopy;
            block4: {
                workingCopy = (WorkItemWorkingCopyImpl)this.fWorkingCopies.get((Object)handle);
                if (!this.fDeletedItems.contains((Object)handle) && workingCopy != null && this.matchesProfile(workingCopy, profile)) break block4;
                return false;
            }
            workingCopy.connect(manager);
            return true;
        }
    }

    private boolean matchesProfile(WorkItemWorkingCopyImpl workingCopy, ItemProfile<IWorkItem> profile) {
        return this.computeMissingProperties((IAuditable)workingCopy.getWorkItem(), profile).isEmpty() && this.computeMissingReferences(workingCopy, profile).isEmpty();
    }

    private WorkItemWorkingCopyImpl createWorkingCopy(IWorkItem copy, IWorkItem sharedItem, IWorkItem baseState, IWorkItemReferences references) {
        Assert.isTrue((boolean)copy.isWorkingCopy());
        Assert.isTrue((sharedItem == null || !sharedItem.isWorkingCopy() ? 1 : 0) != 0);
        Assert.isTrue((boolean)(copy.isNewItem() ^ sharedItem != null));
        Assert.isTrue((baseState == null || !baseState.isWorkingCopy() && baseState.getStateId().equals((Object)((WorkItem)copy).getWorkingCopyPredecessor()) ? 1 : 0) != 0);
        Assert.isTrue((boolean)(copy.isNewItem() ^ baseState != null));
        WorkItemWorkingCopyImpl workingCopy = new WorkItemWorkingCopyImpl(copy);
        workingCopy.setReferences(references);
        if (!copy.isNewItem()) {
            workingCopy.setSharedItem(sharedItem);
            workingCopy.setBaseState(baseState);
            this.copyModifiedValues(workingCopy.getWorkItem(), sharedItem);
        } else {
            workingCopy.setNewItemBaseState((IWorkItem)EcoreUtil.copy((EObject)((EObject)copy)));
        }
        return workingCopy;
    }

    private void copyModifiedValues(IWorkItem to, IWorkItem from) {
        Timestamp modified = ((Item)from).getModified();
        ((Item)to).setModified(modified);
        IContributorHandle modifier = ((Item)from).getModifiedBy();
        ((Item)to).setModifiedBy(modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectWorkingCopy(IWorkItemWorkingCopyManager manager, WorkItemWorkingCopyImpl workingCopy) {
        ItemHandleAwareHashMap<IWorkItemHandle, WorkItemWorkingCopyImpl> itemHandleAwareHashMap = this.fWorkingCopies;
        synchronized (itemHandleAwareHashMap) {
            IWorkItemHandle handle;
            block4: {
                handle = (IWorkItemHandle)workingCopy.getWorkItem().getItemHandle();
                WorkItemWorkingCopyImpl existing = (WorkItemWorkingCopyImpl)this.fWorkingCopies.get((Object)handle);
                if (existing == null) break block4;
                existing.connect(manager);
                return false;
            }
            this.fWorkingCopies.put((Object)handle, (Object)workingCopy);
            this.fInternalListener.install(workingCopy);
            workingCopy.connect(manager);
            return true;
        }
    }

    private void upgradeWorkingCopy(IWorkItemWorkingCopyManager manager, List<? extends IWorkItemHandle> handles, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        int i = 0;
        while (i < 5) {
            boolean restart = this.doUpgradeWorkingCopy(manager, handles, profile, monitor);
            if (!restart) {
                return;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    private boolean doUpgradeWorkingCopy(IWorkItemWorkingCopyManager manager, List<? extends IWorkItemHandle> handles, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        final boolean[] restart = new boolean[1];
        final HashSet<String> missingProperties = new HashSet<String>();
        ItemHandleAwareHashSet workItemMissingReferences = new ItemHandleAwareHashSet();
        HashSet allMissingReferences = new HashSet();
        HashMap<UUID, WorkItemWorkingCopy> workingCopies = new HashMap<UUID, WorkItemWorkingCopy>();
        HashMap<UUID, IWorkItem> workItems = new HashMap<UUID, IWorkItem>();
        HashMap<UUID, IWorkItem> patchMap = null;
        HashMap<UUID, WorkItemReferences> referencesMap = null;
        for (IWorkItemHandle iWorkItemHandle : handles) {
            WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, iWorkItemHandle);
            IWorkItem workItem = workingCopy.getWorkItem();
            UUID key = iWorkItemHandle.getItemId();
            workingCopies.put(key, workingCopy);
            workItems.put(key, workItem);
            missingProperties.addAll(this.computeMissingProperties((IAuditable)workItem, profile));
            List<String> missingReferences = this.computeMissingReferences(workingCopy, profile);
            if (missingReferences.isEmpty()) continue;
            allMissingReferences.addAll(missingReferences);
            workItemMissingReferences.add((Object)workItem);
        }
        if (!missingProperties.isEmpty() || !workItemMissingReferences.isEmpty()) {
            WorkItemWorkingCopy workingCopy;
            if (!missingProperties.isEmpty()) {
                ITeamRepository iTeamRepository = this.fWorkItemClient.getTeamRepository();
                IAuditableClient auditableClient = (IAuditableClient)iTeamRepository.getClientLibrary(IAuditableClient.class);
                ArrayList itemHandes = new ArrayList(missingProperties.size());
                ArrayList<IWorkItemHandle> stateHandles = new ArrayList<IWorkItemHandle>(missingProperties.size());
                for (final IWorkItem workItem : workItems.values()) {
                    itemHandes.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)this.fWorkItemClient.getTeamRepository(), workItem.getItemId(), null));
                    stateHandles.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)this.fWorkItemClient.getTeamRepository(), workItem.getItemId(), ((Auditable)workItem).getWorkingCopyPredecessor()));
                }
                patchMap = new HashMap<UUID, IWorkItem>();
                List patches = auditableClient.resolveAuditables(itemHandes, profile, monitor);
                Iterator iter = patches.listIterator();
                int offset = 0;
                while (iter.hasNext()) {
                    int index = iter.nextIndex() - offset;
                    IWorkItem patch = (IWorkItem)iter.next();
                    Assert.isTrue((boolean)((IWorkItemHandle)stateHandles.get(index)).sameItemId((IItemHandle)patch));
                    if (((IWorkItemHandle)stateHandles.get(index)).sameStateId((IItemHandle)patch)) {
                        stateHandles.remove(index);
                        ++offset;
                        patch = (IWorkItem)EMFHelper.copy((Object)patch);
                    }
                    patchMap.put(patch.getItemId(), patch);
                }
                patches = iTeamRepository.itemManager().fetchPartialStates(stateHandles, missingProperties, monitor);
                for (IWorkItem patch : patches) {
                    patch = (IWorkItem)EMFHelper.copy((Object)patch);
                    IWorkItem old = patchMap.put(patch.getItemId(), patch);
                    Assert.isNotNull((Object)old);
                    Assert.isTrue((boolean)old.sameItemId((IItemHandle)patch));
                }
            }
            if (!workItemMissingReferences.isEmpty()) {
                referencesMap = new HashMap<UUID, WorkItemReferences>();
                ItemHandleAwareHashMap<IWorkItemHandle, ? extends Collection<ILink>> itemHandleAwareHashMap = this.fetchLinks((Collection<? extends IWorkItemHandle>)workItemMissingReferences, allMissingReferences.toArray(new String[allMissingReferences.size()]), false, monitor);
                for (IWorkItem workItem : workItemMissingReferences) {
                    WorkItemReferences references;
                    workingCopy = (WorkItemWorkingCopy)workingCopies.get(workItem.getItemId());
                    List originalLinks = (List)itemHandleAwareHashMap.get((Object)workItem);
                    if (workingCopy.isReferencesSet()) {
                        references = (WorkItemReferences)workingCopy.getReferences();
                        ItemHandleAwareHashSet mergedLinks = new ItemHandleAwareHashSet((Collection)references.getOriginalLinks());
                        if (originalLinks != null) {
                            mergedLinks.addAll(originalLinks);
                        }
                        HashSet linkTypeIds = new HashSet(references.getOriginalLinkTypeIds());
                        linkTypeIds.addAll(profile.getReferences());
                        references = new WorkItemReferences(workItem, linkTypeIds, (Collection)mergedLinks, (Collection)references.getCreatedLinks(), (Collection)references.getDeletedLinks());
                    } else {
                        references = new WorkItemReferences(workItem, profile.getReferences(), originalLinks != null ? originalLinks : Collections.emptyList());
                    }
                    referencesMap.put(workItem.getItemId(), references);
                }
            }
            for (IWorkItemHandle iWorkItemHandle : handles) {
                IWorkItem workItem;
                UUID key = iWorkItemHandle.getItemId();
                workingCopy = (WorkItemWorkingCopy)workingCopies.get(key);
                workItem = (IWorkItem)workItems.get(key);
                final IWorkItem finalPatch = patchMap != null ? (IWorkItem)patchMap.get(key) : null;
                final IWorkItemReferences links = referencesMap != null ? (IWorkItemReferences)referencesMap.get(key) : null;
                ((WorkItemWorkingCopyImpl)workingCopy).write(new WorkingCopyRunnable<Void>(){

                    @Override
                    public Void run() {
                        IWorkItemHandle stateHandle;
                        if (finalPatch != null && !(stateHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)WorkItemWorkingCopyRegistry.this.fWorkItemClient.getTeamRepository(), workItem.getItemId(), ((Auditable)workItem).getWorkingCopyPredecessor())).sameStateId((IItemHandle)finalPatch)) {
                            restart[0] = true;
                            return null;
                        }
                        WorkItemWorkingCopyRegistry.this.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                        WorkItemWorkingCopyRegistry.this.beginUpgradeWorkItemChange((IWorkItemHandle)workItem);
                        ItemUtil.unprotect((ItemHandle)((ItemHandle)workItem));
                        if (finalPatch != null) {
                            IAuditable workingCopyPatch = (IAuditable)finalPatch.getWorkingCopy();
                            IAuditable baseStatePatch = (IAuditable)EMFHelper.copy((Object)finalPatch);
                            IWorkItem baseState = ((WorkItemWorkingCopyImpl)workingCopy).getBaseState();
                            for (String property : missingProperties) {
                                WorkItemWorkingCopyRegistry.this.set((IAuditable)workItem, property, PropertyUtil.get((IAuditable)workingCopyPatch, (String)property));
                                WorkItemWorkingCopyRegistry.this.set((IAuditable)baseState, property, PropertyUtil.get((IAuditable)baseStatePatch, (String)property));
                            }
                        }
                        if (links != null) {
                            ((WorkItemWorkingCopyImpl)workingCopy).setReferences(links);
                        }
                        return null;
                    }

                    @Override
                    public void runFinally() {
                        if (restart[0]) {
                            return;
                        }
                        WorkItemWorkingCopyRegistry.this.endUpgradeWorkItemChange((IWorkItemHandle)workItem);
                        WorkItemWorkingCopyRegistry.this.endCompoundWorkItemChange((IWorkItemHandle)workItem);
                    }
                });
            }
        }
        return restart[0];
    }

    private void upgradeWorkingCopy(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        int i = 0;
        while (i < 5) {
            boolean restart = this.doUpgradeWorkingCopy(manager, handle, profile, monitor);
            if (!restart) {
                return;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    private boolean doUpgradeWorkingCopy(IWorkItemWorkingCopyManager manager, IWorkItemHandle handle, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean missingReferences;
        final boolean[] restart = new boolean[1];
        final WorkItemWorkingCopy workingCopy = this.getWorkingCopy(manager, handle);
        final IWorkItem workItem = workingCopy.getWorkItem();
        final List<String> missing = this.computeMissingProperties((IAuditable)workItem, profile);
        boolean bl = missingReferences = !this.computeMissingReferences(workingCopy, profile).isEmpty();
        if (!missing.isEmpty() || missingReferences) {
            WorkItemReferences links;
            EObject patch = null;
            if (!missing.isEmpty()) {
                ITeamRepository teamRepository = this.fWorkItemClient.getTeamRepository();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                IWorkItemHandle itemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)this.fWorkItemClient.getTeamRepository(), workItem.getItemId(), null);
                IWorkItemHandle stateHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)this.fWorkItemClient.getTeamRepository(), workItem.getItemId(), ((Auditable)workItem).getWorkingCopyPredecessor());
                if (!stateHandle.sameStateId((IItemHandle)((IWorkItem)(patch = (EObject)auditableClient.resolveAuditable((IAuditableHandle)itemHandle, profile, monitor))))) {
                    patch = (EObject)teamRepository.itemManager().fetchPartialState((IAuditableHandle)stateHandle, missing, monitor);
                }
                patch = (EObject)EMFHelper.copy((Object)patch);
            }
            if (missingReferences) {
                WorkItemReferences references;
                HashSet linkTypeIds = new HashSet();
                linkTypeIds.addAll(profile.getReferences());
                ItemHandleAwareHashSet mergedLinks = new ItemHandleAwareHashSet();
                List<ILink> originalLinks = this.fetchLinks((IWorkItemHandle)workItem, false, monitor);
                if (originalLinks != null) {
                    mergedLinks.addAll(originalLinks);
                }
                WorkItemReferences workItemReferences = references = workingCopy.isReferencesSet() ? (WorkItemReferences)workingCopy.getReferences() : null;
                if (references != null) {
                    mergedLinks.addAll(references.getOriginalLinks());
                    linkTypeIds.addAll(references.getOriginalLinkTypeIds());
                    links = new WorkItemReferences(workItem, linkTypeIds, (Collection)mergedLinks, (Collection)references.getCreatedLinks(), (Collection)references.getDeletedLinks());
                } else {
                    links = new WorkItemReferences(workItem, linkTypeIds, (Collection)mergedLinks);
                }
            } else {
                links = null;
            }
            final EObject finalPatch = patch;
            ((WorkItemWorkingCopyImpl)workingCopy).write(new WorkingCopyRunnable<Void>(){

                @Override
                public Void run() {
                    IWorkItemHandle stateHandle;
                    if (finalPatch != null && !(stateHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)WorkItemWorkingCopyRegistry.this.fWorkItemClient.getTeamRepository(), workItem.getItemId(), ((Auditable)workItem).getWorkingCopyPredecessor())).sameStateId((IItemHandle)((IWorkItem)finalPatch))) {
                        restart[0] = true;
                        return null;
                    }
                    WorkItemWorkingCopyRegistry.this.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                    WorkItemWorkingCopyRegistry.this.beginUpgradeWorkItemChange((IWorkItemHandle)workItem);
                    ItemUtil.unprotect((ItemHandle)((ItemHandle)workItem));
                    if (finalPatch != null) {
                        IAuditable workingCopyPatch = (IAuditable)((IWorkItem)finalPatch).getWorkingCopy();
                        IAuditable baseStatePatch = (IAuditable)EMFHelper.copy((Object)finalPatch);
                        IWorkItem baseState = ((WorkItemWorkingCopyImpl)workingCopy).getBaseState();
                        for (String property : missing) {
                            WorkItemWorkingCopyRegistry.this.set((IAuditable)workItem, property, PropertyUtil.get((IAuditable)workingCopyPatch, (String)property));
                            WorkItemWorkingCopyRegistry.this.set((IAuditable)baseState, property, PropertyUtil.get((IAuditable)baseStatePatch, (String)property));
                        }
                    }
                    if (links != null) {
                        ((WorkItemWorkingCopyImpl)workingCopy).setReferences(links);
                    }
                    return null;
                }

                @Override
                public void runFinally() {
                    if (restart[0]) {
                        return;
                    }
                    WorkItemWorkingCopyRegistry.this.endUpgradeWorkItemChange((IWorkItemHandle)workItem);
                    WorkItemWorkingCopyRegistry.this.endCompoundWorkItemChange((IWorkItemHandle)workItem);
                }
            });
        }
        return restart[0];
    }

    private void set(IAuditable object, String propertyName, Object value) {
        EStructuralFeature structuralFeature = PropertyUtil.getFeature((IAuditable)object, (String)propertyName);
        if (structuralFeature.isMany() && value instanceof List) {
            List target = (List)PropertyUtil.get((IAuditable)object, (String)propertyName);
            target.clear();
            ArrayList list = (ArrayList)value;
            if (PropertyUtil.isContainment((EStructuralFeature)structuralFeature)) {
                list = new ArrayList(list);
            }
            for (Object element : list) {
                if (element instanceof Helper) {
                    UUID uuid = ((Helper)element).getInternalId();
                    target.add(element);
                    ((Helper)element).setInternalId(uuid);
                    continue;
                }
                target.add(element);
            }
        } else {
            PropertyUtil.set((IAuditable)object, (String)propertyName, (Object)value);
        }
    }

    private List<String> computeMissingProperties(IAuditable item, ItemProfile<IWorkItem> profile) {
        if (profile.getProperties().isEmpty()) {
            return Collections.emptyList();
        }
        Collection existing = ItemProfile.computeProfile((IAuditable)item).getProperties();
        ArrayList<String> missing = new ArrayList<String>(profile.getProperties());
        missing.removeAll(existing);
        return missing;
    }

    private List<String> computeMissingReferences(WorkItemWorkingCopy workingCopy, ItemProfile<IWorkItem> profile) {
        if (!profile.containsReferences()) {
            return Collections.emptyList();
        }
        ArrayList<String> missing = new ArrayList<String>(profile.getReferences());
        if (workingCopy.isReferencesSet()) {
            missing.removeAll(((WorkItemReferences)workingCopy.getReferences()).getOriginalLinkTypeIds());
        }
        return missing;
    }

    public boolean autoMerge(final WorkItemWorkingCopy workingCopy) {
        return ((WorkItemWorkingCopyImpl)workingCopy).write(new WorkingCopyRunnable<Boolean>(){

            @Override
            public Boolean run() {
                IWorkItem workItem = workingCopy.getWorkItem();
                WorkItemWorkingCopyRegistry.this.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                WorkItemWorkingCopyRegistry.this.beginRemoteWorkItemChange((IWorkItemHandle)workItem);
                IWorkItem oldBaseState = ((WorkItemWorkingCopyImpl)workingCopy).getBaseState();
                IWorkItem sharedItem = ((WorkItemWorkingCopyImpl)workingCopy).getSharedItem();
                IWorkItem newBaseState = (IWorkItem)EcoreUtil.copy((EObject)((EObject)sharedItem));
                WorkItemWorkingCopyRegistry.this.copyModifiedValues(workItem, sharedItem);
                ThreeWayDiffReport report = new ThreeWayDiffReport((IAuditable)((IWorkItem)oldBaseState.getWorkingCopy()), (IAuditable)workItem, (IAuditable)((IWorkItem)newBaseState.getWorkingCopy()));
                if (!report.canMergeAutomatically()) {
                    return false;
                }
                ((WorkItemWorkingCopyImpl)workingCopy).setBaseState(newBaseState);
                report.merge();
                return true;
            }

            @Override
            public void runFinally() {
                IWorkItem workItem = workingCopy.getWorkItem();
                WorkItemWorkingCopyRegistry.this.endRemoteWorkItemChange((IWorkItemHandle)workItem);
                WorkItemWorkingCopyRegistry.this.endCompoundWorkItemChange((IWorkItemHandle)workItem);
            }
        });
    }

    private void fireWorkItemChanged(IWorkItem target, String attributeIdentifier, IAdaptable details) {
        boolean connected = this.connectLocal(this.fSystemWorkingCopyManager, (IWorkItemHandle)target, EMPTY_PROFILE);
        Assert.isTrue((boolean)connected);
        try {
            this.fireWorkItemChanged(this.getWorkingCopy(this.fSystemWorkingCopyManager, (IWorkItemHandle)target), attributeIdentifier, details);
        }
        finally {
            this.disconnect(this.fSystemWorkingCopyManager, (IWorkItemHandle)target);
        }
    }

    private void fireWorkItemChanged(WorkItemWorkingCopy workingCopy, String attributeIdentifier, IAdaptable details) {
        String[] dependents;
        IWorkItem target = workingCopy.getWorkItem();
        int kind = this.getWorkItemChangeMode((IWorkItemHandle)target);
        if (!workingCopy.isDirty() && kind == 1) {
            ((WorkItemWorkingCopyImpl)workingCopy).setDirty(true);
        }
        try {
            IProjectAreaHandle projectArea;
            if (target.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY)) {
                projectArea = target.getProjectArea();
            } else {
                IAuditableCommon auditableCommon = this.fWorkItemClient.getAuditableCommon();
                ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.PROJECT_AREA_PROPERTY});
                IWorkItem resolved = (IWorkItem)auditableCommon.resolveAuditable((IAuditableHandle)target, profile, null);
                projectArea = resolved.getProjectArea();
            }
            dependents = this.fWorkItemClient.findDependents(projectArea, attributeIdentifier, null);
        }
        catch (TeamRepositoryException x) {
            ModelPlugin.log("Exception while retrieving attributes", (Exception)((Object)x));
            dependents = new String[]{};
        }
        WorkItemChangeEvent event = this.fillWorkItemEvent(workingCopy, attributeIdentifier, dependents, details, kind);
        if (event != null) {
            this.fireWorkItemChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkItemChangeEvent fillWorkItemEvent(WorkItemWorkingCopy workingCopy, String attributeIdentifier, String[] dependents, IAdaptable details, int kind) {
        Object object = this.fCompoundWorkItemChangeLock;
        synchronized (object) {
            IWorkItem target;
            block5: {
                target = workingCopy.getWorkItem();
                if (!this.hasCompoundChange((IWorkItemHandle)target)) break block5;
                WorkItemChangeEvent event = this.fCompoundWorkItemChangeEvents.get(target.getItemId());
                if (event == null) {
                    event = new WorkItemChangeEvent(target);
                    this.fCompoundWorkItemChangeEvents.put(target.getItemId(), event);
                }
                event.addAttributeDetails(attributeIdentifier, dependents, details, kind);
                return null;
            }
            WorkItemChangeEvent event = new WorkItemChangeEvent(target);
            event.addAttributeDetails(attributeIdentifier, dependents, details, kind);
            return event;
        }
    }

    private void fireWorkItemChanged(WorkItemChangeEvent event) {
        if (!this.fListenerList.isEmpty()) {
            this.fireWorkItemAttributeChange(this.fListenerList, event);
            if (event.getAffectedDependents().length > 0) {
                this.fireWorkItemAttributeDependencyChange(this.fListenerList, event);
            }
        }
        String[] stringArray = event.getChangedAttributes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            this.fireWorkItemChanged(attribute, event);
            ++n2;
        }
    }

    private void fireWorkItemChanged(String attributeIdentifier, WorkItemChangeEvent event) {
        ListenerList listenerList = this.getListeners(this.fAttributeListenerMap, attributeIdentifier, false);
        if (listenerList != null) {
            this.fireWorkItemAttributeChange(listenerList, event);
        }
        if ((listenerList = this.getListeners(this.fAttributeDependencyListenerMap, attributeIdentifier, false)) != null) {
            this.fireWorkItemAttributeDependencyChange(listenerList, event);
        }
    }

    private void fireWorkItemAttributeChange(final ListenerList listenerList, final WorkItemChangeEvent event) {
        Object[] listeners = listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IWorkItemListener listener = (IWorkItemListener)listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.workItemAttributeChanged(event);
                }

                public void handleException(Throwable exception) {
                    listenerList.remove((Object)listener);
                }
            };
            this.fEventDispatcher.add(runnable);
            ++i;
        }
    }

    private void fireWorkItemAttributeDependencyChange(final ListenerList listenerList, final WorkItemChangeEvent event) {
        Object[] listeners = listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IWorkItemListener listener = (IWorkItemListener)listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.workItemAttributeDependencyChanged(event);
                }

                public void handleException(Throwable exception) {
                    listenerList.remove((Object)listener);
                }
            };
            this.fEventDispatcher.add(runnable);
            ++i;
        }
    }

    public void fireWorkingCopyEvent(ListenerList listenerList, WorkingCopyEvent event) {
        this.doFireWorkingCopyEvent(listenerList, event);
        this.doFireWorkingCopyEvent(this.fLiveCycleListenerLists, event);
    }

    private void doFireWorkingCopyEvent(final ListenerList listenerList, final WorkingCopyEvent event) {
        Object[] listeners = listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IWorkingCopyListener listener = (IWorkingCopyListener)listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.workingCopyEvent(event);
                }

                public void handleException(Throwable exception) {
                    listenerList.remove((Object)listener);
                }
            };
            this.fEventDispatcher.add(runnable);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void joinEventDispatcher() {
        Object object = this.fCompoundWorkItemChangeLock;
        synchronized (object) {
            while (this.hasCompoundChange()) {
                try {
                    this.fCompoundWorkItemChangeLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.fEventDispatcher.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasCompoundChange() {
        Object object = this.fCompoundWorkItemChangeLock;
        synchronized (object) {
            Integer counter;
            Iterator<Integer> iterator = this.fCompoundWorkItemChangeCounters.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((counter = iterator.next()) == null || counter <= 0);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginCompoundWorkItemChange(IWorkItemHandle target) {
        Object object = this.fCompoundWorkItemChangeLock;
        synchronized (object) {
            Integer counter = this.fCompoundWorkItemChangeCounters.get(target.getItemId());
            if (counter == null) {
                this.fCompoundWorkItemChangeCounters.put(target.getItemId(), new Integer(1));
            } else {
                this.fCompoundWorkItemChangeCounters.put(target.getItemId(), new Integer(counter + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCompoundWorkItemChange(IWorkItemHandle target) {
        WorkItemChangeEvent event = null;
        Object object = this.fCompoundWorkItemChangeLock;
        synchronized (object) {
            Integer counter = this.fCompoundWorkItemChangeCounters.remove(target.getItemId());
            Assert.isNotNull((Object)counter);
            Assert.isTrue((counter > 0 ? 1 : 0) != 0);
            if (counter > 1) {
                this.fCompoundWorkItemChangeCounters.put(target.getItemId(), counter - 1);
            } else {
                event = this.fCompoundWorkItemChangeEvents.remove(target.getItemId());
            }
        }
        if (event != null) {
            this.fireWorkItemChanged(event);
            object = this.fCompoundWorkItemChangeLock;
            synchronized (object) {
                this.fCompoundWorkItemChangeLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCompoundChange(IWorkItemHandle target) {
        Object object = this.fCompoundWorkItemChangeLock;
        synchronized (object) {
            Integer counter = this.fCompoundWorkItemChangeCounters.get(target.getItemId());
            return counter != null && counter > 0;
        }
    }

    public void beginRemoteWorkItemChange(IWorkItemHandle target) {
        this.fWorkItemChangeModes.put(target.getItemId(), new Integer(2));
    }

    public void endRemoteWorkItemChange(IWorkItemHandle target) {
        this.fWorkItemChangeModes.remove(target.getItemId());
    }

    public void beginUpgradeWorkItemChange(IWorkItemHandle target) {
        this.fWorkItemChangeModes.put(target.getItemId(), new Integer(3));
    }

    public void endUpgradeWorkItemChange(IWorkItemHandle target) {
        this.fWorkItemChangeModes.remove(target.getItemId());
    }

    private int getWorkItemChangeMode(IWorkItemHandle target) {
        Integer mode = this.fWorkItemChangeModes.get(target.getItemId());
        if (mode != null) {
            return mode;
        }
        return 1;
    }

    public void addWorkItemListener(IWorkItemListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public void removeWorkItemListener(IWorkItemListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    public void addWorkingCopyListener(IWorkingCopyListener listener) {
        this.fLiveCycleListenerLists.add((Object)listener);
    }

    public void removeWorkingCopyListener(IWorkingCopyListener listener) {
        this.fLiveCycleListenerLists.remove((Object)listener);
    }

    private ListenerList getListeners(Map<String, ListenerList> listenerMap, String attributeIdentifier, boolean create) {
        ListenerList listeners = listenerMap.get(attributeIdentifier);
        if (listeners == null && create) {
            listeners = new ListenerList();
            listenerMap.put(attributeIdentifier, listeners);
        }
        return listeners;
    }

    public IDetailedStatus save(IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy[] copies, IProgressMonitor monitor) throws TeamRepositoryException, MultiStaleDataException {
        return this.save(manager, copies, this.fWorkItemClient.getSaveTransport(), monitor);
    }

    /*
     * Exception decompiling
     */
    public IDetailedStatus save(IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy[] copies, WorkItemSaveTransport transport, IProgressMonitor monitor) throws TeamRepositoryException, MultiStaleDataException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<IDetailedStatus> delete(IWorkItemWorkingCopyManager manager, List<IWorkItemHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((boolean)((WorkItemWorkingCopyManager)manager).isWriteable());
        StatusResultDTO[] status = this.fWorkItemClient.deleteWorkItems0(handles, monitor);
        ArrayList<IDetailedStatus> result = new ArrayList<IDetailedStatus>(status.length);
        ArrayList<IWorkItemHandle> deletedItems = new ArrayList<IWorkItemHandle>();
        int idx = 0;
        while (idx < status.length) {
            StatusResultDTO cur = status[idx];
            if (cur.getSeverity() == 0) {
                deletedItems.add(handles.get(idx));
            }
            result.add(new DetailedStatus((IStatus)new Status(cur.getSeverity(), "com.ibm.team.workitem.client", cur.getMessage()), cur.getOperationReport()));
            ++idx;
        }
        manager.markAsDeleted(deletedItems.toArray(new IWorkItemHandle[deletedItems.size()]));
        return result;
    }

    private List<WorkItemWorkingCopy> collectChangedCopies(WorkItemWorkingCopy[] copies) {
        ArrayList<WorkItemWorkingCopy> toSave = new ArrayList<WorkItemWorkingCopy>(copies.length);
        ItemHandleAwareHashSet toSaveSet = new ItemHandleAwareHashSet();
        WorkItemWorkingCopy[] workItemWorkingCopyArray = copies;
        int n = copies.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemWorkingCopy wc = workItemWorkingCopyArray[n2];
            Object origin = wc.getWorkItem().getOrigin();
            if (!(origin instanceof ITeamRepository)) {
                throw new IllegalArgumentException("Working copy not connected to team repository");
            }
            if (!this.fWorkItemClient.getTeamRepository().equals(origin)) {
                throw new IllegalArgumentException("Working copies must belong to same team repository");
            }
            IWorkItemHandle handle = (IWorkItemHandle)wc.getWorkItem().getItemHandle();
            if (!toSaveSet.contains(handle) && wc.isDirty()) {
                toSaveSet.add(handle);
                toSave.add(wc);
            }
            ++n2;
        }
        return toSave;
    }

    private void collectAdditionalCopies(IWorkItemWorkingCopyManager manager, List<WorkItemWorkingCopy> changedCopies, List<WorkItemWorkingCopy> additionalCopies, WorkItemWorkingCopy copy) {
        List handles = new DuplicateLinks().computeAffectedWorkItems((ISaveParameter)new SaveParameter(null, null, (IAuditable)copy.getWorkItem(), copy.isReferencesSet() ? copy.getReferences() : null, null, copy.getWorkflowAction(), null, null, null, null, Collections.emptyList(), null, copy.getAdditionalSaveParameters()));
        for (IWorkItemHandle handle : handles) {
            if (!this.connectExisting(manager, handle, EMPTY_PROFILE)) continue;
            WorkItemWorkingCopy target = this.getWorkingCopy(manager, handle);
            boolean found = false;
            for (WorkItemWorkingCopy tmp : changedCopies) {
                if (!tmp.getWorkItem().sameItemId((IItemHandle)target.getWorkItem())) continue;
                found = true;
                break;
            }
            if (!found) {
                for (WorkItemWorkingCopy tmp : additionalCopies) {
                    if (!tmp.getWorkItem().sameItemId((IItemHandle)target.getWorkItem())) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                this.disconnect(manager, handle);
                continue;
            }
            additionalCopies.add(target);
            if (!target.isDirty()) continue;
            this.collectAdditionalCopies(manager, changedCopies, additionalCopies, target);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private IDetailedStatus saveAffected(IWorkItemWorkingCopyManager manager, List<WorkItemWorkingCopy> copies, WorkItemSaveTransport transport, IProgressMonitor monitor) throws TeamRepositoryException, MultiStaleDataException {
        upload = new ArrayList<Object>();
        for (WorkItemWorkingCopy copy : copies) {
            if (!copy.isReferencesSet()) continue;
            links = ((WorkItemWorkingCopyImpl)copy).getArtifactLinks();
            for (Object link : links) {
                if (!link.needsUpload()) continue;
                upload.add(link);
            }
        }
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.beginTask(Messages.WorkItemWorkingCopyRegistry_SAVING_WORK_ITEM, 100);
        subMonitor = progress.newChild(10);
        for (ArtifactLink link : upload) {
            link.upload((IProgressMonitor)subMonitor);
        }
        for (WorkItemWorkingCopy copy : copies) {
            ((WorkItemWorkingCopyImpl)copy).aboutToBeSaved();
        }
        stati = null;
        saveProblem = null;
        try {
            try {
                stati = this.saveWorkItems(manager, copies, transport, (IProgressMonitor)progress.newChild(60));
            }
            catch (TeamRepositoryException x) {
                saveProblem = DetailedStatus.createFromException(Messages.WorkItemWorkingCopyRegistry_SAVE_EXCEPTION, x);
                throw x;
            }
        }
        finally {
            if (stati == null && saveProblem == null) {
                saveProblem = new DetailedStatus(4, "com.ibm.team.workitem.client", 2, Messages.WorkItemWorkingCopyRegistry_SAVE_PROBLEM, null);
            }
            i = 0;
            ** while (i < copies.size())
        }
lbl-1000:
        // 1 sources

        {
            wc = (WorkItemWorkingCopyImpl)copies.get(i);
            status = stati != null && saveProblem != null ? (stati[i].getSeverity() >= saveProblem.getSeverity() ? stati[i] : saveProblem) : (stati != null ? stati[i] : saveProblem);
            wc.saved(status);
            ++i;
            continue;
        }
lbl39:
        // 1 sources

        progress.worked(40);
        if (monitor != null) {
            monitor.done();
        }
        if (saveProblem != null) {
            return saveProblem;
        }
        if (stati == null) {
            return DetailedStatus.OK_STATUS;
        }
        if (stati.length == 1) {
            return stati[0];
        }
        result = new MultiStatus("com.ibm.team.workitem.client", 0, Messages.WorkItemWorkingCopyRegistry_SAVE_PROBLEMS, null);
        i = 0;
        while (i < stati.length) {
            if (!stati[i].isOK()) {
                result.add((IStatus)stati[i]);
            }
            ++i;
        }
        if (result.isOK()) {
            return DetailedStatus.OK_STATUS;
        }
        return new DetailedStatus((IStatus)result);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public IDetailedStatus[] saveWorkItems(final IWorkItemWorkingCopyManager manager, List<WorkItemWorkingCopy> workingCopies, WorkItemSaveTransport transport, IProgressMonitor monitor) throws TeamRepositoryException {
        block21: {
            teamRepository = this.fWorkItemClient.getTeamRepository();
            auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            result = new IDetailedStatus[workingCopies.size()];
            dependentParameters = null;
            saveParameters = null;
            multiSaveResult = null;
            updatedLinks = new ArrayList<Object>();
            try {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                dependentParameters = new ArrayList<SaveParameterDTO>();
                saveParameters = new ArrayList<SaveParameterDTO>();
                for (WorkItemWorkingCopy workingCopy : workingCopies) {
                    workItem = workingCopy.getWorkItem();
                    manager.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                    this.beginRemoteWorkItemChange((IWorkItemHandle)workItem);
                    if (workItem.isPropertySet(IWorkItem.CREATOR_PROPERTY) && workItem.getCreator() == null) {
                        workItem.setCreator((IContributorHandle)teamRepository.loggedInContributor());
                    }
                    if (workItem.isPropertySet(IWorkItem.RESOLVER_PROPERTY) && ((WorkItem)workItem).getResolver() == null) {
                        ((WorkItem)workItem).setResolver((IContributorHandle)auditableClient.createAuditableHandle(IContributor.ITEM_TYPE, DefaultModel.NULL_CONTRIBUTOR_ITEM_ID, null));
                    }
                    attachments = new ArrayList<IAttachment>();
                    if (workingCopy.isReferencesSet()) {
                        links = ((WorkItemWorkingCopyImpl)workingCopy).getArtifactLinks();
                        subMonitor = progress.newChild(5);
                        for (Object link : links) {
                            if (!link.needsUpdate()) continue;
                            attachment = link.createUpdatedAttachment((IProgressMonitor)subMonitor);
                            attachments.add(attachment);
                            updatedLinks.add(link);
                        }
                    }
                    saveParameter = this.createSaveParameter(workingCopy);
                    saveParameter.getAttachments().addAll(attachments);
                    saveParameters.add(saveParameter);
                    link = workingCopy.getDependentItems().getAll().iterator();
                    while (link.hasNext()) {
                        auditable = (IAuditable)link.next();
                        copy = (IAuditable)EMFHelper.copy((Object)auditable);
                        dependentParameter = Utils.createSaveParameter((IAuditable)copy, null, null, Collections.<T>emptySet());
                        dependentParameters.add(dependentParameter);
                    }
                }
                multiSaveParameter = RcpFactory.eINSTANCE.createMultiSaveParameterDTO();
                Utils.setUserTimeZone((MultiSaveParameterDTO)multiSaveParameter, (TimeZone)TimeZone.getDefault());
                Utils.setImport((MultiSaveParameterDTO)multiSaveParameter);
                multiSaveParameter.getSaveParameters().addAll(dependentParameters);
                multiSaveParameter.getSaveParameters().addAll(saveParameters);
                multiSaveResult = this.fWorkItemClient.save(WorkItemCommon.getSaveWorkItemName(), multiSaveParameter, transport, (IProgressMonitor)progress.newChild(50));
                if (multiSaveResult.isConflictingUpdate()) {
                    reports = multiSaveResult.getReconcileReports();
                    incoming = new ArrayList<IAuditable>(reports.length);
                    link = reports;
                    auditable = reports.length;
                    saveParameter = 0;
                    while (saveParameter < auditable) {
                        report = link[saveParameter];
                        incoming.add(report.getIncoming());
                        ++saveParameter;
                    }
                    ((AuditableCommon)this.fWorkItemClient.getAuditableCommon()).update(incoming, (IProgressMonitor)progress.newChild(10));
                }
                Utils.checkSaveResult((Object)auditableClient.getOrigin(), (MultiSaveResultDTO)multiSaveResult);
                saveResults = multiSaveResult.getSaveResults();
                Assert.isTrue((boolean)(workingCopies.size() <= saveResults.size()));
                saveResultMap = this.buildSaveResultMap(saveResults);
                subMonitor = progress.newChild(5);
                i = 0;
                while (i < workingCopies.size()) {
                    workingCopy = workingCopies.get(i);
                    saveResult = (SaveResultDTO)saveResultMap.get((Object)workingCopy.getWorkItem());
                    Assert.isNotNull((Object)saveResult);
                    target = workingCopy.getWorkItem();
                    source = saveResult.getUpdatedState();
                    copy = (IWorkItem)source.getWorkingCopy();
                    if (!ItemProfile.computeProfile((IAuditable)target).isMatched((IAuditable)copy)) {
                        source = this.fWorkItemClient.getTeamRepository().itemManager().fetchCompleteState((IAuditableHandle)source, (IProgressMonitor)subMonitor);
                    }
                    finalSource = (IWorkItem)source;
                    ((WorkItemWorkingCopyImpl)workingCopy).write(new WorkingCopyRunnable<Void>(){

                        @Override
                        public Void run() {
                            WorkItemWorkingCopyRegistry.this.remoteUpdate(manager, workingCopy, finalSource, saveResult.getUpdatedLinks(), false, false);
                            return null;
                        }
                    });
                    result[i] = new DetailedStatus(saveResult.getStatus(), saveResult.getOperationReport());
                    ++i;
                }
                subMonitor.done();
                updatedStates = new ArrayList<IAuditable>(saveResults.size());
                updatedAttachments = new ArrayList<E>(saveResults.size());
                for (final SaveResultDTO saveResult : saveResults) {
                    updatedStates.add(saveResult.getUpdatedState());
                    updatedAttachments.addAll(saveResult.getUpdatedAttachments());
                }
                sharedItems = ((AuditableClient)auditableClient).update(updatedStates, (IProgressMonitor)progress.newChild(10));
                Assert.isTrue((boolean)(updatedStates.size() == sharedItems.size()));
                sharedItemMap = this.buildSharedItemMap(sharedItems);
                i = 0;
                while (i < workingCopies.size()) {
                    workingCopy = workingCopies.get(i);
                    sharedItem = (IAuditable)sharedItemMap.get((Object)workingCopy.getWorkItem());
                    Assert.isNotNull((Object)sharedItem);
                    ((WorkItemWorkingCopyImpl)workingCopy).setSharedItem((IWorkItem)sharedItem);
                    workingCopy.getDependentItems().clear();
                    ++i;
                }
                ((AuditableClient)auditableClient).update(updatedAttachments, (IProgressMonitor)progress.newChild(10));
                for (ArtifactLink link : updatedLinks) {
                    link.updateSuccessful();
                }
            }
            finally {
                if (saveParameters == null) break block21;
                ** for (parameter : saveParameters)
            }
lbl-1000:
            // 1 sources

            {
                Utils.detachItems((EObject)((EObject)parameter));
                continue;
            }
        }
        if (multiSaveResult != null) {
            Utils.detachItems((EObject)((EObject)multiSaveResult));
        }
        for (ArtifactLink link : updatedLinks) {
            link.updateFinished();
        }
        i = 0;
        while (i < workingCopies.size()) {
            workItem = workingCopies.get(i).getWorkItem();
            this.endRemoteWorkItemChange((IWorkItemHandle)workItem);
            manager.endCompoundWorkItemChange((IWorkItemHandle)workItem);
            ++i;
        }
        if (monitor != null && !monitor.isCanceled()) {
            monitor.done();
        }
        return result;
    }

    private ItemHandleAwareHashMap<IAuditableHandle, IAuditable> buildSharedItemMap(List<IAuditable> sharedItems) {
        ItemHandleAwareHashMap map = new ItemHandleAwareHashMap();
        for (IAuditable sharedItem : sharedItems) {
            map.put((Object)((IAuditableHandle)sharedItem.getItemHandle()), (Object)sharedItem);
        }
        return map;
    }

    private ItemHandleAwareHashMap<IAuditableHandle, SaveResultDTO> buildSaveResultMap(List<SaveResultDTO> saveResults) {
        ItemHandleAwareHashMap map = new ItemHandleAwareHashMap();
        for (SaveResultDTO saveResult : saveResults) {
            map.put((Object)((IAuditableHandle)saveResult.getUpdatedState().getItemHandle()), (Object)saveResult);
        }
        return map;
    }

    private SaveParameterDTO createSaveParameter(final WorkItemWorkingCopy workingCopy) {
        return ((WorkItemWorkingCopyImpl)workingCopy).read(new WorkingCopyRunnable<SaveParameterDTO>(){

            @Override
            public SaveParameterDTO run() {
                IWorkItem workItem = (IWorkItem)EMFHelper.copy((Object)workingCopy.getWorkItem());
                if (!workingCopy.isReferencesSet()) {
                    return Utils.createSaveParameter((IAuditable)workItem, null, (String)workingCopy.getWorkflowAction(), workingCopy.getAdditionalSaveParameters());
                }
                return Utils.createSaveParameter((IAuditable)workItem, (IWorkItemReferences)workingCopy.getReferences(), (String)workingCopy.getWorkflowAction(), workingCopy.getAdditionalSaveParameters());
            }
        });
    }

    private <T extends IItemHandle> T handle(T handle) {
        return (T)(handle instanceof IItem ? ((IItem)handle).getItemHandle() : handle);
    }

    void addToDeleted(IWorkItemHandle[] handles) {
        IWorkItemHandle[] iWorkItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkItemHandle cur = iWorkItemHandleArray[n2];
            if (this.fWorkingCopies.containsKey((Object)cur)) {
                this.fDeletedItems.add((Object)cur);
                WorkItemWorkingCopyImpl curCopy = (WorkItemWorkingCopyImpl)this.fWorkingCopies.get((Object)cur);
                curCopy.fireWorkingCopyChanged(WorkingCopyEvent.createWorkingCopyEvent(curCopy, "deleted"));
            }
            ++n2;
        }
    }

    private class InternalAttributeChangedNotfier
    extends AttributeChangedNotifier {
        private InternalAttributeChangedNotfier() {
        }

        public void fireAttributeChanged(IWorkItem workItem, String attributeIdentifier, IAdaptable details) {
            WorkItemWorkingCopyRegistry.this.fireWorkItemChanged(workItem, attributeIdentifier, details);
        }

        public void validateWorkingCopyPredecessor(IWorkItem workItem, UUID newWorkingCopyPredecessor) {
            boolean connected = WorkItemWorkingCopyRegistry.this.connectLocal(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, (IWorkItemHandle)workItem, (ItemProfile<IWorkItem>)EMPTY_PROFILE);
            Assert.isTrue((boolean)connected);
            try {
                WorkItemWorkingCopy workingCopy = WorkItemWorkingCopyRegistry.this.getWorkingCopy(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, (IWorkItemHandle)workItem);
                ((WorkItemWorkingCopyImpl)workingCopy).assertIsValidWorkingCopyPredecessor(newWorkingCopyPredecessor);
            }
            finally {
                WorkItemWorkingCopyRegistry.this.disconnect(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, (IWorkItemHandle)workItem, false);
            }
        }
    }

    private class InternalListener
    extends EMFListener
    implements IListener,
    ISharedItemChangeListener {
        private InternalListener() {
        }

        public void install(WorkItemWorkingCopyImpl workingCopy) {
            IWorkItem workItem = workingCopy.getWorkItem();
            ((EObject)workItem).eAdapters().add((Object)this);
            for (String property : IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES) {
                EStructuralFeature feature = ModelPackage.eINSTANCE.getWorkItem().getEStructuralFeature(property);
                if (feature == null || !feature.isMany() || !this.isStateExtensionFeature(feature)) continue;
                Collection collection = (Collection)((EObject)workItem).eGet(feature);
                for (Object object : collection) {
                    this.install(object);
                }
            }
            this.collectionInstall(workItem, (EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_InternalApprovalDescriptors());
            this.collectionInstall(workItem, (EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_InternalApprovals());
            workItem.setAttributeChangedNotifier((AttributeChangedNotifier)WorkItemWorkingCopyRegistry.this.fInternalNotfier);
            workingCopy.setRegistry(WorkItemWorkingCopyRegistry.this);
        }

        public void uninstall(WorkItemWorkingCopyImpl workingCopy) {
            IWorkItem workItem = workingCopy.getWorkItem();
            ((EObject)workItem).eAdapters().remove((Object)this);
            for (String property : IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES) {
                EStructuralFeature feature = ModelPackage.eINSTANCE.getWorkItem().getEStructuralFeature(property);
                if (feature == null || !feature.isMany() || !this.isStateExtensionFeature(feature)) continue;
                Collection collection = (Collection)((EObject)workItem).eGet(feature);
                for (Object object : collection) {
                    this.uninstall(object);
                }
            }
            this.collectionUninstall(workItem, (EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_InternalApprovalDescriptors());
            this.collectionUninstall(workItem, (EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_InternalApprovals());
            workItem.setAttributeChangedNotifier(null);
            workingCopy.setRegistry(null);
        }

        private void collectionInstall(IWorkItem workItem, EStructuralFeature feature) {
            EObject eObject = (EObject)workItem;
            if (!eObject.eIsSet(feature)) {
                return;
            }
            Collection collection = (Collection)eObject.eGet(feature);
            for (Object object : collection) {
                if (!(object instanceof EObject)) continue;
                ((EObject)object).eAdapters().add((Object)this);
            }
        }

        private void collectionUninstall(IWorkItem workItem, EStructuralFeature feature) {
            EObject eObject = (EObject)workItem;
            if (!eObject.eIsSet(feature)) {
                return;
            }
            Collection collection = (Collection)eObject.eGet(feature);
            for (Object object : collection) {
                if (!(object instanceof EObject)) continue;
                ((EObject)object).eAdapters().remove((Object)this);
            }
        }

        private void install(Object value) {
            if (this.isStateExtensionEntry(value)) {
                ((EObject)value).eAdapters().add((Object)this);
            }
        }

        private void uninstall(Object value) {
            if (this.isStateExtensionEntry(value)) {
                ((EObject)value).eAdapters().remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void featureChanged(Object notifier, EStructuralFeature feature, Object oldValue, Object newValue, int position) {
            IAttribute attribute;
            IWorkItem resolved;
            ItemProfile profile;
            IAuditableCommon auditableCommon;
            IProjectAreaHandle newProjectArea;
            String identifier;
            this.uninstall(oldValue);
            this.install(newValue);
            IWorkItem workItem = this.findWorkItem(notifier);
            if (workItem == null || WorkItemWorkingCopyRegistry.this.getWorkItemChangeMode((IWorkItemHandle)workItem) == 3 || this.filtered(feature)) {
                return;
            }
            ApprovalChangeDetails details = null;
            if (this.isStateExtensionFeature(feature)) {
                String newIdentifier;
                String oldIdentifier = oldValue instanceof Map.Entry ? (String)((Map.Entry)oldValue).getKey() : null;
                String string = newIdentifier = newValue instanceof Map.Entry ? (String)((Map.Entry)newValue).getKey() : null;
                if (oldIdentifier == null && newIdentifier == null) {
                    return;
                }
                if (oldIdentifier != null && newIdentifier != null && !oldIdentifier.equals(newIdentifier)) {
                    WorkItemWorkingCopyRegistry.this.fireWorkItemChanged(workItem, oldIdentifier, null);
                    WorkItemWorkingCopyRegistry.this.fireWorkItemChanged(workItem, newIdentifier, null);
                    return;
                }
                identifier = oldIdentifier != null ? oldIdentifier : newIdentifier;
                oldValue = oldValue instanceof Map.Entry ? ((Map.Entry)oldValue).getValue() : null;
                newValue = newValue instanceof Map.Entry ? ((Map.Entry)newValue).getValue() : null;
                position = -1;
            } else if (this.isStateExtensionEntry(notifier)) {
                if (!"value".equals(feature.getName())) {
                    return;
                }
                identifier = (String)((Map.Entry)notifier).getKey();
            } else {
                identifier = feature.getName();
            }
            if (notifier instanceof IWorkItem) {
                try {
                    if (workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY)) {
                        newProjectArea = workItem.getProjectArea();
                    } else {
                        auditableCommon = WorkItemWorkingCopyRegistry.this.fWorkItemClient.getAuditableCommon();
                        profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.PROJECT_AREA_PROPERTY});
                        resolved = (IWorkItem)auditableCommon.resolveAuditable((IAuditableHandle)workItem, profile, null);
                        newProjectArea = resolved.getProjectArea();
                    }
                    attribute = this.findAttribute(newProjectArea, identifier);
                    if (attribute != null && "eSignature".equals(attribute.getAttributeType())) {
                        return;
                    }
                }
                catch (TeamRepositoryException e) {
                    ModelPlugin.log(e.getMessage(), (Exception)((Object)e));
                }
            }
            if (ModelPackage.eINSTANCE.getWorkItem_InternalComments().equals(feature)) {
                if (oldValue == null && newValue != null && position != -1) {
                    details = new CommentsChangeDetails((IComment)newValue, null, position, true);
                } else if (oldValue != null && newValue == null && position != -1) {
                    details = new CommentsChangeDetails((IComment)oldValue, null, position, false);
                }
            } else if (notifier instanceof IApproval) {
                details = new ApprovalChangeDetails((IApproval)notifier, identifier, oldValue, newValue);
                identifier = ((EObject)notifier).eContainingFeature().getName();
            } else if (notifier instanceof IApprovalDescriptor) {
                details = new ApprovalChangeDetails((IApprovalDescriptor)notifier, identifier, oldValue, newValue);
                identifier = ((EObject)notifier).eContainingFeature().getName();
            } else if (ModelPackage.eINSTANCE.getWorkItem_MultiItemExtensions().equals(feature)) {
                ItemHandleAwareHashSet oldValues = new ItemHandleAwareHashSet();
                ItemHandleAwareHashSet newValues = new ItemHandleAwareHashSet();
                if (oldValue instanceof List) {
                    oldValues.addAll((Collection)((List)oldValue));
                } else if (oldValue != null) {
                    oldValues.add(oldValue);
                }
                if (newValue instanceof List) {
                    newValues.addAll((Collection)((List)newValue));
                } else if (newValue != null) {
                    newValues.add(newValue);
                }
                ArrayList added = new ArrayList();
                for (Object object : newValues) {
                    if (oldValues.contains(object)) continue;
                    added.add(object);
                }
                ArrayList removed = new ArrayList();
                for (Object object : oldValues) {
                    if (newValues.contains(object)) continue;
                    removed.add(object);
                }
                details = new ListChangeDetails(added, removed);
            } else {
                try {
                    Object enumerationType;
                    if (workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY)) {
                        newProjectArea = workItem.getProjectArea();
                    } else {
                        auditableCommon = WorkItemWorkingCopyRegistry.this.fWorkItemClient.getAuditableCommon();
                        profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.PROJECT_AREA_PROPERTY});
                        resolved = (IWorkItem)auditableCommon.resolveAuditable((IAuditableHandle)workItem, profile, null);
                        newProjectArea = resolved.getProjectArea();
                    }
                    attribute = this.findAttribute(newProjectArea, identifier);
                    if (attribute != null && AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType())) {
                        Class enumerationType2 = ((EnumerationAttributeType)AttributeTypes.getAttributeType((String)attribute.getAttributeType())).getEnumerationType();
                        if (oldValue instanceof String) {
                            Object object = oldValue = ((String)oldValue).length() > 0 ? Identifier.create((Class)enumerationType2, (String)((String)oldValue)) : null;
                        }
                        if (newValue instanceof String) {
                            Object object = newValue = ((String)newValue).length() > 0 ? Identifier.create((Class)enumerationType2, (String)((String)newValue)) : null;
                        }
                    }
                    if (attribute != null && ("tags".equals(attribute.getAttributeType()) || "stringList".equals(attribute.getAttributeType()))) {
                        if (oldValue instanceof String) {
                            oldValue = new SeparatedStringList((String)oldValue);
                        }
                        if (newValue instanceof String) {
                            newValue = new SeparatedStringList((String)newValue);
                        }
                    }
                    if (attribute != null && AttributeTypes.isEnumerationListAttributeType((String)attribute.getAttributeType())) {
                        String containedType = AttributeTypes.getContainedType((String)attribute.getAttributeType());
                        enumerationType = ((EnumerationAttributeType)AttributeTypes.getAttributeType((String)containedType)).getEnumerationType();
                        if (oldValue instanceof String) {
                            oldValue = new SeparatedStringList((String)oldValue).toIdentifiers((Class)enumerationType);
                        }
                        if (newValue instanceof String) {
                            newValue = new SeparatedStringList((String)newValue).toIdentifiers((Class)enumerationType);
                        }
                    }
                    IProjectAreaHandle oldProjectArea = null;
                    enumerationType = WorkItemWorkingCopyRegistry.this.fCompoundWorkItemChangeLock;
                    synchronized (enumerationType) {
                        if (WorkItemWorkingCopyRegistry.this.hasCompoundChange((IWorkItemHandle)workItem)) {
                            ChangeDetails projectChange;
                            WorkItemChangeEvent event = (WorkItemChangeEvent)WorkItemWorkingCopyRegistry.this.fCompoundWorkItemChangeEvents.get(workItem.getItemId());
                            ChangeDetails changeDetails = projectChange = event != null ? event.getAttributeChangeDetails(IWorkItem.PROJECT_AREA_PROPERTY, ChangeDetails.class) : null;
                            if (projectChange != null && projectChange.getOldValue() instanceof IProjectAreaHandle && !newProjectArea.sameItemId((IItemHandle)((IProjectAreaHandle)projectChange.getOldValue()))) {
                                oldProjectArea = (IProjectAreaHandle)projectChange.getOldValue();
                            }
                        }
                    }
                    if (oldProjectArea != null) {
                        attribute = this.findAttribute(oldProjectArea, identifier);
                    }
                    if (attribute != null && AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType())) {
                        enumerationType = ((EnumerationAttributeType)AttributeTypes.getAttributeType((String)attribute.getAttributeType())).getEnumerationType();
                        if (oldValue instanceof String) {
                            Object object = oldValue = ((String)oldValue).length() > 0 ? Identifier.create((Class)enumerationType, (String)((String)oldValue)) : null;
                        }
                        if (newValue instanceof String) {
                            newValue = ((String)newValue).length() > 0 ? Identifier.create((Class)enumerationType, (String)((String)newValue)) : null;
                        }
                    }
                }
                catch (TeamRepositoryException x) {
                    ModelPlugin.log(x.getMessage(), (Exception)((Object)x));
                }
                if (this.equalValues(oldValue, newValue)) {
                    return;
                }
                if (position == -1) {
                    details = new ChangeDetails(oldValue, newValue);
                } else if (oldValue != null && newValue == null) {
                    details = new ListChangeDetails(Collections.emptyList(), Collections.singletonList(oldValue));
                } else if (newValue != null && oldValue == null) {
                    details = new ListChangeDetails(Collections.singletonList(newValue), Collections.emptyList());
                }
            }
            WorkItemWorkingCopyRegistry.this.fireWorkItemChanged(workItem, identifier, details);
        }

        private IAttribute findAttribute(IProjectAreaHandle projectAreaHandle, String identifier) throws TeamRepositoryException {
            IAttribute attribute = WorkItemWorkingCopyRegistry.this.fWorkItemClient.findCachedAttribute(projectAreaHandle, identifier);
            if (attribute == null) {
                attribute = WorkItemWorkingCopyRegistry.this.fWorkItemClient.findAttribute(projectAreaHandle, identifier, null);
            }
            return attribute;
        }

        private IWorkItem findWorkItem(Object notifier) {
            while (notifier instanceof EObject && !(notifier instanceof IWorkItem)) {
                notifier = ((EObject)notifier).eContainer();
            }
            if (notifier instanceof IWorkItem) {
                return (IWorkItem)notifier;
            }
            return null;
        }

        private boolean filtered(EStructuralFeature feature) {
            if (this.isStateExtensionFeature(feature) || IItem.CONTEXT_ID_PROPERTY.equals(feature.getName()) || IItem.MODIFIED_BY_PROPERTY.equals(feature.getName()) || IItem.MODIFIED_PROPERTY.equals(feature.getName())) {
                return false;
            }
            return RepositoryPackage.eINSTANCE.getAuditable().getEAllStructuralFeatures().contains((Object)feature);
        }

        private boolean isStateExtensionFeature(EStructuralFeature feature) {
            return feature.getEContainingClass().isSuperTypeOf(RepositoryPackage.eINSTANCE.getAuditable()) && IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES.contains(feature.getName()) || IWorkItem.WORKITEM_CUSTOM_ATTRIBUTE_PROPERTIES.contains(feature.getName());
        }

        private boolean isStateExtensionEntry(Object notifier) {
            if (!(notifier instanceof EObject)) {
                return false;
            }
            EObject object = (EObject)notifier;
            EStructuralFeature feature = object.eContainingFeature();
            if (feature == null) {
                return false;
            }
            return this.isStateExtensionFeature(feature);
        }

        private boolean equalValues(Object oldValue, Object newValue) {
            if (oldValue == newValue) {
                return true;
            }
            if (oldValue == null) {
                return false;
            }
            if (oldValue instanceof IItemHandle && newValue instanceof IItemHandle) {
                return ((IItemHandle)oldValue).getItemId().equals((Object)((IItemHandle)newValue).getItemId());
            }
            return oldValue.equals(newValue);
        }

        public void handleEvents(List events) {
            for (IEvent event : events) {
                if (!(event instanceof ILinkEvent)) continue;
                ILink link = ((ILinkEvent)event).getLink();
                if ("com.ibm.team.links.LinkSaveEvent".equals(event.getEventType())) {
                    WorkItemWorkingCopyRegistry.this.handleAddedLink(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, link);
                    continue;
                }
                if (!"com.ibm.team.links.LinkDeletedEvent".equals(event.getEventType())) continue;
                WorkItemWorkingCopyRegistry.this.handleRemovedLink(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, link);
            }
        }

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                if (!(event.getSharedItem() instanceof IWorkItem)) continue;
                IWorkItemHandle handle = (IWorkItemHandle)event.getSharedItem().getItemHandle();
                boolean connected = WorkItemWorkingCopyRegistry.this.connectExisting(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, handle, (ItemProfile<IWorkItem>)EMPTY_PROFILE);
                if (!connected) continue;
                try {
                    boolean isStale;
                    WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)WorkItemWorkingCopyRegistry.this.getWorkingCopy(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, handle);
                    if (workingCopy.hasWriteConnection()) {
                        workingCopy.updateStaleState();
                        continue;
                    }
                    IWorkItem baseState = workingCopy.getBaseState();
                    IWorkItem sharedItem = workingCopy.getSharedItem();
                    boolean bl = isStale = baseState != null && sharedItem != null && !baseState.sameStateId((IItemHandle)sharedItem);
                    if (!isStale) continue;
                    WorkItemWorkingCopyRegistry.this.refresh(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, handle);
                }
                finally {
                    WorkItemWorkingCopyRegistry.this.disconnect(WorkItemWorkingCopyRegistry.this.fSystemWorkingCopyManager, handle);
                }
            }
        }
    }
}

