/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client;

import com.urbancode.commons.util.IO;
import com.urbancode.vfs.common.Hash;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;

public class HashingInputStreamRequestEntity
extends AbstractHttpEntity
implements HttpEntity {
    protected final InputStream input;
    protected final MessageDigest digest;
    protected final long length;

    HashingInputStreamRequestEntity(InputStream input, long length, MessageDigest digest) {
        this.input = input;
        this.digest = digest;
        this.length = length;
        this.setContentType("application/octet-stream");
    }

    public void writeTo(OutputStream output) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(new BufferedOutputStream(output, 65536));
        dataOutput.writeLong(this.length);
        IO.copyAndDigest((InputStream)this.input, (OutputStream)dataOutput, (long)this.length, (MessageDigest[])new MessageDigest[]{this.digest});
        String hash = Hash.hashForMessageDigest(this.digest).toString();
        dataOutput.writeUTF(hash);
        dataOutput.flush();
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.input;
    }
}

