/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.internal.util.InternalTeamPlatform;
import com.ibm.team.repository.common.util.ExtensionReaderListener;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SafeRunner;

@Deprecated
public abstract class ExtensionReader {
    private static final Log logger = LogFactory.getLog(ExtensionReader.class);
    private final String pluginId;
    private final String extensionPointId;
    private final IRegistryChangeListener registryChangeListener;
    private final Object startLock = new Object();
    private boolean started;
    private final List listeners;

    public static String getPluginId(IConfigurationElement configurationElement) {
        IExtension extension;
        String pluginId = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            pluginId = extension.getNamespaceIdentifier();
        }
        return pluginId;
    }

    protected ExtensionReader(String pluginID, String extensionPoint) {
        this.pluginId = pluginID;
        this.extensionPointId = extensionPoint;
        this.registryChangeListener = this.createRegistryChangeListener();
        this.listeners = new ArrayList(3);
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionReaderListener(ExtensionReaderListener listener) {
        List list = this.listeners;
        synchronized (list) {
            boolean exists = this.listeners.contains(listener);
            if (exists) {
                return;
            }
            this.listeners.add(listener);
        }
    }

    protected final void addRegistryListener(IRegistryChangeListener listener, String filter) {
        IExtensionRegistry registry = this.getRegistry();
        if (registry != null) {
            registry.addRegistryChangeListener(listener, filter);
        }
    }

    protected final void checkStarted() {
        boolean started = this.isStarted();
        if (started) {
            return;
        }
        throw new RuntimeException("Registry is not started");
    }

    private IRegistryChangeListener createRegistryChangeListener() {
        return new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                ExtensionReader.this.handleRegistryChanged(event);
            }
        };
    }

    public final void earlyStart() {
        if (!InternalTeamPlatform.getDefault().asBundle()) {
            this.start();
        }
    }

    private IExtensionRegistry getRegistry() {
        return RegistryFactory.getRegistry();
    }

    protected boolean handleExtensionAdded(IConfigurationElement element) {
        return false;
    }

    protected boolean handleExtensionRemoved(IConfigurationElement element) {
        return false;
    }

    private void handleRegistryChanged(int kind, IConfigurationElement element) {
        switch (kind) {
            case 1: {
                boolean result = this.handleExtensionAdded(element);
                if (result) {
                    this.notifyListenersOfExtensionAdded(element);
                    break;
                }
                this.logFailedToAddExtension(element);
                break;
            }
            case 2: {
                boolean result = this.handleExtensionRemoved(element);
                if (result) {
                    this.notifyListenersOfExtensionRemoved(element);
                    break;
                }
                this.logFailedToRemoveExtension(element);
                break;
            }
            default: {
                this.logFailedToHandleRegistryChange(kind, element);
            }
        }
    }

    private void handleRegistryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(this.pluginId, this.extensionPointId);
        int deltasLength = deltas.length;
        int i = 0;
        while (i < deltasLength) {
            IExtensionDelta delta = deltas[i];
            int kind = delta.getKind();
            IExtension extension = delta.getExtension();
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int elementsLength = elements.length;
            int j = 0;
            while (j < elementsLength) {
                IConfigurationElement element = elements[j];
                this.handleRegistryChanged(kind, element);
                ++j;
            }
            ++i;
        }
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.handleExtensionAdded(element);
        if (!recognized) {
            this.logError(element, "Error processing extension: " + element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isStarted() {
        Object object = this.startLock;
        synchronized (object) {
            return this.started;
        }
    }

    protected final void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        String namespace = extension.getNamespaceIdentifier();
        String uniqueId = extension.getExtensionPointUniqueIdentifier();
        int size = 20 + namespace.length() + uniqueId.length() + text.length();
        StringBuffer buffer = new StringBuffer(size);
        buffer.append("Plugin ");
        buffer.append(namespace);
        buffer.append(", extension ");
        buffer.append(uniqueId);
        buffer.append('\n');
        buffer.append(text);
        String message = buffer.toString();
        logger.warn((Object)message);
    }

    private void logFailedToAddExtension(IConfigurationElement element) {
        IExtension extension = element.getDeclaringExtension();
        String uniqueId = extension.getExtensionPointUniqueIdentifier();
        String pattern = "The extension reader {0} failed to add an extension to {1}.{2} with the ID {3}";
        String msg = NLS.bind(pattern, this, this.pluginId, this.extensionPointId, uniqueId);
        logger.error((Object)msg);
    }

    private void logFailedToHandleRegistryChange(int kind, IConfigurationElement element) {
        String kindValue = String.valueOf(kind);
        IExtension extension = element.getDeclaringExtension();
        String uniqueId = extension.getExtensionPointUniqueIdentifier();
        String pattern = "The extension reader {0} failed to handle a registry change of type {1} to the extension point {2}.{3} with the ID {4}";
        String msg = NLS.bind(pattern, this, kindValue, this.pluginId, this.extensionPointId, uniqueId);
        logger.error((Object)msg);
    }

    private void logFailedToRemoveExtension(IConfigurationElement element) {
        IExtension extension = element.getDeclaringExtension();
        String uniqueId = extension.getExtensionPointUniqueIdentifier();
        String pattern = "The extension reader {0} failed to remove an extension from {1}.{2} with the ID {3}";
        String msg = NLS.bind(pattern, this, this.pluginId, this.extensionPointId, uniqueId);
        logger.error((Object)msg);
    }

    protected final void logMissingAttribute(IConfigurationElement element, String attributeName) {
        int size = 35 + attributeName.length();
        StringBuffer buffer = new StringBuffer(size);
        buffer.append("Required attribute '");
        buffer.append(attributeName);
        buffer.append("' not defined");
        String message = buffer.toString();
        this.logError(element, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfExtensionAdded(final IConfigurationElement element) {
        ExtensionReaderListener[] listeners;
        List list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray(new ExtensionReaderListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            final ExtensionReaderListener listener = listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    logger.error((Object)exception);
                }

                public void run() throws Exception {
                    listener.handleExtensionAdded(element);
                }
            });
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfExtensionRemoved(final IConfigurationElement element) {
        ExtensionReaderListener[] listeners;
        List list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray(new ExtensionReaderListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            final ExtensionReaderListener listener = listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    logger.error((Object)exception);
                }

                public void run() throws Exception {
                    listener.handleExtensionRemoved(element);
                }
            });
            ++i;
        }
    }

    @Deprecated
    public boolean readElement(IConfigurationElement element) {
        boolean added = this.handleExtensionAdded(element);
        return added;
    }

    protected final void readRegistry() {
        IExtensionRegistry useRegistry = this.getRegistry();
        if (useRegistry == null) {
            return;
        }
        IExtensionPoint point = useRegistry.getExtensionPoint(this.pluginId, this.extensionPointId);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            this.internalReadElement(elements[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensionReaderListener(ExtensionReaderListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected final void removeRegistryListener(IRegistryChangeListener listener) {
        IExtensionRegistry registry = this.getRegistry();
        if (registry != null) {
            registry.removeRegistryChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarted(boolean started) {
        Object object = this.startLock;
        synchronized (object) {
            this.started = started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.startLock;
        synchronized (object) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setStarted(true);
            this.addRegistryListener(this.registryChangeListener, this.pluginId);
            this.readRegistry();
            this.started();
        }
    }

    protected void started() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.startLock;
        synchronized (object) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.setStarted(false);
            this.removeRegistryListener(this.registryChangeListener);
            this.stopped();
        }
    }

    protected void stopped() {
    }
}

