/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import java.io.IOException;
import java.io.InputStream;

public class UnsynchronizedByteArrayInputStream
extends InputStream {
    private byte[] buf;
    private int pos;
    private int limit;
    private int mark;

    public UnsynchronizedByteArrayInputStream(byte[] buf) {
        this.buf = buf;
        this.limit = buf.length;
    }

    public UnsynchronizedByteArrayInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.limit = offset + length;
        this.mark = offset;
    }

    @Override
    public int read() throws IOException {
        if (this.pos == this.limit) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.limit == this.pos) {
            return -1;
        }
        int bytesRead = Math.min(len, this.limit - this.pos);
        System.arraycopy(this.buf, this.pos, b, off, bytesRead);
        this.pos += bytesRead;
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int bytesSkipped = (int)Math.min(n, (long)(this.limit - this.pos));
        this.pos += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public int available() throws IOException {
        return this.limit - this.pos;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.pos = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

