/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.StandardTokenTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.Payload;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.eclipse.core.runtime.Assert;

public class ArtifactAttributeImpl
extends AttributeImpl
implements ArtifactAttribute,
CharTermAttribute,
TermAttribute,
TypeAttribute,
PositionIncrementAttribute,
FlagsAttribute,
OffsetAttribute,
PayloadAttribute {
    public static final EnumSet<TokenizerTypes> DEFAULT_TOKENIZER = EnumSet.of(TokenizerTypes.EXPAND_CAMELCASE, TokenizerTypes.LOWERCASE_TOKENS, TokenizerTypes.FILTER_STOP_WORDS, TokenizerTypes.PORTER_STEM_WORDS);
    private HashMap<Class, Attribute> attributes = new HashMap();
    private EnumSet<TokenizerTypes> fTokenizers;
    private Token fCreatedFrom;

    public ArtifactAttributeImpl() {
        this(new Token());
        this.fTokenizers = DEFAULT_TOKENIZER;
        this.fCreatedFrom = null;
    }

    public ArtifactAttributeImpl(String text, int start, int end, String type, EnumSet<TokenizerTypes> tokenizers) {
        this(new Token(text, start, end, type != null ? type : StandardTokenTypes.WORD.getId()));
        Assert.isNotNull((Object)text, (String)"The text of the token must not be null!");
        Assert.isNotNull(tokenizers);
        this.fTokenizers = tokenizers;
        this.fCreatedFrom = null;
    }

    private ArtifactAttributeImpl(Token token) {
        Class<?>[] attributeClasses = ArtifactAttribute.class.getInterfaces();
        int i = 0;
        int length = attributeClasses.length;
        while (i < length) {
            Class<?> attributeClass = attributeClasses[i];
            this.attributes.put(attributeClass, (Attribute)token);
            ++i;
        }
    }

    public static ArtifactAttributeImpl addAttributeToStream(TokenStream stream) {
        ArtifactAttributeImpl artifactAttributeImpl = (ArtifactAttributeImpl)stream.addAttribute(ArtifactAttribute.class);
        Class<?>[] attributeClasses = ArtifactAttribute.class.getInterfaces();
        int i = 0;
        int length = attributeClasses.length;
        while (i < length) {
            Class<?> attributeClass = attributeClasses[i];
            Attribute attribute = stream.getAttribute(attributeClass);
            if (attribute != artifactAttributeImpl) {
                artifactAttributeImpl.addAttribute(attributeClass, attribute);
            }
            ++i;
        }
        return artifactAttributeImpl;
    }

    private void addAttribute(Class attributeClass, Attribute attribute) {
        this.attributes.put(attributeClass, attribute);
    }

    @Override
    public boolean applies(TokenizerTypes tokenizer) {
        return this.fTokenizers != null && this.fTokenizers.contains((Object)tokenizer);
    }

    public void clear() {
        Iterator<Attribute> iterator = this.attributes.values().iterator();
        while (iterator.hasNext()) {
            ((AttributeImpl)iterator.next()).clear();
        }
    }

    public ArtifactToken toToken(String text, int start, int end) {
        return new ArtifactToken(text, start, end, this.type(), this.fTokenizers, this.fCreatedFrom);
    }

    public void copyTo(AttributeImpl target) {
        ArtifactAttributeImpl artifactTarget = (ArtifactAttributeImpl)target;
        Class<?>[] attributeClasses = ArtifactAttribute.class.getInterfaces();
        HashSet<Attribute> knownAttributes = new HashSet<Attribute>();
        int i = 0;
        int length = attributeClasses.length;
        while (i < length) {
            Class<?> attributeClass = attributeClasses[i];
            Attribute attribute = this.attributes.get(attributeClass);
            if (knownAttributes.add(attribute)) {
                Attribute targetAtt = artifactTarget.attributes.get(attributeClass);
                ((AttributeImpl)attribute).copyTo((AttributeImpl)targetAtt);
            }
            ++i;
        }
        artifactTarget.fTokenizers = this.fTokenizers.clone();
        artifactTarget.fCreatedFrom = this.fCreatedFrom;
    }

    public int endOffset() {
        return this.getAttribute(OffsetAttribute.class).endOffset();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArtifactAttributeImpl)) {
            return false;
        }
        ArtifactAttributeImpl otherArtifact = (ArtifactAttributeImpl)other;
        if (!this.attributes.equals(otherArtifact.attributes)) {
            return false;
        }
        if (!this.fTokenizers.equals(otherArtifact.fTokenizers)) {
            return false;
        }
        if (this.fCreatedFrom == null) {
            return otherArtifact.fCreatedFrom == null;
        }
        return this.fCreatedFrom.equals((Object)otherArtifact.fCreatedFrom);
    }

    private <T> T getAttribute(Class<T> clazz) {
        return (T)this.attributes.get(clazz);
    }

    public int getFlags() {
        return this.getAttribute(FlagsAttribute.class).getFlags();
    }

    public Payload getPayload() {
        return this.getAttribute(PayloadAttribute.class).getPayload();
    }

    public int getPositionIncrement() {
        return this.getAttribute(PositionIncrementAttribute.class).getPositionIncrement();
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    @Override
    public boolean isArtifact() {
        return !"word".equals(this.type());
    }

    public char[] resizeTermBuffer(int newSize) {
        return this.getAttribute(TermAttribute.class).resizeTermBuffer(newSize);
    }

    public void setCreatedFrom(Token token) {
        this.fCreatedFrom = token;
    }

    public void setFlags(int flags) {
        this.getAttribute(FlagsAttribute.class).setFlags(flags);
    }

    public void setOffset(int startOffset, int endOffset) {
        this.getAttribute(OffsetAttribute.class).setOffset(startOffset, endOffset);
    }

    public void setPayload(Payload payload) {
        this.getAttribute(PayloadAttribute.class).setPayload(payload);
    }

    public void setPositionIncrement(int positionIncrement) {
        this.getAttribute(PositionIncrementAttribute.class).setPositionIncrement(positionIncrement);
    }

    public void setTermBuffer(char[] buffer, int offset, int length) {
        this.getAttribute(TermAttribute.class).setTermBuffer(buffer, offset, length);
    }

    public void setTermBuffer(String buffer) {
        this.getAttribute(TermAttribute.class).setTermBuffer(buffer);
    }

    public void setTermBuffer(String buffer, int offset, int length) {
        this.getAttribute(TermAttribute.class).setTermBuffer(buffer, offset, length);
    }

    public void setTermLength(int length) {
        this.getAttribute(TermAttribute.class).setTermLength(length);
    }

    public void setTokenizers(EnumSet<TokenizerTypes> tokenizers) {
        this.fTokenizers = tokenizers;
    }

    public void setType(String type) {
        this.getAttribute(TypeAttribute.class).setType(type);
    }

    public int startOffset() {
        return this.getAttribute(OffsetAttribute.class).startOffset();
    }

    public String term() {
        return this.getAttribute(TermAttribute.class).term();
    }

    public char[] termBuffer() {
        return this.getAttribute(TermAttribute.class).termBuffer();
    }

    public int termLength() {
        return this.getAttribute(TermAttribute.class).termLength();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        if (this.term() == null) {
            sb.append("null");
        } else {
            sb.append(this.term());
        }
        sb.append(',').append(this.startOffset()).append(',').append(this.endOffset());
        if (!this.type().equals("word")) {
            sb.append(",type=").append(this.type());
        }
        if (this.getPositionIncrement() != 1) {
            sb.append(",posIncr=").append(this.getPositionIncrement());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public ArtifactToken toToken() {
        return new ArtifactToken(this.term(), 0, this.termLength(), this.type(), this.fTokenizers, this.fCreatedFrom);
    }

    public String type() {
        return this.getAttribute(TypeAttribute.class).type();
    }

    public int length() {
        return this.getAttribute(CharTermAttribute.class).length();
    }

    public char charAt(int index) {
        return this.getAttribute(CharTermAttribute.class).charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        return this.getAttribute(CharTermAttribute.class).subSequence(start, end);
    }

    public void copyBuffer(char[] buffer, int offset, int length) {
        this.getAttribute(CharTermAttribute.class).copyBuffer(buffer, offset, length);
    }

    public char[] buffer() {
        return this.getAttribute(CharTermAttribute.class).buffer();
    }

    public char[] resizeBuffer(int newSize) {
        return this.getAttribute(CharTermAttribute.class).resizeBuffer(newSize);
    }

    public CharTermAttribute setLength(int length) {
        return this.getAttribute(CharTermAttribute.class).setLength(length);
    }

    public CharTermAttribute setEmpty() {
        return this.getAttribute(CharTermAttribute.class).setEmpty();
    }

    public CharTermAttribute append(CharSequence csq) {
        return this.getAttribute(CharTermAttribute.class).append(csq);
    }

    public CharTermAttribute append(CharSequence csq, int start, int end) {
        return this.getAttribute(CharTermAttribute.class).append(csq, start, end);
    }

    public CharTermAttribute append(char c) {
        return this.getAttribute(CharTermAttribute.class).append(c);
    }

    public CharTermAttribute append(String s) {
        return this.getAttribute(CharTermAttribute.class).append(s);
    }

    public CharTermAttribute append(StringBuilder sb) {
        return this.getAttribute(CharTermAttribute.class).append(sb);
    }

    public CharTermAttribute append(CharTermAttribute termAtt) {
        return this.getAttribute(CharTermAttribute.class).append(termAtt);
    }
}

