/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import java.util.List;

public abstract class ServerListener
implements ITeamRepositoryService.IRepositoryServiceListener,
IListener {
    private static Integer LOGGED_IN = new Integer(1);
    private static Integer LOGGED_OUT = new Integer(3);

    public void install() {
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            this.addListener(repos[i]);
            ++i;
        }
    }

    public void uninstall() {
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            this.removeListener(repos[i]);
            ++i;
        }
    }

    protected abstract void repositoryAdded(ITeamRepository var1);

    protected abstract void repositoryRemoved(ITeamRepository var1);

    protected abstract void repositoryLogin(ITeamRepository var1);

    protected abstract void repositoryLogout(ITeamRepository var1);

    protected void repositoryError(ITeamRepository repository) {
    }

    public void addedRepository(ITeamRepository repository) {
        this.addListener(repository);
        this.repositoryAdded(repository);
    }

    public void removedRepository(ITeamRepository repository) {
        this.removeListener(repository);
        this.repositoryRemoved(repository);
    }

    public void handleEvents(List events) {
        for (IEvent event : events) {
            if (this.isLoginEvent(event)) {
                ITeamRepository repository = (ITeamRepository)event.getEventSource();
                IPropertyChangeEvent deltaEvent = (IPropertyChangeEvent)event;
                if (deltaEvent.getNewValue().equals(LOGGED_IN)) {
                    this.repositoryLogin(repository);
                    continue;
                }
                if (!deltaEvent.getNewValue().equals(LOGGED_OUT)) continue;
                this.repositoryLogout(repository);
                continue;
            }
            if (!this.isErrorEvent(event)) continue;
            this.repositoryError((ITeamRepository)event.getEventSource());
        }
    }

    private boolean isLoginEvent(IEvent event) {
        if (event instanceof IPropertyChangeEvent) {
            IPropertyChangeEvent deltaEvent = (IPropertyChangeEvent)event;
            return deltaEvent.getProperty().equals("state") && deltaEvent.getEventSource() instanceof ITeamRepository;
        }
        return false;
    }

    private boolean isErrorEvent(IEvent event) {
        if (event instanceof IPropertyChangeEvent) {
            IPropertyChangeEvent deltaEvent = (IPropertyChangeEvent)event;
            return deltaEvent.getProperty().equals("error_state") && deltaEvent.getEventSource() instanceof ITeamRepository;
        }
        return false;
    }

    private void addListener(ITeamRepository repository) {
        repository.addGenericListener((Object)"state", (IListener)this);
        repository.addGenericListener((Object)"error_state", (IListener)this);
    }

    private void removeListener(ITeamRepository repository) {
        repository.removeGenericListener((Object)"state", (IListener)this);
        repository.removeGenericListener((Object)"error_state", (IListener)this);
    }
}

