/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.valueset;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IValueSetClient;
import com.ibm.team.workitem.client.ValueProviderTestResult;
import com.ibm.team.workitem.client.internal.ClientServiceContext;
import com.ibm.team.workitem.client.internal.valueset.Messages;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IValueSetService;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.valueset.rcp.dto.ValueProviderTestResultDTO;
import com.ibm.team.workitem.common.internal.valueset.rcp.dto.ValueSetDTO;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class ValueSetClient
implements IValueSetClient {
    private final ICommonServiceContext fContext;

    public ValueSetClient(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException(Messages.ValueSetClient_ERROR_ON_INITIALIZATION);
        }
        this.fContext = new ClientServiceContext(context);
    }

    @Override
    public ValueSetDTO getValueSet(final IWorkItem workItem, final IProjectAreaHandle projectArea, final String attributeId, final String filter, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)projectArea);
        Assert.isNotNull((Object)attributeId);
        ServiceRunnable<ValueSetDTO> runnable = new ServiceRunnable<ValueSetDTO>(){

            public ValueSetDTO run() throws TeamRepositoryException {
                return ValueSetClient.this.getService().getValueSet(workItem, projectArea, attributeId, filter);
            }
        };
        return (ValueSetDTO)this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public ValueProviderTestResult testHttpFilteredValueSetProvider(final IWorkItem workItem, final IProjectAreaHandle projectArea, final String filter, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        String temp;
        Assert.isNotNull((Object)projectArea);
        Assert.isNotNull((Object)configuration);
        XMLMemento memento = XMLMemento.createWriteRoot((String)"testConfiguration");
        IMemento provider = memento.createChild(configuration.getElementName());
        ValueSetClient.addToMemento(configuration, provider);
        try {
            temp = memento.asXMLString();
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        final String configurationXML = temp;
        ServiceRunnable<ValueProviderTestResultDTO> runnable = new ServiceRunnable<ValueProviderTestResultDTO>(){

            public ValueProviderTestResultDTO run() throws TeamRepositoryException {
                return ValueSetClient.this.getService().testHttpFilteredValueSetProvider(workItem, projectArea, configurationXML, filter);
            }
        };
        ValueProviderTestResultDTO result = (ValueProviderTestResultDTO)this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
        return new ValueProviderTestResult(result.getLog(), result.getValueSet());
    }

    private static void addToMemento(IConfiguration configuration, IMemento memento) {
        for (String attribute : configuration.getAttributeNames()) {
            memento.putString(attribute, configuration.getString(attribute));
        }
        for (IConfiguration child : configuration.getChildren()) {
            IMemento mem = memento.createChild(child.getElementName());
            ValueSetClient.addToMemento(child, mem);
        }
    }

    public IValueSetService getService() throws TeamRepositoryException {
        IValueSetService service = (IValueSetService)this.fContext.getService(IValueSetService.class);
        if (service == null) {
            throw new TeamRepositoryException(Messages.ValueSetClient_ERROR_ON_ACCESSING_VALUESET_SERVICE);
        }
        return service;
    }
}

