/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.dbhm;

import com.ibm.team.internal.repository.rcp.dbhm.BTree;
import com.ibm.team.internal.repository.rcp.dbhm.BTreeComparator;
import com.ibm.team.internal.repository.rcp.dbhm.BTreeHeap;
import com.ibm.team.internal.repository.rcp.dbhm.BadHeapException;
import com.ibm.team.internal.repository.rcp.dbhm.ByteBTreeComparator;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentBTree;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentBTreeAllocator;
import com.ibm.team.internal.repository.rcp.util.FileChannelUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.TreeSet;

public class PersistentBTreeHeap
extends BTreeHeap
implements PersistentBTreeAllocator {
    public static final long MAGIC = -2401053086532404614L;
    public static final int HEAP_TRAILER_SIZE = 16;
    protected boolean mustWriteTrailer;
    protected byte[] originalBTreePersistedBytes;
    protected byte[] originalPersistedBytes;
    protected byte[] bTreeBytesToPersist;
    protected byte[] bytesToPersist;
    protected boolean closed;
    protected long origWorkingAreaSize;

    public PersistentBTreeHeap(String path) throws IOException {
        this(new File(path));
    }

    public PersistentBTreeHeap(File f) throws IOException {
        boolean success = false;
        try {
            this.init(f);
            success = true;
        }
        catch (Throwable throwable) {
            if (!success && this.raf != null) {
                try {
                    this.raf.getFile().close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (!success && this.raf != null) {
            try {
                this.raf.getFile().close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected void init(File f) throws IOException {
        this.doInit(f);
        long len = FileChannelUtil.getLengthUninterrupted(this.raf);
        if (len != 0L) {
            if (len < 16L) {
                throw new BadHeapException("Not a heap file: " + f.getAbsolutePath());
            }
            long offset = len - 16L;
            ByteBuffer buf = ByteBuffer.allocate(16);
            this.readFully(buf, offset);
            buf.rewind();
            if (buf.getLong() != -2401053086532404614L) {
                throw new BadHeapException("Not a heap file: " + f.getAbsolutePath());
            }
            int dataLen = buf.getInt();
            if ((long)dataLen > offset || dataLen < 0) {
                throw new BadHeapException("Invalid persisted bytes length in " + f.getAbsolutePath());
            }
            int userDataLen = buf.getInt();
            if ((long)userDataLen > offset || userDataLen < 0) {
                throw new BadHeapException("Invalid user persisted bytes length in " + f.getAbsolutePath());
            }
            this.origWorkingAreaSize = this.workingAreaSize = offset - (long)dataLen - (long)userDataLen;
            byte[] data = new byte[dataLen];
            if (dataLen != 0) {
                buf = ByteBuffer.wrap(data);
                this.readFully(buf, this.workingAreaSize);
            }
            this.originalBTreePersistedBytes = data;
            data = new byte[userDataLen];
            if (userDataLen != 0) {
                buf = ByteBuffer.wrap(data);
                this.readFully(buf, this.workingAreaSize + (long)dataLen);
            }
            this.originalPersistedBytes = data;
        } else {
            this.mustWriteTrailer = true;
            this.originalPersistedBytes = new byte[0];
            this.originalBTreePersistedBytes = this.originalPersistedBytes;
        }
        this.bTreeBytesToPersist = this.originalBTreePersistedBytes;
        this.bytesToPersist = this.originalPersistedBytes;
        this.freeBlocks = new TreeSet();
        this.freeTable = this.getBTreeImpl();
    }

    @Override
    public void clear() throws IOException {
        this.bTreeBytesToPersist = new byte[0];
        this.originalBTreePersistedBytes = this.bTreeBytesToPersist;
        super.clear();
    }

    @Override
    protected BTree getBTreeImpl() throws IOException {
        return new PersistentBTree(16, 8192, (BTreeComparator)ByteBTreeComparator.CMP, this, this.raf);
    }

    @Override
    protected long allocateAtEnd(long size) throws IOException {
        long result = super.allocateAtEnd(size);
        if (this.workingAreaSize > this.origWorkingAreaSize) {
            this.mustWriteTrailer = true;
        }
        return result;
    }

    public void close() throws IOException {
        try {
            this.persist();
        }
        catch (IllegalStateException e) {
            this.raf.getFile().close();
            this.closed = true;
            throw new DBHMException(e);
        }
        catch (IOException e) {
            this.raf.getFile().close();
            this.closed = true;
            throw new DBHMException(e);
        }
        this.raf.getFile().close();
        this.closed = true;
    }

    public void persist() throws IOException {
        this.freeTable.sync();
        if (this.mustWriteTrailer || this.persistedBytesChanged() || this.metaDataChanged()) {
            ByteBuffer buf = ByteBuffer.allocate(16 + this.bytesToPersist.length + this.bTreeBytesToPersist.length);
            buf.put(this.bTreeBytesToPersist);
            buf.put(this.bytesToPersist);
            buf.putLong(-2401053086532404614L);
            buf.putInt(this.bTreeBytesToPersist.length);
            buf.putInt(this.bytesToPersist.length);
            buf.flip();
            this.writeFully(buf, this.workingAreaSize);
            FileChannelUtil.setLengthUninterrupted(this.raf, this.workingAreaSize + 16L + (long)this.bytesToPersist.length + (long)this.bTreeBytesToPersist.length);
            this.mustWriteTrailer = false;
            this.writtenMetaData();
            this.writtenBytesChanged();
        }
    }

    protected void writtenBytesChanged() {
        this.originalPersistedBytes = this.bytesToPersist;
        this.originalBTreePersistedBytes = this.bTreeBytesToPersist;
    }

    protected boolean persistedBytesChanged() {
        return !Arrays.equals(this.bytesToPersist, this.originalPersistedBytes) || !Arrays.equals(this.bTreeBytesToPersist, this.originalBTreePersistedBytes);
    }

    protected void writtenMetaData() {
        this.origWorkingAreaSize = this.workingAreaSize;
    }

    protected boolean metaDataChanged() {
        return this.workingAreaSize != this.origWorkingAreaSize;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.closed) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        super.finalize();
    }

    public byte[] getPersistedData() {
        byte[] copy = new byte[this.bytesToPersist.length];
        System.arraycopy(this.bytesToPersist, 0, copy, 0, copy.length);
        return copy;
    }

    public void setPersistedData(byte[] toPersist) {
        this.bytesToPersist = new byte[toPersist.length];
        System.arraycopy(toPersist, 0, this.bytesToPersist, 0, toPersist.length);
    }

    @Override
    public byte[] getBTreePersistedData() {
        byte[] copy = new byte[this.bTreeBytesToPersist.length];
        System.arraycopy(this.bTreeBytesToPersist, 0, copy, 0, this.bTreeBytesToPersist.length);
        return copy;
    }

    @Override
    public void setBTreePersistentData(byte[] data) {
        this.bTreeBytesToPersist = new byte[data.length];
        System.arraycopy(data, 0, this.bTreeBytesToPersist, 0, data.length);
    }
}

